/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstFieldList;
import com.adbs.ast.AstToken;
import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.AstTokenList;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLDatabaseObject;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Helpers;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SQLQualifiedName
extends AstTokenList {
    public SQLQualifiedName dbLink;

    public SQLQualifiedName(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    public String getQualifiedName() {
        return this.getSimpleSQL(this.sqlContext.getSQLBuilderExpression());
    }

    public String getQualifiedNameWithQuotes() {
        return this.getSimpleSQL(this.sqlContext.getSQLBuilderExpressionQuoted());
    }

    public String getQualifiedNameWithoutQuotes() {
        return this.getSimpleSQL(this.sqlContext.getSQLBuilderExpressionNonQuoted());
    }

    public String getQualifiedNameForServer() {
        return this.getSimpleSQL(this.sqlContext.getSQLBuilderExpressionForServer());
    }

    public String getNonQualifiedNameNames() {
        this.sqlContext.getSQLBuilderExpression().beginBuild();
        try {
            this.buildNonQualifiedNameNames(this.sqlContext.getSQLBuilderExpression(), this.sqlContext.getSQLBuilderExpression().getMainQueryFormat());
        }
        finally {
            this.sqlContext.getSQLBuilderExpression().endBuild();
        }
        return this.sqlContext.getSQLBuilderExpression().getResult();
    }

    void setQualifiedName(String value) throws QueryBuilderException {
        assert (this.sqlContext.getSyntaxProvider() != null);
        SQLQualifiedName qn = null;
        try {
            qn = this.sqlContext.parseQualifiedNameQuoteIfNeed(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (qn == null) {
            throw new QueryBuilderException(Helpers.localizer.getString("strBadObjectName", "Invalid object name"));
        }
        this.clear();
        this.assign(qn);
    }

    Element getXMLNode(Document doc, String nodeName, String itemsName) {
        Element result = doc.createElement(nodeName);
        for (int i = 0; i < this.getCount(); ++i) {
            AstToken id = this.get(i);
            assert (id instanceof AstTokenIdentifier);
            result.appendChild(((AstTokenIdentifier)id).getXMLNode(doc, itemsName));
        }
        return result;
    }

    public void loadFromXMLNode(Node node, String itemsName) {
        this.clear();
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node child = node.getChildNodes().item(i);
            if (child == null || !child.getNodeName().equals(itemsName)) continue;
            AstTokenIdentifier tId = new AstTokenIdentifier(this.sqlContext);
            tId.loadFromXMLNode(child);
            this.add(tId);
        }
    }

    @Override
    public SQLQualifiedName clone(BaseSQLContext sqlContext) {
        return (SQLQualifiedName)super.clone(sqlContext);
    }

    @Override
    public void buildSQLDirect(SQLBuilder builder, SQLBuilderSelectFormat format) {
        this.buildQualifiedName(builder, format);
    }

    public void addPrefix(String prefix, boolean caseSensitive) {
        this.addPrefix(new AstTokenIdentifier(this.sqlContext, prefix, caseSensitive));
    }

    public void addName(String name, boolean caseSensitive) {
        this.addName(new AstTokenIdentifier(this.sqlContext, name, caseSensitive));
    }

    public void addPrefix(String prefix) {
        assert (this.sqlContext.getSyntaxProvider() != null);
        AstTokenIdentifier id = null;
        try {
            id = this.sqlContext.parseIdentifierQuoteIfNeed(prefix);
        }
        catch (Exception exception) {
            // empty catch block
        }
        assert (id != null);
        this.addPrefix(id);
    }

    public void addName(String name) {
        assert (this.sqlContext.getSyntaxProvider() != null);
        AstTokenIdentifier id = null;
        try {
            id = this.sqlContext.parseIdentifierQuoteIfNeed(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        assert (id != null);
        this.addName(id);
    }

    public void addPrefix(SQLQualifiedName prefix) {
        assert (prefix != null);
        for (int i = 0; i < prefix.getCount(); ++i) {
            this.add(prefix.get(i).clone(this.sqlContext));
        }
    }

    public void addName(SQLQualifiedName name) {
        assert (name != null);
        for (int i = name.getCount() - 1; i >= 0; --i) {
            this.insert(0, name.get(i).clone(this.sqlContext));
        }
    }

    public void addPrefix(AstToken prefix) {
        assert (prefix != null);
        this.add(prefix);
    }

    public void addName(AstToken name) {
        assert (name != null);
        this.insert(0, name);
    }

    public AstToken extractPrefix() {
        return this.extract(this.getCount() - 1);
    }

    public AstToken extractName() {
        return this.extract(0);
    }

    public void removeLastName() {
        assert (this.getCount() > 0);
        this.delete(0);
    }

    public void removeFirstPrefix() {
        assert (this.getCount() > 0);
        this.delete(this.getCount() - 1);
    }

    public void buildQualifiedName(SQLBuilder builder, SQLBuilderSelectFormat format) {
        this.buildQualifiedNameNames(builder, format);
        this.buildQualifiedNameDBLink(builder, format);
    }

    public boolean startsWith(SQLQualifiedName name) {
        int i2;
        assert (this.sqlContext.getSyntaxProvider() != null);
        int i1 = this.getCount() - 1;
        if (i1 < (i2 = name.getCount() - 1)) {
            return false;
        }
        while (i1 >= 0 && i2 >= 0) {
            if (this.sqlContext.compareTokens(this.get(i1), name.get(i2)) != 0) {
                return false;
            }
            --i1;
            --i2;
        }
        return true;
    }

    public SQLQualifiedName getNameWithoutNames(int skipNames) {
        SQLQualifiedName result = this.clone(this.sqlContext);
        for (int i = skipNames - 1; i >= 0; --i) {
            result.delete(i);
        }
        return result;
    }

    public SQLQualifiedName getNameWithoutPrefixes(int skipPrefixes) {
        SQLQualifiedName result = this.clone(this.sqlContext);
        int x = result.getCount() - skipPrefixes;
        for (int i = result.getCount() - 1; i >= x; --i) {
            result.delete(i);
        }
        return result;
    }

    public String toString() {
        return this.getQualifiedName();
    }

    @Override
    protected void getASTFields(AstFieldList l) {
        super.getASTFields(l);
        try {
            l.add(SQLQualifiedName.class.getField("dbLink"));
        }
        catch (Exception ex) {
            Logger.getLogger(SQLQualifiedName.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void buildQualifiedNameNames(SQLBuilder builder, SQLBuilderSelectFormat format) {
        this.buildNonQualifiedNameNames(builder, format);
    }

    public void buildNonQualifiedNameNames(SQLBuilder builder, SQLBuilderSelectFormat format) {
        for (int i = this.getCount() - 1; i >= 0; --i) {
            this.get(i).buildSQL(builder, format);
            if (i <= 0) continue;
            builder.writeSymbol(".");
        }
    }

    public void buildQualifiedNameDBLink(SQLBuilder builder, SQLBuilderSelectFormat ormat) {
        if (this.dbLink != null) {
            builder.writeSymbol("@");
            this.dbLink.buildSQL(builder, ormat);
        }
    }

    public void getTokensToCompare(List list) {
        if (this.dbLink != null) {
            this.dbLink.getTokensToCompare(list);
        }
        for (int i = this.getCount() - 1; i >= 0; --i) {
            list.add(this.get(i));
        }
    }

    public void getAllTokensToCompare(List list) {
        this.getTokensToCompare(list);
    }

    public boolean parse(String name) {
        SQLDatabaseObject qn = null;
        try {
            qn = this.sqlContext.parseObjectNameQuoteIfNeed(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (qn != null) {
            this.assign(qn);
            return true;
        }
        return false;
    }
}

