/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstFieldList;
import com.adbs.ast.AstNode;
import com.adbs.ast.AstNodeWithList;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLExpressionItem;
import com.adbs.ast.SQLOrderByNullOrdering;
import com.adbs.ast.SQLOrderByOrders;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLOrderByItem
extends AstNode {
    public SQLExpressionItem expression;
    public SQLOrderByOrders sort = SQLOrderByOrders.Asc;
    public AstNodeWithList postExpression;
    public SQLOrderByNullOrdering nullOrdering = SQLOrderByNullOrdering.Default;

    public SQLOrderByItem(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    @Override
    protected void getASTFields(AstFieldList l) {
        super.getASTFields(l);
        try {
            l.add(SQLOrderByItem.class.getField("expression"));
            l.add(SQLOrderByItem.class.getField("postExpression"));
        }
        catch (Exception ex) {
            Logger.getLogger(SQLOrderByItem.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void assign(Object source) {
        super.assign(source);
        if (source instanceof SQLOrderByItem) {
            this.sort = ((SQLOrderByItem)source).sort;
            this.nullOrdering = ((SQLOrderByItem)source).nullOrdering;
        }
    }

    @Override
    public void buildSQLDirect(SQLBuilder builder, SQLBuilderSelectFormat format) {
        this.buildASTField(this.expression, builder, format);
        this.buildSortOrder(builder, format);
        this.buildNullOrdering(builder, format);
        if (this.postExpression != null) {
            builder.space();
            this.postExpression.buildSQL(builder, format);
        }
    }

    public void buildSortOrder(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (this.sort != SQLOrderByOrders.Asc) {
            builder.space();
            builder.writeKeyword("Desc");
        }
    }

    public void buildNullOrdering(SQLBuilder builder, SQLBuilderSelectFormat format) {
        switch (this.nullOrdering) {
            case NullsFirst: {
                builder.space();
                builder.writeKeyword("Nulls");
                builder.space();
                builder.writeKeyword("First");
                break;
            }
            case NullsLast: {
                builder.space();
                builder.writeKeyword("Nulls");
                builder.space();
                builder.writeKeyword("Last");
                break;
            }
        }
    }
}

