/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.SQLFromFunction;
import com.adbs.ast.SQLFromObject;
import com.adbs.ast.SQLFromSource;
import com.adbs.ast.SQLObjectColumn;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNameList;

public class SQLObjectColumnList
extends SQLQualifiedNameList {
    public SQLObjectColumnList(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    @Override
    public SQLObjectColumn get(int index) {
        return (SQLObjectColumn)super.get(index);
    }

    public void set(int index, SQLObjectColumn value) {
        super.set(index, value);
    }

    public void assign(SQLObjectColumnList source) {
        super.assign(source);
    }

    public int add(SQLObjectColumn obj) {
        return super.add(obj);
    }

    public SQLObjectColumn extract(SQLObjectColumn item) {
        return (SQLObjectColumn)super.extract(item);
    }

    public int remove(SQLObjectColumn obj) {
        return super.remove(obj);
    }

    public void insert(int index, SQLObjectColumn obj) {
        super.insert(index, obj);
    }

    private SQLQualifiedName getDatasourceName(SQLFromSource datasource) {
        if (datasource instanceof SQLFromObject) {
            return ((SQLFromObject)datasource).fromObj;
        }
        if (datasource instanceof SQLFromFunction) {
            return ((SQLFromFunction)datasource).name;
        }
        return null;
    }

    public int findByNameAndDatasource(SQLObjectColumn obj) {
        int result = -1;
        for (int i = 0; i < this.getCount(); ++i) {
            SQLObjectColumn objCol = this.get(i);
            if (objCol.datasource == obj.datasource && this.sqlContext.isQualifiedNamesEqual(objCol, obj)) {
                result = i;
                break;
            }
            if (!this.sqlContext.isQualifiedNamesEqual(objCol, obj) || objCol.datasource == null || obj.datasource == null) continue;
            SQLQualifiedName tName1 = this.getDatasourceName(objCol.datasource);
            SQLQualifiedName tName2 = this.getDatasourceName(obj.datasource);
            if (tName1 == null || tName2 == null || !this.sqlContext.isQualifiedNamesEqual(tName1, tName2)) continue;
            result = i;
            break;
        }
        return result;
    }
}

