/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstAliasExpressionsList;
import com.adbs.ast.AstFieldList;
import com.adbs.ast.AstNode;
import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataFieldList;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLAliasObjectAlias;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLExpressionItem;
import com.adbs.ast.SQLFromNodeList;
import com.adbs.ast.SQLJoinKind;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Str;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SQLFromSource
extends AstNode {
    private MetadataObject metadataObject;
    private MetadataFieldList fieldList;
    public SQLJoinKind joinKind;
    public SQLExpressionItem joinOn;
    public SQLAliasObjectAlias alias;
    public AstAliasExpressionsList columnNamesList;

    public SQLFromSource(BaseSQLContext sqlContext) {
        super(sqlContext);
        this.fieldList = new MetadataFieldList(null, sqlContext);
    }

    @Override
    public void dispose() {
        this.fieldList.dispose();
        super.dispose();
    }

    @Override
    public SQLFromSource clone(BaseSQLContext sqlContext) {
        return (SQLFromSource)super.clone(sqlContext);
    }

    public MetadataObject getMetadataObject() {
        if (this.sqlContext.getMetadataContainer() != null && this.sqlContext.getMetadataContainer().indexOf(this.metadataObject) != -1) {
            return this.metadataObject;
        }
        return null;
    }

    public void setMetadataObject(MetadataObject metadataObject) {
        this.metadataObject = metadataObject;
    }

    public MetadataFieldList getFieldList() {
        return this.fieldList;
    }

    public void setFieldList(MetadataFieldList fieldList) {
        if (this.fieldList != fieldList) {
            this.fieldList.assign(fieldList);
        }
    }

    public String getSimpleExpression(SQLBuilder sqlBuilder) {
        sqlBuilder.beginBuild();
        try {
            this.buildExpression(sqlBuilder, sqlBuilder.getMainQueryFormat());
        }
        finally {
            sqlBuilder.endBuild();
        }
        return sqlBuilder.getResult();
    }

    @Override
    protected void getASTFields(AstFieldList l) {
        super.getASTFields(l);
        try {
            l.add(SQLFromSource.class.getField("joinKind"));
            l.add(SQLFromSource.class.getField("joinOn"));
            l.add(SQLFromSource.class.getField("alias"));
            l.add(SQLFromNodeList.class.getField("columnNamesList"));
        }
        catch (Exception ex) {
            Logger.getLogger(SQLFromSource.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void assign(Object source) {
        super.assign(source);
        if (source instanceof SQLFromSource) {
            this.setFieldList(((SQLFromSource)source).getFieldList());
            this.setMetadataObject(((SQLFromSource)source).getMetadataObject());
        }
    }

    @Override
    public void buildSQLDirect(SQLBuilder builder, SQLBuilderSelectFormat format) {
        this.buildExpression(builder, format);
        this.buildAlias(builder, format);
    }

    public void buildJoinOperator(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (this.joinKind != null) {
            this.joinKind.buildSQL(builder, format);
        } else {
            builder.writeSymbol(",");
        }
    }

    public abstract void buildExpression(SQLBuilder var1, SQLBuilderSelectFormat var2);

    public void buildAlias(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (this.alias != null) {
            builder.space(3);
            this.alias.buildSQL(builder, format);
        }
    }

    public void calcFieldList(List cteList, List fromSourcesList, boolean calcFieldUsageStats) throws QueryBuilderException {
        String ssql;
        this.fieldList.clear();
        assert (this.sqlContext.getMetadataContainer() != null);
        assert (this.sqlContext.getSyntaxProvider() != null);
        if (!this.sqlContext.getMetadataContainer().isOfflineMode() && !Str.IsNullOrEmpty(ssql = this.getSimpleExpression(this.sqlContext.getSQLBuilderExpressionForServer()))) {
            ssql = this.sqlContext.getSyntaxProvider().getQueryToLoadFieldsForObject("", ssql);
            this.sqlContext.loadFieldsForQuery(ssql, this.getFieldList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buildColumnPrefix(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (this.alias != null) {
            this.alias.buildAliasName(builder, format);
        } else if (this.metadataObject != null && builder.isExpandVirtualObjects() && this.metadataObject.isVirtualCalculatedObject()) {
            SQLAliasObjectAlias tmpAlias = new SQLAliasObjectAlias(this.sqlContext);
            try {
                String aliasString = !Str.IsNullOrEmpty(this.metadataObject.getAltName()) ? this.metadataObject.getAltName() : this.metadataObject.getNameStr();
                tmpAlias.alias = new AstTokenIdentifier(this.sqlContext, aliasString);
                tmpAlias.buildSQL(builder, format);
            }
            finally {
                tmpAlias.dispose();
            }
        } else {
            this.buildExpression(builder, format);
        }
        return true;
    }

    public void buildColumnSuffix(SQLBuilder builder, SQLBuilderSelectFormat format) {
    }
}

