/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderConditionFormat;
import com.adbs.ast.SQLBuilderConditionFormatNL;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLExpressionBrackets;
import com.adbs.ast.SQLExpressionItem;
import com.adbs.ast.SQLExpressionLogicalCollection;

public class SQLExpressionOr
extends SQLExpressionLogicalCollection {
    public SQLExpressionOr(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    @Override
    public void buildSQLDirect(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (this.getCount() > 0) {
            this.get(0).buildSQL(builder, format);
        }
        for (int i = 1; i < this.getCount(); ++i) {
            builder.space(0);
            builder.writeKeyword("Or");
            builder.space(0);
            this.get(i).buildSQL(builder, format);
        }
    }

    @Override
    public void buildSQLCosmetic(SQLBuilder builder, SQLBuilderSelectFormat selectFormat, SQLBuilderConditionFormat format, int level, boolean parenWritten) {
        if (this.getCount() == 0) {
            return;
        }
        if (this.getCount() == 1) {
            this.get(0).buildSQLCosmetic(builder, selectFormat, format, level, parenWritten);
        } else {
            this.buildLogicalCollectionItem(this.get(0), builder, selectFormat, format, level + 1, parenWritten);
            for (int i = 1; i < this.getCount(); ++i) {
                builder.space(1);
                builder.writeKeyword("Or");
                if (format.getNewLineAfter() == SQLBuilderConditionFormatNL.AllLogical || (format.getNewLineAfter() == SQLBuilderConditionFormatNL.TopmostOr || format.getNewLineAfter() == SQLBuilderConditionFormatNL.TopmostLogical) && level == 0) {
                    builder.newLine();
                } else {
                    builder.space(1);
                }
                this.buildLogicalCollectionItem(this.get(i), builder, selectFormat, format, level + 1, parenWritten);
            }
        }
    }

    private void buildLogicalCollectionItem(SQLExpressionItem item, SQLBuilder builder, SQLBuilderSelectFormat selectFormat, SQLBuilderConditionFormat format, int level, boolean parenWritten) {
        boolean parenthesize;
        boolean bl = parenthesize = (builder.isParenthesizeANDGroups() && item instanceof SQLExpressionLogicalCollection || builder.isParenthesizeSingleCriterion() && !(item instanceof SQLExpressionLogicalCollection)) && !(item instanceof SQLExpressionBrackets);
        if (!parenWritten && parenthesize) {
            builder.writeSymbol("(");
        }
        item.buildSQLCosmetic(builder, selectFormat, format, level, parenWritten || parenthesize);
        if (!parenWritten && parenthesize) {
            builder.writeSymbol(")");
        }
    }
}

