/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstNode;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLExpressionItem;
import com.adbs.utils.Helpers;
import java.util.ArrayList;
import java.util.List;

public class SQLExpressionItemWithList
extends SQLExpressionItem {
    private final ArrayList<AstNode> items = new ArrayList();

    public SQLExpressionItemWithList(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    public int getCount() {
        return this.items.size();
    }

    public AstNode get(int index) {
        return this.items.get(index);
    }

    public void set(int index, AstNode value) {
        this.items.set(index, value);
    }

    public void setCount(int newLength) {
        assert (newLength >= 0);
        Helpers.listSetSize(this.items, newLength, true);
    }

    public int indexOf(AstNode item) {
        return this.items.indexOf(item);
    }

    @Override
    public void assign(Object source) {
        super.assign(source);
        if (source instanceof SQLExpressionItemWithList) {
            this.clear();
            for (int i = 0; i < ((SQLExpressionItemWithList)source).getCount(); ++i) {
                this.add(((SQLExpressionItemWithList)source).get(i).clone(this.sqlContext));
            }
        }
    }

    @Override
    public void getMyChildren(List l) {
        super.getMyChildren(l);
        int index = this.findFirstChildIndexForClass(SQLExpressionItemWithList.class);
        for (int i = this.getCount() - 1; i >= 0; --i) {
            l.add(index, this.get(i));
        }
    }

    @Override
    public void buildSQLDirect(SQLBuilder builder, SQLBuilderSelectFormat format) {
        for (int i = 0; i < this.getCount(); ++i) {
            this.get(i).buildSQL(builder, format);
            if (i >= this.getCount() - 1) continue;
            builder.writeSymbol(",");
            builder.space();
        }
    }

    public int remove(AstNode item) {
        int i = this.items.indexOf(item);
        if (i != -1) {
            this.items.remove(i);
        }
        return i;
    }

    public void delete(int index) {
        AstNode i = this.get(index);
        if (i != null) {
            i.dispose();
        }
        this.items.remove(index);
    }

    public void delete(AstNode item) {
        item.dispose();
        this.items.remove(item);
    }

    public AstNode extract(AstNode item) {
        this.items.remove(item);
        return item;
    }

    public AstNode extract(int i) {
        AstNode item = this.items.get(i);
        this.items.remove(i);
        return item;
    }

    public int add(AstNode item) {
        this.items.add(item);
        return this.items.size() - 1;
    }

    public void insert(int i, AstNode item) {
        this.items.add(i, item);
    }

    public void clear() {
        for (int i = 0; i < this.getCount(); ++i) {
            this.items.get(i).dispose();
        }
        this.items.clear();
    }
}

