/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstNode;
import com.adbs.ast.AstNodeSpace;
import com.adbs.ast.AstTokenBuiltin;
import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.AstTokenKeyword;
import com.adbs.ast.AstTokenNumber;
import com.adbs.ast.AstTokenString;
import com.adbs.ast.AstTokenSymbol;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLExpressionItemWithList;

public class SQLExpressionConstant
extends SQLExpressionItemWithList {
    public SQLExpressionConstant(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    @Override
    public void buildSQLDirect(SQLBuilder builder, SQLBuilderSelectFormat format) {
        for (int i = 0; i < this.getCount(); ++i) {
            this.get(i).buildSQL(builder, format);
        }
    }

    public void addSpace(int newLineIndex) {
        this.add(new AstNodeSpace(this.sqlContext, newLineIndex));
    }

    public void addSpace() {
        this.addSpace(2);
    }

    public void addNode(AstNode node, boolean spaceBefore, int newLineIndex) {
        if (spaceBefore) {
            this.addSpace(newLineIndex);
        }
        this.add(node);
    }

    public void addNode(AstNode node, boolean spaceBefore) {
        this.addNode(node, spaceBefore, 2);
    }

    public void addNode(AstNode node) {
        this.addNode(node, false, 2);
    }

    public void addKeyword(String keyword, boolean spaceBefore, int newLineIndex) {
        if (spaceBefore) {
            this.addSpace(newLineIndex);
        }
        this.add(new AstTokenKeyword(this.sqlContext, keyword));
    }

    public void addKeyword(String keyword, boolean spaceBefore) {
        this.addKeyword(keyword, spaceBefore, 2);
    }

    public void addKeyword(String keyword) {
        this.addKeyword(keyword, false, 2);
    }

    public void addIdentifier(String identifier, boolean spaceBefore, int newLineIndex) {
        if (spaceBefore) {
            this.addSpace(newLineIndex);
        }
        this.add(new AstTokenIdentifier(this.sqlContext, identifier));
    }

    public void addIdentifier(String identifier, boolean spaceBefore) {
        this.addIdentifier(identifier, spaceBefore, 2);
    }

    public void addIdentifier(String identifier) {
        this.addIdentifier(identifier, false, 2);
    }

    public void addBuiltin(String builtin, boolean spaceBefore, int newLineIndex) {
        if (spaceBefore) {
            this.addSpace(newLineIndex);
        }
        this.add(new AstTokenBuiltin(this.sqlContext, builtin));
    }

    public void addBuiltin(String builtin, boolean spaceBefore) {
        this.addBuiltin(builtin, spaceBefore, 2);
    }

    public void addBuiltin(String builtin) {
        this.addBuiltin(builtin, false, 2);
    }

    public void addSymbol(String symbol, boolean spaceBefore, int newLineIndex) {
        if (spaceBefore) {
            this.addSpace(newLineIndex);
        }
        this.add(new AstTokenSymbol(this.sqlContext, symbol));
    }

    public void addSymbol(String symbol, boolean spaceBefore) {
        this.addSymbol(symbol, spaceBefore, 2);
    }

    public void addSymbol(String symbol) {
        this.addSymbol(symbol, false, 2);
    }

    public void addNumber(String number, boolean spaceBefore, int newLineIndex) {
        if (spaceBefore) {
            this.addSpace(newLineIndex);
        }
        this.add(new AstTokenNumber(this.sqlContext, number));
    }

    public void addNumber(String number, boolean spaceBefore) {
        this.addNumber(number, spaceBefore, 2);
    }

    public void addNumber(String number) {
        this.addNumber(number, false, 2);
    }

    public void addString(String str, boolean spaceBefore, int newLineIndex) {
        if (spaceBefore) {
            this.addSpace(newLineIndex);
        }
        this.add(new AstTokenString(this.sqlContext, str));
    }

    public void addString(String str, boolean spaceBefore) {
        this.addString(str, spaceBefore, 2);
    }

    public void addString(String str) {
        this.addString(str, false, 2);
    }

    public SQLExpressionConstant space(int newLineIndex) {
        this.addSpace(newLineIndex);
        return this;
    }

    public SQLExpressionConstant space() {
        return this.space(2);
    }

    public SQLExpressionConstant node(AstNode node) {
        this.addNode(node);
        return this;
    }

    public SQLExpressionConstant keyword(String keyword) {
        this.addKeyword(keyword);
        return this;
    }

    public SQLExpressionConstant builtin(String builtin) {
        this.addBuiltin(builtin);
        return this;
    }

    public SQLExpressionConstant identifier(String identifier) {
        this.addIdentifier(identifier);
        return this;
    }

    public SQLExpressionConstant symbol(String symbol) {
        this.addSymbol(symbol);
        return this;
    }

    public SQLExpressionConstant number(String number) {
        this.addNumber(number);
        return this;
    }

    public SQLExpressionConstant string(String string) {
        this.addString(string);
        return this;
    }
}

