/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstNodeBase;
import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.SQLFromSource;
import com.adbs.ast.SQLSelectItem;
import com.adbs.ast.SQLSelectItemExpression;
import com.adbs.ast.SQLSelectItems;
import com.adbs.ast.SQLWithClauseItem;
import com.adbs.utils.Helpers;
import java.util.ArrayList;
import java.util.List;

public class PrepareAndFixupParam {
    private boolean countersStored;
    public PrepareAndFixupParam parentParam;
    public AstNodeBase node;
    public int cteItemsCount;
    public int fromItemsCount;
    public ArrayList cteItems;
    public ArrayList fromItems;
    public ArrayList aliasedSelectItems;

    public PrepareAndFixupParam(PrepareAndFixupParam parentParam, AstNodeBase node) {
        this.parentParam = parentParam;
        this.node = node;
        this.countersStored = false;
        if (parentParam != null) {
            this.cteItems = parentParam.cteItems;
            this.fromItems = parentParam.fromItems;
        } else {
            this.createLists();
        }
        this.aliasedSelectItems = null;
    }

    public void createLists() {
        this.cteItems = new ArrayList();
        this.fromItems = new ArrayList();
    }

    public void saveCounters() {
        this.countersStored = true;
        this.cteItemsCount = this.cteItems.size();
        this.fromItemsCount = this.fromItems.size();
    }

    public void restoreCounters() {
        if (this.countersStored) {
            Helpers.listSetSize(this.cteItems, this.cteItemsCount, false);
            Helpers.listSetSize(this.fromItems, this.fromItemsCount, false);
        }
    }

    public void addCTEItem(SQLWithClauseItem item) {
        this.cteItems.add(item);
    }

    public void addCTEItemsFrom(List list) {
        this.cteItems.addAll(list);
    }

    public void addFROMItem(SQLFromSource item) {
        this.fromItems.add(item);
    }

    public void addFROMItemsFrom(List list) {
        this.fromItems.addAll(list);
    }

    public void loadExpressionAliases(SQLSelectItems selectList) {
        assert (this.aliasedSelectItems == null);
        assert (this.node != null);
        this.aliasedSelectItems = new ArrayList();
        for (int i = 0; i < selectList.getCount(); ++i) {
            SQLSelectItem si = selectList.get(i);
            if (!(si instanceof SQLSelectItemExpression) || ((SQLSelectItemExpression)si).alias == null || ((SQLSelectItemExpression)si).alias.alias == null || !(((SQLSelectItemExpression)si).alias.alias instanceof AstTokenIdentifier)) continue;
            this.aliasedSelectItems.add(si);
        }
    }
}

