/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataBase;
import com.adbs.ast.MetadataCollectionItemBase;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.MetadataQualifiedNameList;
import com.adbs.ast.MetadataRelationCardinality;
import com.adbs.ast.MetadataRelationList;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MetadataRelation
extends MetadataCollectionItemBase {
    private boolean inverted;
    private MetadataQualifiedNameList keyFields;
    private MetadataRelationCardinality keyCardinality;
    private SQLQualifiedName childDatabase;
    private AstTokenIdentifier childSchema;
    private AstTokenIdentifier childName;
    private SQLQualifiedName childTable;
    private MetadataQualifiedNameList childFields;
    private MetadataRelationCardinality childCardinality;

    public MetadataRelation(MetadataBase parent, BaseSQLContext sqlContext) {
        super(parent, sqlContext);
        assert (parent == null || parent instanceof MetadataRelationList || MetadataRelationList.class.isAssignableFrom(parent.getClass()));
        this.keyFields = new MetadataQualifiedNameList(this, sqlContext);
        this.keyCardinality = MetadataRelationCardinality.One;
        this.childDatabase = new SQLQualifiedName(sqlContext);
        this.childSchema = new AstTokenIdentifier(sqlContext);
        this.childName = new AstTokenIdentifier(sqlContext);
        this.childTable = new SQLQualifiedName(sqlContext);
        this.childFields = new MetadataQualifiedNameList(this, sqlContext);
        this.childCardinality = MetadataRelationCardinality.Many;
        this.inverted = false;
    }

    @Override
    public void dispose() {
        this.keyFields.dispose();
        this.childDatabase.dispose();
        this.childSchema.dispose();
        this.childName.dispose();
        this.childTable.dispose();
        this.childFields.dispose();
        super.dispose();
    }

    public MetadataRelationList getRelations() {
        return (MetadataRelationList)this.getCollection();
    }

    public MetadataQualifiedNameList getKeyFields() {
        return this.keyFields;
    }

    public void setKeyFields(MetadataQualifiedNameList value) {
        if (this.keyFields != value) {
            if (value != null) {
                this.keyFields.assign(value);
            } else {
                this.keyFields.clear();
            }
            this.notifyUpdated();
        }
    }

    public AstTokenIdentifier getChildSchema() {
        return this.childSchema;
    }

    public void setChildSchema(AstTokenIdentifier value) {
        this.childSchema.assign(value);
        this.updateChildFullName();
        this.notifyUpdated();
    }

    public AstTokenIdentifier getChildName() {
        return this.childName;
    }

    public void setChildName(AstTokenIdentifier value) {
        this.childName.assign(value);
        this.updateChildFullName();
        this.notifyUpdated();
    }

    public SQLQualifiedName getChildDatabase() {
        return this.childDatabase;
    }

    public void setChildDatabase(SQLQualifiedName value) {
        if (value != null) {
            this.childDatabase.assign(value);
        } else {
            this.childDatabase.clear();
        }
        this.updateChildFullName();
        this.notifyUpdated();
    }

    public SQLQualifiedName getChildTable() {
        return this.childTable;
    }

    public MetadataQualifiedNameList getChildFields() {
        return this.childFields;
    }

    public void setChildFields(MetadataQualifiedNameList value) {
        if (this.childFields != value) {
            if (value != null) {
                this.childFields.assign(value);
            } else {
                this.childFields.clear();
            }
            this.notifyUpdated();
        }
    }

    public String getChildSchemaStr() {
        return this.childSchema.getSimpleSQL(this.sqlContext.getSQLBuilderExpression());
    }

    public void setChildSchemaStr(String value) {
        this.childSchema.setTokenStr(value);
        this.updateChildFullName();
        this.notifyUpdated();
    }

    public String getChildNameStr() {
        return this.childName.getSimpleSQL(this.sqlContext.getSQLBuilderExpression());
    }

    public void setChildNameStr(String value) {
        this.childName.setTokenStr(value);
        this.updateChildFullName();
        this.notifyUpdated();
    }

    public String getChildDatabaseStr() {
        return this.childDatabase.getQualifiedName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setChildDatabaseStr(String value) throws QueryBuilderException {
        SQLQualifiedName qn = null;
        if (value == null) return;
        if (value.equals(this.getChildDatabaseStr())) return;
        if (!Str.IsNullOrEmpty(value)) {
            try {
                qn = this.sqlContext.parseQualifiedNameQuoteIfNeed(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (qn == null) throw new QueryBuilderException(Helpers.localizer.getString("strBadObjectName", "Invalid object name"));
            this.childDatabase.assign(qn);
        } else {
            this.childDatabase.clear();
        }
        this.updateChildFullName();
        this.notifyUpdated();
    }

    public String getChildTableStr() {
        return this.childTable.getQualifiedName();
    }

    public String getChildSchemaStrNotQuoted() {
        return this.childSchema.getToken();
    }

    public String getChildNameStrNotQuoted() {
        return this.childName.getToken();
    }

    public String getChildDatabaseStrNotQuoted() {
        return this.childDatabase.getQualifiedNameWithoutQuotes();
    }

    public String getChildTableStrNotQuoted() {
        return this.childTable.getQualifiedNameWithoutQuotes();
    }

    private void updateChildFullName() {
        this.childTable.assign(this.childDatabase);
        if (!this.childSchema.isEmpty()) {
            this.childTable.insert(0, this.childSchema.clone(this.sqlContext));
        }
        this.childTable.insert(0, this.childName.clone(this.sqlContext));
    }

    @Override
    Element getXMLNode(Document doc, String nodeName) {
        Element result = super.getXMLNode(doc, nodeName);
        if (this.isInverted()) {
            result.setAttribute("type", "fk");
        }
        result.appendChild(this.keyFields.getXMLNode(doc, "key_fields", "field_name"));
        result.appendChild(Helpers.createNodeWithValue(doc, "key_cardinality", Helpers.metadataRelationCardinalityToString(this.keyCardinality)));
        if (this.childDatabase.getCount() != 0) {
            result.appendChild(this.childDatabase.getXMLNode(doc, "child_database", "item"));
        }
        if (!this.childSchema.isEmpty()) {
            result.appendChild(this.childSchema.getXMLNode(doc, "child_schema"));
        }
        result.appendChild(this.childName.getXMLNode(doc, "child_name"));
        result.appendChild(this.childFields.getXMLNode(doc, "child_fields", "field_name"));
        result.appendChild(Helpers.createNodeWithValue(doc, "child_cardinality", Helpers.metadataRelationCardinalityToString(this.childCardinality)));
        return result;
    }

    @Override
    void loadFromXMLNode(Element node) {
        super.loadFromXMLNode(node);
        String v = node.getAttribute("type");
        this.inverted = !Str.IsNullOrEmpty(v) && v.compareToIgnoreCase("FK") == 0;
        Element child = Helpers.findChildElByName("key_fields", node);
        if (child != null) {
            this.keyFields.loadFromXMLNode(child, "field_name");
        }
        this.keyCardinality = !Str.IsNullOrEmpty(v = Helpers.getValueFromChildNode(node, "key_cardinality")) ? Helpers.stringToMetadataRelationCardinality(v) : MetadataRelationCardinality.Unknown;
        child = Helpers.findChildElByName("child_database", node);
        if (child != null) {
            this.childDatabase.loadFromXMLNode(child, "item");
        }
        if ((child = Helpers.findChildElByName("child_schema", node)) != null) {
            this.childSchema.loadFromXMLNode(child);
        }
        if ((child = Helpers.findChildElByName("child_name", node)) != null) {
            this.childName.loadFromXMLNode(child);
        }
        child = Helpers.findChildElByName("child_fields", node);
        this.updateChildFullName();
        if (child != null) {
            this.childFields.loadFromXMLNode(child, "field_name");
        }
        this.childCardinality = !Str.IsNullOrEmpty(v = Helpers.getValueFromChildNode(node, "child_cardinality")) ? Helpers.stringToMetadataRelationCardinality(v) : MetadataRelationCardinality.Unknown;
    }

    @Override
    public void assign(Object source) {
        this.beginUpdate();
        try {
            super.assign(source);
            if (source instanceof MetadataRelation) {
                this.inverted = ((MetadataRelation)source).inverted;
                this.keyFields.assign(((MetadataRelation)source).getKeyFields());
                this.keyCardinality = ((MetadataRelation)source).getKeyCardinality();
                this.childSchema.assign(((MetadataRelation)source).getChildSchema());
                this.childName.assign(((MetadataRelation)source).getChildName());
                this.childDatabase.assign(((MetadataRelation)source).getChildDatabase());
                this.updateChildFullName();
                this.childFields.assign(((MetadataRelation)source).getChildFields());
                this.childCardinality = ((MetadataRelation)source).getChildCardinality();
                this.notifyUpdated();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public MetadataRelationCardinality getChildCardinality() {
        return this.childCardinality;
    }

    public void setChildCardinality(MetadataRelationCardinality childCardinality) {
        if (this.childCardinality != childCardinality) {
            this.childCardinality = childCardinality;
            this.notifyUpdated();
        }
    }

    public MetadataRelationCardinality getKeyCardinality() {
        return this.keyCardinality;
    }

    public void setKeyCardinality(MetadataRelationCardinality keyCardinality) {
        if (this.keyCardinality != keyCardinality) {
            this.keyCardinality = keyCardinality;
            this.notifyUpdated();
        }
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    public MetadataObject getKeyMetadataObject() {
        if (this.getRelations() != null && this.getRelations().getParent() != null) {
            return (MetadataObject)this.getRelations().getParent();
        }
        return null;
    }

    public MetadataObject getChildMetadataObject() {
        MetadataObject keyObject = this.getKeyMetadataObject();
        if (keyObject != null && keyObject.getMetadataContainer() != null) {
            return keyObject.getMetadataContainer().findObjectByFullName(this.getChildTable());
        }
        return null;
    }
}

