/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataBase;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFieldList;
import com.adbs.ast.MetadataObjectHashBucket;
import com.adbs.ast.MetadataRelation;
import com.adbs.ast.MetadataRelationList;
import com.adbs.ast.ObjectPrefixSkipping;
import com.adbs.ast.ParsingException;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLFromSource;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class MetadataObject
extends MetadataBase {
    private MetadataContainer metadataContainer;
    MetadataObjectHashBucket metadataContainerHashBucketName;
    MetadataObjectHashBucket metadataContainerHashBucketAltName;
    private SQLQualifiedName dbLink;
    private SQLQualifiedName database;
    private AstTokenIdentifier schema;
    private AstTokenIdentifier name;
    private SQLQualifiedName schemedName;
    private SQLQualifiedName fullName;
    private String expression;
    private SQLFromSource expressionAST;
    private boolean system;
    private boolean visible;
    private AstTokenIdentifier altNameId;
    private String longDescription = "";
    private String shortDescription = "";
    private MetadataFieldList fields;
    private MetadataRelationList relations;

    public MetadataObject(MetadataBase parent, BaseSQLContext sqlContext) {
        super(parent, sqlContext);
        assert (parent == null || parent instanceof MetadataContainer);
        if (parent != null) {
            this.metadataContainer = (MetadataContainer)parent;
        }
        this.visible = true;
        this.dbLink = new SQLQualifiedName(sqlContext);
        this.database = new SQLQualifiedName(sqlContext);
        this.schema = new AstTokenIdentifier(sqlContext);
        this.name = new AstTokenIdentifier(sqlContext);
        this.schemedName = new SQLQualifiedName(sqlContext);
        this.fullName = new SQLQualifiedName(sqlContext);
        this.fields = new MetadataFieldList(this, sqlContext);
        this.relations = new MetadataRelationList(this, sqlContext);
        this.altNameId = new AstTokenIdentifier(sqlContext);
    }

    @Override
    public void dispose() {
        if (this.metadataContainerHashBucketName != null) {
            this.metadataContainerHashBucketName.remove(this);
        }
        if (this.metadataContainerHashBucketAltName != null) {
            this.metadataContainerHashBucketAltName.remove(this);
        }
        if (this.altNameId != null) {
            this.altNameId.dispose();
            this.altNameId = null;
        }
        if (this.expressionAST != null) {
            this.expressionAST.dispose();
            this.expressionAST = null;
        }
        if (this.dbLink != null) {
            this.dbLink.dispose();
            this.dbLink = null;
        }
        if (this.database != null) {
            this.database.dispose();
            this.database = null;
        }
        if (this.schema != null) {
            this.schema.dispose();
            this.schema = null;
        }
        if (this.name != null) {
            this.name.dispose();
            this.name = null;
        }
        if (this.schemedName != null) {
            this.schemedName.dispose();
            this.schemedName = null;
        }
        if (this.fullName != null) {
            this.fullName.dispose();
            this.fullName = null;
        }
        if (this.fields != null) {
            this.fields.dispose();
            this.fields = null;
        }
        if (this.relations != null) {
            this.relations.dispose();
            this.relations = null;
        }
        super.dispose();
    }

    public MetadataContainer getMetadataContainer() {
        return this.metadataContainer;
    }

    public SQLQualifiedName getDBLink() {
        return this.dbLink;
    }

    public void setDBLink(SQLQualifiedName value) {
        if (value != null) {
            this.dbLink.assign(value);
        } else {
            this.dbLink.clear();
        }
        this.updateFullName();
        this.notifyUpdated();
    }

    public SQLQualifiedName getDatabase() {
        return this.database;
    }

    public void setDatabase(SQLQualifiedName value) {
        if (value != null) {
            this.database.assign(value);
        } else {
            this.database.clear();
        }
        this.updateFullName();
        this.notifyUpdated();
    }

    public AstTokenIdentifier getSchema() {
        return this.schema;
    }

    public void setSchema(AstTokenIdentifier value) {
        if (value != null) {
            this.schema.assign(value);
        } else {
            this.schema.clear();
        }
        this.updateFullName();
        this.notifyUpdated();
    }

    public AstTokenIdentifier getName() {
        return this.name;
    }

    public void setName(AstTokenIdentifier value) {
        if (value != null) {
            this.name.assign(value);
        } else {
            this.name.clear();
        }
        this.updateFullName();
        this.notifyUpdated();
    }

    public SQLQualifiedName getSchemedName() {
        return this.schemedName;
    }

    public SQLQualifiedName getFullName() {
        return this.fullName;
    }

    public String getDBLinkStr() {
        return this.dbLink.getSimpleSQL(this.sqlContext.getSQLBuilderExpression());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDBLinkStr(String value) {
        if (value.equals(this.getDBLinkStr())) return;
        if (!Str.IsNullOrEmpty(value)) {
            SQLQualifiedName qn = this.sqlContext.parseQualifiedNameQuoteIfNeed(value);
            if (qn == null) throw new QueryBuilderException(Helpers.localizer.getString("strBadObjectName", "Invalid object name"));
            try {
                this.dbLink.assign(qn);
            }
            finally {
                qn.dispose();
            }
        } else {
            this.dbLink.clear();
        }
        this.updateFullName();
        this.notifyUpdated();
    }

    public String getDatabaseStr() {
        return this.database.getQualifiedName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDatabaseStr(String value) throws QueryBuilderException {
        if (value.equals(this.getDatabaseStr())) return;
        if (!Str.IsNullOrEmpty(value)) {
            SQLQualifiedName qn;
            try {
                qn = this.sqlContext.parseQualifiedNameQuoteIfNeed(value);
            }
            catch (ParsingException ex) {
                throw new QueryBuilderException("MetadataObject.setDatabaseStr(): Failed to parse qualified name.\n" + ex.getMessage(), ex);
            }
            if (qn == null) throw new QueryBuilderException(Helpers.localizer.getString("strBadObjectName", "Invalid object name"));
            this.database.assign(qn);
        } else {
            this.database.clear();
        }
        this.updateFullName();
        this.notifyUpdated();
    }

    public String getSchemaStr() {
        return this.schema.getSimpleSQL(this.sqlContext.getSQLBuilderExpression());
    }

    public void setSchemaStr(String value) {
        this.schema.setTokenStr(value);
        this.updateFullName();
        this.notifyUpdated();
    }

    public String getNameStr() {
        return this.name.getSimpleSQL(this.sqlContext.getSQLBuilderExpression());
    }

    public void setNameStr(String value) {
        this.name.setTokenStr(value);
        this.updateFullName();
        this.notifyUpdated();
    }

    public String getSchemedNameStr() {
        return this.schemedName.getQualifiedName();
    }

    public String getFullNameStr() {
        return this.fullName.getQualifiedName();
    }

    public String getDatabaseStrNotQuoted() {
        return this.database.getQualifiedNameWithoutQuotes();
    }

    public String getSchemaStrNotQuoted() {
        return this.schema.getToken();
    }

    public String getNameStrNotQuoted() {
        return this.name.getToken();
    }

    public String getSchemedNameStrNotQuoted() {
        return this.schemedName.getQualifiedNameWithoutQuotes();
    }

    public String getFullNameStrNotQuoted() {
        return this.fullName.getQualifiedNameWithoutQuotes();
    }

    public boolean isSystem() {
        return this.system;
    }

    public void setSystem(boolean value) {
        this.system = value;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean value) {
        this.visible = value;
    }

    public AstTokenIdentifier getAltNameId() {
        return this.altNameId;
    }

    public String getAltName() {
        return this.altNameId.getToken();
    }

    public void setAltName(String value) {
        if (!this.getAltName().equals(value)) {
            this.altNameId.setToken(value);
            if (this.metadataContainer != null) {
                this.metadataContainer.namesHash.reHashByAltName(this);
                this.metadataContainer.setObjectsUpdated();
            }
            this.notifyUpdated();
        }
    }

    public boolean getAltNameCaseSensitive() {
        return this.altNameId.getCaseSensitive();
    }

    public void setAltNameCaseSensitive(boolean value) {
        if (this.altNameId.getCaseSensitive() != value) {
            this.altNameId.setCaseSensitive(value);
            if (this.metadataContainer != null) {
                this.metadataContainer.namesHash.reHashByAltName(this);
                this.metadataContainer.setObjectsUpdated();
            }
            this.notifyUpdated();
        }
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String value) {
        this.shortDescription = value;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public void setLongDescription(String value) {
        this.longDescription = value;
    }

    public MetadataFieldList getFields() {
        return this.fields;
    }

    public void setFields(MetadataFieldList value) {
        if (this.fields != value) {
            this.fields.assign(value);
        }
    }

    public MetadataRelationList getRelations() {
        return this.relations;
    }

    public void setRelations(MetadataRelationList value) {
        if (this.relations != value) {
            this.relations.assign(value);
        }
    }

    private void updateFullName() {
        this.schemedName.clear();
        if (!this.schema.isEmpty()) {
            this.schemedName.insert(0, this.schema.clone(this.sqlContext));
        }
        this.schemedName.insert(0, this.name.clone(this.sqlContext));
        this.fullName.clear();
        this.fullName.assign(this.database);
        if (!this.schema.isEmpty()) {
            this.fullName.insert(0, this.schema.clone(this.sqlContext));
        }
        this.fullName.insert(0, this.name.clone(this.sqlContext));
        if (this.dbLink.getCount() > 0) {
            if (this.fullName.dbLink != null) {
                this.fullName.dbLink.dispose();
            }
            this.fullName.dbLink = this.dbLink.clone(this.sqlContext);
        }
        if (this.getMetadataContainer() != null) {
            this.getMetadataContainer().namesHash.reHashByName(this);
            this.metadataContainer.setObjectsUpdated();
        }
    }

    protected String getFieldsSQL() {
        return "";
    }

    String getXMLItemName() {
        return "object";
    }

    @Override
    Element getXMLNode(Document doc, String nodeName) {
        Element result = super.getXMLNode(doc, nodeName);
        if (this.dbLink.getCount() > 0) {
            result.appendChild(this.dbLink.getXMLNode(doc, "dblink", "item"));
        }
        if (this.database.getCount() != 0) {
            result.appendChild(this.database.getXMLNode(doc, "database", "item"));
        }
        if (!this.schema.isEmpty()) {
            result.appendChild(this.schema.getXMLNode(doc, "schema"));
        }
        result.appendChild(this.name.getXMLNode(doc, "name"));
        String altName = this.getAltName();
        if (!Str.IsNullOrEmpty(altName)) {
            result.appendChild(Helpers.createNodeWithValue(doc, "alt_name", altName));
        }
        if (this.getAltNameCaseSensitive()) {
            result.appendChild(Helpers.createNodeWithValue(doc, "alt_name_case_sens", true));
        }
        if (this.isVirtualCalculatedObject()) {
            result.appendChild(Helpers.createNodeWithValue(doc, "expression", this.getExpression()));
        }
        result.appendChild(Helpers.createNodeWithValue(doc, "system", this.system));
        result.appendChild(Helpers.createNodeWithValue(doc, "visible", this.visible));
        if (!Str.IsNullOrEmpty(this.shortDescription)) {
            result.appendChild(Helpers.createNodeWithValue(doc, "descr", this.shortDescription));
        }
        if (!Str.IsNullOrEmpty(this.longDescription)) {
            result.appendChild(Helpers.createNodeWithValue(doc, "long_descr", this.longDescription));
        }
        if (!this.fields.isLoaded() && !this.metadataContainer.isOfflineMode()) {
            try {
                this.loadFields();
            }
            catch (QueryBuilderException queryBuilderException) {
                // empty catch block
            }
        }
        if (this.fields.isLoaded()) {
            result.appendChild(this.fields.getXMLNode(doc, "fields"));
        }
        if (this.relations.getCount() != 0) {
            result.appendChild(this.relations.getXMLNode(doc, "relations"));
        }
        return result;
    }

    void loadFromXMLNode(Node node) {
        Element child = Helpers.findChildElByName("dblink", node);
        if (child != null) {
            this.dbLink.loadFromXMLNode(child, "item");
        }
        if ((child = Helpers.findChildElByName("database", node)) != null) {
            this.database.loadFromXMLNode(child, "item");
        }
        if ((child = Helpers.findChildElByName("schema", node)) != null) {
            this.schema.loadFromXMLNode(child);
        }
        if ((child = Helpers.findChildElByName("name", node)) != null) {
            this.name.loadFromXMLNode(child);
        }
        this.updateFullName();
        String v = Helpers.getValueFromChildNode(node, "alt_name");
        this.setAltName(v != null ? v.toString() : "");
        v = Helpers.getValueFromChildNode(node, "alt_name_case_sens");
        this.setAltNameCaseSensitive(v != null && v.toString().equals("1"));
        v = Helpers.getValueFromChildNode(node, "expression");
        if (v != null) {
            this.setExpression(v.toString());
        }
        if ((v = Helpers.getValueFromChildNode(node, "system")) != null) {
            this.system = v.toString().equals("1");
        }
        if ((v = Helpers.getValueFromChildNode(node, "visible")) != null) {
            this.visible = v.toString().equals("1");
        }
        if ((v = Helpers.getValueFromChildNode(node, "descr")) != null) {
            this.shortDescription = v;
        }
        if ((v = Helpers.getValueFromChildNode(node, "long_descr")) != null) {
            this.longDescription = v;
        }
        if ((child = Helpers.findChildElByName("fields", node)) != null) {
            this.fields.loadFromXMLNode(child);
            this.fields.setLoaded(this.fields.getCount() > 0);
        } else {
            this.fields.clear();
        }
        child = Helpers.findChildElByName("relations", node);
        if (child != null) {
            this.relations.loadFromXMLNode(child);
        }
    }

    @Override
    public void assign(Object source) {
        this.beginUpdate();
        try {
            super.assign(source);
            if (source instanceof MetadataObject) {
                MetadataObject sourceAsObject = (MetadataObject)source;
                this.dbLink.assign(sourceAsObject.getDBLink());
                this.database.assign(sourceAsObject.getDatabase());
                this.schema.assign(sourceAsObject.getSchema());
                this.name.assign(sourceAsObject.getName());
                this.updateFullName();
                this.expression = sourceAsObject.getExpression();
                if (this.expressionAST != null) {
                    this.expressionAST.dispose();
                }
                this.expressionAST = sourceAsObject.isVirtualCalculatedObject() ? sourceAsObject.getExpressionAST().clone(this.sqlContext) : null;
                this.setSystem(sourceAsObject.isSystem());
                this.setVisible(sourceAsObject.isVisible());
                this.setAltName(sourceAsObject.getAltName());
                this.setAltNameCaseSensitive(sourceAsObject.getAltNameCaseSensitive());
                this.setShortDescription(sourceAsObject.getShortDescription());
                this.setLongDescription(sourceAsObject.getLongDescription());
                this.fields.assign(sourceAsObject.getFields());
                this.relations.assign(sourceAsObject.getRelations());
                this.notifyUpdated();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void loadFields() throws QueryBuilderException {
        this.loadFieldsHelper(true);
    }

    public String getNameAsString(boolean database, boolean schema, boolean name, SQLBuilder sqlBuilder) {
        SQLQualifiedName qn = this.getNameAsObject(database, schema, name, sqlBuilder.getObjectPrefixSkipping());
        return qn.getSimpleSQL(sqlBuilder);
    }

    public SQLQualifiedName getNameAsObject(boolean database, boolean schema, boolean name, ObjectPrefixSkipping prefixSkipping) {
        boolean defdb;
        assert (database || schema || name);
        SQLQualifiedName result = new SQLQualifiedName(this.sqlContext);
        if (database && !Helpers.isQualifiedNameEmpty(this.database)) {
            boolean bl = defdb = this.dbLink.getCount() == 0 && (prefixSkipping == ObjectPrefixSkipping.SkipAll || prefixSkipping == ObjectPrefixSkipping.SkipDatabase) && this.sqlContext.isQualifiedNamesEqual(this.database, this.getMetadataContainer().getDefaultDatabaseName());
            if (!defdb && !Helpers.isQualifiedNameEmpty(this.database)) {
                result.addName(this.database);
            }
        } else {
            defdb = true;
        }
        if (schema && !this.schema.isEmpty()) {
            boolean defsch;
            boolean bl = defsch = this.dbLink.getCount() == 0 && prefixSkipping == ObjectPrefixSkipping.SkipAll && defdb && this.getMetadataContainer().getDefaultSchemaNames().containsSameId(this.schema);
            if (!defsch && !this.schema.isEmpty()) {
                result.addName(this.schema.clone(this.sqlContext));
            }
        }
        if (name) {
            result.addName(this.name.clone(this.sqlContext));
        }
        if (database && this.dbLink.getCount() > 0) {
            result.dbLink = this.dbLink.clone(result.sqlContext);
        }
        return result;
    }

    public boolean isNameEqual(AstTokenIdentifier name, AstTokenIdentifier schema, SQLQualifiedName database) {
        return this.sqlContext.isIdentifiersEqual(name, this.name) && this.sqlContext.isIdentifiersEqual(schema, this.schema) && this.sqlContext.isQualifiedNamesEqual(database, this.database);
    }

    public boolean isFullNameEqual(SQLQualifiedName fullName) {
        return this.sqlContext.isQualifiedNamesEqual(fullName, this.fullName);
    }

    protected abstract void loadFieldsInternal() throws QueryBuilderException;

    public String getQueryToLoadFields(String fieldName) {
        assert (this.sqlContext.getSyntaxProvider() != null);
        return this.sqlContext.getSyntaxProvider().getQueryToLoadFieldsForObject(fieldName, this.fullName.getQualifiedNameForServer());
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expr) {
        if (!expr.equals(this.getExpression())) {
            if (Str.IsNullOrEmpty(expr)) {
                this.expression = "";
                if (this.expressionAST != null) {
                    this.expressionAST.dispose();
                    this.expressionAST = null;
                }
            } else {
                SQLFromSource fs = this.sqlContext.parseDatasource(expr);
                this.expression = expr;
                if (this.expressionAST != null) {
                    this.expressionAST.dispose();
                    this.expressionAST = null;
                }
                this.expressionAST = fs;
            }
        }
    }

    public SQLFromSource getExpressionAST() {
        return this.expressionAST;
    }

    public boolean isVirtualCalculatedObject() {
        return this.getExpressionAST() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadFieldsHelper(boolean force) {
        if (!this.fields.isLoaded()) {
            this.beginUpdate();
            try {
                if (!this.isVirtualCalculatedObject()) {
                    if (!this.fields.isLoaded()) {
                        if (this.sqlContext.getSyntaxProvider() == null) throw new QueryBuilderException(Helpers.localizer.getString("strNoSyntaxProvider", "No syntax provider."));
                        if (!this.getMetadataContainer().isOfflineMode() || force) {
                            if (this.sqlContext.getMetadataProvider() == null) throw new QueryBuilderException(Helpers.localizer.getString("strNoMetadataProvider", "No metadata provider."));
                            this.loadFieldsInternal();
                        }
                    }
                } else {
                    ArrayList lCTE = new ArrayList();
                    ArrayList lFromObj = new ArrayList();
                    this.expressionAST.prepareAndFixupRecursive(lCTE, lFromObj);
                    this.fields = this.expressionAST.getFieldList();
                    for (int i = this.fields.getCount() - 1; i >= 0; --i) {
                        if (!this.fields.get(i).isVirtualCalculatedField()) continue;
                        this.fields.delete(i);
                    }
                }
            }
            finally {
                this.endUpdate();
            }
        }
        if (this.fields.isLoaded()) return;
        if (this.sqlContext.getSyntaxProvider() == null) throw new QueryBuilderException(Helpers.localizer.getString("strNoSyntaxProvider", "No syntax provider."));
        if (this.sqlContext.getMetadataProvider() == null) throw new QueryBuilderException(Helpers.localizer.getString("strNoMetadataProvider", "No metadata provider."));
        this.beginUpdate();
        try {
            this.loadFieldsInternal();
            return;
        }
        finally {
            this.endUpdate();
        }
    }

    void loadFieldsOnDemand() {
        this.loadFieldsHelper(false);
    }

    private List<MetadataObject> getReferencedObjects(boolean reverse) {
        ArrayList<MetadataObject> result = new ArrayList<MetadataObject>();
        List<MetadataRelation> relations = this.metadataContainer.getRelations();
        for (int i = 0; i < relations.size(); ++i) {
            MetadataRelation relation = relations.get(i);
            MetadataObject keyObject = (MetadataObject)relation.getRelations().getParent();
            MetadataObject childObject = this.metadataContainer.findObjectByFullName(relation.getChildTable());
            if (relation.isInverted() ^ reverse) {
                if (keyObject != this || childObject == null) continue;
                result.add(childObject);
                continue;
            }
            if (childObject != this) continue;
            result.add(keyObject);
        }
        return result;
    }

    public List<MetadataObject> getReferencingObjects() {
        return this.getReferencedObjects(true);
    }

    public List<MetadataObject> getReferencedObjects() {
        return this.getReferencedObjects(false);
    }

    public List<MetadataRelation> getReferencingRelations() {
        List<MetadataRelation> relations = this.getMetadataContainer().getRelations();
        ArrayList<MetadataRelation> result = new ArrayList<MetadataRelation>();
        for (MetadataRelation relation : relations) {
            MetadataObject keyObject = (MetadataObject)relation.getRelations().getParent();
            MetadataObject childObject = this.getMetadataContainer().findObjectByFullName(relation.getChildTable());
            if (!relation.isInverted()) {
                if (keyObject != this || childObject == null) continue;
                result.add(relation);
                continue;
            }
            if (childObject != this) continue;
            result.add(relation);
        }
        return result;
    }

    public List<MetadataRelation> getReferencedRelations() {
        List<MetadataRelation> relations = this.getMetadataContainer().getRelations();
        ArrayList<MetadataRelation> result = new ArrayList<MetadataRelation>();
        for (MetadataRelation relation : relations) {
            MetadataObject keyObject = (MetadataObject)relation.getRelations().getParent();
            MetadataObject childObject = this.getMetadataContainer().findObjectByFullName(relation.getChildTable());
            if (!relation.isInverted()) {
                if (childObject != this) continue;
                result.add(relation);
                continue;
            }
            if (keyObject != this || childObject == null) continue;
            result.add(relation);
        }
        return result;
    }
}

