/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.MetadataFilterApplyFor;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import java.util.EnumSet;

public class MetadataFilterItem {
    private EnumSet<MetadataFilterApplyFor> applyFor = Helpers.metadataFilterApplyForAll;
    private String schemaMask = String.valueOf('%');
    private boolean schemaMaskCaseSensitive = true;
    private String objectMask = String.valueOf('%');
    private boolean objectMaskCaseSensitive = true;
    private boolean exclude = false;

    public EnumSet<MetadataFilterApplyFor> getApplyFor() {
        return this.applyFor;
    }

    public void setApplyFor(EnumSet<MetadataFilterApplyFor> value) {
        this.applyFor = value;
    }

    public String getSchemaMask() {
        return this.schemaMask;
    }

    public void setSchemaMask(String value) {
        this.schemaMask = value;
    }

    public String getObjectMask() {
        return this.objectMask;
    }

    public void setObjectMask(String value) {
        this.objectMask = value;
    }

    public boolean getExclude() {
        return this.exclude;
    }

    public void setExclude(boolean value) {
        this.exclude = value;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        StringBuilder sobj = new StringBuilder();
        if (!this.exclude) {
            s.append("+ ");
        } else {
            s.append("- ");
        }
        if (!Str.IsNullOrEmpty(this.schemaMask)) {
            s.append(this.schemaMask + ".");
        }
        if (!Str.IsNullOrEmpty(this.objectMask)) {
            s.append(this.objectMask);
        } else {
            s.append("%");
        }
        if (this.applyFor.containsAll(Helpers.metadataFilterApplyForAll)) {
            sobj.append("All");
        } else {
            if (this.applyFor.contains((Object)MetadataFilterApplyFor.Tables)) {
                sobj.append("T");
            }
            if (this.applyFor.contains((Object)MetadataFilterApplyFor.Views)) {
                if (sobj.length() > 0) {
                    sobj.append(",");
                }
                sobj.append("V");
            }
            if (this.applyFor.contains((Object)MetadataFilterApplyFor.Procedures)) {
                if (sobj.length() > 0) {
                    sobj.append(",");
                }
                sobj.append("P");
            }
            if (this.applyFor.contains((Object)MetadataFilterApplyFor.Synonyms)) {
                if (sobj.length() > 0) {
                    sobj.append(",");
                }
                sobj.append("S");
            }
        }
        s.append("(");
        s.append((CharSequence)sobj);
        s.append(")");
        return s.toString();
    }

    public void assign(Object source) {
        if (source instanceof MetadataFilterItem) {
            this.applyFor = ((MetadataFilterItem)source).getApplyFor();
            this.schemaMask = ((MetadataFilterItem)source).getSchemaMask();
            this.schemaMaskCaseSensitive = ((MetadataFilterItem)source).schemaMaskCaseSensitive;
            this.objectMask = ((MetadataFilterItem)source).getObjectMask();
            this.objectMaskCaseSensitive = ((MetadataFilterItem)source).objectMaskCaseSensitive;
            this.exclude = ((MetadataFilterItem)source).getExclude();
        }
    }

    public boolean isObjectMaskCaseSensitive() {
        return this.objectMaskCaseSensitive;
    }

    public void setObjectMaskCaseSensitive(boolean objectMaskCaseSensitive) {
        this.objectMaskCaseSensitive = objectMaskCaseSensitive;
    }

    public boolean isSchemaMaskCaseSensitive() {
        return this.schemaMaskCaseSensitive;
    }

    public void setSchemaMaskCaseSensitive(boolean schemaMaskCaseSensitive) {
        this.schemaMaskCaseSensitive = schemaMaskCaseSensitive;
    }
}

