/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.scheduler;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.datatypes.objects.OraINTERVALDS;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.dal.sql.ConnectionProperties;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.repository.Workflow;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.TimeUtils;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.preferences.SchedulerPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.scheduler.DialogsLrb;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleResultSet;
import oracle.sql.INTERVALDS;
import oracle.sql.TIMESTAMPTZ;

public class SchedulerModel {
    private Context context;
    private BigDecimal projectId;
    private BigDecimal workflowId;
    private List<Node> selectedNodes;
    private Workflow.ScheduleRunMode runMode;
    private Integer maxRuns;
    private OraINTERVALDS maxRunDuration;
    private OraINTERVALDS scheduleLimit;
    private String jobClass;
    private String timeZoneId;
    private boolean useNotification;
    private String emailRecipients;
    private String emailSubject;
    private String emailComment;
    private boolean useEventStarted;
    private boolean useEventSucceeded;
    private boolean useEventFailed;
    private boolean useEventStopped;
    private int jobPriority;
    private boolean useMaxFailures;
    private int maxFailures;
    private boolean useMaxRunDuration;
    private int maxRunDurationDays;
    private int maxRunDurationHours;
    private int maxRunDurationMins;
    private boolean useScheduleLimit;
    private int scheduleLimitDays;
    private int scheduleLimitHours;
    private int scheduleLimitMins;
    private Locale locale;
    private GregorianCalendar calStartDate;
    private GregorianCalendar calEndDate;
    private GregorianCalendar calNextRunDate;
    private Repeat repeat;
    private Object endRepeat;
    private boolean useSchedulePrev;
    private boolean useSchedule;
    private String scheduleName;
    private UniqueScheduleNameGenerator scheduleNameGen;
    private boolean isWorkflowJobClassAllowed;
    private List<RunNodeInfo> nodes = new ArrayList<RunNodeInfo>();
    private List<String> jobClasses = new ArrayList<String>();
    private List<ScheduleInfo> schedules = new ArrayList<ScheduleInfo>();
    private HashMap<String, Object> job_data = new HashMap();
    private static String NOTIFICATION_ADDITIONAL_INFO_HEADER = DialogsLrb.get("SCHEDULER_NOTIFICATION_ADDITIONAL_INFO");
    private static String NOTIFICATION_ADDITIONAL_INFO_BODY = DialogsLrb.get("SCHEDULER_NOTIFICATION_ADDITIONAL_INFO_BODY");
    private static String ODMR_OWNED_SCHEDULE = "Created by ODMR";

    public SchedulerModel(Context context, BigDecimal bigDecimal, BigDecimal bigDecimal2, List<Node> list, Workflow.ScheduleRunMode scheduleRunMode) {
        this.context = context;
        this.projectId = bigDecimal;
        this.workflowId = bigDecimal2;
        this.selectedNodes = list;
        this.runMode = scheduleRunMode;
        this.init();
    }

    public void init() {
        SchedulerPreferencesPanelSettings schedulerPreferencesPanelSettings = SchedulerPreferencesPanelSettings.getInstance((PropertyStorage)Preferences.getPreferences());
        this.locale = Locale.getDefault();
        this.timeZoneId = schedulerPreferencesPanelSettings.getTimeZone();
        this.calStartDate = new GregorianCalendar(this.locale);
        this.calStartDate.setTimeZone(TimeZone.getTimeZone(this.timeZoneId));
        this.calStartDate.add(11, 1);
        this.calEndDate = (GregorianCalendar)this.calStartDate.clone();
        this.calEndDate.add(6, 1);
        this.repeat = new RepeatDailyBasic();
        this.endRepeat = null;
        this.maxRuns = 3;
        this.useSchedule = false;
        this.useSchedulePrev = false;
        boolean bl = this.emailServerExist();
        this.useNotification = schedulerPreferencesPanelSettings.useNotification() && bl;
        this.emailRecipients = schedulerPreferencesPanelSettings.getEmailRecipients();
        this.emailSubject = schedulerPreferencesPanelSettings.getEmailSubject();
        this.emailComment = schedulerPreferencesPanelSettings.getEmailComment();
        this.useEventStarted = schedulerPreferencesPanelSettings.useEventStarted();
        this.useEventSucceeded = schedulerPreferencesPanelSettings.useEventSucceeded();
        this.useEventFailed = schedulerPreferencesPanelSettings.useEventFailed();
        this.useEventStopped = schedulerPreferencesPanelSettings.useEventStopped();
        this.jobPriority = schedulerPreferencesPanelSettings.getJobPriority();
        this.useMaxFailures = schedulerPreferencesPanelSettings.useMaxFailures();
        this.maxFailures = schedulerPreferencesPanelSettings.getMaxFailures();
        this.useMaxRunDuration = schedulerPreferencesPanelSettings.useMaxRunDuration();
        this.maxRunDurationDays = schedulerPreferencesPanelSettings.getMaxRunDurationDays();
        this.maxRunDurationHours = schedulerPreferencesPanelSettings.getMaxRunDurationHours();
        this.maxRunDurationMins = schedulerPreferencesPanelSettings.getMaxRunDurationMins();
        this.useScheduleLimit = schedulerPreferencesPanelSettings.useScheduleLimit();
        this.scheduleLimitDays = schedulerPreferencesPanelSettings.getScheduleLimitDays();
        this.scheduleLimitHours = schedulerPreferencesPanelSettings.getScheduleLimitHours();
        this.scheduleLimitMins = schedulerPreferencesPanelSettings.getScheduleLimitMins();
        this.scheduleNameGen = new UniqueScheduleNameGenerator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean emailServerExist() {
        String string = "SELECT VALUE FROM all_scheduler_global_attribute WHERE attribute_name = 'EMAIL_SERVER'";
        boolean bl = false;
        try (SQLHelper sQLHelper = new SQLHelper();){
            Connection connection = sQLHelper.conn = ConnectionFolder.getConnection(this.context);
            synchronized (connection) {
                if (sQLHelper.conn.isClosed()) {
                    throw new RuntimeException("Connection was closed unexpectedly.");
                }
                sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
                sQLHelper.ors = (OracleResultSet)sQLHelper.pstmt.executeQuery();
                if (sQLHelper.ors.next()) {
                    String string2 = sQLHelper.ors.getString("VALUE");
                    bl = string2 != null && string2.trim().length() > 0;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadJobs() throws SQLException {
        String string = "SELECT JOB_CLASS_NAME from ALL_SCHEDULER_JOB_CLASSES";
        try (SQLHelper sQLHelper = new SQLHelper();){
            Connection connection = sQLHelper.conn = ConnectionFolder.getConnection(this.context);
            synchronized (connection) {
                Object object;
                if (sQLHelper.conn.isClosed()) {
                    throw new RuntimeException("Connection was closed unexpectedly.");
                }
                sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
                sQLHelper.ors = (OracleResultSet)sQLHelper.pstmt.executeQuery();
                this.jobClasses.clear();
                while (sQLHelper.ors.next()) {
                    object = sQLHelper.ors.getString("JOB_CLASS_NAME");
                    this.jobClasses.add((String)object);
                }
                if (this.jobClass == null) {
                    this.jobClass = ConfigUtils.getDefaultWorkflowJobClass(sQLHelper.conn);
                    if (this.jobClass.isEmpty()) {
                        this.jobClass = "DEFAULT_JOB_CLASS";
                    }
                }
                object = ConnectionFolder.getConnectionFolder(this.context);
                this.isWorkflowJobClassAllowed = ConfigUtils.isWorkflowJobClassAllowed((ConnectionManager)object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSchedules() throws SQLException {
        String string = "SELECT SCHEDULE_NAME, START_DATE, REPEAT_INTERVAL, END_DATE, COMMENTS FROM USER_SCHEDULER_SCHEDULES";
        try (SQLHelper sQLHelper = new SQLHelper();){
            Connection connection = sQLHelper.conn = ConnectionFolder.getConnection(this.context);
            synchronized (connection) {
                if (sQLHelper.conn.isClosed()) {
                    throw new RuntimeException("Connection was closed unexpectedly.");
                }
                sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
                sQLHelper.ors = (OracleResultSet)sQLHelper.pstmt.executeQuery();
                this.schedules.clear();
                while (sQLHelper.ors.next()) {
                    String string2 = sQLHelper.ors.getString("SCHEDULE_NAME");
                    TIMESTAMPTZ tIMESTAMPTZ = sQLHelper.ors.getTIMESTAMPTZ("START_DATE");
                    String string3 = sQLHelper.ors.getString("REPEAT_INTERVAL");
                    TIMESTAMPTZ tIMESTAMPTZ2 = sQLHelper.ors.getTIMESTAMPTZ("END_DATE");
                    String string4 = sQLHelper.ors.getString("COMMENTS");
                    boolean bl = string4 != null ? !string4.equals(ODMR_OWNED_SCHEDULE) : true;
                    ScheduleInfo scheduleInfo = new ScheduleInfo(sQLHelper.conn, string2, tIMESTAMPTZ, string3, tIMESTAMPTZ2, bl);
                    this.schedules.add(scheduleInfo);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRunNodes() throws SQLException {
        String string = "SELECT a.WF_ID, a.NODE_ID FROM ODMR_USER_WORKFLOW_ALL_POLL a\nWHERE a.WF_JOB_NAME = :1 AND a.NODE_ID NOT IN ('WF_START','WF_END')";
        String string2 = "SELECT DISTINCT b.NODE_NAME, b.NODE_TYPE FROM ODMR_USER_WORKFLOW_NODES b\nWHERE b.WORKFLOW_ID = {0} AND b.NODE_ID IN ({1})";
        String string3 = (String)this.job_data.get("JOB_NAME");
        try (SQLHelper sQLHelper = new SQLHelper();){
            String string4;
            sQLHelper.conn = ConnectionFolder.getConnection(this.context);
            Object object = sQLHelper.conn;
            synchronized (object) {
                if (sQLHelper.conn.isClosed()) {
                    throw new RuntimeException("Connection was closed unexpectedly.");
                }
            }
            sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
            sQLHelper.pstmt.setString(1, string3);
            sQLHelper.ors = (OracleResultSet)sQLHelper.pstmt.executeQuery();
            object = null;
            StringBuffer stringBuffer = new StringBuffer();
            while (sQLHelper.ors.next()) {
                object = sQLHelper.ors.getString("WF_ID");
                string4 = sQLHelper.ors.getString("NODE_ID");
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(string4);
            }
            sQLHelper.ors.close();
            sQLHelper.pstmt.close();
            this.nodes.clear();
            if (stringBuffer.length() > 0) {
                string4 = MessageFormat.format(string2, object, stringBuffer.toString());
                sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string4);
                sQLHelper.ors = (OracleResultSet)sQLHelper.pstmt.executeQuery();
                while (sQLHelper.ors.next()) {
                    String string5 = sQLHelper.ors.getString("NODE_NAME");
                    String string6 = sQLHelper.ors.getString("NODE_TYPE");
                    RunNodeInfo runNodeInfo = new RunNodeInfo(string5, string6);
                    this.nodes.add(runNodeInfo);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws SQLException {
        String string = "WITH a AS\n(\n  SELECT\n    CHAIN_NAME,\n    PROJECT_NAME,\n    WORKFLOW_NAME\n  FROM ODMR_USER_PROJECT_WORKFLOW\n  WHERE PROJECT_ID = :1 AND WORKFLOW_ID = :2\n),\nb AS \n(\n  SELECT\n    PROJECT_NAME,\n    WORKFLOW_NAME,\n    JOB_ACTION,\n    JOB_NAME,\n    START_DATE,\n    END_DATE,\n    NEXT_RUN_DATE,\n    REPEAT_INTERVAL,\n    MAX_FAILURES,\n    MAX_RUNS,\n    MAX_RUN_DURATION,\n    SCHEDULE_LIMIT,\n    JOB_PRIORITY,\n    RAISE_EVENTS,\n    JOB_CLASS,\n    SCHEDULE_NAME,\n    STATE  \n  FROM\n  (\n    SELECT a.*, s.*, dense_rank() over (order by JOB_NAME desc) \"RANK\"\n    FROM a, user_scheduler_jobs s\n    WHERE JOB_ACTION = a.CHAIN_NAME AND SCHEDULE_TYPE IN ('ONCE','CALENDAR','NAMED')\n  )\n  WHERE rank = 1\n)\nselect distinct\n    b.PROJECT_NAME, \n    b.WORKFLOW_NAME,\n    b.JOB_ACTION, \n    b.JOB_NAME,\n    b.START_DATE,\n    b.END_DATE,\n    b.NEXT_RUN_DATE,\n    b.REPEAT_INTERVAL,\n    b.MAX_FAILURES,\n    b.MAX_RUNS,\n    b.MAX_RUN_DURATION,\n    b.SCHEDULE_LIMIT,\n    b.JOB_PRIORITY,\n    b.RAISE_EVENTS,\n    b.JOB_CLASS,\n    b.SCHEDULE_NAME,\n    b.STATE,\n    c.RECIPIENT,\n    c.SUBJECT,\n    c.BODY\n    from b, USER_SCHEDULER_NOTIFICATIONS c\n    where b.JOB_NAME = c.JOB_NAME(+)";
        try (SQLHelper sQLHelper = new SQLHelper();){
            Object object;
            StringBuffer stringBuffer;
            Connection connection = sQLHelper.conn = ConnectionFolder.getConnection(this.context);
            synchronized (connection) {
                if (sQLHelper.conn.isClosed()) {
                    throw new RuntimeException("Connection was closed unexpectedly.");
                }
                sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
                sQLHelper.pstmt.setBigDecimal(1, this.projectId);
                sQLHelper.pstmt.setBigDecimal(2, this.workflowId);
                sQLHelper.ors = (OracleResultSet)sQLHelper.pstmt.executeQuery();
                this.job_data.clear();
                stringBuffer = new StringBuffer();
                while (sQLHelper.ors.next()) {
                    this.job_data.put("PROJECT_NAME", sQLHelper.ors.getString("PROJECT_NAME"));
                    this.job_data.put("WORKFLOW_NAME", sQLHelper.ors.getString("WORKFLOW_NAME"));
                    this.job_data.put("START_DATE", sQLHelper.ors.getTIMESTAMPTZ("START_DATE"));
                    this.job_data.put("END_DATE", sQLHelper.ors.getTIMESTAMPTZ("END_DATE"));
                    this.job_data.put("NEXT_RUN_DATE", sQLHelper.ors.getTIMESTAMPTZ("NEXT_RUN_DATE"));
                    this.job_data.put("REPEAT_INTERVAL", sQLHelper.ors.getString("REPEAT_INTERVAL"));
                    this.job_data.put("MAX_FAILURES", sQLHelper.ors.getInt("MAX_FAILURES"));
                    this.job_data.put("MAX_RUNS", sQLHelper.ors.getInt("MAX_RUNS"));
                    this.job_data.put("MAX_RUN_DURATION", sQLHelper.ors.getINTERVALDS("MAX_RUN_DURATION"));
                    this.job_data.put("SCHEDULE_LIMIT", sQLHelper.ors.getINTERVALDS("SCHEDULE_LIMIT"));
                    this.job_data.put("JOB_PRIORITY", sQLHelper.ors.getInt("JOB_PRIORITY"));
                    this.job_data.put("RAISE_EVENTS", sQLHelper.ors.getString("RAISE_EVENTS"));
                    this.job_data.put("JOB_NAME", sQLHelper.ors.getString("JOB_NAME"));
                    this.job_data.put("JOB_CLASS", sQLHelper.ors.getString("JOB_CLASS"));
                    this.job_data.put("SCHEDULE_NAME", sQLHelper.ors.getString("SCHEDULE_NAME"));
                    this.job_data.put("STATE", sQLHelper.ors.getString("STATE"));
                    object = sQLHelper.ors.getString("RECIPIENT");
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(",");
                    }
                    if (object != null) {
                        stringBuffer.append((String)object);
                    }
                    this.job_data.put("SUBJECT", sQLHelper.ors.getString("SUBJECT"));
                    this.job_data.put("BODY", sQLHelper.ors.getString("BODY"));
                }
                if (stringBuffer.length() > 0) {
                    this.job_data.put("RECIPIENT", stringBuffer.toString());
                }
            }
            if (!this.job_data.isEmpty()) {
                String string2;
                String string3;
                String string4;
                String string5;
                String string6;
                Integer n;
                INTERVALDS iNTERVALDS;
                INTERVALDS iNTERVALDS2;
                connection = (TIMESTAMPTZ)this.job_data.get("START_DATE");
                this.calStartDate = SchedulerModel.toGregorianCalendar(sQLHelper.conn, (TIMESTAMPTZ)connection);
                this.timeZoneId = this.calStartDate.getTimeZone().getID();
                stringBuffer = (TIMESTAMPTZ)this.job_data.get("END_DATE");
                if (stringBuffer != null) {
                    this.calEndDate = SchedulerModel.toGregorianCalendar(sQLHelper.conn, (TIMESTAMPTZ)stringBuffer);
                }
                if ((object = (TIMESTAMPTZ)this.job_data.get("NEXT_RUN_DATE")) != null) {
                    this.calNextRunDate = SchedulerModel.toGregorianCalendar(sQLHelper.conn, object);
                }
                String string7 = (String)this.job_data.get("REPEAT_INTERVAL");
                this.repeat = SchedulerModel.getRepeat(string7);
                Integer n2 = (Integer)this.job_data.get("MAX_RUNS");
                if (stringBuffer != null) {
                    this.endRepeat = this.calEndDate;
                } else if (n2 != null && n2 > 0) {
                    this.maxRuns = n2;
                    this.endRepeat = this.maxRuns;
                } else {
                    this.endRepeat = null;
                }
                Integer n3 = (Integer)this.job_data.get("MAX_FAILURES");
                if (n3 != null && n3 > 0) {
                    this.useMaxFailures = true;
                    this.maxFailures = n3;
                }
                if ((iNTERVALDS2 = (INTERVALDS)this.job_data.get("MAX_RUN_DURATION")) != null) {
                    this.useMaxRunDuration = true;
                    this.maxRunDuration = OraINTERVALDS.getInstance((INTERVALDS)iNTERVALDS2);
                    this.maxRunDurationDays = this.maxRunDuration.get(1);
                    this.maxRunDurationHours = this.maxRunDuration.get(2);
                    this.maxRunDurationMins = this.maxRunDuration.get(3);
                }
                if ((iNTERVALDS = (INTERVALDS)this.job_data.get("SCHEDULE_LIMIT")) != null) {
                    this.useScheduleLimit = true;
                    this.scheduleLimit = OraINTERVALDS.getInstance((INTERVALDS)iNTERVALDS);
                    this.scheduleLimitDays = this.scheduleLimit.get(1);
                    this.scheduleLimitHours = this.scheduleLimit.get(2);
                    this.scheduleLimitMins = this.scheduleLimit.get(3);
                }
                if ((n = (Integer)this.job_data.get("JOB_PRIORITY")) != null) {
                    this.jobPriority = n;
                }
                if ((string6 = (String)this.job_data.get("SCHEDULE_NAME")) != null) {
                    this.useSchedule = true;
                    this.useSchedulePrev = true;
                    this.scheduleName = string6;
                }
                if ((string5 = (String)this.job_data.get("JOB_CLASS")) != null) {
                    this.jobClass = string5;
                }
                boolean bl = this.emailServerExist();
                String string8 = (String)this.job_data.get("RECIPIENT");
                if (string8 != null) {
                    this.emailRecipients = string8;
                }
                if ((string4 = (String)this.job_data.get("SUBJECT")) != null) {
                    this.emailSubject = string4;
                }
                if ((string3 = (String)this.job_data.get("BODY")) != null) {
                    int n4 = string3.indexOf(NOTIFICATION_ADDITIONAL_INFO_HEADER);
                    if (n4 > 0) {
                        this.emailComment = string3.substring(0, n4);
                        this.useNotification = bl;
                    } else {
                        this.emailComment = string3;
                        this.useNotification = false;
                    }
                }
                if ((string2 = (String)this.job_data.get("RAISE_EVENTS")) != null) {
                    string2 = string2.toUpperCase();
                    this.useEventStarted = string2.contains("JOB_STARTED");
                    this.useEventSucceeded = string2.contains("JOB_SUCCEEDED") || string2.contains("JOB_COMPLETED");
                    this.useEventFailed = string2.contains("JOB_BROKEN") || string2.contains("JOB_FAILED") || string2.contains("JOB_OVER_MAX_DUR") || string2.contains("JOB_SCH_LIM_REACHED");
                    this.useEventStopped = string2.contains("JOB_STOPPED");
                }
            }
        }
    }

    public static Repeat getRepeat(String string) {
        Repeat repeat = null;
        if (string != null && !string.isEmpty()) {
            Object object;
            String[] stringArray;
            Object object2;
            Object object3;
            String string2 = null;
            Integer n = null;
            String[] stringArray2 = null;
            String string3 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                object3 = stringTokenizer.nextToken().trim();
                object2 = new StringTokenizer((String)object3, "=");
                if (!object2.hasMoreTokens()) continue;
                stringArray = object2.nextToken().trim();
                object = object2.nextToken().trim();
                if (stringArray.equalsIgnoreCase("FREQ")) {
                    string2 = object;
                    continue;
                }
                if (stringArray.equalsIgnoreCase("INTERVAL")) {
                    n = Integer.valueOf(object);
                    continue;
                }
                if (!stringArray.equalsIgnoreCase("BYDAY") && !stringArray.equalsIgnoreCase("BYMONTHDAY") && !stringArray.equalsIgnoreCase("BYDATE")) continue;
                stringArray2 = stringArray;
                string3 = object;
            }
            if ("DAILY".equals(string2)) {
                repeat = n == null ? new RepeatDailyBasic() : new RepeatDailyInterval(n);
            } else if ("HOURLY".equals(string2)) {
                repeat = new RepeatHourInterval(n);
            } else if ("WEEKLY".equals(string2)) {
                if (n == null) {
                    repeat = new RepeatWeeklyBasic();
                } else if ("BYDAY".equals(stringArray2)) {
                    stringTokenizer = new StringTokenizer(string3, ",");
                    object3 = new ArrayList();
                    while (stringTokenizer.hasMoreTokens()) {
                        object2 = stringTokenizer.nextToken().trim();
                        ((ArrayList)object3).add(SchedulerModel.toDayType((String)object2));
                    }
                    repeat = new RepeatWeeklyInterval(n, ((ArrayList)object3).toArray(new DayType[((ArrayList)object3).size()]));
                }
            } else if ("MONTHLY".equals(string2)) {
                if ("BYDAY".equals(stringArray2)) {
                    object3 = DayType.DAY;
                    object2 = string3.split("[a-zA-Z]{3}");
                    stringArray = string3.split("\\d+");
                    object = SchedulerModel.toOrderType(object2[0]);
                    object3 = SchedulerModel.toDayType(stringArray[1]);
                    repeat = new RepeatMonthlyInterval(n, (OrderType)((Object)object), (DayType)((Object)object3));
                } else if ("BYMONTHDAY".equals(stringArray2)) {
                    stringTokenizer = new StringTokenizer(string3, ",");
                    object3 = new ArrayList();
                    while (stringTokenizer.hasMoreTokens()) {
                        object2 = stringTokenizer.nextToken().trim();
                        ((ArrayList)object3).add(object2);
                    }
                    repeat = new RepeatMonthlyInterval(n, ((ArrayList)object3).toArray(new String[((ArrayList)object3).size()]));
                }
            } else if ("YEARLY".equals(string2)) {
                stringTokenizer = new StringTokenizer(string3, ",");
                object3 = new ArrayList();
                while (stringTokenizer.hasMoreTokens()) {
                    object2 = stringTokenizer.nextToken().trim();
                    ((ArrayList)object3).add(object2);
                }
                repeat = new RepeatYearlyInterval(n, ((ArrayList)object3).toArray(new String[((ArrayList)object3).size()]));
            }
        }
        return repeat;
    }

    private static DayType toDayType(String string) {
        if (string.equalsIgnoreCase("MON")) {
            return DayType.MON;
        }
        if (string.equalsIgnoreCase("TUE")) {
            return DayType.TUE;
        }
        if (string.equalsIgnoreCase("WED")) {
            return DayType.WED;
        }
        if (string.equalsIgnoreCase("THU")) {
            return DayType.THU;
        }
        if (string.equalsIgnoreCase("FRI")) {
            return DayType.FRI;
        }
        if (string.equalsIgnoreCase("SAT")) {
            return DayType.SAT;
        }
        if (string.equalsIgnoreCase("SUN")) {
            return DayType.SUN;
        }
        if (string.equalsIgnoreCase("DAY")) {
            return DayType.DAY;
        }
        return null;
    }

    private static OrderType toOrderType(String string) {
        if ("1".equals(string)) {
            return OrderType.FIRST;
        }
        if ("2".equals(string)) {
            return OrderType.SECOND;
        }
        if ("3".equals(string)) {
            return OrderType.THIRD;
        }
        if ("4".equals(string)) {
            return OrderType.FOURTH;
        }
        if ("5".equals(string)) {
            return OrderType.FIFTH;
        }
        if ("-1".equals(string)) {
            return OrderType.LAST;
        }
        return null;
    }

    private static TIMESTAMPTZ toTIMESTAMPTZ(Connection connection, GregorianCalendar gregorianCalendar, String string) throws SQLException {
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2);
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(n, n2, n3, n4, n5, 0);
        gregorianCalendar2.setTimeZone(TimeZone.getTimeZone(string));
        TIMESTAMPTZ tIMESTAMPTZ = new TIMESTAMPTZ(connection, new Date(gregorianCalendar2.getTime().getTime()), (Calendar)gregorianCalendar2);
        return tIMESTAMPTZ;
    }

    private static GregorianCalendar toGregorianCalendar(Connection connection, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        byte[] byArray = tIMESTAMPTZ.toBytes();
        String string = TimeUtils.getRegionName(byArray);
        Object object = tIMESTAMPTZ.stringValue(connection);
        int n = ((String)object).lastIndexOf(".");
        String string2 = ((String)object).substring(0, n);
        String string3 = ((String)object).substring(n);
        n = string3.lastIndexOf(" ");
        object = string2 + string3.substring(n);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z");
        LocalDateTime localDateTime = null;
        try {
            localDateTime = LocalDateTime.parse((CharSequence)object, dateTimeFormatter);
        }
        catch (Exception exception) {
            Logger.getLogger(SchedulerModel.class.getName()).log(Level.SEVERE, exception.getMessage(), exception);
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.of(localDateTime, ZoneId.of(string));
        GregorianCalendar gregorianCalendar = GregorianCalendar.from(zonedDateTime);
        return gregorianCalendar;
    }

    public BigDecimal getProjectId() {
        return this.projectId;
    }

    public BigDecimal getWorkflowId() {
        return this.workflowId;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public GregorianCalendar getStartDate() {
        return this.calStartDate;
    }

    public void setStartDate(GregorianCalendar gregorianCalendar) {
        this.calStartDate = gregorianCalendar;
    }

    public GregorianCalendar getEndDate() {
        return this.calEndDate;
    }

    public void setEndDate(GregorianCalendar gregorianCalendar) {
        this.calEndDate = gregorianCalendar;
    }

    public Repeat getRepeat() {
        return this.repeat;
    }

    public void setRepeat(Repeat repeat) {
        this.repeat = repeat;
    }

    public void setEndRepeat(Object object) {
        this.endRepeat = object;
    }

    public Object getEndRepeat() {
        return this.endRepeat;
    }

    public void setUseSchedule(boolean bl) {
        this.useSchedule = bl;
    }

    public boolean isUseSchedule() {
        return this.useSchedule;
    }

    public void setScheduleName(String string) {
        this.scheduleName = string;
    }

    public String getScheduleName() {
        return this.scheduleName;
    }

    public void setMaxFailures(Integer n) {
        this.maxFailures = n;
    }

    public Integer getMaxFailures() {
        return this.maxFailures;
    }

    public void setMaxRunDuration(OraINTERVALDS oraINTERVALDS) {
        this.maxRunDuration = oraINTERVALDS;
    }

    public OraINTERVALDS getMaxRunDuration() {
        return this.maxRunDuration;
    }

    public void setScheduleLimit(OraINTERVALDS oraINTERVALDS) {
        this.scheduleLimit = oraINTERVALDS;
    }

    public OraINTERVALDS getScheduleLimit() {
        return this.scheduleLimit;
    }

    public void setJobPriority(Integer n) {
        this.jobPriority = n;
    }

    public Integer getJobPriority() {
        return this.jobPriority;
    }

    public String[] getAllTimeZones() {
        Object[] objectArray = TimeZone.getAvailableIDs();
        Arrays.sort(objectArray);
        return objectArray;
    }

    public String getTimeZone() {
        return this.timeZoneId;
    }

    public void setTimeZone(String string) {
        this.timeZoneId = string;
    }

    public void setMaxRuns(Integer n) {
        this.maxRuns = n;
    }

    public Integer getMaxRuns() {
        return this.maxRuns;
    }

    public void setJobClass(String string) {
        this.jobClass = string;
    }

    public String getJobClass() {
        return this.jobClass;
    }

    public void setUseNotification(boolean bl) {
        this.useNotification = bl;
    }

    public boolean isUseNotification() {
        return this.useNotification;
    }

    public void setEmailRecipients(String string) {
        this.emailRecipients = string;
    }

    public String getEmailRecipients() {
        return this.emailRecipients;
    }

    public void setEmailSubject(String string) {
        this.emailSubject = string;
    }

    public String getEmailSubject() {
        return this.emailSubject;
    }

    public void setEmailComment(String string) {
        this.emailComment = string;
    }

    public String getEmailComment() {
        return this.emailComment;
    }

    public void setUseEventStarted(boolean bl) {
        this.useEventStarted = bl;
    }

    public boolean isUseEventStarted() {
        return this.useEventStarted;
    }

    public void setUseEventSucceeded(boolean bl) {
        this.useEventSucceeded = bl;
    }

    public boolean isUseEventSucceeded() {
        return this.useEventSucceeded;
    }

    public void setUseEventFailed(boolean bl) {
        this.useEventFailed = bl;
    }

    public boolean isUseEventFailed() {
        return this.useEventFailed;
    }

    public void setUseEventStopped(boolean bl) {
        this.useEventStopped = bl;
    }

    public boolean isUseEventStopped() {
        return this.useEventStopped;
    }

    public void setUseMaxFailures(boolean bl) {
        this.useMaxFailures = bl;
    }

    public boolean isUseMaxFailures() {
        return this.useMaxFailures;
    }

    public void setUseMaxRunDuration(boolean bl) {
        this.useMaxRunDuration = bl;
    }

    public boolean isUseMaxRunDuration() {
        return this.useMaxRunDuration;
    }

    public void setMaxRunDurationDays(int n) {
        this.maxRunDurationDays = n;
    }

    public int getMaxRunDurationDays() {
        return this.maxRunDurationDays;
    }

    public void setMaxRunDurationHours(int n) {
        this.maxRunDurationHours = n;
    }

    public int getMaxRunDurationHours() {
        return this.maxRunDurationHours;
    }

    public void setMaxRunDurationMins(int n) {
        this.maxRunDurationMins = n;
    }

    public int getMaxRunDurationMins() {
        return this.maxRunDurationMins;
    }

    public void setUseScheduleLimit(boolean bl) {
        this.useScheduleLimit = bl;
    }

    public boolean isUseScheduleLimit() {
        return this.useScheduleLimit;
    }

    public void setScheduleLimitDays(int n) {
        this.scheduleLimitDays = n;
    }

    public int getScheduleLimitDays() {
        return this.scheduleLimitDays;
    }

    public void setScheduleLimitHours(int n) {
        this.scheduleLimitHours = n;
    }

    public int getScheduleLimitHours() {
        return this.scheduleLimitHours;
    }

    public void setScheduleLimitMins(int n) {
        this.scheduleLimitMins = n;
    }

    public int getScheduleLimitMins() {
        return this.scheduleLimitMins;
    }

    public GregorianCalendar getCalNextRunDate() {
        return this.calNextRunDate;
    }

    public List<RunNodeInfo> getNodes() {
        return this.nodes;
    }

    public List<String> getJobClasses() {
        return this.jobClasses;
    }

    public List<ScheduleInfo> getSchedules() {
        return this.schedules;
    }

    public String genUniqueScheduleName(String string) {
        return this.scheduleNameGen.getUniqueName(string);
    }

    public boolean doesScheduleNameExist(String string) {
        return this.scheduleNameGen.doesNameExist(string);
    }

    public boolean isIsWorkflowJobClassAllowed() {
        return this.isWorkflowJobClassAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GregorianCalendar getNextRunDate(Connection connection, TIMESTAMPTZ tIMESTAMPTZ, String string) throws SQLException, ODMrDAOException {
        SQLHelper sQLHelper = new SQLHelper();
        GregorianCalendar gregorianCalendar = null;
        try {
            Connection connection2 = sQLHelper.conn = connection;
            synchronized (connection2) {
                if (sQLHelper.conn.isClosed()) {
                    throw new RuntimeException("Connection was closed unexpectedly.");
                }
            }
            sQLHelper.cstmt = (OracleCallableStatement)sQLHelper.conn.prepareCall("begin DBMS_SCHEDULER.EVALUATE_CALENDAR_STRING(?, ?, ?, ?); end;");
            sQLHelper.cstmt.setString(1, string);
            sQLHelper.cstmt.setTIMESTAMPTZ(2, tIMESTAMPTZ);
            sQLHelper.cstmt.setNull(3, -101);
            sQLHelper.cstmt.registerOutParameter(4, -101);
            sQLHelper.cstmt.execute();
            connection2 = sQLHelper.cstmt.getTIMESTAMPTZ(4);
            if (connection2 != null) {
                gregorianCalendar = SchedulerModel.toGregorianCalendar(sQLHelper.conn, (TIMESTAMPTZ)connection2);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            sQLHelper.cstmt.close();
        }
        return gregorianCalendar;
    }

    public void editSchedule(Connection connection) throws SQLException, ODMrDAOException {
        String string = (String)this.job_data.get("JOB_NAME");
        SQLHelper sQLHelper = new SQLHelper();
        try {
            if (this.useSchedule) {
                if (!this.useSchedulePrev) {
                    sQLHelper.cstmt = (OracleCallableStatement)connection.prepareCall("begin DBMS_SCHEDULER.SET_ATTRIBUTE_NULL(?, ?); end;");
                    sQLHelper.cstmt.setString("name", string);
                    sQLHelper.cstmt.setString("attribute", "start_date");
                    sQLHelper.cstmt.execute();
                    sQLHelper.cstmt.setString("name", string);
                    sQLHelper.cstmt.setString("attribute", "repeat_interval");
                    sQLHelper.cstmt.execute();
                    sQLHelper.cstmt.setString("name", string);
                    sQLHelper.cstmt.setString("attribute", "end_date");
                    sQLHelper.cstmt.execute();
                    sQLHelper.cstmt.close();
                }
                sQLHelper.cstmt = (OracleCallableStatement)connection.prepareCall("begin DBMS_SCHEDULER.SET_ATTRIBUTE(?, ?, ?); end;");
                sQLHelper.cstmt.setString("name", string);
                sQLHelper.cstmt.setString("attribute", "SCHEDULE_NAME");
                sQLHelper.cstmt.setString("value", this.scheduleName);
                sQLHelper.cstmt.execute();
            } else {
                if (this.useSchedulePrev) {
                    sQLHelper.cstmt = (OracleCallableStatement)connection.prepareCall("begin DBMS_SCHEDULER.SET_ATTRIBUTE_NULL(?, ?); end;");
                    sQLHelper.cstmt.setString("name", string);
                    sQLHelper.cstmt.setString("attribute", "SCHEDULE_NAME");
                    sQLHelper.cstmt.execute();
                    sQLHelper.cstmt.close();
                }
                sQLHelper.cstmt = (OracleCallableStatement)connection.prepareCall("begin DBMS_SCHEDULER.SET_ATTRIBUTE(?, ?, ?); end;");
                sQLHelper.cstmt.setString("name", string);
                sQLHelper.cstmt.setString("attribute", "start_date");
                TIMESTAMPTZ tIMESTAMPTZ = SchedulerModel.toTIMESTAMPTZ(connection, this.calStartDate, this.timeZoneId);
                sQLHelper.cstmt.setTIMESTAMPTZ("value", tIMESTAMPTZ);
                sQLHelper.cstmt.execute();
                sQLHelper.cstmt.setString("name", string);
                sQLHelper.cstmt.setString("attribute", "repeat_interval");
                if (this.repeat != null) {
                    sQLHelper.cstmt.setString("value", this.repeat.toIntervalString());
                } else {
                    sQLHelper.cstmt.setNull("value", 12);
                }
                sQLHelper.cstmt.execute();
                if (this.endRepeat != null && this.endRepeat instanceof Calendar && this.calEndDate != null) {
                    sQLHelper.cstmt.setString("name", string);
                    sQLHelper.cstmt.setString("attribute", "end_date");
                    tIMESTAMPTZ = SchedulerModel.toTIMESTAMPTZ(connection, this.calEndDate, this.timeZoneId);
                    sQLHelper.cstmt.setTIMESTAMPTZ("value", tIMESTAMPTZ);
                    sQLHelper.cstmt.execute();
                } else {
                    sQLHelper.cstmt.setString("name", string);
                    sQLHelper.cstmt.setString("attribute", "end_date");
                    sQLHelper.cstmt.setNull("value", -101);
                    sQLHelper.cstmt.execute();
                }
                if (this.endRepeat != null && this.endRepeat instanceof Integer && this.maxRuns != null && this.maxRuns > 0) {
                    sQLHelper.cstmt.setString("name", string);
                    sQLHelper.cstmt.setString("attribute", "max_runs");
                    sQLHelper.cstmt.setInt("value", this.maxRuns.intValue());
                    sQLHelper.cstmt.execute();
                } else {
                    sQLHelper.cstmt.setString("name", string);
                    sQLHelper.cstmt.setString("attribute", "max_runs");
                    sQLHelper.cstmt.setNull("value", 2);
                    sQLHelper.cstmt.execute();
                }
            }
            if (this.jobClass != null) {
                sQLHelper.cstmt.setString("name", string);
                sQLHelper.cstmt.setString("attribute", "job_class");
                sQLHelper.cstmt.setString("value", this.jobClass);
                sQLHelper.cstmt.execute();
            } else {
                sQLHelper.cstmt.setString("name", string);
                sQLHelper.cstmt.setString("attribute", "job_class");
                sQLHelper.cstmt.setNull("value", 12);
                sQLHelper.cstmt.execute();
            }
            sQLHelper.cstmt.close();
            this.emailNotification(connection, string);
            this.maxFailures(connection, string);
            this.maxRunDuration(connection, string);
            this.scheduleLimit(connection, string);
            this.maxRuns(connection, string);
            this.jobPriority(connection, string);
        }
        catch (SQLException sQLException) {
            try {
                this.cancelSchedule(connection);
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw sQLException;
        }
        finally {
            sQLHelper.cstmt.close();
        }
    }

    public String createSchedule(Connection connection) throws SQLException, ODMrDAOException {
        String string = null;
        OracleConnection oracleConnection = (OracleConnection)connection;
        SQLHelper sQLHelper = new SQLHelper();
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.runMode != Workflow.ScheduleRunMode.RERUN) {
                for (Node node : this.selectedNodes) {
                    arrayList.add(node.getMetadataId());
                }
            }
            Array array = oracleConnection.createOracleArray("ODMR_OBJECT_IDS", (Object)arrayList.toArray(new String[arrayList.size()]));
            sQLHelper.cstmt = this.useSchedule ? (OracleCallableStatement)oracleConnection.prepareCall("begin ? := ODMRSYS.ODMR_WORKFLOW.WF_RUN(?, ?, ?, ?, ?, ?, ?); end;") : (OracleCallableStatement)oracleConnection.prepareCall("begin ? := ODMRSYS.ODMR_WORKFLOW.WF_RUN(?, ?, ?, ?, ?, ?, ?, ?, ?); end;");
            sQLHelper.cstmt.registerOutParameter(1, 12);
            sQLHelper.cstmt.setBigDecimal(2, this.projectId);
            sQLHelper.cstmt.setBigDecimal(3, this.workflowId);
            sQLHelper.cstmt.setArray(4, array);
            sQLHelper.cstmt.setString(5, this.runMode.toString());
            sQLHelper.cstmt.setNull(6, 4);
            if (this.useSchedule) {
                sQLHelper.cstmt.setString(7, this.scheduleName);
                if (this.jobClass != null) {
                    sQLHelper.cstmt.setString(8, this.jobClass);
                } else {
                    sQLHelper.cstmt.setNull(8, 12);
                }
            } else {
                Node node;
                node = SchedulerModel.toTIMESTAMPTZ((Connection)oracleConnection, this.calStartDate, this.timeZoneId);
                sQLHelper.cstmt.setTIMESTAMPTZ(7, (TIMESTAMPTZ)node);
                if (this.repeat != null) {
                    sQLHelper.cstmt.setString(8, this.repeat.toIntervalString());
                } else {
                    sQLHelper.cstmt.setNull(8, 12);
                }
                if (this.endRepeat != null && this.endRepeat instanceof Calendar && this.calEndDate != null) {
                    node = SchedulerModel.toTIMESTAMPTZ((Connection)oracleConnection, this.calEndDate, this.timeZoneId);
                    sQLHelper.cstmt.setTIMESTAMPTZ(9, (TIMESTAMPTZ)node);
                } else {
                    sQLHelper.cstmt.setNull(9, -101);
                }
                if (this.jobClass != null) {
                    sQLHelper.cstmt.setString(10, this.jobClass);
                } else {
                    sQLHelper.cstmt.setNull(10, 12);
                }
            }
            sQLHelper.cstmt.execute();
            string = sQLHelper.cstmt.getString(1);
            sQLHelper.cstmt.close();
            this.emailNotification((Connection)oracleConnection, string);
            this.maxFailures((Connection)oracleConnection, string);
            this.maxRunDuration((Connection)oracleConnection, string);
            this.scheduleLimit((Connection)oracleConnection, string);
            this.maxRuns((Connection)oracleConnection, string);
            this.jobPriority((Connection)oracleConnection, string);
        }
        catch (SQLException sQLException) {
            try {
                this.cancelSchedule(connection);
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw sQLException;
        }
        finally {
            sQLHelper.cstmt.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createScheduleObject() throws SQLException {
        sQLHelper.conn = ConnectionFolder.getConnection(this.context, ConnectionProperties.UNIQUE);
        try (SQLHelper sQLHelper = new SQLHelper();){
            OracleConnection oracleConnection = (OracleConnection)sQLHelper.conn;
            sQLHelper.cstmt = (OracleCallableStatement)oracleConnection.prepareCall("begin DBMS_SCHEDULER.CREATE_SCHEDULE(?, ?, ?, ?, ?); end;");
            sQLHelper.cstmt.setString("schedule_name", StringUtils.addDoubleQuotes(this.scheduleName));
            TIMESTAMPTZ tIMESTAMPTZ = SchedulerModel.toTIMESTAMPTZ((Connection)oracleConnection, this.calStartDate, this.timeZoneId);
            sQLHelper.cstmt.setTIMESTAMPTZ("start_date", tIMESTAMPTZ);
            if (this.repeat != null) {
                sQLHelper.cstmt.setString("repeat_interval", this.repeat.toIntervalString());
            } else {
                sQLHelper.cstmt.setNull("repeat_interval", 12);
            }
            if (this.endRepeat != null && this.endRepeat instanceof Calendar && this.calEndDate != null) {
                tIMESTAMPTZ = SchedulerModel.toTIMESTAMPTZ((Connection)oracleConnection, this.calEndDate, this.timeZoneId);
                sQLHelper.cstmt.setTIMESTAMPTZ("end_date", tIMESTAMPTZ);
            } else {
                sQLHelper.cstmt.setNull("end_date", -101);
            }
            sQLHelper.cstmt.setString("comments", ODMR_OWNED_SCHEDULE);
            sQLHelper.cstmt.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editScheduleObject() throws SQLException {
        sQLHelper.conn = ConnectionFolder.getConnection(this.context, ConnectionProperties.UNIQUE);
        try (SQLHelper sQLHelper = new SQLHelper();){
            OracleConnection oracleConnection = (OracleConnection)sQLHelper.conn;
            sQLHelper.cstmt = (OracleCallableStatement)oracleConnection.prepareCall("begin DBMS_SCHEDULER.SET_ATTRIBUTE(?, ?, ?); end;");
            sQLHelper.cstmt.setString("name", this.scheduleName);
            sQLHelper.cstmt.setString("attribute", "start_date");
            TIMESTAMPTZ tIMESTAMPTZ = SchedulerModel.toTIMESTAMPTZ((Connection)oracleConnection, this.calStartDate, this.timeZoneId);
            sQLHelper.cstmt.setTIMESTAMPTZ("value", tIMESTAMPTZ);
            sQLHelper.cstmt.execute();
            sQLHelper.cstmt.setString("name", this.scheduleName);
            sQLHelper.cstmt.setString("attribute", "repeat_interval");
            if (this.repeat != null) {
                sQLHelper.cstmt.setString("value", this.repeat.toIntervalString());
            } else {
                sQLHelper.cstmt.setNull("value", 12);
            }
            sQLHelper.cstmt.execute();
            if (this.endRepeat != null && this.endRepeat instanceof Calendar && this.calEndDate != null) {
                sQLHelper.cstmt.setString("name", this.scheduleName);
                sQLHelper.cstmt.setString("attribute", "end_date");
                tIMESTAMPTZ = SchedulerModel.toTIMESTAMPTZ((Connection)oracleConnection, this.calEndDate, this.timeZoneId);
                sQLHelper.cstmt.setTIMESTAMPTZ("value", tIMESTAMPTZ);
                sQLHelper.cstmt.execute();
            } else {
                sQLHelper.cstmt.setString("name", this.scheduleName);
                sQLHelper.cstmt.setString("attribute", "end_date");
                sQLHelper.cstmt.setNull("value", -101);
                sQLHelper.cstmt.execute();
            }
        }
    }

    public void removeScheduleObject() throws SQLException {
        sQLHelper.conn = ConnectionFolder.getConnection(this.context, ConnectionProperties.UNIQUE);
        try (SQLHelper sQLHelper = new SQLHelper();){
            OracleConnection oracleConnection = (OracleConnection)sQLHelper.conn;
            sQLHelper.cstmt = (OracleCallableStatement)oracleConnection.prepareCall("begin DBMS_SCHEDULER.DROP_SCHEDULE(?); end;");
            sQLHelper.cstmt.setString("schedule_name", StringUtils.addDoubleQuotes(this.scheduleName));
            sQLHelper.cstmt.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadWorkflowAndProjectNames() throws SQLException {
        String string = "SELECT \na.PROJECT_NAME,\na.WORKFLOW_NAME \nFROM\nODMR_USER_PROJECT_WORKFLOW a \nWHERE a.PROJECT_ID = :1 AND a.WORKFLOW_ID = :2";
        try (SQLHelper sQLHelper = new SQLHelper();){
            Connection connection = sQLHelper.conn = ConnectionFolder.getConnection(this.context);
            synchronized (connection) {
                if (sQLHelper.conn.isClosed()) {
                    throw new RuntimeException("Connection was closed unexpectedly.");
                }
                sQLHelper.pstmt = sQLHelper.conn.prepareStatement(string);
                sQLHelper.pstmt.setBigDecimal(1, this.projectId);
                sQLHelper.pstmt.setBigDecimal(2, this.workflowId);
                sQLHelper.ors = (OracleResultSet)sQLHelper.pstmt.executeQuery();
                while (sQLHelper.ors.next()) {
                    this.job_data.put("PROJECT_NAME", sQLHelper.ors.getString("PROJECT_NAME"));
                    this.job_data.put("WORKFLOW_NAME", sQLHelper.ors.getString("WORKFLOW_NAME"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emailNotification(Connection connection, String string) throws SQLException {
        String string2 = (String)this.job_data.get("PROJECT_NAME");
        String string3 = (String)this.job_data.get("WORKFLOW_NAME");
        if (string2 == null || string3 == null) {
            this.loadWorkflowAndProjectNames();
        }
        string2 = (String)this.job_data.get("PROJECT_NAME");
        string3 = (String)this.job_data.get("WORKFLOW_NAME");
        String string4 = MessageFormat.format(NOTIFICATION_ADDITIONAL_INFO_BODY, ConnectionFolder.getConnectionName(this.context), ConnectionFolder.getUserAccountName(this.context), string2, string3);
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.cstmt = (OracleCallableStatement)connection.prepareCall("begin DBMS_SCHEDULER.REMOVE_JOB_EMAIL_NOTIFICATION(?, ?, ?); end;");
            sQLHelper.cstmt.setString("job_name", string);
            sQLHelper.cstmt.setNull("recipients", 12);
            sQLHelper.cstmt.setNull("events", 12);
            sQLHelper.cstmt.execute();
        }
        catch (SQLException sQLException) {
        }
        finally {
            sQLHelper.cstmt.close();
        }
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.useNotification) {
                if (this.useEventStarted) {
                    stringBuffer.append("JOB_STARTED");
                }
                if (this.useEventSucceeded) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append("JOB_SUCCEEDED,JOB_COMPLETED");
                }
                if (this.useEventFailed) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append("JOB_BROKEN,JOB_FAILED,JOB_OVER_MAX_DUR,JOB_SCH_LIM_REACHED");
                }
                if (this.useEventStopped) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append("JOB_STOPPED");
                }
                if (stringBuffer.length() > 0) {
                    sQLHelper.cstmt = (OracleCallableStatement)connection.prepareCall("begin DBMS_SCHEDULER.ADD_JOB_EMAIL_NOTIFICATION(?, ?, ?, ?, ?, ?, ?); end;");
                    sQLHelper.cstmt.setString(1, string);
                    sQLHelper.cstmt.setString(2, this.emailRecipients);
                    sQLHelper.cstmt.setNull(3, 12);
                    this.emailSubject = this.emailSubject.replaceAll("%workflow_name%", string3);
                    this.emailSubject = this.emailSubject.replaceAll("%project_name%", string2);
                    sQLHelper.cstmt.setString(4, this.emailSubject);
                    sQLHelper.cstmt.setString(5, this.emailComment + "\n\n" + NOTIFICATION_ADDITIONAL_INFO_HEADER + "\n\n" + string4);
                    if (stringBuffer.length() > 0) {
                        sQLHelper.cstmt.setString(6, stringBuffer.toString());
                    } else {
                        sQLHelper.cstmt.setNull(6, 12);
                    }
                    sQLHelper.cstmt.setNull(7, 12);
                    sQLHelper.cstmt.execute();
                }
            }
        }
        finally {
            sQLHelper.cstmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maxFailures(Connection connection, String string) throws SQLException {
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.cstmt = (OracleCallableStatement)connection.prepareCall("begin DBMS_SCHEDULER.SET_ATTRIBUTE_NULL(?, ?); end;");
            sQLHelper.cstmt.setString("name", string);
            sQLHelper.cstmt.setString("attribute", "max_failures");
            sQLHelper.cstmt.execute();
        }
        catch (SQLException sQLException) {
        }
        finally {
            sQLHelper.cstmt.close();
        }
        try {
            if (this.useMaxFailures) {
                sQLHelper.cstmt = (OracleCallableStatement)connection.prepareCall("begin DBMS_SCHEDULER.SET_ATTRIBUTE(?, ?, ?); end;");
                sQLHelper.cstmt.setString("name", string);
                sQLHelper.cstmt.setString("attribute", "max_failures");
                sQLHelper.cstmt.setInt("value", this.maxFailures);
                sQLHelper.cstmt.execute();
            }
        }
        finally {
            sQLHelper.cstmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maxRunDuration(Connection connection, String string) throws SQLException {
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.cstmt = (OracleCallableStatement)connection.prepareCall("begin DBMS_SCHEDULER.SET_ATTRIBUTE_NULL(?, ?); end;");
            sQLHelper.cstmt.setString("name", string);
            sQLHelper.cstmt.setString("attribute", "max_run_duration");
            sQLHelper.cstmt.execute();
        }
        catch (SQLException sQLException) {
        }
        finally {
            sQLHelper.cstmt.close();
        }
        try {
            if (this.useMaxRunDuration) {
                sQLHelper.cstmt = (OracleCallableStatement)connection.prepareCall("begin DBMS_SCHEDULER.SET_ATTRIBUTE(?, ?, ?); end;");
                sQLHelper.cstmt.setString("name", string);
                sQLHelper.cstmt.setString("attribute", "max_run_duration");
                INTERVALDS iNTERVALDS = OraINTERVALDS.getInstance((int)this.maxRunDurationDays, (int)this.maxRunDurationHours, (int)this.maxRunDurationMins, (int)0, (int)0).getDatum();
                sQLHelper.cstmt.setINTERVALDS("value", iNTERVALDS);
                sQLHelper.cstmt.execute();
            }
        }
        finally {
            sQLHelper.cstmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleLimit(Connection connection, String string) throws SQLException {
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.cstmt = (OracleCallableStatement)connection.prepareCall("begin DBMS_SCHEDULER.SET_ATTRIBUTE_NULL(?, ?); end;");
            sQLHelper.cstmt.setString("name", string);
            sQLHelper.cstmt.setString("attribute", "schedule_limit");
            sQLHelper.cstmt.execute();
        }
        catch (SQLException sQLException) {
        }
        finally {
            sQLHelper.cstmt.close();
        }
        try {
            if (this.useScheduleLimit) {
                sQLHelper.cstmt = (OracleCallableStatement)connection.prepareCall("begin DBMS_SCHEDULER.SET_ATTRIBUTE(?, ?, ?); end;");
                sQLHelper.cstmt.setString("name", string);
                sQLHelper.cstmt.setString("attribute", "schedule_limit");
                INTERVALDS iNTERVALDS = OraINTERVALDS.getInstance((int)this.scheduleLimitDays, (int)this.scheduleLimitHours, (int)this.scheduleLimitMins, (int)0, (int)0).getDatum();
                sQLHelper.cstmt.setINTERVALDS("value", iNTERVALDS);
                sQLHelper.cstmt.execute();
            }
        }
        finally {
            sQLHelper.cstmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maxRuns(Connection connection, String string) throws SQLException {
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.cstmt = (OracleCallableStatement)connection.prepareCall("begin DBMS_SCHEDULER.SET_ATTRIBUTE_NULL(?, ?); end;");
            sQLHelper.cstmt.setString("name", string);
            sQLHelper.cstmt.setString("attribute", "max_runs");
            sQLHelper.cstmt.execute();
        }
        catch (SQLException sQLException) {
        }
        finally {
            sQLHelper.cstmt.close();
        }
        try {
            if (this.endRepeat != null && this.endRepeat instanceof Integer && this.maxRuns != null && this.maxRuns > 0) {
                sQLHelper.cstmt = (OracleCallableStatement)connection.prepareCall("begin DBMS_SCHEDULER.SET_ATTRIBUTE(?, ?, ?); end;");
                sQLHelper.cstmt.setString("name", string);
                sQLHelper.cstmt.setString("attribute", "max_runs");
                sQLHelper.cstmt.setInt("value", this.maxRuns.intValue());
                sQLHelper.cstmt.execute();
            }
        }
        finally {
            sQLHelper.cstmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jobPriority(Connection connection, String string) throws SQLException {
        SQLHelper sQLHelper = new SQLHelper();
        try {
            sQLHelper.cstmt = (OracleCallableStatement)connection.prepareCall("begin DBMS_SCHEDULER.SET_ATTRIBUTE_NULL(?, ?); end;");
            sQLHelper.cstmt.setString("name", string);
            sQLHelper.cstmt.setString("attribute", "job_priority");
            sQLHelper.cstmt.execute();
        }
        catch (SQLException sQLException) {
        }
        finally {
            sQLHelper.cstmt.close();
        }
        try {
            if (this.jobPriority > 0) {
                sQLHelper.cstmt = (OracleCallableStatement)connection.prepareCall("begin DBMS_SCHEDULER.SET_ATTRIBUTE(?, ?, ?); end;");
                sQLHelper.cstmt.setString("name", string);
                sQLHelper.cstmt.setString("attribute", "job_priority");
                sQLHelper.cstmt.setInt("value", this.jobPriority);
                sQLHelper.cstmt.execute();
            }
        }
        finally {
            sQLHelper.cstmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelSchedule(Connection connection) throws SQLException {
        try (SQLHelper sQLHelper = new SQLHelper();){
            OracleConnection oracleConnection = (OracleConnection)connection;
            sQLHelper.cstmt = (OracleCallableStatement)oracleConnection.prepareCall("begin ODMRSYS.ODMR_WORKFLOW.WF_STOP(?); end;");
            sQLHelper.cstmt.setBigDecimal("p_workflowId", this.workflowId);
            sQLHelper.cstmt.execute();
        }
    }

    private class UniqueScheduleNameGenerator {
        private boolean isExpandedObjNameEnabled;
        private static final int MAXIMUM = 30;
        private static final int MAXIMUM_EX = 128;

        public UniqueScheduleNameGenerator() {
            this.isExpandedObjNameEnabled = SQLHelper.isExpandedObjNameEnabled(SchedulerModel.this.context);
        }

        public String getUniqueName(String string) {
            int n = 0;
            Object object = string;
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            for (ScheduleInfo scheduleInfo : SchedulerModel.this.getSchedules()) {
                hashMap.put(scheduleInfo.getName(), Boolean.TRUE);
            }
            while (hashMap.containsKey(object)) {
                int n2;
                if ((n2 = ((String)(object = string + ++n)).length()) <= (this.isExpandedObjNameEnabled ? 128 : 30)) continue;
                int n3 = n2 - (this.isExpandedObjNameEnabled ? 128 : 30);
                object = string.substring(0, string.length() - n3) + n;
            }
            return object;
        }

        public boolean doesNameExist(String string) {
            for (ScheduleInfo scheduleInfo : SchedulerModel.this.getSchedules()) {
                if (string.compareTo(scheduleInfo.getName()) != 0) continue;
                return true;
            }
            return false;
        }
    }

    public static class ScheduleInfo {
        String name;
        GregorianCalendar calStartDate;
        GregorianCalendar calEndDate;
        GregorianCalendar calNextRunDate;
        Repeat repeat;
        boolean readOnly;

        ScheduleInfo() {
            this.name = null;
            this.calStartDate = null;
            this.calEndDate = null;
            this.calNextRunDate = null;
            this.repeat = null;
            this.readOnly = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ScheduleInfo(Connection connection, String string, TIMESTAMPTZ tIMESTAMPTZ, String string2, TIMESTAMPTZ tIMESTAMPTZ2, boolean bl) {
            this.name = string;
            this.readOnly = bl;
            try {
                if (tIMESTAMPTZ != null) {
                    this.calStartDate = SchedulerModel.toGregorianCalendar(connection, tIMESTAMPTZ);
                }
                this.calEndDate = tIMESTAMPTZ2 != null ? SchedulerModel.toGregorianCalendar(connection, tIMESTAMPTZ2) : null;
                if (!bl) {
                    this.repeat = SchedulerModel.getRepeat(string2);
                }
                this.calNextRunDate = SchedulerModel.getNextRunDate(connection, tIMESTAMPTZ, string2);
                if (this.calEndDate != null && this.calNextRunDate.after(this.calEndDate)) {
                    this.calNextRunDate = null;
                }
            }
            catch (SQLException | ODMrDAOException throwable) {
                Logger.getLogger(SchedulerModel.class.getName()).log(Level.SEVERE, throwable.getMessage(), throwable);
            }
        }

        public String toString() {
            return this.getName();
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public GregorianCalendar getCalStartDate() {
            return this.calStartDate;
        }

        public GregorianCalendar getCalEndDate() {
            return this.calEndDate;
        }

        public GregorianCalendar getCalNextRunDate() {
            return this.calNextRunDate;
        }

        public String toNextRunDateString() {
            Object object = DialogsLrb.get("SCHEDULER_SCHEDULE_EXPIRED");
            if (this.calNextRunDate != null) {
                Locale locale = Locale.getDefault();
                DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, locale);
                dateFormat.setTimeZone(this.calNextRunDate.getTimeZone());
                object = dateFormat.format(this.calNextRunDate.getTime());
                String string = this.calNextRunDate.getTimeZone().getID();
                object = (String)object + " " + string;
            }
            return object;
        }

        public Repeat getRepeat() {
            return this.repeat;
        }

        public Object getEndRepeat() {
            if (this.repeat != null) {
                return this.repeat;
            }
            return null;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }
    }

    public static class RunNodeInfo {
        String name;
        String type;

        RunNodeInfo(String string, String string2) {
            this.name = string;
            this.type = string2;
        }

        public String toString() {
            return this.getName();
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }

    public static class RepeatYearlyInterval
    extends RepeatInterval {
        String[] dates;

        public RepeatYearlyInterval(Integer n, String[] stringArray) {
            super(n);
            this.dates = stringArray;
        }

        public String[] getDates() {
            return this.dates;
        }

        @Override
        public String toIntervalString() {
            String string = MessageFormat.format("FREQ=YEARLY;INTERVAL={0}", this.interval);
            String string2 = "";
            if (this.dates.length > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                for (String string3 : this.dates) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(string3);
                }
                string2 = MessageFormat.format(";BYDATE={0}", stringBuffer.toString());
            }
            return string + string2;
        }

        @Override
        public String displaySchedule() {
            String string = null;
            if (this.interval > 1) {
                string = "" + this.interval;
            }
            if (this.dates.length > 0) {
                String string2 = null;
                String string3 = null;
                StringBuffer stringBuffer = new StringBuffer();
                for (String string4 : this.dates) {
                    string2 = string4.substring(0, 2);
                    string3 = string4.substring(2);
                    if (string3.startsWith("0")) {
                        string3 = string3.substring(1);
                    }
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(", ");
                    }
                    if ("01".equals(string2)) {
                        stringBuffer.append(DialogsLrb.get("SCHEDULER_REPEAT_JANUARY"));
                        continue;
                    }
                    if ("02".equals(string2)) {
                        stringBuffer.append(DialogsLrb.get("SCHEDULER_REPEAT_FEBRUARY"));
                        continue;
                    }
                    if ("03".equals(string2)) {
                        stringBuffer.append(DialogsLrb.get("SCHEDULER_REPEAT_MARCH"));
                        continue;
                    }
                    if ("04".equals(string2)) {
                        stringBuffer.append(DialogsLrb.get("SCHEDULER_REPEAT_APRIL"));
                        continue;
                    }
                    if ("05".equals(string2)) {
                        stringBuffer.append(DialogsLrb.get("SCHEDULER_REPEAT_MAY"));
                        continue;
                    }
                    if ("06".equals(string2)) {
                        stringBuffer.append(DialogsLrb.get("SCHEDULER_REPEAT_JUNE"));
                        continue;
                    }
                    if ("07".equals(string2)) {
                        stringBuffer.append(DialogsLrb.get("SCHEDULER_REPEAT_JULY"));
                        continue;
                    }
                    if ("08".equals(string2)) {
                        stringBuffer.append(DialogsLrb.get("SCHEDULER_REPEAT_AUGUST"));
                        continue;
                    }
                    if ("09".equals(string2)) {
                        stringBuffer.append(DialogsLrb.get("SCHEDULER_REPEAT_SEPTEMBER"));
                        continue;
                    }
                    if ("10".equals(string2)) {
                        stringBuffer.append(DialogsLrb.get("SCHEDULER_REPEAT_OCTOBER"));
                        continue;
                    }
                    if ("11".equals(string2)) {
                        stringBuffer.append(DialogsLrb.get("SCHEDULER_REPEAT_NOVEMBER"));
                        continue;
                    }
                    if (!"12".equals(string2)) continue;
                    stringBuffer.append(DialogsLrb.get("SCHEDULER_REPEAT_DECEMBER"));
                }
                StringBuffer stringBuffer2 = new StringBuffer(string3);
                if ("1".equals(string3)) {
                    stringBuffer2.append("st");
                } else if ("2".equals(string3)) {
                    stringBuffer2.append("nd");
                } else if ("3".equals(string3)) {
                    stringBuffer2.append("rd");
                } else {
                    stringBuffer2.append("th");
                }
                if (string == null) {
                    return MessageFormat.format(DialogsLrb.get("SCHEDULER_REPEAT_DISPLAY_YEARLY_SCHEDULE_MONTHS"), stringBuffer2.toString(), stringBuffer.toString());
                }
                return MessageFormat.format(DialogsLrb.get("SCHEDULER_REPEAT_DISPLAY_YEARLY_SCHEDULE_MONTHS2"), string, stringBuffer2.toString(), stringBuffer.toString());
            }
            if (string == null) {
                return DialogsLrb.get("SCHEDULER_REPEAT_DISPLAY_YEARLY_SCHEDULE");
            }
            return MessageFormat.format(DialogsLrb.get("SCHEDULER_REPEAT_DISPLAY_YEARLY_SCHEDULE2"), string);
        }
    }

    public static class RepeatMonthlyInterval
    extends RepeatInterval {
        OrderType order;
        DayType day;
        String[] dates;

        public RepeatMonthlyInterval(Integer n, OrderType orderType, DayType dayType) {
            super(n);
            this.order = orderType;
            this.day = dayType;
        }

        public RepeatMonthlyInterval(Integer n, String[] stringArray) {
            super(n);
            this.dates = stringArray;
        }

        public boolean isDatesSelected() {
            return this.dates != null && this.dates.length > 0;
        }

        public String[] getDates() {
            return this.dates;
        }

        public OrderType getOrder() {
            return this.order;
        }

        public DayType getDay() {
            return this.day;
        }

        @Override
        public String toIntervalString() {
            String string = MessageFormat.format("FREQ=MONTHLY;INTERVAL={0}", this.interval);
            String string2 = "";
            if (this.dates != null && this.dates.length > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                for (String string3 : this.dates) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(string3);
                }
                string2 = MessageFormat.format(";BYMONTHDAY={0}", stringBuffer.toString());
            } else {
                string2 = this.day == DayType.DAY ? MessageFormat.format(";BYMONTHDAY={0}", this.order.getValue()) : MessageFormat.format(";BYDAY={0}{1}", this.order.getValue(), this.day.getValue());
            }
            return string + string2;
        }

        @Override
        public String displaySchedule() {
            String string = null;
            if (this.interval > 1) {
                string = "" + this.interval;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (this.isDatesSelected()) {
                for (String string2 : this.dates) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(", ");
                    }
                    if ("-1".equals(string2)) {
                        stringBuffer.append(DialogsLrb.get("SCHEDULER_REPEAT_LAST"));
                        continue;
                    }
                    stringBuffer.append(string2);
                    if ("1".equals(string2)) {
                        stringBuffer.append("st");
                        continue;
                    }
                    if ("2".equals(string2)) {
                        stringBuffer.append("nd");
                        continue;
                    }
                    if ("3".equals(string2)) {
                        stringBuffer.append("rd");
                        continue;
                    }
                    stringBuffer.append("th");
                }
                if (string == null) {
                    return MessageFormat.format(DialogsLrb.get("SCHEDULER_REPEAT_DISPLAY_MONTHLY_SCHEDULE_DAYS"), stringBuffer.toString());
                }
                return MessageFormat.format(DialogsLrb.get("SCHEDULER_REPEAT_DISPLAY_MONTHLY_SCHEDULE_DAYS2"), string, stringBuffer.toString());
            }
            if (string == null) {
                return MessageFormat.format(DialogsLrb.get("SCHEDULER_REPEAT_DISPLAY_MONTHLY_SCHEDULE_DAY"), this.order.toString(), this.day.toString());
            }
            return MessageFormat.format(DialogsLrb.get("SCHEDULER_REPEAT_DISPLAY_MONTHLY_SCHEDULE_DAY2"), string, this.order.toString(), this.day.toString());
        }
    }

    public static class RepeatWeeklyInterval
    extends RepeatInterval {
        DayType[] days;

        public RepeatWeeklyInterval(Integer n, DayType[] dayTypeArray) {
            super(n);
            this.days = dayTypeArray;
        }

        public DayType[] getDays() {
            return this.days;
        }

        @Override
        public String toIntervalString() {
            String string = MessageFormat.format("FREQ=WEEKLY;INTERVAL={0}", this.interval);
            String string2 = "";
            if (this.days.length > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                for (DayType dayType : this.days) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(dayType.getValue());
                }
                string2 = MessageFormat.format(";BYDAY={0}", stringBuffer.toString());
            }
            return string + string2;
        }

        @Override
        public String displaySchedule() {
            String string = null;
            if (this.interval > 1) {
                string = "" + this.interval;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (this.days.length > 0) {
                for (DayType dayType : this.days) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(dayType.toString());
                }
                if (string == null) {
                    return MessageFormat.format(DialogsLrb.get("SCHEDULER_REPEAT_DISPLAY_WEEKLY_SCHEDULE_DAYS"), stringBuffer.toString());
                }
                return MessageFormat.format(DialogsLrb.get("SCHEDULER_REPEAT_DISPLAY_WEEKLY_SCHEDULE_DAYS2"), string, stringBuffer.toString());
            }
            if (string == null) {
                return DialogsLrb.get("SCHEDULER_REPEAT_DISPLAY_WEEKLY_SCHEDULE");
            }
            return MessageFormat.format(DialogsLrb.get("SCHEDULER_REPEAT_DISPLAY_WEEKLY_SCHEDULE2"), string);
        }
    }

    public static class RepeatDailyInterval
    extends RepeatInterval {
        public RepeatDailyInterval(Integer n) {
            super(n);
        }

        @Override
        public String toIntervalString() {
            return MessageFormat.format("FREQ=DAILY;INTERVAL={0}", this.interval);
        }

        @Override
        public String displaySchedule() {
            if (this.interval > 1) {
                return MessageFormat.format(DialogsLrb.get("SCHEDULER_REPEAT_DISPLAY_DAILY_SCHEDULE2"), this.interval);
            }
            return DialogsLrb.get("SCHEDULER_REPEAT_DISPLAY_DAILY_SCHEDULE");
        }
    }

    public static class RepeatHourInterval
    extends RepeatInterval {
        public RepeatHourInterval(Integer n) {
            super(n);
        }

        @Override
        public String toIntervalString() {
            return MessageFormat.format("FREQ=HOURLY;INTERVAL={0}", this.interval);
        }

        @Override
        public String displaySchedule() {
            if (this.interval > 1) {
                return MessageFormat.format(DialogsLrb.get("SCHEDULER_REPEAT_DISPLAY_HOURLY_SCHEDULE2"), this.interval);
            }
            return DialogsLrb.get("SCHEDULER_REPEAT_DISPLAY_HOURLY_SCHEDULE");
        }
    }

    public static abstract class RepeatInterval
    extends Repeat {
        Integer interval;

        public RepeatInterval(Integer n) {
            this.interval = n;
        }

        public int getInterval() {
            return this.interval;
        }
    }

    public static class RepeatWeeklyBasic
    extends Repeat {
        @Override
        public String toIntervalString() {
            return "FREQ=WEEKLY";
        }

        @Override
        public String displaySchedule() {
            return DialogsLrb.get("SCHEDULER_REPEAT_DISPLAY_WEEKLY_ONLY_SCHEDULE");
        }
    }

    public static class RepeatDailyBasic
    extends Repeat {
        @Override
        public String toIntervalString() {
            return "FREQ=DAILY";
        }

        @Override
        public String displaySchedule() {
            return DialogsLrb.get("SCHEDULER_REPEAT_DISPLAY_DAILY_ONLY_SCHEDULE");
        }
    }

    public static abstract class Repeat {
        public abstract String toIntervalString();

        public abstract String displaySchedule();
    }

    public static enum OrderType {
        FIRST("1"),
        SECOND("2"),
        THIRD("3"),
        FOURTH("4"),
        FIFTH("5"),
        LAST("-1");

        private String value;

        private OrderType(String string2) {
            this.value = string2;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            if (this.value.equalsIgnoreCase("1")) {
                return DialogsLrb.get("SCHEDULER_REPEAT_FIRST");
            }
            if (this.value.equalsIgnoreCase("2")) {
                return DialogsLrb.get("SCHEDULER_REPEAT_SECOND");
            }
            if (this.value.equalsIgnoreCase("3")) {
                return DialogsLrb.get("SCHEDULER_REPEAT_THIRD");
            }
            if (this.value.equalsIgnoreCase("4")) {
                return DialogsLrb.get("SCHEDULER_REPEAT_FOURTH");
            }
            if (this.value.equalsIgnoreCase("5")) {
                return DialogsLrb.get("SCHEDULER_REPEAT_FIFTH");
            }
            if (this.value.equalsIgnoreCase("-1")) {
                return DialogsLrb.get("SCHEDULER_REPEAT_LAST");
            }
            return null;
        }

        public static OrderType getEnum(String string) {
            for (OrderType orderType : OrderType.values()) {
                if (!orderType.getValue().equalsIgnoreCase(string)) continue;
                return orderType;
            }
            throw new IllegalArgumentException();
        }
    }

    public static enum DayType {
        MON("MON"),
        TUE("TUE"),
        WED("WED"),
        THU("THU"),
        FRI("FRI"),
        SAT("SAT"),
        SUN("SUN"),
        DAY("DAY");

        private String value;

        private DayType(String string2) {
            this.value = string2;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            if (this.value.equalsIgnoreCase("MON")) {
                return DialogsLrb.get("SCHEDULER_REPEAT_MONDAY");
            }
            if (this.value.equalsIgnoreCase("TUE")) {
                return DialogsLrb.get("SCHEDULER_REPEAT_TUESDAY");
            }
            if (this.value.equalsIgnoreCase("WED")) {
                return DialogsLrb.get("SCHEDULER_REPEAT_WEDNESDAY");
            }
            if (this.value.equalsIgnoreCase("THU")) {
                return DialogsLrb.get("SCHEDULER_REPEAT_THURSDAY");
            }
            if (this.value.equalsIgnoreCase("FRI")) {
                return DialogsLrb.get("SCHEDULER_REPEAT_FRIDAY");
            }
            if (this.value.equalsIgnoreCase("SAT")) {
                return DialogsLrb.get("SCHEDULER_REPEAT_SATURDAY");
            }
            if (this.value.equalsIgnoreCase("SUN")) {
                return DialogsLrb.get("SCHEDULER_REPEAT_SUNDAY");
            }
            if (this.value.equalsIgnoreCase("DAY")) {
                return DialogsLrb.get("SCHEDULER_REPEAT_DAY");
            }
            return null;
        }

        public static DayType getEnum(String string) {
            for (DayType dayType : DayType.values()) {
                if (!dayType.getValue().equalsIgnoreCase(string)) continue;
                return dayType;
            }
            throw new IllegalArgumentException();
        }
    }
}

