/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.scheduler;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.scheduler.DialogsLrb;
import oracle.dmt.dataminer.workflow.scheduler.MonthPanel;
import oracle.dmt.dataminer.workflow.scheduler.SchedulerModel;
import oracle.ide.Context;
import oracle.ide.help.HelpSystem;

public class ScheduleRepeatPanel
extends DialogDisplayer<AbstractNode> {
    private JDialog dialog;
    private JDialog parent;
    private SchedulerModel model;
    private MonthPanel calendarPanel;
    private boolean isUIRendering = false;
    private static String SCHEDULER_REPEAT_CUSTOM_OPTION_HOURLY = DialogsLrb.get("SCHEDULER_REPEAT_CUSTOM_OPTION_HOURLY");
    private static String SCHEDULER_REPEAT_CUSTOM_OPTION_DAILY = DialogsLrb.get("SCHEDULER_REPEAT_CUSTOM_OPTION_DAILY");
    private static String SCHEDULER_REPEAT_CUSTOM_OPTION_WEEKLY = DialogsLrb.get("SCHEDULER_REPEAT_CUSTOM_OPTION_WEEKLY");
    private static String SCHEDULER_REPEAT_CUSTOM_OPTION_MONTHLY = DialogsLrb.get("SCHEDULER_REPEAT_CUSTOM_OPTION_MONTHLY");
    private static String SCHEDULER_REPEAT_CUSTOM_OPTION_YEARLY = DialogsLrb.get("SCHEDULER_REPEAT_CUSTOM_OPTION_YEARLY");
    private static String SCHEDULER_REPEAT_EVERY_HOUR = DialogsLrb.get("SCHEDULER_REPEAT_EVERY_HOUR_LBL");
    private static String SCHEDULER_REPEAT_EVERY_DAY = DialogsLrb.get("SCHEDULER_REPEAT_EVERY_DAY_LBL");
    private static String SCHEDULER_REPEAT_EVERY_WEEK = DialogsLrb.get("SCHEDULER_REPEAT_EVERY_WEEK_LBL");
    private static String SCHEDULER_REPEAT_EVERY_MONTH = DialogsLrb.get("SCHEDULER_REPEAT_EVERY_MONTH_LBL");
    private static String SCHEDULER_REPEAT_EVERY_YEAR = DialogsLrb.get("SCHEDULER_REPEAT_EVERY_YEAR_LBL");
    private static String SCHEDULER_REPEAT_WEEKLY_SUN = DialogsLrb.get("SCHEDULER_REPEAT_WEEKLY_SUN");
    private static String SCHEDULER_REPEAT_WEEKLY_MON = DialogsLrb.get("SCHEDULER_REPEAT_WEEKLY_MON");
    private static String SCHEDULER_REPEAT_WEEKLY_TUE = DialogsLrb.get("SCHEDULER_REPEAT_WEEKLY_TUE");
    private static String SCHEDULER_REPEAT_WEEKLY_WED = DialogsLrb.get("SCHEDULER_REPEAT_WEEKLY_WED");
    private static String SCHEDULER_REPEAT_WEEKLY_THUR = DialogsLrb.get("SCHEDULER_REPEAT_WEEKLY_THUR");
    private static String SCHEDULER_REPEAT_WEEKLY_FRI = DialogsLrb.get("SCHEDULER_REPEAT_WEEKLY_FRI");
    private static String SCHEDULER_REPEAT_WEEKLY_SAT = DialogsLrb.get("SCHEDULER_REPEAT_WEEKLY_SAT");
    private static String SCHEDULER_REPEAT_FIRST = DialogsLrb.get("SCHEDULER_REPEAT_FIRST");
    private static String SCHEDULER_REPEAT_SECOND = DialogsLrb.get("SCHEDULER_REPEAT_SECOND");
    private static String SCHEDULER_REPEAT_THIRD = DialogsLrb.get("SCHEDULER_REPEAT_THIRD");
    private static String SCHEDULER_REPEAT_FOURTH = DialogsLrb.get("SCHEDULER_REPEAT_FOURTH");
    private static String SCHEDULER_REPEAT_FIFTH = DialogsLrb.get("SCHEDULER_REPEAT_FIFTH");
    private static String SCHEDULER_REPEAT_LAST = DialogsLrb.get("SCHEDULER_REPEAT_LAST");
    private static String SCHEDULER_REPEAT_SUNDAY = DialogsLrb.get("SCHEDULER_REPEAT_SUNDAY");
    private static String SCHEDULER_REPEAT_MONDAY = DialogsLrb.get("SCHEDULER_REPEAT_MONDAY");
    private static String SCHEDULER_REPEAT_TUESDAY = DialogsLrb.get("SCHEDULER_REPEAT_TUESDAY");
    private static String SCHEDULER_REPEAT_WEDNESDAY = DialogsLrb.get("SCHEDULER_REPEAT_WEDNESDAY");
    private static String SCHEDULER_REPEAT_THURSDAY = DialogsLrb.get("SCHEDULER_REPEAT_THURSDAY");
    private static String SCHEDULER_REPEAT_FRIDAY = DialogsLrb.get("SCHEDULER_REPEAT_FRIDAY");
    private static String SCHEDULER_REPEAT_SATURDAY = DialogsLrb.get("SCHEDULER_REPEAT_SATURDAY");
    private static String SCHEDULER_REPEAT_DAY = DialogsLrb.get("SCHEDULER_REPEAT_DAY");
    private static String SCHEDULER_REPEAT_YEARLY_JAN = DialogsLrb.get("SCHEDULER_REPEAT_YEARLY_JAN");
    private static String SCHEDULER_REPEAT_YEARLY_FEB = DialogsLrb.get("SCHEDULER_REPEAT_YEARLY_FEB");
    private static String SCHEDULER_REPEAT_YEARLY_MAR = DialogsLrb.get("SCHEDULER_REPEAT_YEARLY_MAR");
    private static String SCHEDULER_REPEAT_YEARLY_APR = DialogsLrb.get("SCHEDULER_REPEAT_YEARLY_APR");
    private static String SCHEDULER_REPEAT_YEARLY_MAY = DialogsLrb.get("SCHEDULER_REPEAT_YEARLY_MAY");
    private static String SCHEDULER_REPEAT_YEARLY_JUN = DialogsLrb.get("SCHEDULER_REPEAT_YEARLY_JUN");
    private static String SCHEDULER_REPEAT_YEARLY_JUL = DialogsLrb.get("SCHEDULER_REPEAT_YEARLY_JUL");
    private static String SCHEDULER_REPEAT_YEARLY_AUG = DialogsLrb.get("SCHEDULER_REPEAT_YEARLY_AUG");
    private static String SCHEDULER_REPEAT_YEARLY_SEP = DialogsLrb.get("SCHEDULER_REPEAT_YEARLY_SEP");
    private static String SCHEDULER_REPEAT_YEARLY_OCT = DialogsLrb.get("SCHEDULER_REPEAT_YEARLY_OCT");
    private static String SCHEDULER_REPEAT_YEARLY_NOV = DialogsLrb.get("SCHEDULER_REPEAT_YEARLY_NOV");
    private static String SCHEDULER_REPEAT_YEARLY_DEC = DialogsLrb.get("SCHEDULER_REPEAT_YEARLY_DEC");
    private ButtonGroup buttonGroup;
    private JCheckBox jAprCheckBox;
    private JCheckBox jAugCheckBox;
    private JPanel jCalPanel;
    private JComboBox jDayComboBox;
    private JComboBox jDayComboBox1;
    private JCheckBox jDecCheckBox;
    private JRadioButton jEachRadioButton;
    private JLabel jEveryLabel;
    private JSpinner jEverySpinner;
    private JLabel jEveryUnitLabel;
    private JCheckBox jFebCheckBox;
    private JComboBox jFrequencyComboBox;
    private JLabel jFrequencyLabel;
    private JCheckBox jFriCheckBox;
    private JCheckBox jJanCheckBox;
    private JCheckBox jJulyCheckBox;
    private JCheckBox jJunCheckBox;
    private JCheckBox jMarCheckBox;
    private JCheckBox jMayCheckBox;
    private JCheckBox jMonCheckBox;
    private JPanel jMonthlyPanel;
    private JCheckBox jNovCheckBox;
    private JCheckBox jOctCheckBox;
    private JCheckBox jOnTheCheckBox;
    private JRadioButton jOnTheRadioButton;
    private JCheckBox jSatCheckBox;
    private JCheckBox jSepCheckBox;
    private JCheckBox jSunCheckBox;
    private JCheckBox jThurCheckBox;
    private JCheckBox jTueCheckBox;
    private JCheckBox jWedCheckBox;
    private JPanel jWeeklyPanel;
    private JComboBox jWhichComboBox;
    private JComboBox jWhichComboBox1;
    private JPanel jYearlyPanel;

    public ScheduleRepeatPanel(Context context, JDialog jDialog, SchedulerModel schedulerModel) {
        super(context, null);
        this.parent = jDialog;
        this.model = schedulerModel;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("SCHEDULER_REPEAT_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return null;
    }

    private void setHelpTopic() {
        if (this.jFrequencyComboBox.getSelectedItem().equals(SCHEDULER_REPEAT_CUSTOM_OPTION_HOURLY)) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "scheduler_repeat_hourly");
        } else if (this.jFrequencyComboBox.getSelectedItem().equals(SCHEDULER_REPEAT_CUSTOM_OPTION_DAILY)) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "scheduler_repeat_daily");
        } else if (this.jFrequencyComboBox.getSelectedItem().equals(SCHEDULER_REPEAT_CUSTOM_OPTION_WEEKLY)) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "scheduler_repeat_weekly");
        } else if (this.jFrequencyComboBox.getSelectedItem().equals(SCHEDULER_REPEAT_CUSTOM_OPTION_MONTHLY)) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "scheduler_repeat_monthly");
        } else if (this.jFrequencyComboBox.getSelectedItem().equals(SCHEDULER_REPEAT_CUSTOM_OPTION_YEARLY)) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "scheduler_repeat_yearly");
        }
    }

    @Override
    public void initRes() {
        this.jFrequencyLabel.setText(DialogsLrb.get("SCHEDULER_REPEAT_FREQUENCY_LBL"));
        this.jEveryLabel.setText(DialogsLrb.get("SCHEDULER_REPEAT_EVERY_LBL"));
        this.jSunCheckBox.setText(SCHEDULER_REPEAT_WEEKLY_SUN);
        this.jMonCheckBox.setText(SCHEDULER_REPEAT_WEEKLY_MON);
        this.jTueCheckBox.setText(SCHEDULER_REPEAT_WEEKLY_TUE);
        this.jWedCheckBox.setText(SCHEDULER_REPEAT_WEEKLY_WED);
        this.jThurCheckBox.setText(SCHEDULER_REPEAT_WEEKLY_THUR);
        this.jFriCheckBox.setText(SCHEDULER_REPEAT_WEEKLY_FRI);
        this.jSatCheckBox.setText(SCHEDULER_REPEAT_WEEKLY_SAT);
        this.jEachRadioButton.setText(DialogsLrb.get("SCHEDULER_REPEAT_EACH_LBL"));
        this.jOnTheRadioButton.setText(DialogsLrb.get("SCHEDULER_REPEAT_ON_THE_LBL"));
        this.jJanCheckBox.setText(SCHEDULER_REPEAT_YEARLY_JAN);
        this.jFebCheckBox.setText(SCHEDULER_REPEAT_YEARLY_FEB);
        this.jMarCheckBox.setText(SCHEDULER_REPEAT_YEARLY_MAR);
        this.jAprCheckBox.setText(SCHEDULER_REPEAT_YEARLY_APR);
        this.jMayCheckBox.setText(SCHEDULER_REPEAT_YEARLY_MAY);
        this.jJunCheckBox.setText(SCHEDULER_REPEAT_YEARLY_JUN);
        this.jJulyCheckBox.setText(SCHEDULER_REPEAT_YEARLY_JUL);
        this.jAugCheckBox.setText(SCHEDULER_REPEAT_YEARLY_AUG);
        this.jSepCheckBox.setText(SCHEDULER_REPEAT_YEARLY_SEP);
        this.jOctCheckBox.setText(SCHEDULER_REPEAT_YEARLY_OCT);
        this.jNovCheckBox.setText(SCHEDULER_REPEAT_YEARLY_NOV);
        this.jDecCheckBox.setText(SCHEDULER_REPEAT_YEARLY_DEC);
        this.jOnTheCheckBox.setText(DialogsLrb.get("SCHEDULER_REPEAT_ON_THE_LBL"));
    }

    @Override
    public void initUI() {
        this.isUIRendering = true;
        this.jFrequencyComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{SCHEDULER_REPEAT_CUSTOM_OPTION_HOURLY, SCHEDULER_REPEAT_CUSTOM_OPTION_DAILY, SCHEDULER_REPEAT_CUSTOM_OPTION_WEEKLY, SCHEDULER_REPEAT_CUSTOM_OPTION_MONTHLY, SCHEDULER_REPEAT_CUSTOM_OPTION_YEARLY}));
        this.jEachRadioButton.setSelected(true);
        this.jWhichComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{SCHEDULER_REPEAT_FIRST, SCHEDULER_REPEAT_SECOND, SCHEDULER_REPEAT_THIRD, SCHEDULER_REPEAT_FOURTH, SCHEDULER_REPEAT_FIFTH, SCHEDULER_REPEAT_LAST}));
        this.jDayComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{SCHEDULER_REPEAT_SUNDAY, SCHEDULER_REPEAT_MONDAY, SCHEDULER_REPEAT_TUESDAY, SCHEDULER_REPEAT_WEDNESDAY, SCHEDULER_REPEAT_THURSDAY, SCHEDULER_REPEAT_FRIDAY, SCHEDULER_REPEAT_SATURDAY, SCHEDULER_REPEAT_DAY}));
        this.jWhichComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{SCHEDULER_REPEAT_FIRST, SCHEDULER_REPEAT_SECOND, SCHEDULER_REPEAT_THIRD, SCHEDULER_REPEAT_FOURTH, SCHEDULER_REPEAT_FIFTH, SCHEDULER_REPEAT_LAST}));
        this.jDayComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{SCHEDULER_REPEAT_SUNDAY, SCHEDULER_REPEAT_MONDAY, SCHEDULER_REPEAT_TUESDAY, SCHEDULER_REPEAT_WEDNESDAY, SCHEDULER_REPEAT_THURSDAY, SCHEDULER_REPEAT_FRIDAY, SCHEDULER_REPEAT_SATURDAY, SCHEDULER_REPEAT_DAY}));
        this.jEverySpinner.setModel(new SpinnerNumberModel(1, 1, 1000, 1));
        this.calendarPanel = new MonthPanel(Locale.getDefault(), null);
        this.jCalPanel.add(this.calendarPanel);
        this.calendarPanel.setBackground(this.getBackground());
        this.calendarPanel.setBorder(BorderFactory.createTitledBorder(DialogsLrb.get("SCHEDULER_REPEAT_DAY_OF_MONTH")));
        this.jOnTheCheckBox.setVisible(false);
        this.jWhichComboBox1.setVisible(false);
        this.jDayComboBox1.setVisible(false);
        this.initFrequencyOption();
        this.isUIRendering = false;
        this.setHelpTopic();
    }

    @Override
    public void customizeDialogProperties(JEWTDialog jEWTDialog) {
        super.customizeDialogProperties(jEWTDialog);
        this.dialog = jEWTDialog;
    }

    private void initFrequencyOption() {
        this.jWeeklyPanel.setVisible(false);
        this.jMonthlyPanel.setVisible(false);
        this.jYearlyPanel.setVisible(false);
        SchedulerModel.Repeat repeat = this.model.getRepeat();
        if (repeat instanceof SchedulerModel.RepeatHourInterval) {
            this.jFrequencyComboBox.setSelectedItem(SCHEDULER_REPEAT_CUSTOM_OPTION_HOURLY);
            this.jEveryUnitLabel.setText(SCHEDULER_REPEAT_EVERY_HOUR);
            SchedulerModel.RepeatHourInterval repeatHourInterval = (SchedulerModel.RepeatHourInterval)repeat;
            this.jEverySpinner.setValue(repeatHourInterval.getInterval());
        } else if (repeat instanceof SchedulerModel.RepeatDailyInterval) {
            this.jFrequencyComboBox.setSelectedItem(SCHEDULER_REPEAT_CUSTOM_OPTION_DAILY);
            this.jEveryUnitLabel.setText(SCHEDULER_REPEAT_EVERY_DAY);
            SchedulerModel.RepeatDailyInterval repeatDailyInterval = (SchedulerModel.RepeatDailyInterval)repeat;
            this.jEverySpinner.setValue(repeatDailyInterval.getInterval());
        } else if (repeat instanceof SchedulerModel.RepeatWeeklyInterval) {
            this.jFrequencyComboBox.setSelectedItem(SCHEDULER_REPEAT_CUSTOM_OPTION_WEEKLY);
            this.jEveryUnitLabel.setText(SCHEDULER_REPEAT_EVERY_WEEK);
            SchedulerModel.RepeatWeeklyInterval repeatWeeklyInterval = (SchedulerModel.RepeatWeeklyInterval)repeat;
            this.jEverySpinner.setValue(repeatWeeklyInterval.getInterval());
            this.jSunCheckBox.setSelected(false);
            this.jMonCheckBox.setSelected(false);
            this.jTueCheckBox.setSelected(false);
            this.jWedCheckBox.setSelected(false);
            this.jThurCheckBox.setSelected(false);
            this.jFriCheckBox.setSelected(false);
            this.jSatCheckBox.setSelected(false);
            for (SchedulerModel.DayType dayType : repeatWeeklyInterval.getDays()) {
                if (!this.jSunCheckBox.isSelected()) {
                    this.jSunCheckBox.setSelected(dayType == SchedulerModel.DayType.SUN);
                }
                if (!this.jMonCheckBox.isSelected()) {
                    this.jMonCheckBox.setSelected(dayType == SchedulerModel.DayType.MON);
                }
                if (!this.jTueCheckBox.isSelected()) {
                    this.jTueCheckBox.setSelected(dayType == SchedulerModel.DayType.TUE);
                }
                if (!this.jWedCheckBox.isSelected()) {
                    this.jWedCheckBox.setSelected(dayType == SchedulerModel.DayType.WED);
                }
                if (!this.jThurCheckBox.isSelected()) {
                    this.jThurCheckBox.setSelected(dayType == SchedulerModel.DayType.THU);
                }
                if (!this.jFriCheckBox.isSelected()) {
                    this.jFriCheckBox.setSelected(dayType == SchedulerModel.DayType.FRI);
                }
                if (this.jSatCheckBox.isSelected()) continue;
                this.jSatCheckBox.setSelected(dayType == SchedulerModel.DayType.SAT);
            }
            this.jWeeklyPanel.setVisible(true);
        } else if (repeat instanceof SchedulerModel.RepeatMonthlyInterval) {
            this.jFrequencyComboBox.setSelectedItem(SCHEDULER_REPEAT_CUSTOM_OPTION_MONTHLY);
            this.jEveryUnitLabel.setText(SCHEDULER_REPEAT_EVERY_MONTH);
            SchedulerModel.RepeatMonthlyInterval repeatMonthlyInterval = (SchedulerModel.RepeatMonthlyInterval)repeat;
            this.jEverySpinner.setValue(repeatMonthlyInterval.getInterval());
            if (repeatMonthlyInterval.isDatesSelected()) {
                this.calendarPanel.setSelectedDays(repeatMonthlyInterval.getDates());
                this.jEachRadioButton.setSelected(true);
            } else {
                SchedulerModel.OrderType orderType = repeatMonthlyInterval.getOrder();
                SchedulerModel.DayType dayType = repeatMonthlyInterval.getDay();
                if (orderType == SchedulerModel.OrderType.FIRST) {
                    this.jWhichComboBox.setSelectedItem(SCHEDULER_REPEAT_FIRST);
                } else if (orderType == SchedulerModel.OrderType.SECOND) {
                    this.jWhichComboBox.setSelectedItem(SCHEDULER_REPEAT_SECOND);
                } else if (orderType == SchedulerModel.OrderType.THIRD) {
                    this.jWhichComboBox.setSelectedItem(SCHEDULER_REPEAT_THIRD);
                } else if (orderType == SchedulerModel.OrderType.FOURTH) {
                    this.jWhichComboBox.setSelectedItem(SCHEDULER_REPEAT_FOURTH);
                } else if (orderType == SchedulerModel.OrderType.FIFTH) {
                    this.jWhichComboBox.setSelectedItem(SCHEDULER_REPEAT_FIFTH);
                } else if (orderType == SchedulerModel.OrderType.LAST) {
                    this.jWhichComboBox.setSelectedItem(SCHEDULER_REPEAT_LAST);
                }
                if (dayType == SchedulerModel.DayType.SUN) {
                    this.jDayComboBox.setSelectedItem(SCHEDULER_REPEAT_SUNDAY);
                } else if (dayType == SchedulerModel.DayType.MON) {
                    this.jDayComboBox.setSelectedItem(SCHEDULER_REPEAT_MONDAY);
                } else if (dayType == SchedulerModel.DayType.TUE) {
                    this.jDayComboBox.setSelectedItem(SCHEDULER_REPEAT_TUESDAY);
                } else if (dayType == SchedulerModel.DayType.WED) {
                    this.jDayComboBox.setSelectedItem(SCHEDULER_REPEAT_WEDNESDAY);
                } else if (dayType == SchedulerModel.DayType.THU) {
                    this.jDayComboBox.setSelectedItem(SCHEDULER_REPEAT_THURSDAY);
                } else if (dayType == SchedulerModel.DayType.FRI) {
                    this.jDayComboBox.setSelectedItem(SCHEDULER_REPEAT_FRIDAY);
                } else if (dayType == SchedulerModel.DayType.SAT) {
                    this.jDayComboBox.setSelectedItem(SCHEDULER_REPEAT_SATURDAY);
                } else if (dayType == SchedulerModel.DayType.DAY) {
                    this.jDayComboBox.setSelectedItem(SCHEDULER_REPEAT_DAY);
                }
                this.jOnTheRadioButton.setSelected(true);
            }
            this.jMonthlyPanel.setVisible(true);
        } else if (repeat instanceof SchedulerModel.RepeatYearlyInterval) {
            this.jFrequencyComboBox.setSelectedItem(SCHEDULER_REPEAT_CUSTOM_OPTION_YEARLY);
            this.jEveryUnitLabel.setText(SCHEDULER_REPEAT_EVERY_YEAR);
            SchedulerModel.RepeatYearlyInterval repeatYearlyInterval = (SchedulerModel.RepeatYearlyInterval)repeat;
            this.jEverySpinner.setValue(repeatYearlyInterval.getInterval());
            String[] stringArray = repeatYearlyInterval.getDates();
            this.jJanCheckBox.setSelected(false);
            this.jFebCheckBox.setSelected(false);
            this.jMarCheckBox.setSelected(false);
            this.jAprCheckBox.setSelected(false);
            this.jMayCheckBox.setSelected(false);
            this.jJunCheckBox.setSelected(false);
            this.jJulyCheckBox.setSelected(false);
            this.jAugCheckBox.setSelected(false);
            this.jSepCheckBox.setSelected(false);
            this.jOctCheckBox.setSelected(false);
            this.jNovCheckBox.setSelected(false);
            this.jDecCheckBox.setSelected(false);
            for (String string : stringArray) {
                String string2 = string.substring(0, 2);
                if (string2.equals("01")) {
                    this.jJanCheckBox.setSelected(true);
                }
                if (string2.equals("02")) {
                    this.jFebCheckBox.setSelected(true);
                }
                if (string2.equals("03")) {
                    this.jMarCheckBox.setSelected(true);
                }
                if (string2.equals("04")) {
                    this.jAprCheckBox.setSelected(true);
                }
                if (string2.equals("05")) {
                    this.jMayCheckBox.setSelected(true);
                }
                if (string2.equals("06")) {
                    this.jJunCheckBox.setSelected(true);
                }
                if (string2.equals("07")) {
                    this.jJulyCheckBox.setSelected(true);
                }
                if (string2.equals("08")) {
                    this.jAugCheckBox.setSelected(true);
                }
                if (string2.equals("09")) {
                    this.jSepCheckBox.setSelected(true);
                }
                if (string2.equals("10")) {
                    this.jOctCheckBox.setSelected(true);
                }
                if (string2.equals("11")) {
                    this.jNovCheckBox.setSelected(true);
                }
                if (!string2.equals("12")) continue;
                this.jDecCheckBox.setSelected(true);
            }
            this.jYearlyPanel.setVisible(true);
        }
        if (this.dialog != null) {
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(this.parent);
        }
    }

    private void updateFrequencyLayout() {
        this.jWeeklyPanel.setVisible(false);
        this.jMonthlyPanel.setVisible(false);
        this.jYearlyPanel.setVisible(false);
        if (this.jFrequencyComboBox.getSelectedItem().equals(SCHEDULER_REPEAT_CUSTOM_OPTION_HOURLY)) {
            this.jEveryUnitLabel.setText(SCHEDULER_REPEAT_EVERY_HOUR);
        } else if (this.jFrequencyComboBox.getSelectedItem().equals(SCHEDULER_REPEAT_CUSTOM_OPTION_DAILY)) {
            this.jEveryUnitLabel.setText(SCHEDULER_REPEAT_EVERY_DAY);
        } else if (this.jFrequencyComboBox.getSelectedItem().equals(SCHEDULER_REPEAT_CUSTOM_OPTION_WEEKLY)) {
            this.jEveryUnitLabel.setText(SCHEDULER_REPEAT_EVERY_WEEK);
            this.jWeeklyPanel.setVisible(true);
        } else if (this.jFrequencyComboBox.getSelectedItem().equals(SCHEDULER_REPEAT_CUSTOM_OPTION_MONTHLY)) {
            this.jEveryUnitLabel.setText(SCHEDULER_REPEAT_EVERY_MONTH);
            this.jMonthlyPanel.setVisible(true);
        } else if (this.jFrequencyComboBox.getSelectedItem().equals(SCHEDULER_REPEAT_CUSTOM_OPTION_YEARLY)) {
            this.jEveryUnitLabel.setText(SCHEDULER_REPEAT_EVERY_YEAR);
            this.jOnTheCheckBox.setVisible(false);
            this.jWhichComboBox1.setVisible(false);
            this.jDayComboBox1.setVisible(false);
            this.jYearlyPanel.setVisible(true);
        }
        if (this.dialog != null) {
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(this.parent);
        }
        this.setHelpTopic();
    }

    @Override
    protected boolean doWork() {
        JComboBox jComboBox = this.jFrequencyComboBox;
        if (jComboBox.getSelectedItem().equals(SCHEDULER_REPEAT_CUSTOM_OPTION_HOURLY)) {
            SchedulerModel.RepeatHourInterval repeatHourInterval = new SchedulerModel.RepeatHourInterval((Integer)this.jEverySpinner.getValue());
            this.model.setRepeat(repeatHourInterval);
        } else if (jComboBox.getSelectedItem().equals(SCHEDULER_REPEAT_CUSTOM_OPTION_DAILY)) {
            SchedulerModel.RepeatDailyInterval repeatDailyInterval = new SchedulerModel.RepeatDailyInterval((Integer)this.jEverySpinner.getValue());
            this.model.setRepeat(repeatDailyInterval);
        } else if (jComboBox.getSelectedItem().equals(SCHEDULER_REPEAT_CUSTOM_OPTION_WEEKLY)) {
            ArrayList<SchedulerModel.DayType> arrayList = new ArrayList<SchedulerModel.DayType>();
            if (this.jSunCheckBox.isSelected()) {
                arrayList.add(SchedulerModel.DayType.SUN);
            }
            if (this.jMonCheckBox.isSelected()) {
                arrayList.add(SchedulerModel.DayType.MON);
            }
            if (this.jTueCheckBox.isSelected()) {
                arrayList.add(SchedulerModel.DayType.TUE);
            }
            if (this.jWedCheckBox.isSelected()) {
                arrayList.add(SchedulerModel.DayType.WED);
            }
            if (this.jThurCheckBox.isSelected()) {
                arrayList.add(SchedulerModel.DayType.THU);
            }
            if (this.jFriCheckBox.isSelected()) {
                arrayList.add(SchedulerModel.DayType.FRI);
            }
            if (this.jSatCheckBox.isSelected()) {
                arrayList.add(SchedulerModel.DayType.SAT);
            }
            SchedulerModel.RepeatWeeklyInterval repeatWeeklyInterval = new SchedulerModel.RepeatWeeklyInterval((Integer)this.jEverySpinner.getValue(), arrayList.toArray(new SchedulerModel.DayType[arrayList.size()]));
            this.model.setRepeat(repeatWeeklyInterval);
        } else if (jComboBox.getSelectedItem().equals(SCHEDULER_REPEAT_CUSTOM_OPTION_MONTHLY)) {
            String[] stringArray = this.calendarPanel.getSelectedDays();
            SchedulerModel.RepeatMonthlyInterval repeatMonthlyInterval = null;
            if (this.jEachRadioButton.isSelected()) {
                repeatMonthlyInterval = new SchedulerModel.RepeatMonthlyInterval((Integer)this.jEverySpinner.getValue(), stringArray);
            } else if (this.jOnTheRadioButton.isSelected()) {
                String string = (String)this.jWhichComboBox.getSelectedItem();
                String string2 = (String)this.jDayComboBox.getSelectedItem();
                SchedulerModel.OrderType orderType = null;
                SchedulerModel.DayType dayType = null;
                if (string.equals(SCHEDULER_REPEAT_FIRST)) {
                    orderType = SchedulerModel.OrderType.FIRST;
                } else if (string.equals(SCHEDULER_REPEAT_SECOND)) {
                    orderType = SchedulerModel.OrderType.SECOND;
                } else if (string.equals(SCHEDULER_REPEAT_THIRD)) {
                    orderType = SchedulerModel.OrderType.THIRD;
                } else if (string.equals(SCHEDULER_REPEAT_FOURTH)) {
                    orderType = SchedulerModel.OrderType.FOURTH;
                } else if (string.equals(SCHEDULER_REPEAT_FIFTH)) {
                    orderType = SchedulerModel.OrderType.FIFTH;
                } else if (string.equals(SCHEDULER_REPEAT_LAST)) {
                    orderType = SchedulerModel.OrderType.LAST;
                }
                if (string2.equals(SCHEDULER_REPEAT_SUNDAY)) {
                    dayType = SchedulerModel.DayType.SUN;
                } else if (string2.equals(SCHEDULER_REPEAT_MONDAY)) {
                    dayType = SchedulerModel.DayType.MON;
                } else if (string2.equals(SCHEDULER_REPEAT_TUESDAY)) {
                    dayType = SchedulerModel.DayType.TUE;
                } else if (string2.equals(SCHEDULER_REPEAT_WEDNESDAY)) {
                    dayType = SchedulerModel.DayType.WED;
                } else if (string2.equals(SCHEDULER_REPEAT_THURSDAY)) {
                    dayType = SchedulerModel.DayType.THU;
                } else if (string2.equals(SCHEDULER_REPEAT_FRIDAY)) {
                    dayType = SchedulerModel.DayType.FRI;
                } else if (string2.equals(SCHEDULER_REPEAT_SATURDAY)) {
                    dayType = SchedulerModel.DayType.SAT;
                } else if (string2.equals(SCHEDULER_REPEAT_DAY)) {
                    dayType = SchedulerModel.DayType.DAY;
                }
                repeatMonthlyInterval = new SchedulerModel.RepeatMonthlyInterval((Integer)this.jEverySpinner.getValue(), orderType, dayType);
            }
            this.model.setRepeat(repeatMonthlyInterval);
        } else if (jComboBox.getSelectedItem().equals(SCHEDULER_REPEAT_CUSTOM_OPTION_YEARLY)) {
            ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
            int n = this.model.getStartDate().get(5);
            if (this.jJanCheckBox.isSelected()) {
                arrayList.add((CallSite)((Object)("01" + String.format("%02d", n))));
            }
            if (this.jFebCheckBox.isSelected()) {
                arrayList.add((CallSite)((Object)("02" + String.format("%02d", n))));
            }
            if (this.jMarCheckBox.isSelected()) {
                arrayList.add((CallSite)((Object)("03" + String.format("%02d", n))));
            }
            if (this.jAprCheckBox.isSelected()) {
                arrayList.add((CallSite)((Object)("04" + String.format("%02d", n))));
            }
            if (this.jMayCheckBox.isSelected()) {
                arrayList.add((CallSite)((Object)("05" + String.format("%02d", n))));
            }
            if (this.jJunCheckBox.isSelected()) {
                arrayList.add((CallSite)((Object)("06" + String.format("%02d", n))));
            }
            if (this.jJulyCheckBox.isSelected()) {
                arrayList.add((CallSite)((Object)("07" + String.format("%02d", n))));
            }
            if (this.jAugCheckBox.isSelected()) {
                arrayList.add((CallSite)((Object)("08" + String.format("%02d", n))));
            }
            if (this.jSepCheckBox.isSelected()) {
                arrayList.add((CallSite)((Object)("09" + String.format("%02d", n))));
            }
            if (this.jOctCheckBox.isSelected()) {
                arrayList.add((CallSite)((Object)("10" + String.format("%02d", n))));
            }
            if (this.jNovCheckBox.isSelected()) {
                arrayList.add((CallSite)((Object)("11" + String.format("%02d", n))));
            }
            if (this.jDecCheckBox.isSelected()) {
                arrayList.add((CallSite)((Object)("12" + String.format("%02d", n))));
            }
            SchedulerModel.RepeatYearlyInterval repeatYearlyInterval = new SchedulerModel.RepeatYearlyInterval((Integer)this.jEverySpinner.getValue(), arrayList.toArray(new String[arrayList.size()]));
            this.model.setRepeat(repeatYearlyInterval);
        }
        return true;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.jFrequencyLabel = new JLabel();
        this.jFrequencyComboBox = new JComboBox();
        this.jEveryLabel = new JLabel();
        this.jEverySpinner = new JSpinner();
        this.jEveryUnitLabel = new JLabel();
        this.jWeeklyPanel = new JPanel();
        this.jSunCheckBox = new JCheckBox();
        this.jMonCheckBox = new JCheckBox();
        this.jTueCheckBox = new JCheckBox();
        this.jWedCheckBox = new JCheckBox();
        this.jThurCheckBox = new JCheckBox();
        this.jFriCheckBox = new JCheckBox();
        this.jSatCheckBox = new JCheckBox();
        this.jMonthlyPanel = new JPanel();
        this.jEachRadioButton = new JRadioButton();
        this.jCalPanel = new JPanel();
        this.jOnTheRadioButton = new JRadioButton();
        this.jWhichComboBox = new JComboBox();
        this.jDayComboBox = new JComboBox();
        this.jYearlyPanel = new JPanel();
        this.jJanCheckBox = new JCheckBox();
        this.jFebCheckBox = new JCheckBox();
        this.jMarCheckBox = new JCheckBox();
        this.jAprCheckBox = new JCheckBox();
        this.jMayCheckBox = new JCheckBox();
        this.jJunCheckBox = new JCheckBox();
        this.jJulyCheckBox = new JCheckBox();
        this.jAugCheckBox = new JCheckBox();
        this.jSepCheckBox = new JCheckBox();
        this.jOctCheckBox = new JCheckBox();
        this.jNovCheckBox = new JCheckBox();
        this.jDecCheckBox = new JCheckBox();
        this.jOnTheCheckBox = new JCheckBox();
        this.jDayComboBox1 = new JComboBox();
        this.jWhichComboBox1 = new JComboBox();
        this.jFrequencyLabel.setLabelFor(this.jFrequencyComboBox);
        this.jFrequencyLabel.setText("Frequency:");
        this.jFrequencyComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Hourly", "Daily", "Weekly", "Monthly", "Yearly"}));
        this.jFrequencyComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScheduleRepeatPanel.this.jFrequencyComboBoxActionPerformed(actionEvent);
            }
        });
        this.jEveryLabel.setLabelFor(this.jEverySpinner);
        this.jEveryLabel.setText("Every");
        this.jEverySpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.jEveryUnitLabel.setText("hour(s)");
        this.jSunCheckBox.setText("Sun");
        this.jSunCheckBox.setPreferredSize(new Dimension(45, 23));
        this.jMonCheckBox.setText("Mon");
        this.jTueCheckBox.setText("Tue");
        this.jTueCheckBox.setPreferredSize(new Dimension(45, 23));
        this.jWedCheckBox.setText("Wed");
        this.jWedCheckBox.setPreferredSize(new Dimension(45, 23));
        this.jThurCheckBox.setText("Thur");
        this.jThurCheckBox.setPreferredSize(new Dimension(45, 23));
        this.jFriCheckBox.setText("Fri");
        this.jFriCheckBox.setPreferredSize(new Dimension(45, 23));
        this.jSatCheckBox.setText("Sat");
        this.jSatCheckBox.setPreferredSize(new Dimension(45, 23));
        GroupLayout groupLayout = new GroupLayout(this.jWeeklyPanel);
        this.jWeeklyPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jSunCheckBox, -1, 47, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jMonCheckBox, -1, 47, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTueCheckBox, -1, 47, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jWedCheckBox, -1, 47, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jThurCheckBox, -1, 47, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jFriCheckBox, -1, 47, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSatCheckBox, -1, 47, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jSunCheckBox, -2, -1, -2).addComponent(this.jMonCheckBox).addComponent(this.jTueCheckBox, -2, -1, -2).addComponent(this.jWedCheckBox, -2, -1, -2).addComponent(this.jThurCheckBox, -2, -1, -2).addComponent(this.jFriCheckBox, -2, -1, -2).addComponent(this.jSatCheckBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.buttonGroup.add(this.jEachRadioButton);
        this.jEachRadioButton.setText("Each");
        this.jEachRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScheduleRepeatPanel.this.jEachRadioButtonActionPerformed(actionEvent);
            }
        });
        this.jCalPanel.setLayout(new BorderLayout());
        this.buttonGroup.add(this.jOnTheRadioButton);
        this.jOnTheRadioButton.setText("On the");
        this.jWhichComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"first", "second", "fourth", "fifth", "last"}));
        this.jDayComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Day"}));
        GroupLayout groupLayout2 = new GroupLayout(this.jMonthlyPanel);
        this.jMonthlyPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jEachRadioButton, -2, 151, -2).addContainerGap(-1, Short.MAX_VALUE)).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jOnTheRadioButton, -1, -1, Short.MAX_VALUE).addGap(217, 217, 217)))).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(27, 27, 27).addComponent(this.jWhichComboBox, -2, 136, -2).addGap(18, 18, 18).addComponent(this.jDayComboBox, -2, 136, -2)).addGroup(groupLayout2.createSequentialGroup().addGap(27, 27, 27).addComponent(this.jCalPanel, -1, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jEachRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCalPanel, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jOnTheRadioButton, -2, 18, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jWhichComboBox, -2, -1, -2).addComponent(this.jDayComboBox, -2, -1, -2)).addContainerGap()));
        this.jJanCheckBox.setText("Jan");
        this.jFebCheckBox.setText("Feb");
        this.jFebCheckBox.setPreferredSize(new Dimension(45, 23));
        this.jMarCheckBox.setText("Mar");
        this.jMarCheckBox.setPreferredSize(new Dimension(45, 23));
        this.jAprCheckBox.setText("Apr");
        this.jAprCheckBox.setPreferredSize(new Dimension(45, 23));
        this.jMayCheckBox.setText("May");
        this.jJunCheckBox.setText("Jun");
        this.jJulyCheckBox.setText("July");
        this.jAugCheckBox.setText("Aug");
        this.jSepCheckBox.setText("Sep");
        this.jSepCheckBox.setPreferredSize(new Dimension(45, 23));
        this.jOctCheckBox.setText("Oct");
        this.jOctCheckBox.setPreferredSize(new Dimension(45, 23));
        this.jNovCheckBox.setText("Nov");
        this.jDecCheckBox.setText("Dec");
        this.jOnTheCheckBox.setText("On the");
        this.jDayComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Day"}));
        this.jWhichComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"first", "second", "fourth", "fifth", "last"}));
        GroupLayout groupLayout3 = new GroupLayout(this.jYearlyPanel);
        this.jYearlyPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jJulyCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.jJanCheckBox, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jAugCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.jFebCheckBox, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSepCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.jMarCheckBox, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jOctCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.jAprCheckBox, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jNovCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.jMayCheckBox, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jDecCheckBox, -1, -1, Short.MAX_VALUE).addComponent(this.jJunCheckBox, -1, -1, Short.MAX_VALUE)).addContainerGap()).addGroup(groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jOnTheCheckBox, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(groupLayout3.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jWhichComboBox1, -2, 136, -2))).addGap(18, 18, 18).addComponent(this.jDayComboBox1, -2, 136, -2).addGap(40, 40, 40)))));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jJanCheckBox).addComponent(this.jFebCheckBox, -2, -1, -2).addComponent(this.jMarCheckBox, -2, -1, -2).addComponent(this.jAprCheckBox, -2, -1, -2).addComponent(this.jMayCheckBox).addComponent(this.jJunCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jJulyCheckBox).addComponent(this.jAugCheckBox).addComponent(this.jSepCheckBox, -2, -1, -2).addComponent(this.jOctCheckBox, -2, -1, -2).addComponent(this.jNovCheckBox).addComponent(this.jDecCheckBox)).addGap(18, 18, 18).addComponent(this.jOnTheCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jWhichComboBox1, -2, -1, -2).addComponent(this.jDayComboBox1, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout4 = new GroupLayout(this);
        this.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jYearlyPanel, -1, -1, Short.MAX_VALUE).addComponent(this.jMonthlyPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jWeeklyPanel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout4.createSequentialGroup().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jEveryLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jFrequencyLabel, -2, 69, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jFrequencyComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.jEverySpinner, -2, 120, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jEveryUnitLabel, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFrequencyLabel).addComponent(this.jFrequencyComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jEveryLabel).addComponent(this.jEverySpinner, -2, -1, -2).addComponent(this.jEveryUnitLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jWeeklyPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jMonthlyPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jYearlyPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jFrequencyComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this.isUIRendering) {
            return;
        }
        this.updateFrequencyLayout();
    }

    private void jEachRadioButtonActionPerformed(ActionEvent actionEvent) {
    }
}

