/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.scheduler;

import java.awt.Component;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.TableNameValidator;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.scheduler.DialogsLrb;
import oracle.dmt.dataminer.workflow.scheduler.ScheduleWorkflowDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class SaveAsSchedulePanel
extends DialogDisplayer<AbstractNode> {
    private ScheduleWorkflowDialog parent;
    private String name;
    private JLabel jNameLabel;
    private JTextField jNameTextField;

    public SaveAsSchedulePanel(ScheduleWorkflowDialog scheduleWorkflowDialog, Context context, String string) {
        super(context, null);
        this.parent = scheduleWorkflowDialog;
        this.name = string;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jNameLabel = new JLabel();
        this.jNameTextField = new JTextField();
        this.jNameLabel.setLabelFor(this.jNameTextField);
        this.jNameLabel.setText("Name:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jNameLabel, -2, 49, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jNameTextField, -1, 198, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jNameLabel).addComponent(this.jNameTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("SCHEDULER_SCHEDULE_SAVE_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "save_as_schedule_dialog";
    }

    @Override
    public void initRes() {
        this.jNameLabel.setText(DialogsLrb.get("SCHEDULER_SCHEDULE_NAME_LBL"));
    }

    @Override
    public void initUI() {
        this.jNameTextField.setText(this.name);
    }

    @Override
    protected boolean doWork() {
        boolean bl = true;
        String string = this.name;
        JTextField jTextField = this.jNameTextField;
        String string2 = jTextField.getText().trim();
        if (string2.length() == 0) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("SCHEDULER_SCHEDULE_NAME_MISSING"), (String)DialogsLrb.get("ERROR_TITLE"), null);
            bl = false;
        }
        if (StringUtils.isDoubleQuotedString(string2)) {
            string = StringUtils.addDoubleQuotes(string);
        }
        if (bl && !StringUtils.isDoubleQuotedString(string2)) {
            string2 = string2.toUpperCase();
        }
        try {
            if (string != null && string.compareTo(string2) != 0) {
                if (bl && this.isDuplicateName(StringUtils.trimDoubleQuotes(string2))) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("SCHEDULER_SCHEDULE_NAME_NOT_UNIQUE_MSG"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                    bl = false;
                }
                if (bl && !TableNameValidator.validateTableName(string2, null, this.getContext(), false)) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("SCHEDULER_SCHEDULE_NAME_INVALID_ERROR"), (String)DialogsLrb.get("ERROR_TITLE"), null);
                    bl = false;
                }
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("SCHEDULER_SCHEDULE_NAME_VALIDATION_SYSTEM_ERROR"), null);
            bl = false;
        }
        if (bl) {
            this.name = StringUtils.trimDoubleQuotes(string2);
        }
        return bl;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    private boolean isDuplicateName(String string) {
        return this.parent.doesScheduleNameExist(string);
    }

    @Override
    public String getName() {
        return this.name;
    }
}

