/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.preferences;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dmt.dataminer.workflow.inspect.CachePIComponentPanelSamplingTypeTopN;
import oracle.dmt.dataminer.workflow.inspect.CachePIComponentPanelSubPanelSamplingSizePercent;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.preferences.CachePIComponentPanelSamplingTypeRandom;
import oracle.dmt.dataminer.workflow.preferences.CachePIComponentPanelSubPanelSamplingSizeRows;
import oracle.dmt.dataminer.workflow.preferences.CacheSettingsPanelSettings;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;

public class SamplingPanel
extends DefaultTraversablePanel
implements ChangeListener {
    private JComboBox jCmbSampling;
    private JComboBox jCmbSize;
    private JLabel jLblSampling;
    private JLabel jLblSize;
    private JPanel jPanelSamplingSize;
    private JPanel jPanelSamplingType;
    private boolean _bAdjusting;
    private CardLayout _samplingTypeLayout;
    private CachePIComponentPanelSamplingTypeRandom jPanelSamplingTypeRandom;
    private CachePIComponentPanelSamplingTypeTopN jPanelSamplingTypeTopN;
    private CardLayout _samplingSizeLayout;
    private CachePIComponentPanelSubPanelSamplingSizeRows jPanelSamplingSizeRows;
    private CachePIComponentPanelSubPanelSamplingSizePercent jPanelSamplingSizePercent;
    private static final String RANDOM = PropertyLrb.get("PI_ATTRIBUTES_CACHE_GROUP_SAMPLING_TYPE_RANDOM");
    private static final String TOP_N = PropertyLrb.get("PI_ATTRIBUTES_CACHE_GROUP_SAMPLING_TYPE_TOPN");
    private static final String[] SAMPLING_TYPE = new String[]{RANDOM, TOP_N};
    private static final String NUM_ROWS = PropertyLrb.get("PI_ATTRIBUTES_CACHE_GROUP_SAMPLE_SIZE_NUMROWS");
    private static final String PERCENT = PropertyLrb.get("PI_ATTRIBUTES_CACHE_GROUP_SAMPLE_SIZE_PERCENT");
    private static final String[] SAMPLING_SIZE = new String[]{NUM_ROWS, PERCENT};
    private boolean _isRandom;
    private int _seed;
    private boolean _isPercent;
    private long _numberRows;
    private double _samplingPercent;

    public SamplingPanel() {
        this.initComponents();
        this.initRes();
        this.initLayout();
        this.initUI();
    }

    private void initComponents() {
        this.jLblSampling = new JLabel();
        this.jCmbSampling = new JComboBox();
        this.jPanelSamplingType = new JPanel();
        this.jLblSize = new JLabel();
        this.jCmbSize = new JComboBox();
        this.jPanelSamplingSize = new JPanel();
        this.jLblSampling.setText("Sampling Type:");
        this.jCmbSampling.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jPanelSamplingType.setLayout(new CardLayout());
        this.jLblSize.setText("Sampling Size:");
        this.jCmbSize.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jPanelSamplingSize.setLayout(new CardLayout());
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(37, 37, 37).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelSamplingSize, GroupLayout.Alignment.TRAILING, -2, 294, -2).addComponent(this.jPanelSamplingType, GroupLayout.Alignment.TRAILING, -2, 293, -2)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(19, 19, 19).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLblSize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jCmbSize, -2, 221, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLblSampling).addGap(18, 18, 18).addComponent(this.jCmbSampling, -2, 216, -2))).addContainerGap()));
        groupLayout.linkSize(0, this.jCmbSampling, this.jCmbSize);
        groupLayout.linkSize(0, this.jPanelSamplingSize, this.jPanelSamplingType);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblSampling).addComponent(this.jCmbSampling, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelSamplingType, -2, 48, -2).addGap(11, 11, 11).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblSize).addComponent(this.jCmbSize, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelSamplingSize, -2, 58, -2).addContainerGap(110, Short.MAX_VALUE)));
        groupLayout.linkSize(1, this.jPanelSamplingSize, this.jPanelSamplingType);
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLblSampling, (Component)this.jCmbSampling, (String)PropertyLrb.get("PI_ATTRIBUTES_CACHE_GROUP_SAMPLING_TYPE"));
        ResourceUtils.resLabel((JLabel)this.jLblSize, (Component)this.jCmbSize, (String)PropertyLrb.get("PI_ATTRIBUTES_CACHE_GROUP_SAMPLE_SIZE"));
        this.setHelpID("preferences_transforms_sampling");
    }

    public void initUI() {
        this.jCmbSize.setModel(new DefaultComboBoxModel<String>(SAMPLING_SIZE));
        this.jLblSize.setLabelFor(this.jCmbSize);
        this.jCmbSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)SamplingPanel.this.jCmbSize.getSelectedItem();
                if (string.equals(NUM_ROWS)) {
                    SamplingPanel.this.showSamplingSizeCard(NUM_ROWS);
                } else if (string.equals(PERCENT)) {
                    SamplingPanel.this.showSamplingSizeCard(PERCENT);
                }
            }
        });
        this.jCmbSampling.setModel(new DefaultComboBoxModel<String>(SAMPLING_TYPE));
        this.jLblSampling.setLabelFor(this.jCmbSampling);
        this.jCmbSampling.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SamplingPanel.this._bAdjusting) {
                    return;
                }
                String string = (String)SamplingPanel.this.jCmbSampling.getSelectedItem();
                if (string.equals(RANDOM)) {
                    SamplingPanel.this.setRandomSampling();
                } else if (string.equals(TOP_N)) {
                    SamplingPanel.this.setTopN();
                }
            }
        });
    }

    private void initLayout() {
        this.jPanelSamplingType.setOpaque(false);
        this._samplingTypeLayout = (CardLayout)this.jPanelSamplingType.getLayout();
        this.jPanelSamplingTypeRandom = new CachePIComponentPanelSamplingTypeRandom(this);
        this.jPanelSamplingTypeRandom.setOpaque(false);
        this.jPanelSamplingTypeTopN = new CachePIComponentPanelSamplingTypeTopN();
        this.jPanelSamplingTypeTopN.setOpaque(false);
        this.jPanelSamplingType.add((Component)this.jPanelSamplingTypeRandom, RANDOM);
        this.jPanelSamplingType.add((Component)this.jPanelSamplingTypeTopN, TOP_N);
        this.jPanelSamplingSize.setOpaque(false);
        this._samplingSizeLayout = (CardLayout)this.jPanelSamplingSize.getLayout();
        this.jPanelSamplingSizeRows = new CachePIComponentPanelSubPanelSamplingSizeRows(this);
        this.jPanelSamplingSizePercent = new CachePIComponentPanelSubPanelSamplingSizePercent(this);
        this.jPanelSamplingSize.add((Component)this.jPanelSamplingSizeRows, NUM_ROWS);
        this.jPanelSamplingSize.add((Component)this.jPanelSamplingSizePercent, PERCENT);
    }

    private void setRandomSampling() {
        this._bAdjusting = true;
        this.jPanelSamplingTypeRandom.setRandomValue(BigInteger.valueOf(this._seed));
        this.showSamplingTypeCard(RANDOM);
        this._bAdjusting = false;
    }

    private void setTopN() {
        this._bAdjusting = true;
        this.showSamplingTypeCard(TOP_N);
        this._bAdjusting = false;
    }

    private void showSamplingTypeCard(String string) {
        this._samplingTypeLayout.show(this.jPanelSamplingType, string);
        this.jPanelSamplingType.setVisible(string.equals(RANDOM));
    }

    private void showSamplingSizeCard(String string) {
        this._samplingSizeLayout.show(this.jPanelSamplingSize, string);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() instanceof JSlider) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            if (jSlider.getValueIsAdjusting()) {
                return;
            }
            this._samplingPercent = jSlider.getValue();
        } else if (changeEvent.getSource() instanceof JSpinner) {
            JSpinner jSpinner = (JSpinner)changeEvent.getSource();
            if (jSpinner.getName().equals(NUM_ROWS)) {
                this._numberRows = ((Integer)jSpinner.getValue()).intValue();
            } else if (jSpinner.getName().equals(RANDOM)) {
                this._seed = (Integer)jSpinner.getValue();
            }
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        CacheSettingsPanelSettings cacheSettingsPanelSettings = SamplingPanel.getCoolFeaturePrefs(traversableContext);
        this._bAdjusting = true;
        this._isRandom = cacheSettingsPanelSettings.isRandom();
        this._seed = cacheSettingsPanelSettings.getSeed();
        if (this._isRandom) {
            this.jPanelSamplingTypeRandom.setRandomValue(BigInteger.valueOf(this._seed));
            this.jCmbSampling.setSelectedItem(RANDOM);
            this.showSamplingTypeCard(RANDOM);
        } else {
            this.jCmbSampling.setSelectedItem(TOP_N);
            this.showSamplingTypeCard(TOP_N);
        }
        this._isPercent = cacheSettingsPanelSettings.isPercent();
        this._numberRows = cacheSettingsPanelSettings.getNumberOfRows();
        this._samplingPercent = cacheSettingsPanelSettings.getPercentValue();
        this.jPanelSamplingSizePercent.setPercent(this._samplingPercent);
        this.jPanelSamplingSizeRows.setNumberOfRows(this._numberRows);
        if (this._isPercent) {
            this.jCmbSize.setSelectedItem(PERCENT);
            this.showSamplingSizeCard(PERCENT);
        } else {
            this.jCmbSize.setSelectedItem(NUM_ROWS);
            this.showSamplingSizeCard(NUM_ROWS);
        }
        this._bAdjusting = false;
    }

    public void onExit(TraversableContext traversableContext) {
        Object object;
        CacheSettingsPanelSettings cacheSettingsPanelSettings = SamplingPanel.getCoolFeaturePrefs(traversableContext);
        String string = (String)this.jCmbSampling.getSelectedItem();
        if (RANDOM.equalsIgnoreCase(string)) {
            cacheSettingsPanelSettings.setRandom(true);
            object = this.jPanelSamplingTypeRandom.getSeed();
            cacheSettingsPanelSettings.setSeed(((Long)object).intValue());
        } else {
            cacheSettingsPanelSettings.setRandom(false);
            cacheSettingsPanelSettings.removeSeed();
        }
        object = (String)this.jCmbSize.getSelectedItem();
        if (((String)object).equals(PERCENT)) {
            Double d = this.jPanelSamplingSizePercent.getValue();
            cacheSettingsPanelSettings.setPercentValue(d);
            cacheSettingsPanelSettings.removeNumberOfRows();
            cacheSettingsPanelSettings.setPercent(true);
        } else {
            Long l = this.jPanelSamplingSizeRows.getNumberOfRows();
            cacheSettingsPanelSettings.setNumberOfRows(l.intValue());
            cacheSettingsPanelSettings.removePercentValue();
            cacheSettingsPanelSettings.setPercent(false);
        }
    }

    private static CacheSettingsPanelSettings getCoolFeaturePrefs(TraversableContext traversableContext) {
        return CacheSettingsPanelSettings.getInstance(traversableContext.getPropertyStorage());
    }
}

