/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.parallelquery;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;

public class ParallelQuerySettingPanel
extends JPanel {
    private static final int MAX_VALUE_DOP = 65000;
    private ButtonGroup buttonGroup1;
    private JRadioButton degreeValueCheck;
    private JSpinner jSpinner1;
    private JLabel lblDOPTitle;
    private JRadioButton systemDeterminedCheck;

    public ParallelQuerySettingPanel() {
        this.initComponents();
        this.initUI();
        this.initRES();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.systemDeterminedCheck = new JRadioButton();
        this.degreeValueCheck = new JRadioButton();
        this.jSpinner1 = new JSpinner();
        this.lblDOPTitle = new JLabel();
        this.buttonGroup1.add(this.systemDeterminedCheck);
        this.systemDeterminedCheck.setSelected(true);
        this.systemDeterminedCheck.setText("System Determined");
        this.buttonGroup1.add(this.degreeValueCheck);
        this.degreeValueCheck.setText("Degree Value");
        this.jSpinner1.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                ParallelQuerySettingPanel.this.jSpinner1VetoableChange(propertyChangeEvent);
            }
        });
        this.lblDOPTitle.setText("Degree of Parallel:");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(33, 33, 33).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.systemDeterminedCheck).addGroup(groupLayout.createSequentialGroup().addComponent(this.degreeValueCheck).addGap(18, 18, 18).addComponent(this.jSpinner1, -2, 62, -2)))).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.lblDOPTitle))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.lblDOPTitle).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.systemDeterminedCheck).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.degreeValueCheck).addComponent(this.jSpinner1, -2, -1, -2)).addContainerGap(35, Short.MAX_VALUE)));
    }

    private void jSpinner1VetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
    }

    private void initUI() {
        this.jSpinner1.setModel(new SpinnerNumberModel(1, 1, 65000, 1));
        this.jSpinner1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ParallelQuerySettingPanel.this.degreeValueCheck.setSelected(true);
            }
        });
    }

    private void initRES() {
        this.systemDeterminedCheck.setText(WorkflowEditorLrb.get("PARALLEL_VALUE_SYSTEM_DETERMINED"));
        this.degreeValueCheck.setText(WorkflowEditorLrb.get("PARALLEL_DEGREE_VALUE"));
        this.lblDOPTitle.setText(WorkflowEditorLrb.get("PARALLEL_DEGREE_DIALOG_TITLE"));
    }

    public boolean isSystemDetermined() {
        return this.systemDeterminedCheck.isSelected();
    }

    public String getDegreeValue() {
        return this.jSpinner1.getValue().toString();
    }

    public void setSystemDetermined() {
        this.systemDeterminedCheck.setSelected(true);
    }

    public void setDegreeValue(int n) {
        this.degreeValueCheck.setSelected(true);
        this.jSpinner1.setValue(n);
    }

    public void enableControls(boolean bl) {
    }
}

