/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import ilog.views.sdm.model.IlvSDMNode;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.utils.db.DbMetadataUtils;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeGenLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeTemplate;
import oracle.dmt.dataminer.workflow.codegen.ParameterizedSourceDefinitions;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.GeneralLink;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.SubNodeProperty;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.BuildDataSource;
import oracle.dmt.dataminer.workflow.xmlschema.ExtensibleBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningResultType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TestDataSource;
import oracle.ide.Context;
import oracle.javatools.util.Version;

public abstract class SupervisedBuildNode
extends AbstractBuildNode {
    public SupervisedBuildNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_CLASS_BUILD_NODE_NAME");
    }

    @Override
    public void setProperty(String string, Object object) {
        SuperviseBuildNodeType superviseBuildNodeType = (SuperviseBuildNodeType)this.getData();
        if (string.equals("targetAttribute")) {
            superviseBuildNodeType.setTargetAttribute((AttributeType)object);
        } else if (string.equals("targetAttributeInvalid")) {
            AttributeType attributeType = superviseBuildNodeType.getTargetAttribute();
            if (attributeType != null) {
                attributeType.setStatus((AttributeStatus)object);
            }
        } else if (string.equals("testData")) {
            superviseBuildNodeType.setTestDataSource((TestDataSource)object);
        } else if (string.equals("resultStatus")) {
            this.setResultStatus(object);
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    protected void initNewInstance(Context context) {
        super.initNewInstance(context);
        SuperviseBuildNodeType superviseBuildNodeType = (SuperviseBuildNodeType)this.getData();
        TestDataSource testDataSource = new TestDataSource();
        TestDataSource.SplitData splitData = new TestDataSource.SplitData();
        splitData.setTestPercent(40.0);
        testDataSource.setSplitData(splitData);
        superviseBuildNodeType.setTestDataSource(testDataSource);
    }

    @Override
    public boolean isAllowedConnectionFrom(Node node) {
        boolean bl = super.isAllowedConnectionFrom(node);
        if (bl) {
            SuperviseBuildNodeType superviseBuildNodeType = (SuperviseBuildNodeType)this.getData();
            TestDataSource testDataSource = superviseBuildNodeType.getTestDataSource();
            BuildDataSource buildDataSource = superviseBuildNodeType.getBuildDataSource();
            TestDataSource.TestData testData = testDataSource.getTestData();
            if (testData != null && buildDataSource != null) {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        SuperviseBuildNodeType superviseBuildNodeType = (SuperviseBuildNodeType)this.getData();
        TestDataSource testDataSource = superviseBuildNodeType.getTestDataSource();
        TestDataSource.TestData testData = testDataSource.getTestData();
        List<GeneralLink> list = this.getModel().findLinksToNode((IlvSDMNode)this);
        if (testData == null && list.size() == 2) {
            TestDataSource testDataSource2 = new TestDataSource();
            testData = new TestDataSource.TestData();
            testData.setSourceId(node.getMetadataId());
            testDataSource2.setTestData(testData);
            testDataSource2.setSplitData(null);
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "testOptionsChanged", testDataSource2);
            for (GeneralLink generalLink : list) {
                if (((AbstractNode)generalLink.getFrom()).getMetadataId().equals(testData.getSourceId())) {
                    odmrSDMUndoFilter.prepareUndo(generalLink, this.getContext(), "label", WorkflowEditorLrb.get("TEST_DATA_LINK_LABEL"));
                    continue;
                }
                odmrSDMUndoFilter.prepareUndo(generalLink, this.getContext(), "label", WorkflowEditorLrb.get("BUILD_DATA_LINK_LABEL"));
            }
            if (NodeStatusType.COMPLETE.equals((Object)superviseBuildNodeType.getStatus()) || NodeStatusType.WARNING.equals((Object)superviseBuildNodeType.getStatus())) {
                this.setNodeReady();
            }
        }
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        SuperviseBuildNodeType superviseBuildNodeType = (SuperviseBuildNodeType)this.getData();
        TestDataSource testDataSource = superviseBuildNodeType.getTestDataSource();
        TestDataSource.TestData testData = testDataSource.getTestData();
        if (testData != null && testData.getSourceId().equals(node.getMetadataId())) {
            this.handleRemoveTestDataSource(testDataSource);
        } else if (testData != null) {
            this.handleRemoveTestDataSource(testDataSource);
        }
    }

    @Override
    public boolean validate(boolean bl) {
        List list;
        Attributes attributes;
        boolean bl2 = super.validate(bl);
        AbstractDataNode abstractDataNode = this.findBuildDataNode(this.getModel());
        if (abstractDataNode != null) {
            attributes = ((DataProvider)abstractDataNode).getAttributes();
            list = attributes.getAttribute();
            if (!this.validateBuildAttributes(list)) {
                bl2 = false;
            }
            if (!this.validateTarget(list)) {
                bl2 = false;
            }
        } else {
            this.validateTarget(null);
            bl2 = false;
            return bl2;
        }
        attributes = (SuperviseBuildNodeType)this.getData();
        list = attributes.getTestDataSource();
        if (list != null && list.getTestData() != null) {
            AbstractDataNode abstractDataNode2 = this.findTestDataNode(this.getModel());
            if (abstractDataNode2 != null) {
                Attributes attributes2 = ((DataProvider)abstractDataNode2).getAttributes();
                List list2 = attributes2.getAttribute();
                if (!this.validateTestAttributes(list2)) {
                    bl2 = false;
                }
            } else {
                bl2 = false;
            }
        }
        return bl2;
    }

    @Override
    public Object getProperty(String string) {
        SuperviseBuildNodeType superviseBuildNodeType = (SuperviseBuildNodeType)this.getData();
        if ("targetAttribute".equals(string)) {
            AttributeType attributeType = superviseBuildNodeType.getTargetAttribute();
            return attributeType;
        }
        if ("targetAttributeInvalid".equals(string)) {
            AttributeType attributeType = superviseBuildNodeType.getTargetAttribute();
            return attributeType == null ? null : attributeType.getStatus();
        }
        if ("testData".equals(string)) {
            return superviseBuildNodeType.getTestDataSource();
        }
        return super.getProperty(string);
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if ("targetAttributeInvalid".equals(complexProperty.getPropertyName())) {
            return complexProperty.getOldData();
        }
        if ("resultStatus".equals(complexProperty.getPropertyName())) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public void setNodeReady() {
        super.setNodeReady();
        List<? extends MiningResultType> list = MetaDataHelper.getResultsCollection(this.getData());
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        for (MiningResultType miningResultType : list) {
            if (!ModelStatusType.COMPLETE.equals((Object)miningResultType.getStatus())) continue;
            ComplexProperty complexProperty = new ComplexProperty("resultStatus", new SubNodeProperty(miningResultType.getModelId(), ModelStatusType.READY));
            complexProperty.setOldData(new SubNodeProperty(miningResultType.getModelId(), miningResultType.getStatus()));
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), complexProperty);
        }
    }

    @Override
    public void refactorAttributes(Node node, Map<String, AttributeType> map) {
        super.refactorAttributes(node, map);
        if (!map.isEmpty()) {
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            SuperviseBuildNodeType superviseBuildNodeType = (SuperviseBuildNodeType)this.getData();
            AttributeType attributeType = (AttributeType)MetaDataHelper.copyMetadataObject(superviseBuildNodeType.getTargetAttribute());
            AttributeType attributeType2 = map.get(attributeType.getName());
            if (attributeType2 != null) {
                attributeType.setName(attributeType2.getName());
                attributeType.setDataType(attributeType2.getDataType());
                odmrSDMUndoFilter.prepareUndo(this, this.getContext(), "targetAttribute", attributeType);
            }
        }
    }

    @Override
    public boolean isVersionSupported(Context context, StringBuffer stringBuffer) {
        if (!super.isVersionSupported(context, stringBuffer)) {
            return false;
        }
        Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
        SuperviseBuildNodeType superviseBuildNodeType = (SuperviseBuildNodeType)this.getData();
        stringBuffer.setLength(0);
        if (superviseBuildNodeType.getTargetAttribute() != null) {
            String string = superviseBuildNodeType.getTargetAttribute().getName();
            String string2 = superviseBuildNodeType.getTargetAttribute().getDataType();
            if (!DbMetadataUtils.isTargetCategoricalDataTypeSupported((Version)version, (String)string2)) {
                Object[] objectArray = new Object[]{string, string2};
                stringBuffer.append(MessageFormat.format(CodeGenLrb.get("VALIDATE_TARGET_DATA_TYPE_NOT_SUPPORTED"), objectArray));
                return false;
            }
        }
        return true;
    }

    @Override
    public AttributeType getTargetAttribute() {
        if (this.getData() instanceof SuperviseBuildNodeType) {
            return ((SuperviseBuildNodeType)this.getData()).getTargetAttribute();
        }
        if (this.getData() instanceof ExtensibleBuildNodeType) {
            return ((ExtensibleBuildNodeType)this.getData()).getTargetAttribute();
        }
        return null;
    }

    @Override
    public String generateCode(Context context, ParameterizedSourceDefinitions parameterizedSourceDefinitions, String string) throws Exception {
        String string2 = super.generateCode(context, parameterizedSourceDefinitions, string);
        SuperviseBuildNodeType superviseBuildNodeType = (SuperviseBuildNodeType)this.getData();
        String string3 = superviseBuildNodeType.getTargetAttribute().getName();
        string2 = CodeTemplate.updateBodyTemplate(string2, "<TARGET>", string3);
        String string4 = this.generateBuildTestDataCode(context);
        string2 = CodeTemplate.updateBodyTemplate(string2, "<BUILD_TEST_DATA>", string4);
        return string2;
    }

    public abstract String generateBuildTestDataCode(Context var1);

    protected abstract String generateTestModelCode(Context var1, ModelType var2);
}

