/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import oracle.dmt.dataminer.controls.JSONElement;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeGenLrb;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.FilterParser;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTransformNode;
import oracle.dmt.dataminer.workflow.model.ApplyChainNode;
import oracle.dmt.dataminer.workflow.model.DataConsumer;
import oracle.dmt.dataminer.workflow.model.DataGuideProvider;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementsExType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeExType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideType;
import oracle.dmt.dataminer.workflow.xmlschema.GroupingElementExType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONAttributesType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONFilterType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONQueryNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RelationalAttributesType;
import oracle.ide.Context;
import oracle.javatools.util.Version;

public final class JSONQueryNode
extends AbstractTransformNode
implements DataConsumer,
ApplyChainNode {
    private static final Logger theLogger = Logger.getLogger(JSONQueryNode.class.getName());
    public static final String JSON_ATTRIBUTES = "jsonAttributes";
    public static final String RELATIONAL_ATTRIBUTES = "relationalAttributes";
    public static final String AGGREGATION_ELEMENTS = "aggregationElements";
    public static final String GROUPING_ELEMENT = "groupingElement";
    public static final String JSON_FILTERS = "jsonFilters";
    public static final int MAX_FILTER_SIZE = 4000;

    public JSONQueryNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
        JSONQueryNodeType jSONQueryNodeType = (JSONQueryNodeType)nodeType;
        if (jSONQueryNodeType != null && jSONQueryNodeType.getJSONFilters() == null) {
            JSONFilterType jSONFilterType = new JSONFilterType();
            jSONFilterType.setMatch("All");
            jSONFilterType.setUseBy("All");
            jSONQueryNodeType.setJSONFilters(jSONFilterType);
        }
    }

    @Override
    protected void initNewInstance(Context context) {
        super.initNewInstance(context);
        JSONQueryNodeType jSONQueryNodeType = (JSONQueryNodeType)this.getData();
        JSONAttributesType jSONAttributesType = new JSONAttributesType();
        RelationalAttributesType relationalAttributesType = new RelationalAttributesType();
        AggregationElementsExType aggregationElementsExType = new AggregationElementsExType();
        GroupingElementExType groupingElementExType = new GroupingElementExType();
        JSONFilterType jSONFilterType = new JSONFilterType();
        jSONFilterType.setMatch("All");
        jSONFilterType.setUseBy("All");
        jSONQueryNodeType.setJSONAttributes(jSONAttributesType);
        jSONQueryNodeType.setRelationalAttributes(relationalAttributesType);
        jSONQueryNodeType.setAggregationElements(aggregationElementsExType);
        jSONQueryNodeType.setGroupingElement(groupingElementExType);
        jSONQueryNodeType.setJSONFilters(jSONFilterType);
        jSONQueryNodeType.setStatus(NodeStatusType.INVALID);
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_JSON_QUERY_NODE_NAME");
    }

    @Override
    public Attributes getAttributes() {
        Attributes attributes;
        block12: {
            Object object;
            JSONQueryNodeType jSONQueryNodeType;
            block13: {
                attributes = new Attributes();
                jSONQueryNodeType = (JSONQueryNodeType)this.getData();
                ArrayList<JSONAttributeType> arrayList = new ArrayList<JSONAttributeType>();
                for (JSONAttributeType jSONAttributeType : jSONQueryNodeType.getJSONAttributes().getJSONAttribute()) {
                    if (!"ARRAY".equals(jSONAttributeType.getDataType()) || !Boolean.FALSE.equals(jSONAttributeType.isUnnest())) continue;
                    arrayList.add(jSONAttributeType);
                }
                for (JSONAttributeType jSONAttributeType : jSONQueryNodeType.getJSONAttributes().getJSONAttribute()) {
                    boolean bl = true;
                    for (JSONAttributeType jSONAttributeType2 : arrayList) {
                        if (jSONAttributeType.getPath().equals(jSONAttributeType2.getPath()) || jSONAttributeType.getPath().indexOf(jSONAttributeType2.getPath()) != 0) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    if ("ARRAY".equals(jSONAttributeType.getDataType())) {
                        String string2;
                        object = jSONAttributeType;
                        if (Boolean.FALSE.equals(jSONAttributeType.isUnnest())) {
                            AttributeType attributeType = new AttributeType();
                            string2 = object.getDBName();
                            attributeType.setName(string2);
                            attributeType.setAlias(null);
                            attributeType.setDataType(object.getDBDataType());
                            attributeType.setDataTypeQualifier("JSON");
                            attributeType.setStatus(object.getStatus());
                            attributes.getAttribute().add(attributeType);
                            continue;
                        }
                        bl = true;
                        for (String string2 : jSONQueryNodeType.getJSONAttributes().getJSONAttribute()) {
                            if (jSONAttributeType.getPath().equals(string2.getPath()) || string2.getPath().indexOf(jSONAttributeType.getPath() + ".") != 0) continue;
                            bl = false;
                            break;
                        }
                        if (!bl) continue;
                        AttributeType attributeType = new AttributeType();
                        string2 = object.getDBName();
                        attributeType.setName(string2);
                        attributeType.setAlias(null);
                        attributeType.setDataType("VARCHAR2");
                        attributeType.setStatus(object.getStatus());
                        attributes.getAttribute().add(attributeType);
                        continue;
                    }
                    if ("OBJECT".equals(jSONAttributeType.getDataType())) continue;
                    object = new AttributeType();
                    String string = jSONAttributeType.getDBName();
                    object.setName(string);
                    object.setAlias(null);
                    object.setDataType(jSONAttributeType.getDBDataType());
                    object.setStatus(jSONAttributeType.getStatus());
                    attributes.getAttribute().add(object);
                }
                for (JSONAttributeType jSONAttributeType : jSONQueryNodeType.getRelationalAttributes().getAttribute()) {
                    AttributeType attributeType = new AttributeType();
                    attributeType.setName(jSONAttributeType.getAlias() != null && !jSONAttributeType.getAlias().trim().isEmpty() ? jSONAttributeType.getAlias() : jSONAttributeType.getName());
                    attributeType.setAlias(null);
                    attributeType.setDataType(jSONAttributeType.getNewDataType() != null ? jSONAttributeType.getNewDataType() : jSONAttributeType.getDataType());
                    attributeType.setStatus(jSONAttributeType.getStatus());
                    attributes.getAttribute().add(attributeType);
                }
                for (JSONAttributeType jSONAttributeType : jSONQueryNodeType.getAggregationElements().getAggregationElement()) {
                    AttributeType attributeType = new AttributeType();
                    attributeType.setName(jSONAttributeType.getOutput().getName());
                    attributeType.setAlias(null);
                    attributeType.setDataType(jSONAttributeType.getOutput().getDataType());
                    attributeType.setStatus(jSONAttributeType.getOutput().getStatus());
                    attributes.getAttribute().add(attributeType);
                }
                if (jSONQueryNodeType.getGroupingElement() == null || jSONQueryNodeType.getGroupingElement().getAttributes() == null) break block12;
                if (jSONQueryNodeType.getGroupingElement().getAttributes().getAttribute().isEmpty()) break block13;
                for (JSONAttributeType jSONAttributeType : jSONQueryNodeType.getGroupingElement().getAttributes().getAttribute()) {
                    boolean bl = false;
                    object = jSONAttributeType.getAlias() != null ? jSONAttributeType.getAlias() : jSONAttributeType.getName();
                    for (String string2 : attributes.getAttribute()) {
                        String string = string2.getAlias() != null ? string2.getAlias() : string2.getName();
                        if (!((String)object).equals(string)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    AttributeType attributeType = new AttributeType();
                    attributeType.setName((String)object);
                    attributeType.setAlias(null);
                    attributeType.setDataType(jSONAttributeType.getDataType());
                    attributeType.setStatus(jSONAttributeType.getStatus());
                    attributes.getAttribute().add(attributeType);
                }
                break block12;
            }
            if (jSONQueryNodeType.getGroupingElement().getAttributes().getJSONAttribute().isEmpty()) break block12;
            for (JSONAttributeType jSONAttributeType : jSONQueryNodeType.getGroupingElement().getAttributes().getJSONAttribute()) {
                boolean bl = false;
                object = jSONAttributeType.getDBName();
                for (String string2 : attributes.getAttribute()) {
                    String string = string2.getAlias() != null ? string2.getAlias() : string2.getName();
                    if (!((String)object).equals(string)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                AttributeType attributeType = new AttributeType();
                attributeType.setName((String)object);
                attributeType.setAlias(null);
                attributeType.setDataType(jSONAttributeType.getDataType());
                attributeType.setStatus(jSONAttributeType.getStatus());
                attributes.getAttribute().add(attributeType);
            }
        }
        return attributes;
    }

    public List<AbstractNode> findSourceNodes() {
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        List<AbstractNode> list = this.findParentNodes();
        for (AbstractNode abstractNode : list) {
            if (!(abstractNode instanceof DataProvider)) continue;
            arrayList.add(abstractNode);
        }
        return arrayList;
    }

    @Override
    public boolean validate(boolean bl) {
        Object object;
        Object object22;
        Object object3;
        Attributes attributes3;
        AggregationElementsExType.AggregationElement.SubGroupBy.Attributes attributes2;
        Object object4;
        AggregationElementsExType aggregationElementsExType2;
        JSONAttributesType jSONAttributesType;
        boolean bl2 = super.validate(bl);
        JSONQueryNodeType jSONQueryNodeType = (JSONQueryNodeType)this.getData();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (jSONQueryNodeType.getJSONAttributes().getSource() != null) {
            AttributeType attributeType = new AttributeType();
            attributeType.setName(jSONQueryNodeType.getJSONAttributes().getSource());
            attributeType.setDataType(jSONQueryNodeType.getJSONAttributes().getDataType());
            DataGuideProvider dataGuideProvider = (DataGuideProvider)((Object)this.findParentNode());
            if (dataGuideProvider != null && (jSONAttributesType = dataGuideProvider.getJSONAttrDataGuide(attributeType, null)) != null) {
                for (AggregationElementsExType aggregationElementsExType2 : jSONAttributesType.getItem()) {
                    hashMap.put(aggregationElementsExType2.getPath(), aggregationElementsExType2.getType().trim());
                }
            }
        }
        boolean bl3 = false;
        boolean bl4 = false;
        jSONAttributesType = null;
        if (jSONQueryNodeType.getJSONAttributes().getJSONAttribute() != null && !jSONQueryNodeType.getJSONAttributes().getJSONAttribute().isEmpty()) {
            jSONAttributesType = (JSONAttributesType)MetaDataHelper.copyMetadataObject(jSONQueryNodeType.getJSONAttributes());
            for (AggregationElementsExType aggregationElementsExType2 : jSONAttributesType.getJSONAttribute()) {
                Object object5 = (String)hashMap.get(aggregationElementsExType2.getPath());
                if (object5 == null && JSONElement.JSON_ROOT_ARRAY_SYMBOL.equals(aggregationElementsExType2.getDBName())) {
                    object5 = "ARRAY";
                }
                if (object5 != null) {
                    if (!aggregationElementsExType2.getDataType().equals(object5)) {
                        aggregationElementsExType2.setStatus(AttributeStatus.INVALID);
                        if (!bl4) {
                            this.addMessage("JSON_QUERY_JSON_ATTRS_INVALID", MessageEnumType.ERROR, new String[0]);
                            bl4 = true;
                            bl2 = false;
                        }
                        bl3 = true;
                        continue;
                    }
                    aggregationElementsExType2.setStatus(AttributeStatus.VALID);
                    bl3 = true;
                    continue;
                }
                aggregationElementsExType2.setStatus(AttributeStatus.MISSING);
                if (!bl4) {
                    this.addMessage("JSON_QUERY_JSON_ATTRS_INVALID", MessageEnumType.ERROR, new String[0]);
                    bl4 = true;
                    bl2 = false;
                }
                bl3 = true;
            }
        }
        boolean bl5 = false;
        aggregationElementsExType2 = null;
        if (jSONQueryNodeType.getAggregationElements().getAggregationElement() != null && !jSONQueryNodeType.getAggregationElements().getAggregationElement().isEmpty()) {
            aggregationElementsExType2 = (AggregationElementsExType)MetaDataHelper.copyMetadataObject(jSONQueryNodeType.getAggregationElements());
            for (AggregationElementsExType.AggregationElement aggregationElement : aggregationElementsExType2.getAggregationElement()) {
                object4 = (String)hashMap.get(aggregationElement.getJSONAttribute().getPath());
                if (object4 != null) {
                    if (!aggregationElement.getJSONAttribute().getDataType().equals(object4)) {
                        aggregationElement.getJSONAttribute().setStatus(AttributeStatus.INVALID);
                        aggregationElement.getOutput().setStatus(AttributeStatus.INVALID);
                        if (!bl4) {
                            this.addMessage("JSON_QUERY_JSON_ATTRS_INVALID", MessageEnumType.ERROR, new String[0]);
                            bl4 = true;
                            bl2 = false;
                        }
                        bl5 = true;
                    } else {
                        aggregationElement.getJSONAttribute().setStatus(AttributeStatus.VALID);
                        aggregationElement.getOutput().setStatus(AttributeStatus.VALID);
                        bl5 = true;
                    }
                } else {
                    aggregationElement.getJSONAttribute().setStatus(AttributeStatus.MISSING);
                    aggregationElement.getOutput().setStatus(AttributeStatus.MISSING);
                    if (!bl4) {
                        this.addMessage("JSON_QUERY_JSON_ATTRS_INVALID", MessageEnumType.ERROR, new String[0]);
                        bl4 = true;
                        bl2 = false;
                    }
                    bl5 = true;
                }
                if ((attributes2 = aggregationElement.getSubGroupBy().getAttributes()) == null) continue;
                for (Object object6 : attributes2.getJSONAttribute()) {
                    object4 = (String)hashMap.get(object6.getPath());
                    if (object4 != null) {
                        if (!object6.getDataType().equals(object4)) {
                            object6.setStatus(AttributeStatus.INVALID);
                            if (!bl4) {
                                this.addMessage("JSON_QUERY_JSON_ATTRS_INVALID", MessageEnumType.ERROR, new String[0]);
                                bl4 = true;
                                bl2 = false;
                            }
                            bl5 = true;
                            continue;
                        }
                        object6.setStatus(AttributeStatus.VALID);
                        bl5 = true;
                        continue;
                    }
                    object6.setStatus(AttributeStatus.MISSING);
                    if (!bl4) {
                        this.addMessage("JSON_QUERY_JSON_ATTRS_INVALID", MessageEnumType.ERROR, new String[0]);
                        bl4 = true;
                        bl2 = false;
                    }
                    bl5 = true;
                }
            }
        }
        boolean bl6 = false;
        boolean bl7 = false;
        object4 = new HashMap();
        attributes2 = this.findSourceNodes();
        if (attributes2 != null) {
            for (Object object6 : attributes2) {
                if (!(object6 instanceof DataProvider)) continue;
                attributes3 = ((DataProvider)object6).getAttributes();
                for (AttributeType attributeType : attributes3.getAttribute()) {
                    object4.put(attributeType.getName(), attributeType.getDataType());
                }
            }
        }
        Object object7 = null;
        if (jSONQueryNodeType.getRelationalAttributes().getAttribute() != null && !jSONQueryNodeType.getRelationalAttributes().getAttribute().isEmpty()) {
            object7 = (RelationalAttributesType)MetaDataHelper.copyMetadataObject(jSONQueryNodeType.getRelationalAttributes());
            for (Attributes attributes3 : object7.getAttribute()) {
                String string = (String)object4.get(attributes3.getName());
                if (string != null) {
                    if (!attributes3.getDataType().equals(string)) {
                        attributes3.setStatus(AttributeStatus.INVALID);
                        if (!bl7) {
                            this.addMessage("JSON_QUERY_REL_ATTRS_INVALID", MessageEnumType.ERROR, new String[0]);
                            bl7 = true;
                            bl2 = false;
                        }
                        bl6 = true;
                        continue;
                    }
                    attributes3.setStatus(AttributeStatus.VALID);
                    bl6 = true;
                    continue;
                }
                attributes3.setStatus(AttributeStatus.MISSING);
                if (!bl7) {
                    this.addMessage("JSON_QUERY_REL_ATTRS_INVALID", MessageEnumType.ERROR, new String[0]);
                    bl7 = true;
                    bl2 = false;
                }
                bl6 = true;
            }
        }
        boolean bl8 = false;
        attributes3 = null;
        if (!(jSONQueryNodeType.getGroupingElement().getAttributes() == null || jSONQueryNodeType.getGroupingElement().getAttributes().getJSONAttribute().isEmpty() && jSONQueryNodeType.getGroupingElement().getAttributes().getAttribute().isEmpty())) {
            attributes3 = (GroupingElementExType)MetaDataHelper.copyMetadataObject(jSONQueryNodeType.getGroupingElement());
            for (AttributeType attributeType : attributes3.getAttributes().getJSONAttribute()) {
                object3 = (String)hashMap.get(attributeType.getPath());
                if (object3 != null) {
                    if (!attributeType.getDataType().equals(object3)) {
                        attributeType.setStatus(AttributeStatus.INVALID);
                        if (!bl4) {
                            this.addMessage("JSON_QUERY_JSON_ATTRS_INVALID", MessageEnumType.ERROR, new String[0]);
                            bl4 = true;
                            bl2 = false;
                        }
                        bl8 = true;
                        continue;
                    }
                    attributeType.setStatus(AttributeStatus.VALID);
                    bl8 = true;
                    continue;
                }
                attributeType.setStatus(AttributeStatus.MISSING);
                if (!bl4) {
                    this.addMessage("JSON_QUERY_JSON_ATTRS_INVALID", MessageEnumType.ERROR, new String[0]);
                    bl4 = true;
                    bl2 = false;
                }
                bl8 = true;
            }
            for (AttributeType attributeType : attributes3.getAttributes().getAttribute()) {
                object3 = (String)object4.get(attributeType.getName());
                if (object3 != null) {
                    if (!attributeType.getDataType().equals(object3)) {
                        attributeType.setStatus(AttributeStatus.INVALID);
                        if (!bl7) {
                            this.addMessage("JSON_QUERY_REL_ATTRS_INVALID", MessageEnumType.ERROR, new String[0]);
                            bl7 = true;
                            bl2 = false;
                        }
                        bl8 = true;
                        continue;
                    }
                    attributeType.setStatus(AttributeStatus.VALID);
                    bl8 = true;
                    continue;
                }
                attributeType.setStatus(AttributeStatus.MISSING);
                if (!bl7) {
                    this.addMessage("JSON_QUERY_REL_ATTRS_INVALID", MessageEnumType.ERROR, new String[0]);
                    bl7 = true;
                    bl2 = false;
                }
                bl8 = true;
            }
        }
        boolean bl9 = false;
        boolean bl10 = false;
        object3 = null;
        if (jSONQueryNodeType.getJSONFilters() != null && !jSONQueryNodeType.getJSONFilters().getFilterElement().isEmpty()) {
            object3 = (JSONFilterType)MetaDataHelper.copyMetadataObject(jSONQueryNodeType.getJSONFilters());
            for (Object object22 : object3.getFilterElement()) {
                object = (String)hashMap.get(object22.getJSONAttribute().getPath());
                if (object != null) {
                    if (!object22.getJSONAttribute().getDataType().equals(object)) {
                        object22.getJSONAttribute().setStatus(AttributeStatus.INVALID);
                        if (!bl10) {
                            this.addMessage("JSON_QUERY_JSON_FILTERS_INVALID", MessageEnumType.ERROR, new String[0]);
                            bl10 = true;
                            bl2 = false;
                        }
                        bl9 = true;
                        continue;
                    }
                    object22.getJSONAttribute().setStatus(AttributeStatus.VALID);
                    bl9 = true;
                    continue;
                }
                object22.getJSONAttribute().setStatus(AttributeStatus.MISSING);
                if (!bl10) {
                    this.addMessage("JSON_QUERY_JSON_ATTRS_INVALID", MessageEnumType.ERROR, new String[0]);
                    bl10 = true;
                    bl2 = false;
                }
                bl9 = true;
            }
        }
        ArrayList arrayList = new ArrayList();
        if (bl3) {
            object22 = (JSONAttributesType)MetaDataHelper.copyMetadataObject(jSONQueryNodeType.getJSONAttributes());
            object = new ComplexProperty(JSON_ATTRIBUTES, jSONAttributesType);
            ((ComplexProperty)object).setOldData(object22);
            arrayList.add(object);
        }
        if (bl5) {
            object22 = (AggregationElementsExType)MetaDataHelper.copyMetadataObject(jSONQueryNodeType.getAggregationElements());
            object = new ComplexProperty(AGGREGATION_ELEMENTS, aggregationElementsExType2);
            ((ComplexProperty)object).setOldData(object22);
            arrayList.add(object);
        }
        if (bl6) {
            object22 = (RelationalAttributesType)MetaDataHelper.copyMetadataObject(jSONQueryNodeType.getRelationalAttributes());
            object = new ComplexProperty(RELATIONAL_ATTRIBUTES, object7);
            ((ComplexProperty)object).setOldData(object22);
            arrayList.add(object);
        }
        if (bl8) {
            object22 = (GroupingElementExType)MetaDataHelper.copyMetadataObject(jSONQueryNodeType.getGroupingElement());
            object = new ComplexProperty(GROUPING_ELEMENT, attributes3);
            ((ComplexProperty)object).setOldData(object22);
            arrayList.add(object);
        }
        if (bl9) {
            object22 = (JSONFilterType)MetaDataHelper.copyMetadataObject(jSONQueryNodeType.getJSONFilters());
            object = new ComplexProperty(JSON_FILTERS, object3);
            ((ComplexProperty)object).setOldData(object22);
            arrayList.add(object);
        }
        if (bl3 || bl6 || bl5 || bl8 || bl9) {
            object22 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
            ((ComplexProperty)object22).setOldData(this.getSQLExpression());
            arrayList.add(object22);
        }
        if (!arrayList.isEmpty()) {
            object22 = (OdmrSDMUndoFilter)this.getUndoFilter();
            ((OdmrSDMUndoFilter)((Object)object22)).prepareUndoComplexPropertyList(this, this.getContext(), arrayList);
        }
        if (bl2) {
            bl2 = this.validateNode();
        }
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
        return bl2;
    }

    public boolean validateNode() {
        boolean bl = true;
        JSONQueryNodeType jSONQueryNodeType = (JSONQueryNodeType)this.getData();
        if (jSONQueryNodeType.getSQLExpression() == null || jSONQueryNodeType.getSQLExpression().isEmpty()) {
            this.addMessage("JSON_QUERY_NO_OUTPUT", MessageEnumType.WARNING, new String[0]);
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean allowMoreThanOneInputNode() {
        return false;
    }

    @Override
    public boolean isAllowedConnectionFrom(Node node) {
        List<AbstractNode> list = this.findParentNodes();
        boolean bl = true;
        if (!this.allowMoreThanOneInputNode()) {
            bl = list.isEmpty();
        }
        if (bl) {
            bl = node instanceof DataProvider;
        }
        return bl;
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(true);
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validateNodeRemoval(true);
    }

    public boolean validateNodeRemoval(boolean bl) {
        return this.validate(bl);
    }

    @Override
    public String generateSQLExpression() {
        JSONQueryNodeType jSONQueryNodeType = (JSONQueryNodeType)this.getData();
        return this.generateJSONQuery(false, jSONQueryNodeType.getJSONAttributes(), jSONQueryNodeType.getRelationalAttributes(), jSONQueryNodeType.getAggregationElements(), jSONQueryNodeType.getGroupingElement(), jSONQueryNodeType.getJSONFilters());
    }

    public String getJSONDataSQLExpression(String string) {
        AbstractNode abstractNode;
        StringBuffer stringBuffer = new StringBuffer();
        List<AbstractNode> list = this.findSourceNodes();
        if (list.size() > 0 && (abstractNode = list.get(0)) instanceof DataProvider) {
            AbstractDataNode abstractDataNode = (AbstractDataNode)abstractNode;
            String string2 = abstractDataNode.getInputSQL(true, false);
            stringBuffer.append(string2 + "\n");
            stringBuffer.append("SELECT " + StringUtils.addDoubleQuotes(StringUtils.trimDoubleQuotes(string)) + " FROM " + abstractNode.getNodeNameForSQLExpression(true));
            stringBuffer.insert(0, "WITH ");
        }
        return stringBuffer.toString();
    }

    public String getJSONValueSQLExpression(String string, Integer n, String string2, String string3, String string4) {
        JSONAttributesType jSONAttributesType = new JSONAttributesType();
        jSONAttributesType.setDataType("CLOB");
        jSONAttributesType.setSource(string);
        JSONAttributeType jSONAttributeType = new JSONAttributeType();
        jSONAttributeType.setPath(string2);
        jSONAttributeType.setDataType(string3);
        jSONAttributeType.setDBName(string2.substring(string2.lastIndexOf(".") + 1));
        jSONAttributeType.setDBDataType(string3.equals("STRING") ? "VARCHAR2" : "NUMBER");
        jSONAttributesType.getJSONAttribute().add(jSONAttributeType);
        JSONFilterType jSONFilterType = new JSONFilterType();
        jSONFilterType.setMatch("All");
        jSONFilterType.setUseBy("All");
        DataGuideProvider dataGuideProvider = (DataGuideProvider)((Object)this.findParentNode());
        if (dataGuideProvider == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string5 = "\"N$RefNodeId\"";
        String string6 = null;
        List<AbstractNode> list = this.findSourceNodes();
        if (list.size() > 0) {
            AttributeType attributeType;
            AbstractDataNode abstractDataNode;
            AbstractNode abstractNode = list.get(0);
            if (abstractNode instanceof DataProvider) {
                abstractDataNode = (AbstractDataNode)abstractNode;
                string5 = StringUtils.getReplacedString(string5, "RefNodeId", abstractNode.getMetadataId());
                string6 = abstractDataNode.getInputSQL(true, false);
            }
            stringBuffer.setLength(0);
            stringBuffer.append("WITH\n");
            stringBuffer.append(string6 + ",\n");
            abstractDataNode = null;
            if (jSONAttributesType != null && jSONAttributesType.getSource() != null) {
                attributeType = new AttributeType();
                attributeType.setName(jSONAttributesType.getSource());
                attributeType.setDataType(jSONAttributesType.getDataType());
                abstractDataNode = dataGuideProvider.getJSONAttrDataGuide(attributeType, null);
            }
            attributeType = new ArrayList();
            if (jSONAttributesType != null && !jSONAttributesType.getJSONAttribute().isEmpty()) {
                attributeType.addAll(jSONAttributesType.getJSONAttribute());
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            String string7 = this.generateSourceQuery(string5, (DataGuideType)abstractDataNode, jSONAttributesType == null ? null : jSONAttributesType.getSource(), (List<JSONAttributeType>)attributeType, null, (JSONFilterType)(jSONFilterType != null ? (ServerConstants.JSONFilterApplySetting.isApplyAll((String)jSONFilterType.getUseBy()) || ServerConstants.JSONFilterApplySetting.isApplyUnnest((String)jSONFilterType.getUseBy()) ? jSONFilterType : null) : null), jSONFilterType != null ? ServerConstants.JSONFilterMatchSetting.isMatchAll((String)jSONFilterType.getMatch()) : false, arrayList);
            string7 = string7.replace(abstractNode.getNodeNameForSQLExpression(true), "S");
            String string8 = StringUtils.addDoubleQuotes(StringUtils.trimDoubleQuotes((String)arrayList.get(0)));
            stringBuffer.append("S AS (SELECT " + StringUtils.addDoubleQuotes(StringUtils.trimDoubleQuotes(string)) + " FROM " + abstractNode.getNodeNameForSQLExpression(true) + (String)(n == null ? "" : " FETCH FIRST " + n + " ROWS ONLY") + "), \nV AS (" + string7 + ") \nSELECT distinct " + string8 + " FROM V \nWHERE " + string8 + " IS NOT NULL \nAND " + string8 + " LIKE '" + (StringUtils.isEmpty(string4) ? "%" : string4) + "' \nORDER BY " + string8);
        }
        return stringBuffer.toString();
    }

    @Override
    public void setProperty(String string, Object object) {
        JSONQueryNodeType jSONQueryNodeType = (JSONQueryNodeType)this.getData();
        if (string.equals(JSON_ATTRIBUTES)) {
            JSONAttributesType jSONAttributesType = (JSONAttributesType)object;
            jSONQueryNodeType.setJSONAttributes(jSONAttributesType);
        } else if (string.equals(RELATIONAL_ATTRIBUTES)) {
            RelationalAttributesType relationalAttributesType = (RelationalAttributesType)object;
            jSONQueryNodeType.setRelationalAttributes(relationalAttributesType);
        } else if (string.equals(AGGREGATION_ELEMENTS)) {
            AggregationElementsExType aggregationElementsExType = (AggregationElementsExType)object;
            jSONQueryNodeType.setAggregationElements(aggregationElementsExType);
        } else if (string.equals(GROUPING_ELEMENT)) {
            GroupingElementExType groupingElementExType = (GroupingElementExType)object;
            jSONQueryNodeType.setGroupingElement(groupingElementExType);
        } else if (string.equals(JSON_FILTERS)) {
            JSONFilterType jSONFilterType = (JSONFilterType)object;
            jSONQueryNodeType.setJSONFilters(jSONFilterType);
        } else if (string.equals("SQL_EXPRESSION")) {
            if ("SQL_EXPRESSION_GENERATE".equals(object)) {
                jSONQueryNodeType.setSQLExpression(this.generateSQLExpression());
            } else {
                jSONQueryNodeType.setSQLExpression((String)object);
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(JSON_ATTRIBUTES)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(RELATIONAL_ATTRIBUTES)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(AGGREGATION_ELEMENTS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(GROUPING_ELEMENT)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals(JSON_FILTERS)) {
            return complexProperty.getOldData();
        }
        if (complexProperty.getPropertyName().equals("SQL_EXPRESSION")) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty.getPropertyName());
    }

    @Override
    public Object getProperty(String string) {
        JSONQueryNodeType jSONQueryNodeType = (JSONQueryNodeType)this.getData();
        if (string.equals(JSON_ATTRIBUTES)) {
            return jSONQueryNodeType.getJSONAttributes();
        }
        if (string.equals(RELATIONAL_ATTRIBUTES)) {
            return jSONQueryNodeType.getRelationalAttributes();
        }
        if (string.equals(AGGREGATION_ELEMENTS)) {
            return jSONQueryNodeType.getAggregationElements();
        }
        if (string.equals(GROUPING_ELEMENT)) {
            return jSONQueryNodeType.getGroupingElement();
        }
        if (string.equals(JSON_FILTERS)) {
            return jSONQueryNodeType.getJSONFilters();
        }
        if (string.equals("SQL_EXPRESSION")) {
            return jSONQueryNodeType.getSQLExpression();
        }
        return super.getProperty(string);
    }

    @Override
    public String getHelpTopic() {
        return "jsonquery_node";
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_JSON_QUERY_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_JSON_QUERY_ICON"));
    }

    @Override
    public void refactorForApply() {
    }

    @Override
    public void refactorAttributes(Node node, Map<String, AttributeType> map) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        JSONQueryNodeType jSONQueryNodeType = (JSONQueryNodeType)this.getData();
        RelationalAttributesType relationalAttributesType = jSONQueryNodeType.getRelationalAttributes();
        RelationalAttributesType relationalAttributesType2 = (RelationalAttributesType)MetaDataHelper.copyMetadataObject(relationalAttributesType);
        List list = relationalAttributesType2.getAttribute();
        for (AttributeExType attributeExType : list) {
            AttributeType attributeType = map.get(attributeExType.getName());
            if (attributeType == null || attributeExType.getName().equals(attributeType.getName()) && attributeExType.getDataType().equals(attributeType.getDataType())) continue;
            String string = attributeExType.getName();
            AttributeExType attributeExType2 = null;
            if (attributeExType.getAlias() != null && !attributeExType.getAlias().trim().isEmpty()) {
                attributeExType2 = new AttributeType();
                attributeExType2.setName(attributeExType.getAlias());
                attributeExType2.setAlias(null);
                attributeExType2.setDataType(attributeType.getDataType());
                attributeExType2.setStatus(AttributeStatus.VALID);
                string = attributeExType.getAlias();
            } else {
                attributeExType2 = attributeExType;
            }
            attributeExType.setName(attributeType.getName());
            attributeExType.setDataType(attributeType.getDataType());
            hashMap.put(string, (AttributeType)attributeExType2);
        }
        if (!hashMap.isEmpty()) {
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), RELATIONAL_ATTRIBUTES, relationalAttributesType2);
            this.refactorChildrenAttributes(this, hashMap);
        }
    }

    @Override
    public boolean isVersionSupported(Context context, StringBuffer stringBuffer) {
        if (!super.isVersionSupported(context, stringBuffer)) {
            return false;
        }
        Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
        if (!DbVersionHelper.isDB12102Up((Version)version)) {
            String string = MessageFormat.format(CodeGenLrb.get("VALIDATE_NODE_TYPE_NOT_SUPPORTED"), this.getDefaultName());
            stringBuffer.append(string);
            return false;
        }
        JSONQueryNodeType jSONQueryNodeType = (JSONQueryNodeType)this.getData();
        if (jSONQueryNodeType.getJSONFilters() != null && !jSONQueryNodeType.getJSONFilters().getFilterElement().isEmpty() && !DbVersionHelper.isDB122Up((Version)version)) {
            String string = MessageFormat.format(CodeGenLrb.get("VALIDATE_JSON_FILTER_NOT_SUPPORTED"), this.getDefaultName());
            stringBuffer.append(string);
            return false;
        }
        return true;
    }

    private DataGuideType subsetGuide(DataGuideType dataGuideType, String string) {
        DataGuideType dataGuideType2 = new DataGuideType();
        for (DataGuideType.Item item : dataGuideType.getItem()) {
            if (item.getPath().indexOf(string) != 0) continue;
            int n = string.indexOf(46);
            int n2 = string.lastIndexOf(46);
            if (n > 0 && n2 > 0) {
                Object object = item.getPath().substring(0, n + 1);
                object = (String)object + item.getPath().substring(n2 + 1, item.getPath().length());
                item.setPath((String)object);
            }
            dataGuideType2.getItem().add(item);
        }
        return dataGuideType2;
    }

    @Override
    public DataGuideType getJSONAttrDataGuide(AttributeType attributeType, Integer n) {
        JSONAttributeType jSONAttributeType;
        DataGuideType dataGuideType = null;
        String string = null;
        JSONQueryNodeType jSONQueryNodeType = (JSONQueryNodeType)this.getData();
        Object object = jSONQueryNodeType.getJSONAttributes().getJSONAttribute().iterator();
        while (object.hasNext()) {
            jSONAttributeType = (JSONAttributeType)object.next();
            if (!"ARRAY".equals(jSONAttributeType.getDataType()) && !"OBJECT".equals(jSONAttributeType.getDataType()) || !Boolean.FALSE.equals(jSONAttributeType.isUnnest()) || !jSONAttributeType.getDBName().equals(attributeType.getName())) continue;
            string = jSONAttributeType.getPath();
        }
        if (string != null && (object = (DataGuideProvider)((Object)this.findParentNode())) != null) {
            jSONAttributeType = new AttributeType();
            jSONAttributeType.setName(jSONQueryNodeType.getJSONAttributes().getSource());
            jSONAttributeType.setDataType(jSONQueryNodeType.getJSONAttributes().getDataType());
            dataGuideType = object.getJSONAttrDataGuide((AttributeType)jSONAttributeType, n);
            if (dataGuideType != null) {
                dataGuideType = this.subsetGuide(dataGuideType, string);
            }
        }
        return dataGuideType;
    }

    private List<JSONAttributeType> getJSONStructure(DataGuideType dataGuideType, List<JSONAttributeType> list) {
        ArrayList<JSONAttributeType> arrayList = new ArrayList<JSONAttributeType>();
        HashMap<String, JSONAttributeType> hashMap = new HashMap<String, JSONAttributeType>();
        HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
        if (dataGuideType != null) {
            for (JSONAttributeType jSONAttributeType : list) {
                if (!hashMap.containsKey(jSONAttributeType.getPath())) {
                    hashMap.put(jSONAttributeType.getPath(), jSONAttributeType);
                    int n = jSONAttributeType.getPath().lastIndexOf(46);
                    String string = jSONAttributeType.getPath().substring(0, n);
                    if (hashMap2.containsKey(string)) continue;
                    for (DataGuideType.Item item : dataGuideType.getItem()) {
                        if (jSONAttributeType.getPath().indexOf(item.getPath() + ".") != 0) continue;
                        if (!hashMap.containsKey(item.getPath())) {
                            JSONAttributeType jSONAttributeType2 = new JSONAttributeType();
                            jSONAttributeType2.setDBDataType(DatabaseMetadataUtils.convertJSONAttrType(item.getType()));
                            jSONAttributeType2.setDBName(null);
                            jSONAttributeType2.setDataType(item.getType());
                            jSONAttributeType2.setPath(item.getPath());
                            jSONAttributeType2.setStatus(AttributeStatus.VALID);
                            jSONAttributeType2.setUnnest(Boolean.TRUE);
                            hashMap.put(item.getPath(), jSONAttributeType2);
                        }
                        if (hashMap2.containsKey(item.getPath())) continue;
                        hashMap2.put(item.getPath(), Boolean.TRUE);
                    }
                    continue;
                }
                hashMap.put(jSONAttributeType.getPath(), jSONAttributeType);
            }
        }
        arrayList.addAll(hashMap.values());
        return arrayList;
    }

    private JSONElement loadJSONModel(List<JSONAttributeType> list) {
        HashMap<String, JSONAttributeType> hashMap = new HashMap<String, JSONAttributeType>();
        HashMap<String, JSONElement> hashMap2 = new HashMap<String, JSONElement>();
        int n = 1;
        int n2 = 0;
        JSONElement jSONElement = JSONElement.createRootNode();
        hashMap2.put(JSONElement.JSON_ROOT_OBJECT_SYMBOL, jSONElement);
        for (JSONAttributeType object : list) {
            String string = object.getPath();
            hashMap.put(string, object);
        }
        Object object = jSONElement;
        for (JSONAttributeType jSONAttributeType : list) {
            Object object2;
            int n3;
            String string = jSONAttributeType.getPath();
            String string2 = jSONAttributeType.getDataType();
            JSONElement jSONElement2 = (JSONElement)((Object)hashMap2.get(string));
            if (jSONElement2 != null) {
                jSONElement2.setDataType(string2);
                continue;
            }
            String[] stringArray = DatabaseMetadataUtils.getJSONPathElements(string);
            StringBuilder stringBuilder = new StringBuilder();
            int n4 = -1;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if (n3 > 0) {
                    stringBuilder.append(".");
                }
                stringBuilder.append(stringArray[n3]);
                object2 = (JSONElement)((Object)hashMap2.get(stringBuilder.toString()));
                if (object2 == null) {
                    n4 = n3;
                    break;
                }
                object = object2;
            }
            if (-1 == n4) continue;
            stringBuilder = new StringBuilder();
            for (n3 = 0; n3 < n4; ++n3) {
                object2 = stringArray[n3];
                if (n3 > 0) {
                    stringBuilder.append(".");
                }
                stringBuilder.append((String)object2);
            }
            for (n3 = n4; n3 < stringArray.length; ++n3) {
                object2 = stringArray[n3];
                stringBuilder.append("." + (String)object2);
                JSONElement jSONElement3 = new JSONElement(object2, ++n2);
                object.add((MutableTreeNode)((Object)jSONElement3));
                hashMap2.put(stringBuilder.toString(), jSONElement3);
                JSONAttributeType jSONAttributeType2 = (JSONAttributeType)hashMap.get(stringBuilder.toString());
                if (jSONAttributeType2 == null && JSONElement.JSON_ROOT_ARRAY_SYMBOL.equals(object2)) {
                    jSONElement3.setDataType("ARRAY");
                    jSONElement3.setJSONPath(stringBuilder.toString());
                    jSONElement3.setDBDataType("NotApplicable");
                    jSONElement3.setDBName(JSONElement.JSON_ROOT_ARRAY_SYMBOL);
                    jSONElement3.setUnnested(true);
                } else {
                    jSONElement3.setDataType(jSONAttributeType2.getDataType());
                    jSONElement3.setJSONPath(stringBuilder.toString());
                    jSONElement3.setDBDataType(jSONAttributeType2.getDBDataType());
                    jSONElement3.setDBName(jSONAttributeType2.getDBName());
                    if (jSONAttributeType2.isUnnest() != null) {
                        jSONElement3.setUnnested(jSONAttributeType2.isUnnest());
                    }
                }
                object = jSONElement3;
                ++n;
            }
        }
        return jSONElement;
    }

    public String getStackSQLExpression(JSONAttributesType jSONAttributesType, RelationalAttributesType relationalAttributesType, AggregationElementsExType aggregationElementsExType, GroupingElementExType groupingElementExType, JSONFilterType jSONFilterType) {
        return this.generateJSONQuery(true, jSONAttributesType, relationalAttributesType, aggregationElementsExType, groupingElementExType, jSONFilterType);
    }

    public static String getFilterDefinition(JSONFilterType jSONFilterType, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (jSONFilterType != null) {
            FilterParser filterParser = FilterParser.getInstance();
            for (JSONFilterType.FilterElement filterElement : jSONFilterType.getFilterElement()) {
                String string = filterElement.getJSONAttribute().getDataType();
                String string2 = filterElement.getOperator();
                String string3 = filterElement.getConditions();
                StringBuffer stringBuffer2 = new StringBuffer();
                StringBuffer stringBuffer3 = new StringBuffer();
                StringBuffer stringBuffer4 = new StringBuffer();
                if ("ARRAY".equals(filterElement.getJSONAttribute().getDataType()) || ServerConstants.JSONFilterOperators.isOperatorContain((String)string2)) continue;
                try {
                    List list = filterParser.ParseString(string3);
                    int n = -1;
                    n = filterElement.getJSONAttribute().getPath().startsWith("$.[*]") ? filterElement.getJSONAttribute().getPath().indexOf(46, 2) : filterElement.getJSONAttribute().getPath().indexOf(46);
                    Object object = filterElement.getJSONAttribute().getPath().substring(n, filterElement.getJSONAttribute().getPath().length());
                    object = "@" + (String)object;
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(bl ? "\n  && " : "\n  || ");
                    }
                    if ("BOOLEAN".equals(string)) {
                        String string4 = MessageFormat.format("{0} {1} {2}", object, "==", list.get(0));
                        stringBuffer.append(string4);
                        continue;
                    }
                    if (!"STRING".equals(string) && !"NUMBER".equals(string)) continue;
                    int n2 = list.size();
                    for (int i = 0; i < n2; ++i) {
                        Object object2 = list.get(i);
                        String string5 = null;
                        if (object2 instanceof List) {
                            String string6 = (String)((List)object2).get(0);
                            String string7 = (String)((List)object2).get(1);
                            if ("STRING".equals(string) && !"null".equals(string6)) {
                                string6 = StringUtils.addDoubleQuotes(StringUtils.escapeCharacterForSQLScript(StringUtils.trimDoubleQuotes(string6), "\""));
                            }
                            if ("STRING".equals(string) && !"null".equals(string7)) {
                                string7 = StringUtils.addDoubleQuotes(StringUtils.escapeCharacterForSQLScript(StringUtils.trimDoubleQuotes(string7), "\""));
                            }
                            if (ServerConstants.JSONFilterOperators.isOperatorIn((String)string2)) {
                                if (stringBuffer3.length() > 0) {
                                    stringBuffer3.append(" || ");
                                }
                                string5 = MessageFormat.format("({0} >= {1} && {2} <= {3})", object, string6, object, string7);
                                stringBuffer3.append(string5);
                            }
                            if (!ServerConstants.JSONFilterOperators.isOperatorNotIn((String)string2)) continue;
                            if (i > 0) {
                                stringBuffer4.append(" && ");
                            }
                            string5 = MessageFormat.format("({0} < {1} || {2} > {3})", object, string6, object, string7);
                            stringBuffer4.append(string5);
                            continue;
                        }
                        if (!"null".equals(object2) && "STRING".equals(string)) {
                            object2 = StringUtils.addDoubleQuotes(StringUtils.escapeCharacterForSQLScript(StringUtils.trimDoubleQuotes((String)object2), "\""));
                        }
                        if (ServerConstants.JSONFilterOperators.isOperatorIn((String)string2)) {
                            if (stringBuffer2.length() > 0) {
                                stringBuffer2.append(", ");
                            }
                            stringBuffer2.append(object2);
                        }
                        if (ServerConstants.JSONFilterOperators.isOperatorNotIn((String)string2)) {
                            if (i > 0) {
                                stringBuffer4.append(" && ");
                            }
                            string5 = MessageFormat.format("{0} {1} {2}", object, "!=", object2);
                            stringBuffer4.append(string5);
                        }
                        if ("STRING".equals(string) && ServerConstants.JSONFilterOperators.isOperatorStartWith((String)string2)) {
                            if (i > 0) {
                                stringBuffer4.append(" || ");
                            }
                            string5 = MessageFormat.format("{0} {1} {2}", object, "starts with", object2);
                            stringBuffer4.append(string5);
                        }
                        if (ServerConstants.JSONFilterOperators.isOperatorEqual((String)string2)) {
                            string5 = MessageFormat.format("{0} {1} {2}", object, "==", object2);
                            stringBuffer4.append(string5);
                        }
                        if (ServerConstants.JSONFilterOperators.isOperatorNotEqual((String)string2)) {
                            string5 = MessageFormat.format("{0} {1} {2}", object, "!=", object2);
                            stringBuffer4.append(string5);
                        }
                        if (ServerConstants.JSONFilterOperators.isOperatorGreater((String)string2)) {
                            string5 = MessageFormat.format("{0} {1} {2}", object, ">", object2);
                            stringBuffer4.append(string5);
                        }
                        if (ServerConstants.JSONFilterOperators.isOperatorGreaterEqual((String)string2)) {
                            string5 = MessageFormat.format("{0} {1} {2}", object, ">=", object2);
                            stringBuffer4.append(string5);
                        }
                        if (ServerConstants.JSONFilterOperators.isOperatorLess((String)string2)) {
                            string5 = MessageFormat.format("{0} {1} {2}", object, "<", object2);
                            stringBuffer4.append(string5);
                        }
                        if (!ServerConstants.JSONFilterOperators.isOperatorLessEqual((String)string2)) continue;
                        string5 = MessageFormat.format("{0} {1} {2}", object, "<=", object2);
                        stringBuffer4.append(string5);
                    }
                    if (ServerConstants.JSONFilterOperators.isOperatorIn((String)string2)) {
                        if (stringBuffer2.length() > 0) {
                            String string8 = MessageFormat.format("{0} in ({1})", object, stringBuffer2.toString());
                            stringBuffer4.append(string8);
                        }
                        if (stringBuffer3.length() > 0) {
                            if (stringBuffer4.length() > 0) {
                                stringBuffer4.append(" || ");
                            }
                            stringBuffer4.append(stringBuffer3);
                        }
                    }
                    if (n2 > 1) {
                        stringBuffer.append("(" + stringBuffer4.toString() + ")");
                        continue;
                    }
                    stringBuffer.append(stringBuffer4);
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage());
                }
            }
        }
        return stringBuffer.length() > 0 ? "$?(" + stringBuffer.toString() + ")" : "";
    }

    private String generateSourceQuery(String string, DataGuideType dataGuideType, String string2, List<JSONAttributeType> list, List<AttributeExType> list2, JSONFilterType jSONFilterType, boolean bl, List<String> list3) {
        String string3;
        String string4;
        Object object;
        Iterator<AttributeExType> iterator;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        StringBuffer stringBuffer5 = new StringBuffer();
        String string5 = null;
        boolean bl2 = false;
        if (list != null && !list.isEmpty()) {
            Object object2;
            iterator = this.getJSONStructure(dataGuideType, list);
            JSONElement object22 = this.loadJSONModel((List<JSONAttributeType>)((Object)iterator));
            for (int i = 0; i < object22.getChildCount(); ++i) {
                object2 = (JSONElement)((Object)object22.getChildAt(i));
                Object object3 = (String)((JSONElement)((Object)object2)).getValue(JSONElement.JSON_DB_ATTRIBUTE_COLUMN);
                if (!JSONElement.JSON_ROOT_ARRAY_SYMBOL.equals(object3)) continue;
                bl2 = true;
                break;
            }
            object = new HashMap<Integer, Integer>();
            object2 = new HashMap();
            this.generateJSONQueryHelper(2, (Map<Integer, Integer>)object, object22, null, stringBuffer4, jSONFilterType, (Map<String, String>)object2);
            for (JSONAttributeType jSONAttributeType : list) {
                string4 = StringUtils.addDoubleQuotes(StringUtils.trimDoubleQuotes(jSONAttributeType.getDBName().toUpperCase()));
                if (!object2.containsKey(string4)) continue;
                if (stringBuffer2.length() > 0) {
                    stringBuffer2.append(", \n");
                }
                if ((string3 = (String)object2.get(string4)) != null) {
                    stringBuffer2.append("'{'||'" + string3 + ":'||t1." + string4 + "||'}' " + string4);
                } else {
                    stringBuffer2.append("t1." + string4);
                }
                list3.add(StringUtils.trimDoubleQuotes(string4));
            }
        }
        if (list2 != null && !list2.isEmpty()) {
            for (AttributeExType attributeExType : list2) {
                if (stringBuffer2.length() > 0) {
                    stringBuffer2.append(", \n");
                }
                stringBuffer2.append("t0." + StringUtils.addDoubleQuotes(attributeExType.getName()));
                if (attributeExType.getAlias() != null) {
                    stringBuffer2.append(" " + StringUtils.addDoubleQuotes(attributeExType.getAlias()));
                }
                object = attributeExType.getAlias() == null ? attributeExType.getName() : attributeExType.getAlias();
                list3.add((String)object);
            }
        }
        if (jSONFilterType != null) {
            iterator = FilterParser.getInstance();
            String string6 = JSONQueryNode.getFilterDefinition(jSONFilterType, bl);
            if (string6.length() > 0) {
                object = "JSON_EXISTS(" + StringUtils.addDoubleQuotes(string2) + ", '" + string6 + "')";
                stringBuffer5.append((String)object);
            }
            object = new StringBuffer();
            for (Object object3 : jSONFilterType.getFilterElement()) {
                StringBuffer stringBuffer6 = new StringBuffer();
                string4 = object3.getJSONAttribute().getDataType();
                string3 = object3.getOperator();
                String string7 = object3.getConditions();
                if ("ARRAY".equals(string4) || "NUMBER".equals(string4) || !ServerConstants.JSONFilterOperators.isOperatorContain((String)string3)) continue;
                try {
                    List list4 = ((FilterParser)((Object)iterator)).ParseString(string7);
                    if ("STRING".equals(string4)) {
                        int n = list4.size();
                        if (n > 1) {
                            stringBuffer6.append("(");
                        }
                        for (int i = 0; i < n; ++i) {
                            Object object4 = list4.get(i);
                            if (i > 0) {
                                stringBuffer6.append("\n  OR ");
                            }
                            int n2 = -1;
                            n2 = object3.getJSONAttribute().getPath().startsWith("$.[*]") ? object3.getJSONAttribute().getPath().indexOf(46, 2) : object3.getJSONAttribute().getPath().indexOf(46);
                            String string8 = object3.getJSONAttribute().getPath().substring(n2, object3.getJSONAttribute().getPath().length());
                            String string9 = "$" + string8;
                            object4 = StringUtils.escapeSingleQuotesForSQL(StringUtils.trimDoubleQuotes((String)object4));
                            object4 = StringUtils.escapeCharacterForSQLScript((String)object4, "?");
                            stringBuffer6.append("JSON_TEXTCONTAINS(" + StringUtils.addDoubleQuotes(string2) + ", '" + string9 + "', '" + object4 + "')");
                        }
                        if (n > 1) {
                            stringBuffer6.append(")");
                        }
                    }
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage());
                }
                if (stringBuffer6.length() <= 0) continue;
                if (((StringBuffer)object).length() > 0) {
                    ((StringBuffer)object).append(bl ? "\n  AND " : "\n  OR ");
                }
                ((StringBuffer)object).append(stringBuffer6.toString());
            }
            if (((StringBuffer)object).length() > 0) {
                if (stringBuffer5.length() > 0) {
                    stringBuffer5.append(bl ? "\n  AND " : "\n  OR ");
                }
                stringBuffer5.append(((StringBuffer)object).toString());
            }
        }
        stringBuffer.append("SELECT " + (SQLHelper.generateSQLInlineHint(this.getContext()) ? "/*+ inline */" : "") + "\n");
        stringBuffer.append(stringBuffer2 + "\n");
        stringBuffer.append("FROM\n");
        stringBuffer3.append(string);
        stringBuffer3.append(" t0");
        if (stringBuffer4.length() > 0) {
            stringBuffer3.append(", \nJSON_TABLE (" + StringUtils.addDoubleQuotes(string2) + ", " + (bl2 ? "'$[*]'" : "'$'") + " COLUMNS");
            stringBuffer3.append(stringBuffer4);
            stringBuffer3.append("\n");
            stringBuffer3.append(") t1");
        }
        stringBuffer3.append("\n");
        if (stringBuffer5.length() > 0) {
            stringBuffer3.append("WHERE\n");
            stringBuffer3.append("(\n");
            stringBuffer3.append(stringBuffer5.toString() + "\n");
            stringBuffer3.append(")\n");
        }
        stringBuffer.append(stringBuffer3);
        string5 = stringBuffer.toString();
        return string5;
    }

    private String getNodeNameForSQLExpressionWithSuffix(int n, boolean bl) {
        return this.getNodeNameForSQLExpressionInternal(bl, this.getMetadataId() + "_" + n);
    }

    /*
     * WARNING - void declaration
     */
    private String generateJSONQuery(boolean bl, JSONAttributesType jSONAttributesType, RelationalAttributesType relationalAttributesType, AggregationElementsExType aggregationElementsExType, GroupingElementExType groupingElementExType, JSONFilterType jSONFilterType) {
        String string;
        String string22;
        Object object;
        CharSequence charSequence22;
        AttributeExType attributeExType;
        String string3;
        Object object222;
        Object object3;
        Object object422;
        DataGuideType dataGuideType;
        if (!(jSONAttributesType != null && !jSONAttributesType.getJSONAttribute().isEmpty() || relationalAttributesType != null && !relationalAttributesType.getAttribute().isEmpty() || aggregationElementsExType != null && !aggregationElementsExType.getAggregationElement().isEmpty())) {
            return null;
        }
        DataGuideProvider dataGuideProvider = (DataGuideProvider)((Object)this.findParentNode());
        if (dataGuideProvider == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = "{INPUT_SOURCE}";
        String string5 = "\"N$RefNodeId\"";
        String string6 = null;
        if (bl) {
            dataGuideType = this.findSourceNodes();
            for (Object object422 : dataGuideType) {
                if (!(object422 instanceof AbstractDataNode)) continue;
                object3 = (AbstractDataNode)object422;
                string5 = StringUtils.getReplacedString(string5, "RefNodeId", ((AbstractNode)object422).getMetadataId());
                string6 = ((AbstractDataNode)object3).getInputSQL(true, false);
            }
        }
        stringBuffer.setLength(0);
        if (bl) {
            stringBuffer.append("WITH ");
            stringBuffer.append(string6);
        }
        dataGuideType = null;
        if (jSONAttributesType != null && jSONAttributesType.getSource() != null) {
            AttributeType attributeType = new AttributeType();
            attributeType.setName(jSONAttributesType.getSource());
            attributeType.setDataType(jSONAttributesType.getDataType());
            dataGuideType = dataGuideProvider.getJSONAttrDataGuide(attributeType, null);
        }
        int n = 0;
        object422 = new ArrayList();
        object3 = new ArrayList();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList<JSONAttributeType> arrayList3 = new ArrayList<JSONAttributeType>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        if (relationalAttributesType != null && !relationalAttributesType.getAttribute().isEmpty()) {
            object3.addAll(relationalAttributesType.getAttribute());
        }
        if (jSONAttributesType != null && !jSONAttributesType.getJSONAttribute().isEmpty()) {
            object422.addAll(jSONAttributesType.getJSONAttribute());
        }
        if (!(groupingElementExType == null || groupingElementExType.getAttributes() == null || groupingElementExType.getAttributes().getJSONAttribute().isEmpty() && groupingElementExType.getAttributes().getAttribute().isEmpty())) {
            arrayList.addAll(groupingElementExType.getAttributes().getJSONAttribute());
            arrayList2.addAll(groupingElementExType.getAttributes().getAttribute());
            arrayList3.addAll(groupingElementExType.getAttributes().getJSONAttribute());
        }
        if (groupingElementExType != null && groupingElementExType.getAttributes() != null) {
            boolean bl2;
            if (!groupingElementExType.getAttributes().getAttribute().isEmpty()) {
                for (Object object222 : groupingElementExType.getAttributes().getAttribute()) {
                    bl2 = false;
                    string3 = object222.getAlias() != null ? object222.getAlias() : object222.getName();
                    attributeExType = object3.iterator();
                    while (attributeExType.hasNext()) {
                        charSequence22 = (AttributeExType)attributeExType.next();
                        object = charSequence22.getAlias() != null ? charSequence22.getAlias() : charSequence22.getName();
                        if (!string3.equals(object)) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) continue;
                    attributeExType = new AttributeExType();
                    attributeExType.setName(object222.getName());
                    attributeExType.setAlias(object222.getAlias());
                    attributeExType.setDataType(object222.getDataType());
                    attributeExType.setNewDataType(object222.getNewDataType());
                    attributeExType.setStatus(object222.getStatus());
                    object3.add(attributeExType);
                }
            }
            if (!groupingElementExType.getAttributes().getJSONAttribute().isEmpty()) {
                for (Object object222 : groupingElementExType.getAttributes().getJSONAttribute()) {
                    bl2 = false;
                    string3 = object222.getDBName();
                    attributeExType = object422.iterator();
                    while (attributeExType.hasNext()) {
                        charSequence22 = (JSONAttributeType)attributeExType.next();
                        object = charSequence22.getDBName();
                        if (!string3.equals(object)) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) continue;
                    object422.add(object222);
                }
            }
        }
        Object object5 = null;
        object222 = null;
        if (jSONAttributesType != null && !jSONAttributesType.getJSONAttribute().isEmpty() || relationalAttributesType != null && relationalAttributesType.getAttribute() != null && !relationalAttributesType.getAttribute().isEmpty()) {
            object5 = this.generateSourceQuery(bl ? string5 : string4, dataGuideType, jSONAttributesType == null ? null : jSONAttributesType.getSource(), (List<JSONAttributeType>)object422, (List<AttributeExType>)object3, (JSONFilterType)(jSONFilterType != null ? (ServerConstants.JSONFilterApplySetting.isApplyAll((String)jSONFilterType.getUseBy()) || ServerConstants.JSONFilterApplySetting.isApplyUnnest((String)jSONFilterType.getUseBy()) ? jSONFilterType : null) : null), jSONFilterType != null ? ServerConstants.JSONFilterMatchSetting.isMatchAll((String)jSONFilterType.getMatch()) : false, arrayList4);
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",\n");
            }
            object222 = this.getNodeNameForSQLExpressionWithSuffix(++n, true);
            stringBuffer.append((String)object222 + " as (" + (String)object5 + ")\n");
        }
        String string7 = null;
        string3 = null;
        if (aggregationElementsExType != null && !aggregationElementsExType.getAggregationElement().isEmpty()) {
            for (CharSequence charSequence22 : aggregationElementsExType.getAggregationElement()) {
                object = charSequence22.getJSONAttribute();
                boolean bl3 = true;
                for (JSONAttributeType jSONAttributeType : arrayList3) {
                    string22 = jSONAttributeType.getDBName();
                    if (!string22.equals(object.getDBName())) continue;
                    bl3 = false;
                    break;
                }
                if (bl3) {
                    arrayList3.add((JSONAttributeType)object);
                }
                if (charSequence22.getSubGroupBy().getAttributes() == null || charSequence22.getSubGroupBy().getAttributes().getJSONAttribute().isEmpty()) continue;
                for (JSONAttributeType jSONAttributeType : charSequence22.getSubGroupBy().getAttributes().getJSONAttribute()) {
                    boolean bl2 = false;
                    string = jSONAttributeType.getDBName();
                    for (JSONAttributeType jSONAttributeType2 : arrayList3) {
                        String string8 = jSONAttributeType2.getDBName();
                        if (!string.equals(string8)) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) continue;
                    arrayList3.add(jSONAttributeType);
                }
            }
            attributeExType = new ArrayList();
            charSequence22 = this.generateSourceQuery(bl ? string5 : string4, dataGuideType, jSONAttributesType == null ? null : jSONAttributesType.getSource(), arrayList3, (List<AttributeExType>)object3, (JSONFilterType)(jSONFilterType != null ? (ServerConstants.JSONFilterApplySetting.isApplyAll((String)jSONFilterType.getUseBy()) || ServerConstants.JSONFilterApplySetting.isApplyAggreg((String)jSONFilterType.getUseBy()) ? jSONFilterType : null) : null), jSONFilterType != null ? Boolean.valueOf(ServerConstants.JSONFilterMatchSetting.isMatchAll((String)jSONFilterType.getMatch())) : null, (List<String>)attributeExType);
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",\n");
            }
            string7 = this.getNodeNameForSQLExpressionWithSuffix(++n, true);
            stringBuffer.append(string7 + " as (" + (String)charSequence22 + ")\n");
            object5 = this.generateAggregationQuery(string7, groupingElementExType, aggregationElementsExType, string7, false);
            string3 = this.getNodeNameForSQLExpressionWithSuffix(++n, true);
            stringBuffer.append(",\n");
            stringBuffer.append(string3 + " as (" + (String)object5 + ")\n");
        }
        if (arrayList.isEmpty() && object3.isEmpty()) {
            attributeExType = new StringBuilder("SELECT * FROM ");
            if (object222 != null) {
                attributeExType.append((String)object222);
            }
            if (string3 != null) {
                if (object222 != null) {
                    attributeExType.append(", ");
                }
                attributeExType.append(string3);
            }
            object5 = attributeExType.toString();
        } else {
            attributeExType = new StringBuilder();
            charSequence22 = new StringBuilder();
            object = new HashMap();
            for (String string9 : arrayList4) {
                if (((StringBuilder)charSequence22).length() > 0) {
                    ((StringBuilder)charSequence22).append(", ");
                }
                ((StringBuilder)charSequence22).append("t0." + StringUtils.addDoubleQuotes(string9));
                object.put(string9, Boolean.TRUE);
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (aggregationElementsExType != null && !aggregationElementsExType.getAggregationElement().isEmpty()) {
                for (AggregationElementsExType.AggregationElement aggregationElement : aggregationElementsExType.getAggregationElement()) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    string22 = aggregationElement.getOutput().getAlias() != null ? aggregationElement.getOutput().getAlias() : aggregationElement.getOutput().getName();
                    stringBuilder.append("t1." + StringUtils.addDoubleQuotes(string22));
                }
            }
            if (groupingElementExType != null && groupingElementExType.getAttributes() != null) {
                for (AttributeExType attributeExType2 : groupingElementExType.getAttributes().getAttribute()) {
                    string22 = attributeExType2.getAlias() != null ? attributeExType2.getAlias() : attributeExType2.getName();
                    if (object.containsKey(string22)) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("t1." + StringUtils.addDoubleQuotes(string22));
                    object.put(string22, Boolean.TRUE);
                }
                for (JSONAttributeType jSONAttributeType : groupingElementExType.getAttributes().getJSONAttribute()) {
                    string22 = jSONAttributeType.getDBName();
                    if (object.containsKey(string22)) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("t1." + StringUtils.addDoubleQuotes(string22));
                    object.put(string22, Boolean.TRUE);
                }
            }
            attributeExType.append("  SELECT ");
            if (((StringBuilder)charSequence22).length() > 0) {
                attributeExType.append(charSequence22);
            }
            if (stringBuilder.length() > 0) {
                if (((StringBuilder)charSequence22).length() > 0) {
                    attributeExType.append(", ");
                }
                attributeExType.append((CharSequence)stringBuilder);
            }
            attributeExType.append("\n");
            attributeExType.append("  FROM ");
            if (object222 != null) {
                attributeExType.append((String)object222 + " t0");
            }
            if (string3 != null) {
                if (object222 != null) {
                    attributeExType.append(", ");
                }
                attributeExType.append(string3 + " t1 \n");
            } else if (string7 != null) {
                if (object222 != null) {
                    attributeExType.append(", ");
                }
                attributeExType.append(string7 + " t1 \n");
            }
            if (object222 != null && string7 != null) {
                attributeExType.append("  WHERE ");
                boolean bl3 = false;
                for (String string22 : arrayList2) {
                    void var28_42;
                    if (var28_42 > 0) {
                        attributeExType.append("\n  AND ");
                    }
                    string = string22.getAlias() != null ? string22.getAlias() : string22.getName();
                    string = StringUtils.addDoubleQuotes(string);
                    attributeExType.append("t0." + string + " = t1." + string);
                    ++var28_42;
                }
                if (!arrayList.isEmpty()) {
                    for (String string22 : arrayList) {
                        void var28_43;
                        if (var28_43 > 0) {
                            attributeExType.append("\n  AND ");
                        }
                        string = StringUtils.addDoubleQuotes(string22.getDBName());
                        attributeExType.append("t0." + string + " = t1." + string);
                        ++var28_43;
                    }
                }
            }
            object5 = attributeExType.toString();
        }
        stringBuffer.append(",\n");
        stringBuffer.append(this.getNodeNameForSQLExpression(true) + " as (" + (String)object5 + ")\n");
        if (bl) {
            stringBuffer.append("SELECT * FROM " + this.getNodeNameForSQLExpression(true));
        }
        return stringBuffer.toString();
    }

    private String getJSONArraySubscripts(String string, JSONFilterType jSONFilterType) {
        StringBuffer stringBuffer;
        block17: {
            stringBuffer = new StringBuffer();
            Object object = null;
            for (Object object2 : jSONFilterType.getFilterElement()) {
                if (!object2.getJSONAttribute().getPath().equals(string)) continue;
                object = object2;
                break;
            }
            if (object != null) {
                try {
                    int n;
                    Object object3;
                    Object object2;
                    String string2 = object.getOperator();
                    object2 = object.getConditions();
                    FilterParser filterParser = FilterParser.getInstance();
                    List list = filterParser.ParseArray((String)object2);
                    if (ServerConstants.JSONFilterOperators.isOperatorLess((String)string2)) {
                        int n2 = Math.max(0, Integer.parseInt((String)list.get(0)) - 1);
                        if (n2 == 0) {
                            stringBuffer.append(n2);
                        } else {
                            String string3 = MessageFormat.format("{0} to {1}", "0", n2);
                            stringBuffer.append(string3);
                        }
                        break block17;
                    }
                    if (!ServerConstants.JSONFilterOperators.isOperatorIn((String)string2)) break block17;
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    for (int i = 0; i < list.size(); ++i) {
                        object3 = list.get(i);
                        if (object3 instanceof List) {
                            int n3 = Integer.parseInt((String)((List)object3).get(0));
                            int n4 = Integer.parseInt((String)((List)object3).get(1));
                            for (n = n3; n <= n4; ++n) {
                                if (arrayList.contains(n)) continue;
                                arrayList.add(n);
                            }
                            continue;
                        }
                        if (arrayList.contains(Integer.valueOf((String)object3))) continue;
                        arrayList.add(Integer.valueOf((String)object3));
                    }
                    Collections.sort(arrayList);
                    Integer n5 = null;
                    object3 = null;
                    Integer n6 = null;
                    Object object4 = null;
                    for (n = 0; n < arrayList.size(); ++n) {
                        if (n5 == null) {
                            n6 = n5 = (Integer)arrayList.get(n);
                            continue;
                        }
                        if ((Integer)arrayList.get(n) == n6 + 1) {
                            n6 = (Integer)arrayList.get(n);
                            continue;
                        }
                        object3 = n6;
                        object4 = n5.equals(object3) ? "" + n5 : MessageFormat.format("{0} to {1}", n5, object3);
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append((String)object4);
                        n6 = n5 = (Integer)arrayList.get(n);
                    }
                    if (object3 == null || n5 > (Integer)object3) {
                        object3 = (Integer)arrayList.get(arrayList.size() - 1);
                        object4 = n5.equals(object3) ? "" + n5 : MessageFormat.format("{0} to {1}", n5, object3);
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append((String)object4);
                    }
                }
                catch (Exception exception) {
                    theLogger.log(Level.SEVERE, exception.getMessage());
                }
            } else {
                stringBuffer.append("*");
            }
        }
        return stringBuffer.toString();
    }

    private String indentation(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    private void generateJSONQueryHelper(int n, Map<Integer, Integer> map, JSONElement jSONElement, String string, StringBuffer stringBuffer, JSONFilterType jSONFilterType, Map<String, String> map2) {
        Object object = null;
        for (int i = 0; i < jSONElement.getChildCount(); ++i) {
            JSONElement jSONElement2 = (JSONElement)((Object)jSONElement.getChildAt(i));
            String string2 = (String)jSONElement2.getValue(JSONElement.JSON_ATTRIBUTE_COLUMN);
            string2 = StringUtils.addDoubleQuotes(StringUtils.trimDoubleQuotes(string2));
            String string3 = (String)jSONElement2.getValue(JSONElement.JSON_DATA_COLUMN);
            Object object2 = jSONElement2.getValue(JSONElement.JSON_UNNESTED_COLUMN);
            Boolean bl = object2 == null || "".equals(object2) ? Boolean.FALSE : (Boolean)object2;
            String string4 = (String)jSONElement2.getValue(JSONElement.JSON_DB_ATTRIBUTE_COLUMN);
            if (!JSONElement.JSON_ROOT_ARRAY_SYMBOL.equals(string4)) {
                Integer n2;
                if (string4 != null) {
                    string4 = StringUtils.addDoubleQuotes(StringUtils.trimDoubleQuotes(string4.toUpperCase()));
                }
                Object object3 = (String)jSONElement2.getValue(JSONElement.JSON_DB_DATA_COLUMN);
                if ("BOOLEAN".equals(string3)) {
                    object3 = (String)object3 + " EXISTS";
                }
                if ("ARRAY".equals(string3)) {
                    n2 = map.get(n);
                    if (n2 == null) {
                        n2 = 0;
                    }
                    if (n2 > 0) {
                        stringBuffer.append(",\n");
                    } else {
                        stringBuffer.append("\n");
                    }
                    stringBuffer.append(this.indentation(n));
                    if (Boolean.TRUE.equals(bl)) {
                        stringBuffer.append("NESTED PATH '$." + (String)(string != null ? string + "." + string2 : string2) + "[" + this.getJSONArraySubscripts((String)jSONElement2.getValue(JSONElement.JSON_PATH), jSONFilterType) + "]' COLUMNS (");
                        n2 = n2 + 1;
                        map.put(n, n2);
                        map.put(n += 2, 0);
                        object = null;
                    } else {
                        stringBuffer.append(string4 + " VARCHAR2 FORMAT JSON WITH CONDITIONAL WRAPPER PATH '$." + (String)(string != null ? string + "." + string2 : string2) + "'");
                        map2.put(string4, string2);
                        n2 = n2 + 1;
                        map.put(n, n2);
                    }
                } else if ("OBJECT".equals(string3)) {
                    object = string != null ? string + "." + string2 : string2;
                } else {
                    n2 = map.get(n);
                    if (n2 == null) {
                        n2 = 0;
                    }
                    if (n2 > 0) {
                        stringBuffer.append(",\n");
                    } else {
                        stringBuffer.append("\n");
                    }
                    stringBuffer.append(this.indentation(n));
                    stringBuffer.append(string4 + " " + (String)object3 + " PATH '$." + (String)(string != null ? string + "." + string2 : string2) + "'");
                    map2.put(string4, null);
                    n2 = n2 + 1;
                    map.put(n, n2);
                }
                if ("ARRAY".equals(string3)) {
                    if (!Boolean.TRUE.equals(bl)) continue;
                    if (jSONElement2.getChildCount() > 0) {
                        this.generateJSONQueryHelper(n, map, jSONElement2, (String)object, stringBuffer, jSONFilterType, map2);
                    } else {
                        stringBuffer.append("\n");
                        stringBuffer.append(this.indentation(n));
                        stringBuffer.append(string4 + " VARCHAR2 PATH '$'");
                        map2.put(string4, null);
                    }
                    stringBuffer.append("\n");
                    stringBuffer.append(this.indentation(n -= 2));
                    stringBuffer.append(")");
                    continue;
                }
                this.generateJSONQueryHelper(n, map, jSONElement2, (String)object, stringBuffer, jSONFilterType, map2);
                continue;
            }
            this.generateJSONQueryHelper(n, map, jSONElement2, (String)object, stringBuffer, jSONFilterType, map2);
        }
    }

    public static String mainGroupBytoString(GroupingElementExType groupingElementExType) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != groupingElementExType.getAttributes() && null != groupingElementExType.getAttributes().getAttribute()) {
            Object object2;
            List list = groupingElementExType.getAttributes().getAttribute();
            for (Object object2 : list) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(AttributeTypeHelper.processDoubleQuotedName((AttributeType)object2));
            }
            List list2 = groupingElementExType.getAttributes().getJSONAttribute();
            object2 = list2.iterator();
            while (object2.hasNext()) {
                JSONAttributeType jSONAttributeType = (JSONAttributeType)object2.next();
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(AttributeTypeHelper.processDoubleQuotedName(jSONAttributeType.getDBName()));
            }
        }
        return stringBuffer.toString();
    }

    private static String convertJSONGroupingElementTypetoSQL(AggregationElementsExType.AggregationElement.SubGroupBy subGroupBy) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != subGroupBy.getAttributes() && null != subGroupBy.getAttributes().getJSONAttribute()) {
            List list = subGroupBy.getAttributes().getJSONAttribute();
            for (JSONAttributeType jSONAttributeType : list) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" || ");
                    stringBuffer.append("'");
                    stringBuffer.append(" - ");
                    stringBuffer.append("'");
                    stringBuffer.append(" || ");
                } else {
                    stringBuffer.append("(");
                }
                stringBuffer.append(jSONAttributeType.getDBName());
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private static String convertJSONGroupingElementTypetoSQL(GroupingElementExType groupingElementExType, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != groupingElementExType.getAttributes() && null != groupingElementExType.getAttributes().getAttribute()) {
            List list;
            if (!groupingElementExType.getAttributes().getJSONAttribute().isEmpty()) {
                list = groupingElementExType.getAttributes().getJSONAttribute();
                for (JSONAttributeType jSONAttributeType : list) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(string);
                    stringBuffer.append(".");
                    stringBuffer.append(jSONAttributeType.getDBName());
                }
            }
            if (!groupingElementExType.getAttributes().getAttribute().isEmpty()) {
                list = groupingElementExType.getAttributes().getAttribute();
                for (JSONAttributeType jSONAttributeType : list) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(string);
                    stringBuffer.append(".");
                    stringBuffer.append(AttributeTypeHelper.processDoubleQuotedName((AttributeType)jSONAttributeType));
                }
            }
        }
        return stringBuffer.toString();
    }

    private static String convertAggregationElementSourcetoSQL(Context context, AggregationElementsExType.AggregationElement aggregationElement) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = DatabaseMetadataUtils.AggregateFunctions.CAST_COLLECT.toString().equals(aggregationElement.getAggregationFunction());
        JSONAttributeType jSONAttributeType = aggregationElement.getJSONAttribute();
        String string = aggregationElement.getAggregationFunction();
        int n = string.indexOf("()");
        StringBuilder stringBuilder = new StringBuilder(string.substring(0, n));
        stringBuilder.append("(");
        stringBuilder.append(jSONAttributeType.getDBName());
        if (bl) {
            String string2 = AttributeTypeHelper.getNestedCategoricalType(context, jSONAttributeType.getDBDataType());
            stringBuilder.append(") AS " + string2);
            stringBuilder.append(string.substring(n + 2, string.length()));
        } else {
            stringBuilder.append(string.substring(n + 1, string.length()));
        }
        stringBuffer.append((CharSequence)stringBuilder);
        stringBuffer.append(" ");
        stringBuffer.append(AttributeTypeHelper.processDoubleQuotedName(aggregationElement.getOutput()));
        return stringBuffer.toString();
    }

    private static String convertGroupingElementTypetoWhereClause(GroupingElementExType groupingElementExType, String string, List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        if (null != groupingElementExType.getAttributes()) {
            StringBuilder stringBuilder2;
            List list2;
            if (!groupingElementExType.getAttributes().getAttribute().isEmpty()) {
                list2 = groupingElementExType.getAttributes().getAttribute();
                for (AttributeType attributeType : list2) {
                    stringBuilder2 = new StringBuilder();
                    for (String string2 : list) {
                        if (string2.equals(string)) continue;
                        if (stringBuilder2.length() > 0) {
                            stringBuilder2.append(" AND ");
                        }
                        stringBuilder2.append(string);
                        stringBuilder2.append(".");
                        stringBuilder2.append(AttributeTypeHelper.processDoubleQuotedName(attributeType));
                        stringBuilder2.append(" = ");
                        stringBuilder2.append(string2);
                        stringBuilder2.append(".");
                        stringBuilder2.append(AttributeTypeHelper.processDoubleQuotedName(attributeType));
                        stringBuilder2.append("(+)\n");
                    }
                    if (stringBuilder2.length() <= 0) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(" AND ");
                    } else {
                        stringBuilder.append(" WHERE ");
                    }
                    stringBuilder.append((CharSequence)stringBuilder2);
                }
            }
            if (!groupingElementExType.getAttributes().getJSONAttribute().isEmpty()) {
                list2 = groupingElementExType.getAttributes().getJSONAttribute();
                for (AttributeType attributeType : list2) {
                    stringBuilder2 = new StringBuilder();
                    for (String string2 : list) {
                        if (string2.equals(string)) continue;
                        if (stringBuilder2.length() > 0) {
                            stringBuilder2.append(" AND ");
                        }
                        stringBuilder2.append(string);
                        stringBuilder2.append(".");
                        stringBuilder2.append(attributeType.getDBName());
                        stringBuilder2.append(" = ");
                        stringBuilder2.append(string2);
                        stringBuilder2.append(".");
                        stringBuilder2.append(attributeType.getDBName());
                        stringBuilder2.append("(+)\n");
                    }
                    if (stringBuilder2.length() <= 0) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(" AND ");
                    } else {
                        stringBuilder.append(" WHERE ");
                    }
                    stringBuilder.append((CharSequence)stringBuilder2);
                }
            }
        }
        return stringBuilder.toString();
    }

    public String generateAggregationQuery(String string, GroupingElementExType groupingElementExType, AggregationElementsExType aggregationElementsExType, String string2, boolean bl) {
        boolean bl2;
        Object object;
        Object object2;
        Object object3;
        Object object422;
        boolean bl3 = null == groupingElementExType.getAttributes() || groupingElementExType.getAttributes().getAttribute().isEmpty() && groupingElementExType.getAttributes().getJSONAttribute().isEmpty();
        String string4 = AttributeTypeHelper.getHint(this.getContext());
        List list = aggregationElementsExType.getAggregationElement();
        String string5 = JSONQueryNode.mainGroupBytoString(groupingElementExType);
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<AggregationElementsExType.AggregationElement> arrayList2 = new ArrayList<AggregationElementsExType.AggregationElement>();
        int n = 0;
        for (Object object422 : list) {
            object3 = object422.getSubGroupBy();
            object2 = null;
            if (AttributeTypeHelper.isJSONSubGropByPresent((AggregationElementsExType.AggregationElement.SubGroupBy)object3)) {
                object = JSONQueryNode.convertJSONGroupingElementTypetoSQL((AggregationElementsExType.AggregationElement.SubGroupBy)object3);
                object2 = (AggregationJSONSQLElement)hashMap.get(object);
                if (null == object2) {
                    object2 = new AggregationJSONSQLElement((AggregationElementsExType.AggregationElement)object422);
                    hashMap.put((String)object, object2);
                    arrayList.add(object2);
                    ((AggregationJSONSQLElement)object2).sourceTable = string;
                    ((AggregationJSONSQLElement)object2).sqlSubGroupBy = object;
                    ((AggregationJSONSQLElement)object2).idString = "ID" + ++n;
                    ((AggregationJSONSQLElement)object2).tableAlias = " t" + String.valueOf(n - 1);
                    ((AggregationJSONSQLElement)object2).sb.append("  (SELECT ");
                    ((AggregationJSONSQLElement)object2).sb.append(string5);
                } else {
                    ((AggregationJSONSQLElement)object2).addSourceAttr((AggregationElementsExType.AggregationElement)object422);
                }
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl4 = null != object422.getAggregationFunction() && object422.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.MODE.toString());
                boolean bl5 = null != object422.getAggregationFunction() && object422.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.MAX.toString());
                bl2 = null != object422.getAggregationFunction() && object422.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.MIN.toString());
                boolean bl6 = null != object422.getAggregationFunction() && (object422.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.COUNT.toString()) || object422.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.COUNT_DISTINCT.toString()));
                String string3 = null;
                String string6 = null;
                if (bl4 || bl5 || bl2) {
                    JSONAttributeType jSONAttributeType = object422.getJSONAttribute();
                    if (jSONAttributeType.getDBDataType().equals("VARCHAR2") || jSONAttributeType.getDBDataType().equals("CHAR") || jSONAttributeType.getDBDataType().equals("NVARCHAR2") || jSONAttributeType.getDBDataType().equals("NCHAR")) {
                        string3 = "\n\tCAST(COLLECT(DM_NESTED_CATEGORICAL(";
                        string6 = ")) AS DM_NESTED_CATEGORICALS) ";
                    } else if (jSONAttributeType.getDBDataType().equals("NUMBER") || jSONAttributeType.getDBDataType().equals("FLOAT") || jSONAttributeType.getDBDataType().equals("BINARY_DOUBLE") || jSONAttributeType.getDBDataType().equals("BINARY_FLOAT")) {
                        string3 = "\n\tCAST(COLLECT(DM_NESTED_NUMERICAL(";
                        string6 = ")) AS DM_NESTED_NUMERICALS) ";
                    }
                } else if (bl6) {
                    string3 = "\n\tCAST(COLLECT(DM_NESTED_NUMERICAL(";
                    string6 = ")) AS DM_NESTED_NUMERICALS  ) ";
                } else {
                    boolean bl7;
                    boolean bl8 = bl7 = object3.getAttributes() != null && object3.getAttributes().getJSONAttribute() != null && !object3.getAttributes().getJSONAttribute().isEmpty();
                    if (bl7) {
                        String string7 = ((JSONAttributeType)object3.getAttributes().getJSONAttribute().get(0)).getDBDataType();
                        if (string7.equals("BINARY_FLOAT")) {
                            string3 = "\n\tCAST(COLLECT(DM_NESTED_BINARY_FLOAT(";
                            string6 = ")) AS DM_NESTED_BINARY_FLOATS  ) ";
                        } else if (string7.equals("BINARY_DOUBLE")) {
                            string3 = "\n\tCAST(COLLECT(DM_NESTED_BINARY_DOUBLE(";
                            string6 = ")) AS DM_NESTED_BINARY_DOUBLES  ) ";
                        } else {
                            string3 = "\n\tCAST(COLLECT(DM_NESTED_NUMERICAL(";
                            string6 = ")) AS DM_NESTED_NUMERICALS  ) ";
                        }
                    } else {
                        string3 = "\n\tCAST(COLLECT(DM_NESTED_NUMERICAL(";
                        string6 = ")) AS DM_NESTED_NUMERICALS  ) ";
                    }
                }
                if (string3 != null) {
                    stringBuilder.append(string3);
                }
                stringBuilder.append(((AggregationJSONSQLElement)object2).idString);
                stringBuilder.append(", ");
                stringBuilder.append(AttributeTypeHelper.processDoubleQuotedName(object422.getOutput()));
                if (string6 != null) {
                    stringBuilder.append(string6);
                }
                stringBuilder.append(" " + AttributeTypeHelper.processDoubleQuotedName(object422.getOutput()));
                ((AggregationJSONSQLElement)object2).nestedElement.add(stringBuilder.toString());
                ((AggregationJSONSQLElement)object2).internalResultColumns.add(JSONQueryNode.convertAggregationElementSourcetoSQL(this.getContext(), (AggregationElementsExType.AggregationElement)object422));
                ((AggregationJSONSQLElement)object2).resultColumns.add(AttributeTypeHelper.processDoubleQuotedName(object422.getOutput()));
                continue;
            }
            if (!bl) {
                arrayList2.add((AggregationElementsExType.AggregationElement)object422);
                continue;
            }
            object2 = new AggregationJSONSQLElement((AggregationElementsExType.AggregationElement)object422);
            arrayList.add(object2);
            ((AggregationJSONSQLElement)object2).sourceTable = string;
            ((AggregationJSONSQLElement)object2).tableAlias = " t" + String.valueOf(++n - 1);
            ((AggregationJSONSQLElement)object2).resultColumns.add(AttributeTypeHelper.processDoubleQuotedName(object422.getOutput()));
            ((AggregationJSONSQLElement)object2).sb.append("  (SELECT ");
            ((AggregationJSONSQLElement)object2).sb.append(string4);
            ((AggregationJSONSQLElement)object2).sb.append(string5);
            if (!bl3) {
                ((AggregationJSONSQLElement)object2).sb.append(", ");
            }
            ((AggregationJSONSQLElement)object2).sb.append(JSONQueryNode.convertAggregationElementSourcetoSQL(this.getContext(), (AggregationElementsExType.AggregationElement)object422));
            ((AggregationJSONSQLElement)object2).sb.append("\n\tFROM (");
            ((AggregationJSONSQLElement)object2).sb.append(string);
            ((AggregationJSONSQLElement)object2).sb.append(") ");
            if (!bl3) {
                ((AggregationJSONSQLElement)object2).sb.append("\n\tGROUP BY ");
                ((AggregationJSONSQLElement)object2).sb.append(string5);
            }
            ((AggregationJSONSQLElement)object2).sb.append(")");
            ((AggregationJSONSQLElement)object2).sb.append(((AggregationJSONSQLElement)object2).tableAlias);
        }
        AggregationJSONSQLElement aggregationJSONSQLElement = JSONQueryNode.aggregateWithoutSubGroupBy(this.getContext(), arrayList2, n, string5, bl3, string2, string4);
        if (null != aggregationJSONSQLElement) {
            arrayList.add(aggregationJSONSQLElement);
        }
        object422 = new StringBuilder("SELECT ");
        object3 = new StringBuilder();
        Object object4 = object2 = arrayList.isEmpty() ? AttributeTypeHelper.getMaintable_alias() : ((AggregationJSONSQLElement)arrayList.get((int)0)).tableAlias;
        if (!arrayList.isEmpty()) {
            ((StringBuilder)object422).append(JSONQueryNode.convertJSONGroupingElementTypetoSQL(groupingElementExType, (String)object2));
        } else {
            ((StringBuilder)object422).append(JSONQueryNode.mainGroupBytoString(groupingElementExType));
        }
        object = new ArrayList();
        boolean bl9 = !bl3 && !arrayList.isEmpty();
        for (AggregationJSONSQLElement aggregationJSONSQLElement2 : arrayList) {
            for (String iterator : aggregationJSONSQLElement2.resultColumns) {
                if (bl9) {
                    ((StringBuilder)object422).append(", ");
                }
                ((StringBuilder)object422).append("\n");
                ((StringBuilder)object422).append(aggregationJSONSQLElement2.tableAlias);
                ((StringBuilder)object422).append(".");
                ((StringBuilder)object422).append(iterator);
                if (bl9) continue;
                bl9 = true;
            }
            if (((StringBuilder)object3).length() > 0) {
                ((StringBuilder)object3).append(",\n");
            }
            ((StringBuilder)object3).append((CharSequence)aggregationJSONSQLElement2.sb);
            boolean bl10 = bl2 = !bl3 && !aggregationJSONSQLElement2.nestedElement.isEmpty();
            if (!aggregationJSONSQLElement2.nestedElement.isEmpty()) {
                for (String string3 : aggregationJSONSQLElement2.nestedElement) {
                    if (bl2) {
                        ((StringBuilder)object3).append(", ");
                    }
                    ((StringBuilder)object3).append(string3);
                    if (bl2) continue;
                    bl2 = true;
                }
                ((StringBuilder)object3).append("\n\tFROM\n");
                ((StringBuilder)object3).append("\t\t(SELECT ");
                ((StringBuilder)object3).append(string4);
                ((StringBuilder)object3).append(" ");
                ((StringBuilder)object3).append(string5);
                if (!bl3) {
                    ((StringBuilder)object3).append(",");
                }
                ((StringBuilder)object3).append("\n\t\t");
                ((StringBuilder)object3).append(aggregationJSONSQLElement2.sqlSubGroupBy + " ");
                ((StringBuilder)object3).append(aggregationJSONSQLElement2.idString);
                for (String string3 : aggregationJSONSQLElement2.internalResultColumns) {
                    ((StringBuilder)object3).append(",\n\t\t");
                    ((StringBuilder)object3).append(string3);
                }
                if (bl) {
                    ((StringBuilder)object3).append("\n\t\tFROM (");
                    ((StringBuilder)object3).append(aggregationJSONSQLElement2.sourceTable);
                    ((StringBuilder)object3).append(") ");
                } else {
                    ((StringBuilder)object3).append("\n\t\tFROM " + string2 + " " + aggregationJSONSQLElement2.getSourceColumnWhereClause() + " ");
                }
                ((StringBuilder)object3).append("\n\t\tGROUP BY ");
                ((StringBuilder)object3).append(string5);
                if (!bl3) {
                    ((StringBuilder)object3).append(", ");
                }
                ((StringBuilder)object3).append("(");
                ((StringBuilder)object3).append(aggregationJSONSQLElement2.sqlSubGroupBy);
                ((StringBuilder)object3).append(") ");
                ((StringBuilder)object3).append(")");
                ((StringBuilder)object3).append("\n\t ");
                if (!bl3) {
                    ((StringBuilder)object3).append("GROUP BY ");
                }
                ((StringBuilder)object3).append(string5);
                ((StringBuilder)object3).append(") ");
                ((StringBuilder)object3).append(aggregationJSONSQLElement2.tableAlias);
            }
            object.add(aggregationJSONSQLElement2.tableAlias);
        }
        if (arrayList.isEmpty()) {
            if (bl) {
                ((StringBuilder)object3).append(" (");
                ((StringBuilder)object3).append(string);
                ((StringBuilder)object3).append(") ");
            } else {
                ((StringBuilder)object3).append(string2 + " ");
            }
            ((StringBuilder)object3).append("\nGROUP BY ");
            ((StringBuilder)object3).append(string5);
        }
        ((StringBuilder)object422).append("\nFROM\n");
        ((StringBuilder)object422).append((CharSequence)object3);
        ((StringBuilder)object422).append("\n");
        String string8 = object.isEmpty() ? AttributeTypeHelper.getMaintable_alias() : (String)object.get(0);
        ((StringBuilder)object422).append(JSONQueryNode.convertGroupingElementTypetoWhereClause(groupingElementExType, string8, (List<String>)object));
        return ((StringBuilder)object422).toString();
    }

    private static AggregationJSONSQLElement aggregateWithoutSubGroupBy(Context context, List<AggregationElementsExType.AggregationElement> list, int n, String string, boolean bl, String string2, String string3) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        AggregationJSONSQLElement aggregationJSONSQLElement = new AggregationJSONSQLElement();
        aggregationJSONSQLElement.tableAlias = " t" + String.valueOf(n);
        aggregationJSONSQLElement.sb = new StringBuilder("  (SELECT ");
        aggregationJSONSQLElement.sb.append(string3);
        aggregationJSONSQLElement.sb.append(string);
        if (!bl) {
            aggregationJSONSQLElement.sb.append(", ");
        }
        StringBuilder stringBuilder = null;
        int n2 = 0;
        for (AggregationElementsExType.AggregationElement aggregationElement : list) {
            AggregationJSONSQLElement aggregationJSONSQLElement2 = new AggregationJSONSQLElement(aggregationElement);
            aggregationJSONSQLElement.sb.append("\n    ");
            if (n2 > 0) {
                aggregationJSONSQLElement.sb.append(",");
            }
            aggregationJSONSQLElement.resultColumns.add(AttributeTypeHelper.processDoubleQuotedName(aggregationElement.getOutput().getName()));
            aggregationJSONSQLElement.sb.append(JSONQueryNode.convertAggregationElementSourcetoSQL(context, aggregationElement));
            ++n2;
            String string4 = aggregationJSONSQLElement2.getSourceColumnWhereClause();
            if (string4 == null || string4.isEmpty()) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder("WHERE ");
            } else {
                stringBuilder.append("\n    AND ");
            }
            stringBuilder.append(string4 + " ");
        }
        Object object = "";
        if (stringBuilder != null) {
            object = stringBuilder.toString();
        }
        aggregationJSONSQLElement.sb.append("\n  FROM " + string2 + "\n  " + (String)object + " ");
        if (!bl) {
            aggregationJSONSQLElement.sb.append("\n  GROUP BY ");
            aggregationJSONSQLElement.sb.append(string);
        }
        aggregationJSONSQLElement.sb.append(")");
        aggregationJSONSQLElement.sb.append(aggregationJSONSQLElement.tableAlias);
        return aggregationJSONSQLElement;
    }

    private static class AggregationJSONSQLElement {
        private List<JSONAttributeType> sourceAttrs;
        private String sqlSubGroupBy;
        private StringBuilder sb = new StringBuilder();
        private List<String> nestedElement = new ArrayList<String>();
        private String tableAlias;
        private List<String> resultColumns = new ArrayList<String>();
        private List<String> internalResultColumns = new ArrayList<String>();
        private String idString;
        private String sourceTable;

        AggregationJSONSQLElement() {
        }

        AggregationJSONSQLElement(AggregationElementsExType.AggregationElement aggregationElement) {
            this.sourceAttrs = new ArrayList<JSONAttributeType>();
            this.sourceAttrs.add(aggregationElement.getJSONAttribute());
        }

        void addSourceAttr(AggregationElementsExType.AggregationElement aggregationElement) {
            if (this.sourceAttrs == null) {
                this.sourceAttrs = new ArrayList<JSONAttributeType>();
            }
            this.sourceAttrs.add(aggregationElement.getJSONAttribute());
        }

        String getSourceColumnWhereClause() {
            return "";
        }
    }

    public static class ColumnNameGenerator {
        private boolean isExpandedObjNameEnabled;
        private HashMap<String, String> _columnNames = new HashMap();
        private static final int MAXIMUM = 30;
        private static final int MAXIMUM_EX = 128;

        public ColumnNameGenerator(Context context, JSONAttributesType jSONAttributesType, RelationalAttributesType relationalAttributesType, AggregationElementsExType aggregationElementsExType, GroupingElementExType groupingElementExType) {
            Object object;
            String string;
            this.isExpandedObjNameEnabled = SQLHelper.isExpandedObjNameEnabled(context);
            if (jSONAttributesType != null) {
                for (JSONAttributeType jSONAttributeType : jSONAttributesType.getJSONAttribute()) {
                    string = jSONAttributeType.getDBName();
                    object = jSONAttributeType.getPath();
                    this._columnNames.put(string, (String)object);
                }
            }
            if (relationalAttributesType != null) {
                for (JSONAttributeType jSONAttributeType : relationalAttributesType.getAttribute()) {
                    string = jSONAttributeType.getAlias() == null ? jSONAttributeType.getName() : jSONAttributeType.getAlias();
                    object = jSONAttributeType.getName();
                    this._columnNames.put(string, (String)object);
                }
            }
            if (aggregationElementsExType != null) {
                for (JSONAttributeType jSONAttributeType : aggregationElementsExType.getAggregationElement()) {
                    string = jSONAttributeType.getOutput().getName();
                    object = jSONAttributeType.getJSONAttribute().getPath() + ":" + jSONAttributeType.getAggregationFunction();
                    this._columnNames.put(string, (String)object);
                }
            }
            if (groupingElementExType != null && groupingElementExType.getAttributes() != null) {
                for (JSONAttributeType jSONAttributeType : groupingElementExType.getAttributes().getJSONAttribute()) {
                    string = jSONAttributeType.getDBName();
                    object = jSONAttributeType.getPath();
                    this._columnNames.put(string, (String)object);
                }
                for (JSONAttributeType jSONAttributeType : groupingElementExType.getAttributes().getAttribute()) {
                    string = jSONAttributeType.getAlias() == null ? jSONAttributeType.getName() : jSONAttributeType.getAlias();
                    object = jSONAttributeType.getName();
                    this._columnNames.put(string, (String)object);
                }
            }
        }

        private String getUniqueName(String string, String string2) {
            int n = 0;
            String string3 = null;
            Object object = string;
            String string4 = null;
            for (Map.Entry<String, String> entry : this._columnNames.entrySet()) {
                if (!string2.equals(entry.getValue())) continue;
                string4 = entry.getKey();
                break;
            }
            if (string4 != null) {
                return string4;
            }
            string3 = this._columnNames.get(string);
            if (string3 == null) {
                this._columnNames.put(string, string2);
                return string;
            }
            while (this._columnNames.containsKey(object)) {
                int n2;
                if ((n2 = ((String)(object = string + ++n)).length()) <= (this.isExpandedObjNameEnabled ? 128 : 30)) continue;
                int n3 = n2 - (this.isExpandedObjNameEnabled ? 128 : 30);
                object = string.substring(0, string.length() - n3) + n;
            }
            this._columnNames.put((String)object, string2);
            return object;
        }

        public String GenerateName(String string, String string2, String string3) {
            return this.GenerateName(string, string2 + ":" + string3);
        }

        public String GenerateName(String string, String string2) {
            String string3 = string;
            if (string.length() > (this.isExpandedObjNameEnabled ? 128 : 30)) {
                string3 = string.substring(0, this.isExpandedObjNameEnabled ? 128 : 30);
            }
            return this.getUniqueName(string3, string2);
        }

        public void rename(String string, String string2) {
            String string3 = this._columnNames.get(string);
            if (string3 != null) {
                this._columnNames.remove(string);
                this._columnNames.put(string2, string3);
            }
        }

        public void removeAll() {
            this._columnNames.clear();
        }
    }
}

