/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicApplyHelper;
import oracle.dmt.dataminer.workflow.dialog.dynamic.PredictionFunctionsHelper;
import oracle.dmt.dataminer.workflow.dialog.dynamic.anomaly.ColumnGeneratorHelper;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.DynamicHelper;
import oracle.dmt.dataminer.workflow.model.DynamicNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicAnomalyNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicApplyOutputColumnType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicNodeBaseSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.dmt.dataminer.workflow.xmlschema.SupplementalAttributesType;
import oracle.ide.Context;

public class DynamicAnomalyNode
extends DynamicNode {
    private String ANOMALY_TEMPLATE = null;
    public static final String ANOMALY_NODE_INPUT_COLUMNS = "ANOMALY_NODE_INPUT_COLUMNS";
    public static final String NUMBER_OF_FEATURES = "NUMBER_OF_FEATURES";

    public DynamicAnomalyNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
        this.ANOMALY_TEMPLATE = "SELECT " + (SQLHelper.generateSQLInlineHint(context) ? "/*+ inline */" : "") + "<SUPPLEMENTAL_DATA>\n<DYNAMIC_ANOMALY_CODE>FROM {INPUT_SOURCE}\n";
    }

    @Override
    public DynamicNodeBaseSettingsType getDynamicNodeBaseSettingsType() {
        DynamicAnomalyNodeType dynamicAnomalyNodeType = (DynamicAnomalyNodeType)this.getData();
        return dynamicAnomalyNodeType.getDynamicNodeBaseSettings();
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_DYNAMIC_ANOMALY_NODE_NAME");
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_DYNAMIC_ANOMALY_DETECTION_NODE_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_DYNAMIC_ANOMALY_DETECTION_NODE_ICON"));
    }

    @Override
    public void initNewInstance(Context context) {
        super.initNewInstance(context);
        DynamicAnomalyNodeType dynamicAnomalyNodeType = (DynamicAnomalyNodeType)this.getData();
        DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.initDynamicNodeBaseSettingsType();
        dynamicAnomalyNodeType.setDynamicNodeBaseSettings(dynamicNodeBaseSettingsType);
        dynamicNodeBaseSettingsType.getDynamicApplyOutputColumns().getDynamicApplyOutputColumn().addAll(this.generateDefaultPredictionOutputs());
        dynamicAnomalyNodeType.getCacheSettings().setUseFullData(Boolean.valueOf(false));
        dynamicAnomalyNodeType.setStatus(NodeStatusType.INVALID);
    }

    public List<DynamicApplyOutputColumnType> generateDefaultPredictionOutputs() {
        ArrayList<DynamicApplyOutputColumnType> arrayList = new ArrayList<DynamicApplyOutputColumnType>();
        arrayList.add(ColumnGeneratorHelper.generateDefaultPredictionOutput(null, this.getNameGenerator(), true));
        arrayList.add(ColumnGeneratorHelper.generateDefaultPredictionProbabilityOutput(null, this.getNameGenerator(), true));
        arrayList.add(ColumnGeneratorHelper.generateDefaultPredictionDetailsOutput(null, this.getNameGenerator(), true));
        return arrayList;
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        if (!(node instanceof DataProvider)) {
            return;
        }
        super.handleNewConnectionFrom(node);
        Attributes attributes = ((DataProvider)((Object)node)).getAttributes();
        List list = attributes.getAttribute();
        DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
        MiningAttributes miningAttributes = dynamicNodeBaseSettingsType.getMiningAttributes();
        List list2 = miningAttributes.getMiningAttribute();
        SupplementalAttributesType supplementalAttributesType = dynamicNodeBaseSettingsType.getSupplementalAttributes();
        supplementalAttributesType.getAttribute();
        CaseAttributes caseAttributes = dynamicNodeBaseSettingsType.getCaseAttributes();
        caseAttributes.getAttribute();
        PartitionExpressions partitionExpressions = dynamicNodeBaseSettingsType.getPartitionExpressions();
        partitionExpressions.getPartitionExpression();
        if (list2.isEmpty()) {
            miningAttributes.setAutoSpec(AutoSpecType.YES);
            this.copyAttributes(list2, list);
            DynamicHelper dynamicHelper = new DynamicHelper(miningAttributes, supplementalAttributesType, caseAttributes, partitionExpressions);
            this.updateAllColumnsTxn(dynamicHelper, new DynamicHelper());
            this.validate(true);
        } else {
            DynamicHelper dynamicHelper = new DynamicHelper(miningAttributes, supplementalAttributesType, caseAttributes, partitionExpressions);
            DynamicHelper dynamicHelper2 = this.copyPreviousState(miningAttributes, supplementalAttributesType, caseAttributes, partitionExpressions);
            this.updateStatusFromDataProvider();
            this.updateAllColumnsTxn(dynamicHelper, dynamicHelper2);
            this.validateSimple(true);
        }
    }

    private DynamicHelper copyPreviousState(MiningAttributes miningAttributes, SupplementalAttributesType supplementalAttributesType, CaseAttributes caseAttributes, PartitionExpressions partitionExpressions) {
        return this.copyPreviousStateCommon(miningAttributes, supplementalAttributesType, caseAttributes, partitionExpressions);
    }

    @Override
    public boolean validate(boolean bl) {
        boolean bl2 = super.validate(bl);
        boolean bl3 = SQLHelper.isExtendedTypeEnabled(this.getContext());
        this.convertNestedVarcharTypes(bl3);
        bl2 = this.performValidation();
        DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
        DynamicHelper dynamicHelper = this.copyPreviousState(dynamicNodeBaseSettingsType.getMiningAttributes(), dynamicNodeBaseSettingsType.getSupplementalAttributes(), dynamicNodeBaseSettingsType.getCaseAttributes(), dynamicNodeBaseSettingsType.getPartitionExpressions());
        this.updateStatusFromDataProvider();
        DynamicHelper dynamicHelper2 = new DynamicHelper(dynamicNodeBaseSettingsType.getMiningAttributes(), dynamicNodeBaseSettingsType.getSupplementalAttributes(), dynamicNodeBaseSettingsType.getCaseAttributes(), dynamicNodeBaseSettingsType.getPartitionExpressions());
        this.updateAllColumnsTxn(dynamicHelper2, dynamicHelper);
        bl2 = this.performValidation();
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
        return bl2;
    }

    @Override
    public void setSQLPredictionExpression(String string) {
        ((DynamicAnomalyNodeType)this.getData()).getDynamicNodeBaseSettings().setSQLPredictionExpression(string);
    }

    @Override
    public String getHelpTopic() {
        return "dynamic_anomaly_node";
    }

    @Override
    public Attributes getAttributes() {
        if (this._isEnableLegacyApplyOutputTypes == null) {
            this.detectDBVersion();
        }
        Attributes attributes = new Attributes();
        if (null != this.getDynamicNodeBaseSettingsType().getSupplementalAttributes() && !this.getDynamicNodeBaseSettingsType().getSupplementalAttributes().getAttribute().isEmpty()) {
            attributes.getAttribute().addAll(this.getDynamicNodeBaseSettingsType().getSupplementalAttributes().getAttribute());
        }
        if (null != this.getDynamicNodeBaseSettingsType().getDynamicApplyOutputColumns() && null != this.getDynamicNodeBaseSettingsType().getDynamicApplyOutputColumns().getDynamicApplyOutputColumn()) {
            for (DynamicApplyOutputColumnType dynamicApplyOutputColumnType : this.getDynamicNodeBaseSettingsType().getDynamicApplyOutputColumns().getDynamicApplyOutputColumn()) {
                String string = null;
                String string2 = null;
                if (null != dynamicApplyOutputColumnType.getPrediction()) {
                    string2 = dynamicApplyOutputColumnType.getPrediction().getColumn().getName();
                    string = "NUMBER";
                } else if (null != dynamicApplyOutputColumnType.getPredictionDetails()) {
                    string2 = dynamicApplyOutputColumnType.getPredictionDetails().getColumn().getName();
                    string = "XMLTYPE";
                } else if (null != dynamicApplyOutputColumnType.getPredictionProbability()) {
                    string2 = dynamicApplyOutputColumnType.getPredictionProbability().getColumn().getName();
                    string = "BINARY_DOUBLE";
                } else if (null != dynamicApplyOutputColumnType.getPredictionSet()) {
                    string2 = dynamicApplyOutputColumnType.getPredictionSet().getColumn().getName();
                    string = this._isEnableLegacyApplyOutputTypes != false ? "ODMR_PREDICTION_SET_NUM" : "ODMR_PREDICTION_SET_NUM_N";
                }
                AttributeType attributeType = new AttributeType();
                attributeType.setName(string2);
                attributeType.setDataType(string != null ? string : "UNKNOWN");
                attributeType.setStatus(AttributeStatus.VALID);
                attributes.getAttribute().add(attributeType);
            }
        }
        return attributes;
    }

    @Override
    public String generateSQLExpression() {
        Map<String, String> map = this.generateSQLExpressions();
        return map.get("CLIENT_SQL_EXPRESSION");
    }

    @Override
    public void refactorForApply() {
    }

    @Override
    public Map<String, String> generateSQLExpressions() {
        Object object2;
        DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
        StringBuilder stringBuilder = new StringBuilder();
        List list = dynamicNodeBaseSettingsType.getMiningAttributes().getMiningAttribute();
        List list2 = dynamicNodeBaseSettingsType.getCaseAttributes().getAttribute();
        List list3 = dynamicNodeBaseSettingsType.getPartitionExpressions().getPartitionExpression();
        boolean bl = false;
        int n = 1;
        for (Object object2 : list) {
            bl = this.isCaseIdAttribute((AttributeType)object2, list2) ? false : (this.isPartitionAttribute((MiningAttributeType)object2, list3) ? false : "Yes".equals(object2.getInput()));
            if (!bl) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("\"");
            stringBuilder.append(object2.getName());
            stringBuilder.append("\"");
            if (stringBuilder.length() <= n * 500) continue;
            stringBuilder.append("\n");
            ++n;
        }
        stringBuilder.append("\n");
        Object object3 = this.generateSupplementalCode(this.ANOMALY_TEMPLATE);
        object2 = object3;
        Map<String, StringBuilder> map = this.generateAnomalySQL();
        object3 = StringUtils.getReplacedString((String)object3, "<DYNAMIC_ANOMALY_CODE>", map.get("CLIENT_SQL_EXPRESSION").toString());
        object3 = StringUtils.getReplacedString((String)object3, "<INPUT_LIST>", stringBuilder.toString());
        object2 = StringUtils.getReplacedString((String)object2, "<DYNAMIC_ANOMALY_CODE>", map.get("SERVER_SQL_EXPRESSION").toString());
        object2 = StringUtils.getReplacedString((String)object2, "<INPUT_LIST>", stringBuilder.toString());
        String string = this.wrapExpressionInWithClause((String)object3);
        String string2 = this.wrapExpressionInWithClause((String)object2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("CLIENT_SQL_EXPRESSION", string);
        hashMap.put("SERVER_SQL_EXPRESSION", string2);
        return hashMap;
    }

    private Map<String, StringBuilder> generateAnomalySQL() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        List list = this.getDynamicNodeBaseSettingsType().getDynamicApplyOutputColumns().getDynamicApplyOutputColumn();
        for (DynamicApplyOutputColumnType dynamicApplyOutputColumnType : list) {
            String string;
            String string2;
            PredictionFunctionsHelper.Parameters parameters = DynamicApplyHelper.getAnomalyFunctionParameters(dynamicApplyOutputColumnType);
            String string3 = string2 = parameters.generateCode(this);
            if (parameters instanceof PredictionFunctionsHelper.AnomalyPredictionDetails) {
                string = this.generateAnomalyPredictionDetails((PredictionFunctionsHelper.AnomalyPredictionDetails)parameters);
                string2 = StringUtils.getReplacedString(string2, "<ANOMALY_VALUE>", string);
                string3 = StringUtils.getReplacedString(string3, "<ANOMALY_VALUE>", string);
            } else if (parameters instanceof PredictionFunctionsHelper.AnomalyPredictionSet) {
                string = this.generateAnomalyPredictionSet((PredictionFunctionsHelper.AnomalyPredictionSet)parameters);
                string2 = StringUtils.getReplacedString(string2, "<TOP_N> <CUT_OFF> ", string);
                string3 = StringUtils.getReplacedString(string3, "<TOP_N> <CUT_OFF> ", string);
            } else if (parameters instanceof PredictionFunctionsHelper.AnomalyPredictionProbability) {
                string = this.generateAnomalyPredictionProbability((PredictionFunctionsHelper.AnomalyPredictionProbability)parameters);
                string2 = StringUtils.getReplacedString(string2, "<CLASS_VALUE> ", string);
                string3 = StringUtils.getReplacedString(string3, "<CLASS_VALUE> ", string);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(",");
            }
            stringBuilder.append(string2);
            stringBuilder2.append(string3);
        }
        HashMap hashMap = new HashMap();
        hashMap.put("CLIENT_SQL_EXPRESSION", stringBuilder);
        hashMap.put("SERVER_SQL_EXPRESSION", stringBuilder2);
        return hashMap;
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(ANOMALY_NODE_INPUT_COLUMNS) || complexProperty.getPropertyName().equals(ALL_COLUMNS)) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public Object getProperty(String string) {
        Object object = null;
        DynamicAnomalyNodeType dynamicAnomalyNodeType = (DynamicAnomalyNodeType)this.getData();
        if (string.equals(ANOMALY_NODE_INPUT_COLUMNS)) {
            HashMap<String, DynamicNodeBaseSettingsType> hashMap = new HashMap<String, DynamicNodeBaseSettingsType>();
            hashMap.put("DynamicNodeBaseSettingsType", dynamicAnomalyNodeType.getDynamicNodeBaseSettings());
            object = hashMap;
        } else if (string.equals(ALL_COLUMNS)) {
            DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = dynamicAnomalyNodeType.getDynamicNodeBaseSettings();
            object = new DynamicHelper(dynamicNodeBaseSettingsType.getMiningAttributes(), dynamicNodeBaseSettingsType.getSupplementalAttributes(), dynamicNodeBaseSettingsType.getCaseAttributes(), dynamicNodeBaseSettingsType.getPartitionExpressions());
        } else {
            return super.getProperty(string);
        }
        return object;
    }

    @Override
    public void setProperty(String string, Object object) {
        DynamicAnomalyNodeType dynamicAnomalyNodeType = (DynamicAnomalyNodeType)this.getData();
        if (string.equals(ANOMALY_NODE_INPUT_COLUMNS)) {
            Map map = (Map)object;
            DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = (DynamicNodeBaseSettingsType)map.get("DynamicNodeBaseSettingsType");
            dynamicAnomalyNodeType.setDynamicNodeBaseSettings(dynamicNodeBaseSettingsType);
        } else if (string.equals(ALL_COLUMNS)) {
            DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = dynamicAnomalyNodeType.getDynamicNodeBaseSettings();
            DynamicHelper dynamicHelper = (DynamicHelper)object;
            dynamicNodeBaseSettingsType.setMiningAttributes(dynamicHelper.newInputAttributes);
            dynamicNodeBaseSettingsType.setSupplementalAttributes(dynamicHelper.newSupplAttributes);
            dynamicNodeBaseSettingsType.setCaseAttributes(dynamicHelper.newCaseAttributes);
            dynamicNodeBaseSettingsType.setPartitionExpressions(dynamicHelper.newPartExpressions);
        } else {
            super.setProperty(string, object);
        }
    }

    private String generateAnomalyPredictionSet(PredictionFunctionsHelper.AnomalyPredictionSet anomalyPredictionSet) {
        StringBuilder stringBuilder = new StringBuilder();
        if (anomalyPredictionSet != null) {
            if (anomalyPredictionSet.isUseTopN()) {
                BigInteger bigInteger = anomalyPredictionSet.getTopN();
                if (!bigInteger.equals(PredictionFunctionsHelper.TOPN_VALUE)) {
                    stringBuilder.append(", " + bigInteger.toString());
                }
                if (anomalyPredictionSet.isUseCutOff()) {
                    if (bigInteger.equals(PredictionFunctionsHelper.TOPN_VALUE)) {
                        stringBuilder.append(", null");
                    }
                    stringBuilder.append(", " + anomalyPredictionSet.getCutOff().toString());
                }
            } else if (anomalyPredictionSet.isUseCutOff()) {
                stringBuilder.append(", null, " + anomalyPredictionSet.getCutOff().toString());
            }
        }
        return stringBuilder.toString();
    }

    private String generateAnomalyPredictionProbability(PredictionFunctionsHelper.AnomalyPredictionProbability anomalyPredictionProbability) {
        StringBuilder stringBuilder = new StringBuilder();
        if (null != anomalyPredictionProbability.getSelectedTarget()) {
            stringBuilder.append(", " + (String)anomalyPredictionProbability.getSelectedTarget());
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    private String generateAnomalyPredictionDetails(PredictionFunctionsHelper.AnomalyPredictionDetails anomalyPredictionDetails) {
        StringBuilder stringBuilder = new StringBuilder();
        if (anomalyPredictionDetails.isUseTarget() && null != anomalyPredictionDetails.getSelectedTarget()) {
            stringBuilder.append(", " + (String)anomalyPredictionDetails.getSelectedTarget());
            stringBuilder.append(" ");
        }
        if (anomalyPredictionDetails.isUseTopN()) {
            if (null == anomalyPredictionDetails.getSelectedTarget()) {
                stringBuilder.append(", NULL , " + anomalyPredictionDetails.getTopN().toString());
            } else {
                stringBuilder.append(", " + anomalyPredictionDetails.getTopN().toString());
            }
        }
        if (null != anomalyPredictionDetails.getSort()) {
            stringBuilder.append(" " + ServerConstants.ApplyPredictionDetailsSort.toAlgorithm((String)anomalyPredictionDetails.getSort()) + " ");
        }
        return stringBuilder.toString();
    }
}

