/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.r;

import java.awt.Insets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditor;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.TestLiftProfitDialogPanel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.r.RBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.r.RBuildPIComponentGUI;
import oracle.dmt.dataminer.workflow.inspect.r.RBuildPIComponentHelper;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ExtensibleBuildNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.preferences.ClassificationModelBuildPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.preferences.RegressionModelBuildPreferencesPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationTestSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.ExtensibleBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TestDataSource;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public class RBuildPIComponentTestPanel
extends JPanel
implements RBuildPIComponentGUI {
    private static double _SLIDER_INITIAL_VALUE = 40.0;
    private static double _SLIDER_MAX_VALUE = 100.0;
    private static double _SLIDER_STEP_VALUE = 1.0;
    private static double _SLIDER_MIN_VALUE = 5.0;
    private WorkflowNodePropertyProxyModel model;
    private ExtensibleBuildNode buildNode;
    private List<ModelType> models;
    private boolean isPartitionModel;
    private boolean clearSearchState;
    private boolean isAdjusting;
    private ButtonGroup buttonGroupTest;
    private JCheckBox jAccuracyMetricsCheckBox;
    private JCheckBox jChkPerformTest;
    private JCheckBox jConfusionMatrixCheckBox;
    private JLabel jCreateSplitAsLabel;
    private JButton jEditTargetsButton;
    private JLabel jLblSplit;
    private JCheckBox jLiftProfitCheckBox;
    private JLabel jLiftProfitTargetSelectionLabel;
    private JPanel jPanelTestData;
    private JCheckBox jROCCheckBox;
    private JRadioButton jRadioAllData;
    private JRadioButton jRadioSplit;
    private JRadioButton jRadioTest;
    private JCheckBox jResidualsCheckBox;
    private JSpinner jSpinnerSplit;
    private JComboBox<String> jSplitTableViewComboBox;
    private JLabel jTestDataLabel;
    private JLabel jTestResultsLabel;

    public RBuildPIComponentTestPanel(PropertyModel propertyModel) {
        this.buildNode = (ExtensibleBuildNode)this.getTargetNode(propertyModel);
        if (this.buildNode == null) {
            return;
        }
        this.clearSearchState = true;
        this.model = (WorkflowNodePropertyProxyModel)propertyModel;
        this.isPartitionModel = !this.buildNode.getPartitionAttributes(null).isEmpty();
        this.models = MetaDataHelper.getModelsCollection((BuildNodeType)this.buildNode.getData());
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.buttonGroupTest = new ButtonGroup();
        this.jChkPerformTest = new JCheckBox();
        this.jPanelTestData = new JPanel();
        this.jTestResultsLabel = new JLabel();
        this.jAccuracyMetricsCheckBox = new JCheckBox();
        this.jConfusionMatrixCheckBox = new JCheckBox();
        this.jROCCheckBox = new JCheckBox();
        this.jLiftProfitCheckBox = new JCheckBox();
        this.jLiftProfitTargetSelectionLabel = new JLabel();
        this.jEditTargetsButton = new JButton();
        this.jResidualsCheckBox = new JCheckBox();
        this.jTestDataLabel = new JLabel();
        this.jRadioAllData = new JRadioButton();
        this.jRadioSplit = new JRadioButton();
        this.jLblSplit = new JLabel();
        this.jSpinnerSplit = new JSpinner();
        this.jCreateSplitAsLabel = new JLabel();
        this.jSplitTableViewComboBox = new JComboBox();
        this.jRadioTest = new JRadioButton();
        this.jChkPerformTest.setText("Perform Test");
        this.jChkPerformTest.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jChkPerformTest.setMargin(new Insets(0, 0, 0, 0));
        this.jTestResultsLabel.setText("Test Results");
        this.jAccuracyMetricsCheckBox.setText("Accuracy Metrics");
        this.jAccuracyMetricsCheckBox.setOpaque(false);
        this.jConfusionMatrixCheckBox.setText("Confusion Matrix");
        this.jConfusionMatrixCheckBox.setOpaque(false);
        this.jROCCheckBox.setText("ROC Curve (Binary Class Only)");
        this.jROCCheckBox.setOpaque(false);
        this.jLiftProfitCheckBox.setText("Lift and Profit");
        this.jLiftProfitCheckBox.setOpaque(false);
        this.jLiftProfitTargetSelectionLabel.setText("Top 5 target class values by frequency");
        this.jEditTargetsButton.setText("Edit...");
        this.jResidualsCheckBox.setText("Residuals");
        this.jResidualsCheckBox.setOpaque(false);
        this.jTestDataLabel.setText("Test Data");
        this.jRadioAllData.setText("Use All Mining Build Data for Testing");
        this.jRadioAllData.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioAllData.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioSplit.setText("Use Split Build Data for Testing");
        this.jRadioSplit.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioSplit.setMargin(new Insets(0, 0, 0, 0));
        this.jLblSplit.setLabelFor(this.jSpinnerSplit);
        this.jLblSplit.setText("Split for Test (%):");
        this.jCreateSplitAsLabel.setLabelFor(this.jSplitTableViewComboBox);
        this.jCreateSplitAsLabel.setText("Create Split as:");
        this.jRadioTest.setText("Use Test Data Source for Testing");
        this.jRadioTest.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioTest.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout(this.jPanelTestData);
        this.jPanelTestData.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTestResultsLabel, -2, 140, -2).addComponent(this.jTestDataLabel, -2, 146, -2).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioSplit, -2, 373, -2).addComponent(this.jRadioAllData, -2, 372, -2).addComponent(this.jRadioTest).addComponent(this.jConfusionMatrixCheckBox).addComponent(this.jResidualsCheckBox).addComponent(this.jAccuracyMetricsCheckBox).addComponent(this.jROCCheckBox).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLblSplit, -2, 122, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSpinnerSplit, -2, 47, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jCreateSplitAsLabel, -2, 122, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSplitTableViewComboBox, -2, -1, -2)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLiftProfitTargetSelectionLabel, -2, 275, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jEditTargetsButton)))).addComponent(this.jLiftProfitCheckBox)))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jTestResultsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jAccuracyMetricsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jResidualsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jConfusionMatrixCheckBox).addGap(2, 2, 2).addComponent(this.jROCCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLiftProfitCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLiftProfitTargetSelectionLabel).addComponent(this.jEditTargetsButton)).addGap(18, 18, 18).addComponent(this.jTestDataLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioAllData).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioSplit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblSplit).addComponent(this.jSpinnerSplit, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCreateSplitAsLabel).addComponent(this.jSplitTableViewComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioTest).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jPanelTestData, -1, -1, Short.MAX_VALUE)).addGroup(groupLayout2.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jChkPerformTest, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(4, 4, 4).addComponent(this.jChkPerformTest).addGap(1, 1, 1).addComponent(this.jPanelTestData, -1, -1, Short.MAX_VALUE)));
    }

    public void initRes() {
        ResourceUtils.resButton((AbstractButton)this.jChkPerformTest, (String)PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_PERFORM_TEST"));
        this.jTestResultsLabel.setText(PropertyLrb.get("PI_BUILD_GROUP_TEST_TEST_RESULTS"));
        ResourceUtils.resButton((AbstractButton)this.jAccuracyMetricsCheckBox, (String)PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_PERFORMANCE_METRICS"));
        ResourceUtils.resButton((AbstractButton)this.jResidualsCheckBox, (String)PropertyLrb.get("PI_REGRESS_BUILD_GROUP_TEST_RESIDUALS"));
        ResourceUtils.resButton((AbstractButton)this.jConfusionMatrixCheckBox, (String)PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_PERFORMANCE_MATRIX"));
        ResourceUtils.resButton((AbstractButton)this.jROCCheckBox, (String)PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_ROC"));
        ResourceUtils.resButton((AbstractButton)this.jLiftProfitCheckBox, (String)PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_LIFT_N_PROFIT"));
        this.jEditTargetsButton.setText(PropertyLrb.get("PI_BUILD_GROUP_TEST_EDIT"));
        this.jTestDataLabel.setText(PropertyLrb.get("PI_BUILD_GROUP_TEST_TEST_DATA"));
        ResourceUtils.resSpinner((JLabel)this.jLblSplit, (JSpinner)this.jSpinnerSplit, (String)PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_SPLIT_LABEL"));
        ResourceUtils.resButton((AbstractButton)this.jRadioAllData, (String)PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_ALL_BUILD_DATA"));
        ResourceUtils.resButton((AbstractButton)this.jRadioSplit, (String)PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_SPLIT_BUILD_DATA"));
        ResourceUtils.resButton((AbstractButton)this.jRadioTest, (String)PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_TEST_DATA"));
        this.buttonGroupTest.add(this.jRadioAllData);
        this.buttonGroupTest.add(this.jRadioSplit);
        this.buttonGroupTest.add(this.jRadioTest);
    }

    public void initUI() {
        if (this.buildNode == null || !this.buildNode.isSupervisedBuildNode()) {
            this.disableControls();
            return;
        }
        if (this.buildNode.isClassification()) {
            this.showClassificationControls();
        } else if (this.buildNode.isRegression()) {
            this.showRegressionControls();
        }
        this.jChkPerformTest.addActionListener(actionEvent -> this.updateTestOption(this.jChkPerformTest.isSelected()));
        this.jChkPerformTest.setOpaque(false);
        this.jSplitTableViewComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{ServerConstants.SplitDataFormat.toHuman((String)"Table"), ServerConstants.SplitDataFormat.toHuman((String)"View")}));
        this.jSpinnerSplit.setModel(new SpinnerNumberModel(_SLIDER_INITIAL_VALUE, _SLIDER_MIN_VALUE, _SLIDER_MAX_VALUE, _SLIDER_STEP_VALUE));
        this.jPanelTestData.setOpaque(false);
        this.jRadioAllData.setOpaque(false);
        this.jRadioSplit.setOpaque(false);
        this.jRadioTest.setOpaque(false);
        this.jRadioAllData.addActionListener(actionEvent -> {
            TestDataSource testDataSource = new TestDataSource();
            testDataSource.setBuildData(new TestDataSource.BuildData());
            this.setValue(testDataSource);
            this.enableControls();
        });
        this.jRadioSplit.addActionListener(actionEvent -> {
            TestDataSource testDataSource = new TestDataSource();
            Double d = (Double)this.jSpinnerSplit.getValue();
            TestDataSource.SplitData splitData = new TestDataSource.SplitData();
            splitData.setTestPercent(d.doubleValue());
            testDataSource.setSplitData(splitData);
            this.setValue(testDataSource);
            this.enableControls();
        });
        this.jRadioTest.addActionListener(actionEvent -> {
            AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this.model);
            if (abstractBuildNode instanceof ExtensibleBuildNode) {
                WorkflowModel workflowModel = abstractBuildNode.getModel();
                AbstractDataNode abstractDataNode = null;
                List<AbstractNode> list = abstractBuildNode.findParentNodes();
                AbstractDataNode abstractDataNode2 = abstractBuildNode.findBuildDataNode(workflowModel);
                abstractDataNode = list.get(0).equals(abstractDataNode2) ? (AbstractDataNode)list.get(1) : (AbstractDataNode)list.get(0);
                if (abstractDataNode != null) {
                    NodeType nodeType = abstractDataNode.getData();
                    TestDataSource testDataSource = new TestDataSource();
                    TestDataSource.TestData testData = new TestDataSource.TestData();
                    testData.setSourceId(nodeType.getId());
                    testDataSource.setTestData(testData);
                    this.setValue(testDataSource);
                }
            }
            this.enableControls();
        });
        this.jEditTargetsButton.addActionListener(actionEvent -> {
            ClassificationTestSettingsType classificationTestSettingsType;
            TestLiftProfitDialogPanel testLiftProfitDialogPanel = new TestLiftProfitDialogPanel(this.getContext((PropertyModel)this.model), (PropertyModel)this.model);
            if (testLiftProfitDialogPanel.showAsDialog(this) && (classificationTestSettingsType = testLiftProfitDialogPanel.collectData()) != null) {
                this.setValue(classificationTestSettingsType);
            }
        });
        boolean bl = this.isPerformTest(this.getTestDataSettings());
        this.jChkPerformTest.setSelected(bl);
        this.initTestOption();
        this.jAccuracyMetricsCheckBox.addActionListener(actionEvent -> {
            ExtensibleBuildNodeType.Results results = this.getResults();
            boolean bl = this.jAccuracyMetricsCheckBox.isSelected();
            Boolean bl2 = results.isGenAccuracyMetrics();
            if (bl2 == null || bl2 != bl) {
                this.setGenAccuracyMetrics(bl);
            }
        });
        this.jResidualsCheckBox.addActionListener(actionEvent -> {
            boolean bl = this.jResidualsCheckBox.isSelected();
            ExtensibleBuildNodeType.Results results = this.getResults();
            Boolean bl2 = results.isGenResiduals();
            if (bl2 == null || bl2 != bl) {
                this.setGenResiduals(bl);
            }
        });
        this.jConfusionMatrixCheckBox.addActionListener(actionEvent -> {
            ExtensibleBuildNodeType.Results results = this.getResults();
            boolean bl = this.jConfusionMatrixCheckBox.isSelected();
            Boolean bl2 = results.isGenConfusionMatrix();
            if (bl2 == null || bl2 != bl) {
                this.setGenConfusionMatrix(bl);
            }
        });
        this.jROCCheckBox.addActionListener(actionEvent -> {
            ExtensibleBuildNodeType.Results results = this.getResults();
            boolean bl = this.jROCCheckBox.isSelected();
            Boolean bl2 = results.isGenROC();
            if (bl2 == null || bl2 != bl) {
                this.setGenROC(bl);
            }
        });
        this.jLiftProfitCheckBox.addActionListener(actionEvent -> {
            ExtensibleBuildNodeType.Results results = this.getResults();
            boolean bl = this.jLiftProfitCheckBox.isSelected();
            Boolean bl2 = results.isGenLift();
            if (bl2 == null || bl2 != bl) {
                this.setGenLiftAndProfit(bl);
            }
        });
        this.jSpinnerSplit.addChangeListener(changeEvent -> {
            TestDataSource testDataSource = this.getTestDataSettings();
            Double d = (Double)this.jSpinnerSplit.getValue();
            double d2 = testDataSource.getSplitData().getTestPercent();
            if (d2 != d) {
                this.adjustSplitValue(d);
            }
        });
        this.jSplitTableViewComboBox.addActionListener(actionEvent -> {
            if (this.isAdjusting) {
                return;
            }
            TestDataSource testDataSource = this.getTestDataSettings();
            String string = (String)this.jSplitTableViewComboBox.getSelectedItem();
            String string2 = testDataSource.getSplitData().getDataFormat();
            if (string2 == null || !string2.equals(string)) {
                this.adjustSplitFormat(ServerConstants.SplitDataFormat.toSchema((String)string));
            }
        });
    }

    @Override
    public Context getContext(PropertyModel propertyModel) {
        return RBuildPIComponentHelper.getContext(propertyModel);
    }

    @Override
    public AbstractBuildNode getTargetNode(PropertyModel propertyModel) {
        return RBuildPIComponentHelper.getTargetNode(propertyModel);
    }

    @Override
    public boolean getClearState() {
        return this.clearSearchState;
    }

    @Override
    public void setClearState(boolean bl) {
        this.clearSearchState = bl;
    }

    @Override
    public JPanel getGUIComponent() {
        return this;
    }

    private void disableControls() {
        this.jChkPerformTest.setEnabled(false);
        this.jAccuracyMetricsCheckBox.setEnabled(false);
        this.jResidualsCheckBox.setEnabled(false);
        this.jConfusionMatrixCheckBox.setEnabled(false);
        this.jROCCheckBox.setEnabled(false);
        this.jLiftProfitCheckBox.setEnabled(false);
        this.jEditTargetsButton.setEnabled(false);
        this.jRadioAllData.setEnabled(false);
        this.jRadioSplit.setEnabled(false);
        this.jSpinnerSplit.setEnabled(false);
        this.jSplitTableViewComboBox.setEnabled(false);
        this.jRadioTest.setEnabled(false);
        this.jTestResultsLabel.setEnabled(false);
        this.jTestDataLabel.setEnabled(false);
        this.jLiftProfitTargetSelectionLabel.setEnabled(false);
    }

    private void showClassificationControls() {
        this.jConfusionMatrixCheckBox.setVisible(true);
        this.jROCCheckBox.setVisible(true);
        this.jLiftProfitCheckBox.setVisible(true);
        this.jLiftProfitTargetSelectionLabel.setVisible(true);
        this.jEditTargetsButton.setVisible(true);
        this.jResidualsCheckBox.setVisible(false);
    }

    private void showRegressionControls() {
        this.jResidualsCheckBox.setVisible(true);
        this.jConfusionMatrixCheckBox.setVisible(false);
        this.jROCCheckBox.setVisible(false);
        this.jLiftProfitCheckBox.setVisible(false);
        this.jLiftProfitTargetSelectionLabel.setVisible(false);
        this.jEditTargetsButton.setVisible(false);
    }

    private boolean isPerformTest(TestDataSource testDataSource) {
        return testDataSource != null && null == testDataSource.getNone();
    }

    private TestDataSource getTestDataSettings() {
        TestDataSource testDataSource = null;
        Context context = this.getContext((PropertyModel)this.model);
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof ExtensibleBuildNodeType) {
            ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)nodeType;
            testDataSource = extensibleBuildNodeType.getTestDataSource();
        }
        return testDataSource;
    }

    private ExtensibleBuildNodeType.Results getResults() {
        ExtensibleBuildNodeType.Results results = null;
        Context context = this.getContext((PropertyModel)this.model);
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof ExtensibleBuildNodeType) {
            ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)nodeType;
            results = extensibleBuildNodeType.getResults();
        }
        return results;
    }

    private ClassificationTestSettingsType getClassificationTestSettings() {
        ClassificationTestSettingsType classificationTestSettingsType = null;
        Context context = this.getContext((PropertyModel)this.model);
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof ExtensibleBuildNodeType) {
            ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)nodeType;
            classificationTestSettingsType = extensibleBuildNodeType.getTestSettings();
        }
        return classificationTestSettingsType;
    }

    private void initTestOption() {
        TestDataSource testDataSource;
        ExtensibleBuildNodeType.Results results = this.getResults();
        this.isAdjusting = true;
        if (results != null) {
            this.jAccuracyMetricsCheckBox.setSelected(results.isGenAccuracyMetrics() == null || results.isGenAccuracyMetrics() != false);
            this.jResidualsCheckBox.setSelected(results.isGenResiduals() == null || results.isGenResiduals() != false);
            this.jConfusionMatrixCheckBox.setSelected(results.isGenConfusionMatrix() == null || results.isGenConfusionMatrix() != false);
            this.jROCCheckBox.setSelected(results.isGenROC() == null || results.isGenROC() != false);
            this.jLiftProfitCheckBox.setSelected(results.isGenLift() == null || results.isGenLift() != false);
            testDataSource = this.getClassificationTestSettings();
            if (testDataSource != null) {
                if (testDataSource.getTopNTargets() != null) {
                    String string = MessageFormat.format(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_TOP_N_TARGETS"), testDataSource.getTopNTargets().getValue().intValue());
                    this.jLiftProfitTargetSelectionLabel.setText(string);
                } else if (testDataSource.getBottomNTargets() != null) {
                    String string = MessageFormat.format(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_BTN_N_TARGETS"), testDataSource.getBottomNTargets().getValue().intValue());
                    this.jLiftProfitTargetSelectionLabel.setText(string);
                } else {
                    this.jLiftProfitTargetSelectionLabel.setText(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_SPECIFIC_TARGETS"));
                }
            }
        }
        if ((testDataSource = this.getTestDataSettings()) != null) {
            if (null != testDataSource.getBuildData()) {
                this.jRadioAllData.setSelected(true);
            } else if (null != testDataSource.getTestData()) {
                this.jRadioTest.setSelected(true);
            } else if (null != testDataSource.getSplitData()) {
                this.jRadioSplit.setSelected(true);
                this.jSpinnerSplit.setValue(testDataSource.getSplitData().getTestPercent());
                if (testDataSource.getSplitData().getDataFormat() != null) {
                    this.jSplitTableViewComboBox.setSelectedItem(ServerConstants.SplitDataFormat.toHuman((String)testDataSource.getSplitData().getDataFormat()));
                } else {
                    this.jSplitTableViewComboBox.setSelectedItem(ServerConstants.SplitDataFormat.toHuman((String)"View"));
                }
            }
        }
        this.enableControls();
        this.isAdjusting = false;
    }

    private void enableControls() {
        boolean bl = this.isWritable();
        boolean bl2 = this.jChkPerformTest.isSelected();
        this.jChkPerformTest.setEnabled(bl);
        this.jAccuracyMetricsCheckBox.setEnabled(bl2 && bl);
        this.jResidualsCheckBox.setEnabled(bl2 && bl);
        this.jConfusionMatrixCheckBox.setEnabled(bl2 && bl);
        this.jROCCheckBox.setEnabled(bl2 && bl);
        this.jLiftProfitCheckBox.setEnabled(bl2 && bl);
        boolean bl3 = this.jLiftProfitCheckBox.isSelected();
        this.jLiftProfitTargetSelectionLabel.setEnabled(bl2 && bl && bl3);
        this.jEditTargetsButton.setEnabled(bl2 && bl && bl3);
        this.jRadioAllData.setEnabled(bl2 && bl);
        this.jRadioSplit.setEnabled(bl2 && bl);
        boolean bl4 = false;
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this.model);
        if (abstractBuildNode instanceof ExtensibleBuildNode) {
            List<AbstractNode> list = abstractBuildNode.findParentNodes();
            bl4 = list != null && !list.isEmpty() && list.size() == 2;
        }
        this.jRadioTest.setEnabled(bl2 && bl4 && bl);
        boolean bl5 = this.jRadioSplit.isSelected();
        this.jSpinnerSplit.setEnabled(bl2 && bl && bl5);
        this.jSplitTableViewComboBox.setEnabled(bl2 && bl && bl5);
    }

    private void updateTestOption(boolean bl) {
        TestDataSource testDataSource = new TestDataSource();
        if (bl) {
            if (null != testDataSource.getBuildData()) {
                this.jRadioAllData.setSelected(true);
                testDataSource.setBuildData(new TestDataSource.BuildData());
            } else if (null != testDataSource.getTestData()) {
                this.jRadioTest.setSelected(true);
                testDataSource.setTestData(new TestDataSource.TestData());
            } else {
                HashStructureAdapter hashStructureAdapter;
                this.jRadioSplit.setSelected(true);
                Preferences preferences = Preferences.getPreferences();
                boolean bl2 = false;
                Double d = _SLIDER_INITIAL_VALUE;
                if (this.buildNode.isClassification()) {
                    hashStructureAdapter = ClassificationModelBuildPreferencesPanelSettings.getInstance((PropertyStorage)preferences);
                    bl2 = hashStructureAdapter.createSplitAsTable();
                    d = hashStructureAdapter.getTestSplitPercent();
                } else if (this.buildNode.isRegression()) {
                    hashStructureAdapter = RegressionModelBuildPreferencesPanelSettings.getInstance((PropertyStorage)preferences);
                    bl2 = hashStructureAdapter.createSplitAsTable();
                    d = hashStructureAdapter.getTestSplitPercent();
                }
                hashStructureAdapter = new TestDataSource.SplitData();
                hashStructureAdapter.setTestPercent(d.doubleValue());
                String string = bl2 ? "Table" : "View";
                hashStructureAdapter.setDataFormat(string);
                testDataSource.setSplitData((TestDataSource.SplitData)hashStructureAdapter);
            }
        } else {
            testDataSource.setNone(new TestDataSource.None());
        }
        this.setValues(testDataSource, bl);
        this.enableControls();
    }

    private void updateWorkFlow() {
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor instanceof WorkflowEditor) {
            WorkflowEditor workflowEditor = (WorkflowEditor)editor;
            WorkflowNode workflowNode = workflowEditor.getWorkflowNode();
            Node node = workflowEditor.getSelectedDiagramNode();
            if (node != null) {
                workflowEditor.setSelected(workflowNode.getEngine(), node);
            }
        }
    }

    private void adjustSplitValue(double d) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this.model);
        if (abstractBuildNode == null) {
            return;
        }
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        HashMap<String, ModelStatusType> hashMap2 = new HashMap<String, ModelStatusType>();
        RBuildPIComponentHelper.getMaps((PropertyModel)this.model, hashMap, hashMap2);
        if (hashMap != null && !hashMap.isEmpty()) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(Property.createFrom(RBuildNodePropertyModel.SPLIT_VALUE, d));
            arrayList.add(Property.createFrom(RBuildNodePropertyModel.MODELS_RERUN, hashMap));
            arrayList.add(Property.createFrom(RBuildNodePropertyModel.TESTS_RERUN, hashMap2));
            this.model.setValueAt("splitValueChanged", abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void adjustSplitFormat(String string) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this.model);
        if (abstractBuildNode == null) {
            return;
        }
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        HashMap<String, ModelStatusType> hashMap2 = new HashMap<String, ModelStatusType>();
        RBuildPIComponentHelper.getMaps((PropertyModel)this.model, hashMap, hashMap2);
        if (hashMap != null && !hashMap.isEmpty()) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(Property.createFrom(RBuildNodePropertyModel.SPLIT_DATA_FORMAT, string));
            arrayList.add(Property.createFrom(RBuildNodePropertyModel.MODELS_RERUN, hashMap));
            arrayList.add(Property.createFrom(RBuildNodePropertyModel.TESTS_RERUN, hashMap2));
            this.model.setValueAt("splitDataFormat", abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void setGenAccuracyMetrics(Boolean bl) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this.model);
        if (abstractBuildNode == null) {
            return;
        }
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        HashMap<String, ModelStatusType> hashMap2 = new HashMap<String, ModelStatusType>();
        RBuildPIComponentHelper.getMaps((PropertyModel)this.model, hashMap, hashMap2);
        if (hashMap != null && !hashMap.isEmpty()) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(Property.createFrom(RBuildNodePropertyModel.GEN_ACCURACY_METRICS_CLAS, bl));
            if (Boolean.FALSE.equals(bl)) {
                if (this.buildNode.isClassification()) {
                    arrayList.add(Property.createFrom(RBuildNodePropertyModel.GEN_CONFUSION_MATRIX, bl));
                    arrayList.add(Property.createFrom(RBuildNodePropertyModel.GEN_ROC_CURVE, bl));
                    arrayList.add(Property.createFrom(RBuildNodePropertyModel.GEN_LIFT_AND_PROFIT, bl));
                } else if (this.buildNode.isRegression()) {
                    arrayList.add(Property.createFrom(RBuildNodePropertyModel.GEN_RESIDUALS, bl));
                }
            }
            arrayList.add(Property.createFrom(RBuildNodePropertyModel.TESTS_RERUN, hashMap2));
            this.model.setValueAt("genAccuracyMetrics", abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void setGenResiduals(Boolean bl) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this.model);
        if (abstractBuildNode == null) {
            return;
        }
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        HashMap<String, ModelStatusType> hashMap2 = new HashMap<String, ModelStatusType>();
        RBuildPIComponentHelper.getMaps((PropertyModel)this.model, hashMap, hashMap2);
        if (hashMap != null && !hashMap.isEmpty()) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            if (Boolean.TRUE.equals(bl)) {
                arrayList.add(Property.createFrom(RBuildNodePropertyModel.GEN_ACCURACY_METRICS_REG, bl));
            }
            arrayList.add(Property.createFrom(RBuildNodePropertyModel.GEN_RESIDUALS, bl));
            arrayList.add(Property.createFrom(RBuildNodePropertyModel.TESTS_RERUN, hashMap2));
            this.model.setValueAt("genResiduals", abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void setGenConfusionMatrix(Boolean bl) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this.model);
        if (abstractBuildNode == null) {
            return;
        }
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        HashMap<String, ModelStatusType> hashMap2 = new HashMap<String, ModelStatusType>();
        RBuildPIComponentHelper.getMaps((PropertyModel)this.model, hashMap, hashMap2);
        if (hashMap != null && !hashMap.isEmpty()) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            if (Boolean.TRUE.equals(bl)) {
                arrayList.add(Property.createFrom(RBuildNodePropertyModel.GEN_RESIDUALS, bl));
            }
            arrayList.add(Property.createFrom(RBuildNodePropertyModel.GEN_CONFUSION_MATRIX, bl));
            if (Boolean.FALSE.equals(bl)) {
                arrayList.add(Property.createFrom(RBuildNodePropertyModel.GEN_ROC_CURVE, bl));
                arrayList.add(Property.createFrom(RBuildNodePropertyModel.GEN_LIFT_AND_PROFIT, bl));
            }
            arrayList.add(Property.createFrom(RBuildNodePropertyModel.TESTS_RERUN, hashMap2));
            this.model.setValueAt("genConfusionMatrix", abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void setGenROC(Boolean bl) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this.model);
        if (abstractBuildNode == null) {
            return;
        }
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        HashMap<String, ModelStatusType> hashMap2 = new HashMap<String, ModelStatusType>();
        RBuildPIComponentHelper.getMaps((PropertyModel)this.model, hashMap, hashMap2);
        if (hashMap != null && !hashMap.isEmpty()) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            if (Boolean.TRUE.equals(bl)) {
                arrayList.add(Property.createFrom(RBuildNodePropertyModel.GEN_ACCURACY_METRICS_CLAS, bl));
                arrayList.add(Property.createFrom(RBuildNodePropertyModel.GEN_CONFUSION_MATRIX, bl));
            }
            arrayList.add(Property.createFrom(RBuildNodePropertyModel.GEN_ROC_CURVE, bl));
            arrayList.add(Property.createFrom(RBuildNodePropertyModel.TESTS_RERUN, hashMap2));
            this.model.setValueAt("genROC", abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void setGenLiftAndProfit(Boolean bl) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this.model);
        if (abstractBuildNode == null) {
            return;
        }
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        HashMap<String, ModelStatusType> hashMap2 = new HashMap<String, ModelStatusType>();
        RBuildPIComponentHelper.getMaps((PropertyModel)this.model, hashMap, hashMap2);
        if (hashMap != null && !hashMap.isEmpty()) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            if (Boolean.TRUE.equals(bl)) {
                arrayList.add(Property.createFrom(RBuildNodePropertyModel.GEN_ACCURACY_METRICS_CLAS, bl));
                arrayList.add(Property.createFrom(RBuildNodePropertyModel.GEN_CONFUSION_MATRIX, bl));
            }
            arrayList.add(Property.createFrom(RBuildNodePropertyModel.GEN_LIFT_AND_PROFIT, bl));
            arrayList.add(Property.createFrom(RBuildNodePropertyModel.TESTS_RERUN, hashMap2));
            this.model.setValueAt("genLiftProfit", abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void setValue(TestDataSource testDataSource) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this.model);
        if (abstractBuildNode == null) {
            return;
        }
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        HashMap<String, ModelStatusType> hashMap2 = new HashMap<String, ModelStatusType>();
        RBuildPIComponentHelper.getMaps((PropertyModel)this.model, hashMap, hashMap2);
        if (hashMap != null && !hashMap.isEmpty()) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(Property.createFrom(RBuildNodePropertyModel.TEST_OPTIONS_CHANGED, testDataSource));
            arrayList.add(Property.createFrom(RBuildNodePropertyModel.MODELS_RERUN, hashMap));
            if (this.isPerformTest(testDataSource)) {
                arrayList.add(Property.createFrom(RBuildNodePropertyModel.TESTS_RERUN, hashMap2));
            } else {
                arrayList.add(new Property(String.valueOf(RBuildNodePropertyModel.TESTS_ADDED_REMOVED.index), null, new ComplexProperty("alltestsRemoved", "alltestsRestored", MetaDataHelper.getClassificationResultsCollection(abstractBuildNode)), null, null));
            }
            this.model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_OPTIONS_CHANGED"), abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void setValue(ClassificationTestSettingsType classificationTestSettingsType) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this.model);
        if (abstractBuildNode == null) {
            return;
        }
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        HashMap<String, ModelStatusType> hashMap2 = new HashMap<String, ModelStatusType>();
        RBuildPIComponentHelper.getMaps((PropertyModel)this.model, hashMap, hashMap2);
        if (hashMap != null && !hashMap.isEmpty()) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(Property.createFrom(RBuildNodePropertyModel.TEST_SETTINGS_CHANGED, classificationTestSettingsType));
            arrayList.add(Property.createFrom(RBuildNodePropertyModel.TESTS_RERUN, hashMap2));
            this.model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_SETTINGS_CHANGED"), abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    private void setValues(TestDataSource testDataSource, boolean bl) {
        AbstractBuildNode abstractBuildNode = this.getTargetNode((PropertyModel)this.model);
        if (abstractBuildNode == null) {
            return;
        }
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        HashMap<String, ModelStatusType> hashMap2 = new HashMap<String, ModelStatusType>();
        RBuildPIComponentHelper.getMaps((PropertyModel)this.model, hashMap, hashMap2);
        if (hashMap != null && !hashMap.isEmpty()) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(Property.createFrom(RBuildNodePropertyModel.TEST_OPTIONS_CHANGED, testDataSource));
            arrayList.add(Property.createFrom(RBuildNodePropertyModel.GEN_ACCURACY_METRICS_CLAS, bl));
            arrayList.add(Property.createFrom(RBuildNodePropertyModel.GEN_CONFUSION_MATRIX, bl));
            arrayList.add(Property.createFrom(RBuildNodePropertyModel.GEN_ROC_CURVE, bl));
            arrayList.add(Property.createFrom(RBuildNodePropertyModel.GEN_LIFT_AND_PROFIT, bl));
            arrayList.add(Property.createFrom(RBuildNodePropertyModel.MODELS_RERUN, hashMap));
            if (this.isPerformTest(testDataSource)) {
                arrayList.add(Property.createFrom(RBuildNodePropertyModel.TESTS_RERUN, hashMap2));
            } else {
                arrayList.add(new Property(String.valueOf(RBuildNodePropertyModel.TESTS_ADDED_REMOVED.index), null, new ComplexProperty("alltestsRemoved", "alltestsRestored", MetaDataHelper.getClassificationResultsCollection(abstractBuildNode)), null, null));
            }
            this.model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_SETTINGS_CHANGED"), abstractBuildNode, arrayList);
            this.updateWorkFlow();
        }
    }

    public void updateUI(PropertyModel propertyModel) {
        this.buildNode = (ExtensibleBuildNode)this.getTargetNode(propertyModel);
        if (this.buildNode == null || !this.buildNode.isSupervisedBuildNode()) {
            this.disableControls();
            return;
        }
        if (this.buildNode.isClassification()) {
            this.showClassificationControls();
        } else if (this.buildNode.isRegression()) {
            this.showRegressionControls();
        }
        if (!(propertyModel instanceof WorkflowNodePropertyProxyModel)) {
            return;
        }
        this.isPartitionModel = !this.buildNode.getPartitionAttributes(null).isEmpty();
        this.model = (WorkflowNodePropertyProxyModel)propertyModel;
        this.models.clear();
        this.models = MetaDataHelper.getModelsCollection((BuildNodeType)this.buildNode.getData());
        TestDataSource testDataSource = this.getTestDataSettings();
        boolean bl = this.isPerformTest(testDataSource);
        this.jChkPerformTest.setSelected(bl);
        this.initTestOption();
        this.jChkPerformTest.setEnabled(this.isWritable());
    }

    @Override
    public boolean isWritable() {
        return RBuildPIComponentHelper.isWritable((PropertyModel)this.model);
    }
}

