/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import ilog.views.IlvGrapher;
import ilog.views.IlvManagerView;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.diagram.core.context.DiagramView;
import oracle.diagram.sdm.inspector.SDMDiagramContextPropertyModel;
import oracle.diagram.sdm.undo.SDMUndoUtil;
import oracle.dmt.dataminer.workflow.inspect.AbstractNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.DataSourceNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.ide.Context;
import oracle.ide.controller.CommandProcessor;

public class WorkflowNodePropertyProxyModel
extends SDMDiagramContextPropertyModel {
    private static final Logger theLogger = Logger.getLogger(WorkflowNodePropertyProxyModel.class.getName());
    public static final String NAME = "NAME";
    public static final String COMMENT = "COMMENT";
    public static final String CACHE_SETTINGS = "CACHE_SETTINGS";
    public static final String SAMPLE_SETTINGS = "SAMPLE_SETTINGS";
    public static final String PREDICTIONS_ONLY = "PREDICTIONS_ONLY";
    public static final String PARTITIONS_EXPRESSIONS = "PARTITIONS_EXPRESSIONS";
    public static final String PARTITIONS_EXPRESSION_EDIT = "PARTITIONS_EXPRESSION_EDIT";
    public static final String OUTPUT_SUPPLEMENTAL = "OUTPUT_SUPPLEMENTAL";
    public static final String CASE_ATTRIBUTE = "CASE_ATTRIBUTE";
    public static final String SQL_EXPRESSION = "SQL_EXPRESSION";
    public static final String NUMBER_OF_CLUSTERS = "NUMBER_OF_CLUSTERS";
    public static final String NUMBER_OF_FEATURES = "NUMBER_OF_FEATURES";
    public static final String STATS_SELECTION = "STATS_SELECTION";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(String string, AbstractNode abstractNode, Object object, int n) {
        CommandProcessor.getInstance().beginTrans(string);
        try {
            this.setValueAt(object, n, 0);
            if (abstractNode instanceof AbstractBuildNode) {
                ((AbstractBuildNode)abstractNode).validateAfterEdit();
            } else if (n == this.getRowMapping(CACHE_SETTINGS)) {
            } else {
                abstractNode.validate(true);
            }
        }
        catch (Exception exception) {
            CommandProcessor.getInstance().abortTrans();
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModelNameProperty(String string, Property property) {
        assert (property != null);
        boolean bl = CommandProcessor.getInstance().isTransactionActive();
        if (!bl) {
            CommandProcessor.getInstance().beginTrans(string);
        }
        try {
            this.setValueAt(property.getValue(), Integer.parseInt(property.getId()), 0);
        }
        catch (Exception exception) {
            if (!bl) {
                CommandProcessor.getInstance().abortTrans();
            }
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        finally {
            if (!bl) {
                CommandProcessor.getInstance().endTrans();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(String string, AbstractNode abstractNode, List<Property> list) {
        assert (list != null && !list.isEmpty());
        boolean bl = CommandProcessor.getInstance().isTransactionActive();
        if (!bl) {
            CommandProcessor.getInstance().beginTrans(string);
        }
        try {
            for (Property property : list) {
                this.setValueAt(property.getValue(), Integer.parseInt(property.getId()), 0);
            }
            if (abstractNode instanceof AbstractBuildNode) {
                ((AbstractBuildNode)abstractNode).validateAfterEdit();
            } else {
                abstractNode.validate(true);
            }
        }
        catch (Exception exception) {
            if (!bl) {
                CommandProcessor.getInstance().abortTrans();
            }
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        finally {
            if (!bl) {
                CommandProcessor.getInstance().endTrans();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(final Object object, final int n, final int n2) {
        boolean bl;
        final Context context = this.getContext();
        IlvManagerView ilvManagerView = ((DiagramView)context.getProperty("oracle.diagram.inspector.ActiveInspectedView")).getActiveManagerView();
        IlvSDMEngine ilvSDMEngine = IlvSDMEngine.getSDMEngine((IlvGrapher)((IlvGrapher)ilvManagerView.getManager()));
        IlvSDMModel ilvSDMModel = ilvSDMEngine.getModel();
        boolean bl2 = bl = !CommandProcessor.getInstance().isTransactionActive();
        if (bl) {
            CommandProcessor.getInstance().beginTrans("Edit " + this.getPropertyDisplayName(n));
        }
        try {
            SDMUndoUtil.captureModelUndo((Context)context, (IlvSDMModel)ilvSDMModel, (Runnable)new Runnable(){

                @Override
                public void run() {
                    WorkflowNodePropertyProxyModel.this.invokePropertySetCommand(context, object, n, n2);
                }
            });
            this.invalidateValueData();
        }
        finally {
            if (bl) {
                CommandProcessor.getInstance().endTrans();
            }
        }
    }

    public Context getSelectionContext() {
        return super.getContext();
    }

    public int getRowMapping(String string) {
        switch (string) {
            case "CACHE_SETTINGS": {
                return DataSourceNodePropertyModel.CACHE_SETTINGS.index;
            }
            case "NAME": {
                return AbstractNodePropertyModel.PROP_NAME.index;
            }
            case "COMMENT": {
                return AbstractNodePropertyModel.PROP_COMMENT.index;
            }
        }
        return -1;
    }
}

