/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.awt.Component;
import java.awt.Insets;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.dal.sql.ConnectionProperties;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.utils.UITools;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowTestNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.model.ExtensibleBuildNode;
import oracle.dmt.dataminer.workflow.model.TestNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationTestSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.ExtensibleBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TestNodeType;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTable;

public class TestLiftProfitDialogPanel
extends DialogDisplayer<AbstractNode> {
    private static final String[] COLUMNS = new String[]{PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_LIFT_PROFIT_SPECIFIC_TARGETS_COLUMN_NAME")};
    private AbstractNode node;
    private NodeType nodeType;
    private PropertyModel model;
    private List<String> targetValues;
    private AbstractDataNode dataProvider;
    private ButtonGroup buttonGroupAutoManual;
    private ButtonGroup buttonGroupHighLow;
    private DataMinerTable jAvailableAttrs;
    private JScrollPane jAvailableAttrsScrollPane;
    private JLabel jAvailableLabel;
    private JSpinner jFrequencySpinner;
    private JLabel jLabelTargetValueCount;
    private JRadioButton jRadioAuto;
    private JRadioButton jRadioHighest;
    private JRadioButton jRadioLowest;
    private JRadioButton jRadioManual;
    private JButton jRemoveAllBtn;
    private JButton jRemoveBtn;
    private JButton jSelectAllBtn;
    private JButton jSelectBtn;
    private JScrollPane jSelectedAttrsScrollPane;
    private JLabel jSelectedLabel;
    private DataMinerTable jSelectedlAttrs;

    public TestLiftProfitDialogPanel(Context context, PropertyModel propertyModel) {
        super(context, null);
        this.model = propertyModel;
        this.node = this.getTargetNode(propertyModel);
        if (this.node instanceof ClassificationBuildNode || this.node instanceof ExtensibleBuildNode) {
            WorkflowNode workflowNode = (WorkflowNode)context.getNode();
            WorkflowModel workflowModel = WorkflowUtils.getWorkflowModel(workflowNode);
            AbstractBuildNode abstractBuildNode = (AbstractBuildNode)this.node;
            this.dataProvider = abstractBuildNode.findBuildDataNode(workflowModel);
            this.nodeType = abstractBuildNode.getData();
        } else if (this.node instanceof TestNode) {
            TestNode testNode = (TestNode)this.node;
            this.dataProvider = testNode.findTestDataNode();
            this.nodeType = testNode.getData();
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.buttonGroupAutoManual = new ButtonGroup();
        this.buttonGroupHighLow = new ButtonGroup();
        this.jRadioAuto = new JRadioButton();
        this.jLabelTargetValueCount = new JLabel();
        this.jRadioLowest = new JRadioButton();
        this.jRadioHighest = new JRadioButton();
        this.jRadioManual = new JRadioButton();
        this.jAvailableAttrsScrollPane = new JScrollPane();
        this.jAvailableAttrs = new DataMinerTable();
        this.jSelectedAttrsScrollPane = new JScrollPane();
        this.jSelectedlAttrs = new DataMinerTable();
        this.jAvailableLabel = new JLabel();
        this.jSelectedLabel = new JLabel();
        this.jSelectBtn = new JButton();
        this.jSelectAllBtn = new JButton();
        this.jRemoveBtn = new JButton();
        this.jRemoveAllBtn = new JButton();
        this.jFrequencySpinner = new JSpinner();
        this.jRadioAuto.setText("Automatic - Select Target Values by Frequency");
        this.jRadioAuto.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioAuto.setMargin(new Insets(0, 0, 0, 0));
        this.jLabelTargetValueCount.setText("Frequency Count:");
        this.jRadioLowest.setText("Use Lowest Occuring");
        this.jRadioLowest.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioLowest.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioHighest.setText("Use Highest Occuring");
        this.jRadioHighest.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioHighest.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioManual.setText("Manual");
        this.jRadioManual.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioManual.setMargin(new Insets(0, 0, 0, 0));
        this.jAvailableAttrsScrollPane.setViewportView((Component)((Object)this.jAvailableAttrs));
        this.jSelectedAttrsScrollPane.setViewportView((Component)((Object)this.jSelectedlAttrs));
        this.jAvailableLabel.setText("Available Attributes");
        this.jSelectedLabel.setText("Selected Attributes");
        this.jSelectBtn.setText(">");
        this.jSelectAllBtn.setText(">>");
        this.jRemoveBtn.setText("<");
        this.jRemoveAllBtn.setText("<<");
        this.jFrequencySpinner.setModel(new SpinnerNumberModel(5, 1, 100, 1));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(14, 14, 14).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jRadioLowest, -1, -1, Short.MAX_VALUE).addComponent(this.jRadioHighest, -2, 149, -2))).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelTargetValueCount, -2, 159, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jFrequencySpinner, -2, 88, -2)))).addComponent(this.jRadioAuto, -2, 308, -2)).addGap(0, 0, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(17, 17, 17).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jAvailableLabel, -2, 102, -2).addComponent(this.jAvailableAttrsScrollPane, -1, 175, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRemoveAllBtn, -1, 53, Short.MAX_VALUE).addComponent(this.jRemoveBtn, -1, 53, Short.MAX_VALUE).addComponent(this.jSelectAllBtn, GroupLayout.Alignment.TRAILING, -1, 53, Short.MAX_VALUE).addComponent(this.jSelectBtn, GroupLayout.Alignment.TRAILING, -1, 53, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jSelectedLabel, -2, 121, -2).addGap(44, 44, 44)).addComponent(this.jSelectedAttrsScrollPane, GroupLayout.Alignment.LEADING, -1, 176, Short.MAX_VALUE))).addGroup(groupLayout.createSequentialGroup().addComponent(this.jRadioManual, -2, 194, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()))));
        groupLayout.linkSize(0, this.jRemoveAllBtn, this.jRemoveBtn, this.jSelectAllBtn, this.jSelectBtn);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.jRadioAuto).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelTargetValueCount).addComponent(this.jFrequencySpinner, -2, -1, -2)).addGap(7, 7, 7).addComponent(this.jRadioLowest).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioHighest).addGap(18, 18, 18).addComponent(this.jRadioManual).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(32, 32, 32).addComponent(this.jSelectBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSelectAllBtn).addGap(4, 4, 4).addComponent(this.jRemoveBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRemoveAllBtn).addGap(39, 39, 39)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jAvailableLabel).addComponent(this.jSelectedLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSelectedAttrsScrollPane, -2, 0, Short.MAX_VALUE).addComponent(this.jAvailableAttrsScrollPane, -2, 0, Short.MAX_VALUE))))));
    }

    @Override
    public void initRes() {
        ResourceUtils.resSpinner((JLabel)this.jLabelTargetValueCount, (JSpinner)this.jFrequencySpinner, (String)PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_TARGET_COUNT"));
        ResourceUtils.resLabel((JLabel)this.jAvailableLabel, (Component)((Object)this.jAvailableAttrs), (String)PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_AVAILABLE_TARGET_VALUES"));
        ResourceUtils.resLabel((JLabel)this.jSelectedLabel, (Component)((Object)this.jSelectedlAttrs), (String)PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_SELECTED_TARGET_VALUES"));
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_AUTO"), this.jRadioAuto);
        hashMap.put(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_CUSTOM"), this.jRadioManual);
        this.buttonGroupAutoManual.add(this.jRadioAuto);
        this.buttonGroupAutoManual.add(this.jRadioManual);
        hashMap.put(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_LOWEST"), this.jRadioLowest);
        hashMap.put(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_HIGHEST"), this.jRadioHighest);
        this.buttonGroupHighLow.add(this.jRadioLowest);
        this.buttonGroupHighLow.add(this.jRadioHighest);
        this.jSelectBtn.setText("");
        this.jSelectAllBtn.setText("");
        this.jRemoveBtn.setText("");
        this.jRemoveAllBtn.setText("");
        UIResourceHelper.setComponentText(hashMap);
        this.initIcons();
    }

    private void initIcons() {
        this.jSelectBtn.setIcon(OracleIcons.getIcon((String)"shuttle_right.png"));
        this.jSelectAllBtn.setIcon(OracleIcons.getIcon((String)"shuttle_rightall.png"));
        this.jRemoveBtn.setIcon(OracleIcons.getIcon((String)"shuttle_left.png"));
        this.jRemoveAllBtn.setIcon(OracleIcons.getIcon((String)"shuttle_leftall.png"));
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        Context context = null;
        if (propertyModel instanceof WorkflowNodePropertyProxyModel) {
            WorkflowNodePropertyProxyModel workflowNodePropertyProxyModel = (WorkflowNodePropertyProxyModel)propertyModel;
            context = workflowNodePropertyProxyModel.getSelectionContext();
        } else if (propertyModel instanceof WorkflowTestNodePropertyProxyModel) {
            WorkflowTestNodePropertyProxyModel workflowTestNodePropertyProxyModel = (WorkflowTestNodePropertyProxyModel)propertyModel;
            context = workflowTestNodePropertyProxyModel.getSelectionContext();
        }
        return context;
    }

    private ClassificationTestSettingsType getTestSettingsType() {
        ClassificationTestSettingsType classificationTestSettingsType = null;
        Context context = this.getContext(this.model);
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof ClassificationBuildNodeType) {
            ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)nodeType;
            classificationTestSettingsType = classificationBuildNodeType.getTestSettings();
        } else if (nodeType instanceof ExtensibleBuildNodeType) {
            ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)nodeType;
            classificationTestSettingsType = extensibleBuildNodeType.getTestSettings();
        } else if (nodeType instanceof TestNodeType) {
            TestNodeType testNodeType = (TestNodeType)nodeType;
            classificationTestSettingsType = testNodeType.getTestSettings();
        }
        return classificationTestSettingsType;
    }

    @Override
    public void initUI() {
        this.jFrequencySpinner.setModel(new SpinnerNumberModel(5, 1, 100, 1));
        ClassificationTestSettingsType classificationTestSettingsType = this.getTestSettingsType();
        TableAttributesModel tableAttributesModel = new TableAttributesModel();
        TableAttributesModel tableAttributesModel2 = new TableAttributesModel();
        this.jSelectedlAttrs.setModel((TableModel)((Object)tableAttributesModel2));
        this.jAvailableAttrs.setModel((TableModel)((Object)tableAttributesModel));
        if (null != classificationTestSettingsType.getBottomNTargets()) {
            this.jRadioAuto.setSelected(true);
            this.jRadioLowest.setSelected(true);
            this.enableAuto(true);
            this.jFrequencySpinner.setValue(classificationTestSettingsType.getBottomNTargets().getValue().intValue());
        } else if (null != classificationTestSettingsType.getTopNTargets()) {
            this.jRadioAuto.setSelected(true);
            this.jRadioHighest.setSelected(true);
            this.enableAuto(true);
            this.jFrequencySpinner.setValue(classificationTestSettingsType.getTopNTargets().getValue().intValue());
        } else if (this.dataProvider != null && null != classificationTestSettingsType.getSpecificTargets()) {
            this.loadTargetValues();
            this.jRadioManual.setSelected(true);
            this.enableAuto(false);
            ClassificationTestSettingsType.SpecificTargets specificTargets = classificationTestSettingsType.getSpecificTargets();
            tableAttributesModel2.addRows(specificTargets.getTargetValue().stream().map(targetValue -> targetValue.getValue()).sorted().collect(Collectors.toList()));
            this.jSelectedlAttrs.setSorted(true);
        }
        this.jAvailableAttrs.setFillsViewportHeight(true);
        this.jSelectedlAttrs.setFillsViewportHeight(true);
        this.jRadioAuto.addActionListener(actionEvent -> this.enableAuto(true));
        if (this.dataProvider == null) {
            this.jRadioManual.setEnabled(false);
            this.jSelectBtn.setEnabled(false);
            this.jSelectAllBtn.setEnabled(false);
            this.jRemoveBtn.setEnabled(false);
            this.jRemoveAllBtn.setEnabled(false);
            this.jSelectedlAttrs.setEnabled(false);
            this.jAvailableAttrs.setEnabled(false);
        }
        this.jRadioManual.addActionListener(actionEvent -> {
            if (this.targetValues == null) {
                this.loadTargetValues();
            }
            this.enableAuto(false);
        });
        this.jSelectBtn.addActionListener(actionEvent -> this.moveItems(this.jAvailableAttrs, this.jSelectedlAttrs, false));
        this.jSelectAllBtn.addActionListener(actionEvent -> this.moveItems(this.jAvailableAttrs, this.jSelectedlAttrs, true));
        this.jRemoveBtn.addActionListener(actionEvent -> this.moveItems(this.jSelectedlAttrs, this.jAvailableAttrs, false));
        this.jRemoveAllBtn.addActionListener(actionEvent -> this.moveItems(this.jSelectedlAttrs, this.jAvailableAttrs, true));
    }

    private void loadTargetValues() {
        LoadTargets loadTargets = new LoadTargets();
        loadTargets.execute();
    }

    private void moveItems(GenericTable genericTable, GenericTable genericTable2, boolean bl) {
        int n;
        int n2;
        int[] nArray = genericTable.getSelectedRowsInModel();
        List list = ((TableAttributesModel)((Object)genericTable.getModel())).getSrcData();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!bl) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                String object2 = (String)list.get(nArray[n2]);
                arrayList.add(object2);
            }
        } else {
            for (n2 = 0; n2 < list.size(); ++n2) {
                arrayList.add((String)list.get(n2));
            }
        }
        for (String string : arrayList) {
            n = list.indexOf(string);
            if (n == -1) continue;
            list.remove(n);
        }
        List list2 = ((TableAttributesModel)((Object)genericTable2.getModel())).getSrcData();
        list2.addAll(arrayList);
        ((TableAttributesModel)((Object)genericTable2.getModel())).setRowCount(list2.size());
        ((TableAttributesModel)((Object)genericTable.getModel())).setRowCount(list.size());
        ((AbstractTableModel)genericTable.getModel()).fireTableDataChanged();
        ((AbstractTableModel)genericTable2.getModel()).fireTableDataChanged();
        int[] nArray2 = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            int n3 = list2.indexOf(arrayList.get(n));
            assert (n3 != -1) : "Unexpected state - added item should be present and must have an index";
            nArray2[n] = n3;
        }
        genericTable2.setSelectedRowsInModel(nArray2);
    }

    public ClassificationTestSettingsType collectData() {
        ClassificationTestSettingsType classificationTestSettingsType = this.getTestSettingsType();
        ClassificationTestSettingsType classificationTestSettingsType2 = new ClassificationTestSettingsType();
        if (this.jRadioAuto.isSelected()) {
            if (this.jRadioLowest.isSelected()) {
                ClassificationTestSettingsType.BottomNTargets bottomNTargets = new ClassificationTestSettingsType.BottomNTargets();
                Integer n = (Integer)this.jFrequencySpinner.getValue();
                bottomNTargets.setValue(new BigInteger(String.valueOf(n)));
                classificationTestSettingsType2.setBottomNTargets(bottomNTargets);
            } else {
                ClassificationTestSettingsType.TopNTargets topNTargets = new ClassificationTestSettingsType.TopNTargets();
                Integer n = (Integer)this.jFrequencySpinner.getValue();
                topNTargets.setValue(new BigInteger(String.valueOf(n)));
                classificationTestSettingsType2.setTopNTargets(topNTargets);
            }
        } else {
            List list = ((TableAttributesModel)((Object)this.jSelectedlAttrs.getModel())).getSrcData();
            ClassificationTestSettingsType.SpecificTargets specificTargets = new ClassificationTestSettingsType.SpecificTargets();
            List list2 = specificTargets.getTargetValue();
            for (String string : list) {
                ClassificationTestSettingsType.SpecificTargets.TargetValue targetValue = new ClassificationTestSettingsType.SpecificTargets.TargetValue();
                targetValue.setValue(string);
                list2.add(targetValue);
            }
            classificationTestSettingsType2.setSpecificTargets(specificTargets);
        }
        if (TestLiftProfitDialogPanel.areEqual(classificationTestSettingsType, classificationTestSettingsType2)) {
            return null;
        }
        return classificationTestSettingsType2;
    }

    private static boolean areEqual(ClassificationTestSettingsType classificationTestSettingsType, ClassificationTestSettingsType classificationTestSettingsType2) {
        if (classificationTestSettingsType == null && classificationTestSettingsType2 == null) {
            return true;
        }
        if (classificationTestSettingsType == null || classificationTestSettingsType2 == null) {
            return false;
        }
        if (null != classificationTestSettingsType.getBottomNTargets() && null != classificationTestSettingsType2.getBottomNTargets() && (null != classificationTestSettingsType.getBottomNTargets().getValue() && null != classificationTestSettingsType2.getBottomNTargets().getValue() ? classificationTestSettingsType.getBottomNTargets().getValue().equals(classificationTestSettingsType2.getBottomNTargets().getValue()) : null == classificationTestSettingsType.getBottomNTargets().getValue() && null == classificationTestSettingsType2.getBottomNTargets().getValue())) {
            return true;
        }
        if (null != classificationTestSettingsType.getTopNTargets() && null != classificationTestSettingsType2.getTopNTargets() && (null != classificationTestSettingsType.getTopNTargets().getValue() && null != classificationTestSettingsType2.getTopNTargets().getValue() ? classificationTestSettingsType.getTopNTargets().getValue().equals(classificationTestSettingsType2.getTopNTargets().getValue()) : null == classificationTestSettingsType.getTopNTargets().getValue() && null == classificationTestSettingsType2.getTopNTargets().getValue())) {
            return true;
        }
        if (null != classificationTestSettingsType.getSpecificTargets() && null != classificationTestSettingsType2.getSpecificTargets()) {
            List list = classificationTestSettingsType.getSpecificTargets().getTargetValue();
            List list2 = classificationTestSettingsType2.getSpecificTargets().getTargetValue();
            if (null != list && null != list2) {
                if (list.size() != list2.size()) {
                    return false;
                }
                boolean bl = true;
                for (int i = 0; i < list.size(); ++i) {
                    ClassificationTestSettingsType.SpecificTargets.TargetValue targetValue = (ClassificationTestSettingsType.SpecificTargets.TargetValue)list.get(i);
                    ClassificationTestSettingsType.SpecificTargets.TargetValue targetValue2 = (ClassificationTestSettingsType.SpecificTargets.TargetValue)list2.get(i);
                    if (null == targetValue || null == targetValue2 || null == targetValue.getValue() || null == targetValue2.getValue() || targetValue.getValue().equals(targetValue2.getValue())) continue;
                    bl = false;
                    break;
                }
                return bl;
            }
            if (null == list && null == list2) {
                return true;
            }
        }
        return false;
    }

    private void enableAuto(boolean bl) {
        this.jAvailableAttrs.setEnabled(!bl);
        ((AbstractTableModel)this.jAvailableAttrs.getModel()).fireTableDataChanged();
        ((AbstractTableModel)this.jSelectedlAttrs.getModel()).fireTableDataChanged();
        boolean bl2 = this.jAvailableAttrs.getModel().getRowCount() > 0;
        this.jSelectBtn.setEnabled(!bl && bl2);
        this.jSelectAllBtn.setEnabled(!bl && bl2);
        this.jRemoveBtn.setEnabled(!bl && bl2);
        this.jRemoveAllBtn.setEnabled(!bl && bl2);
        this.jSelectedlAttrs.setEnabled(!bl);
        this.jSelectedlAttrs.updateUI();
        this.jRadioLowest.setEnabled(bl);
        this.jRadioHighest.setEnabled(bl);
        this.jFrequencySpinner.setEnabled(bl);
    }

    @Override
    public boolean doWork() {
        List list;
        if (this.jRadioManual.isSelected() && (list = ((TableAttributesModel)((Object)this.jSelectedlAttrs.getModel())).getSrcData()).isEmpty()) {
            MessageDialog.error((Component)UITools.getParentWindow(this), (Object)PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_LIFT_PROFIT_DLG_TITLE_MSG"), (String)PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_LIFT_PROFIT_DLG_TITLE"), null);
            return false;
        }
        return true;
    }

    public AbstractNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        Context context = this.getContext(propertyModel);
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof ClassificationBuildNodeType || nodeType instanceof ExtensibleBuildNodeType || nodeType instanceof TestNodeType) {
            return (AbstractNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    @Override
    protected String getDialogTitle() {
        return PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_LIFT_PROFITSETTINGS_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "class_test_lift_profit_edit";
    }

    private class TableAttributesModel
    extends ODMrTableModel<String> {
        private static final int VALUE = 0;

        private TableAttributesModel() {
            super(COLUMNS);
        }

        private TableAttributesModel(List<String> list) {
            super(COLUMNS, list);
        }

        private TableAttributesModel(ClassificationTestSettingsType.SpecificTargets specificTargets) {
            super(COLUMNS);
            List list = specificTargets.getTargetValue();
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (ClassificationTestSettingsType.SpecificTargets.TargetValue targetValue : list) {
                arrayList.add(targetValue.getValue());
            }
            this.addRows(arrayList);
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            Object var3_3 = null;
            switch (n2) {
                case 0: {
                    var3_3 = this.srcData.get(n);
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return var3_3;
        }
    }

    private class LoadTargets
    extends ODMrSwingWorker<Void, Void> {
        private LoadTargets() {
            super(TestLiftProfitDialogPanel.this, null, TestLiftProfitDialogPanel.this.jAvailableAttrs);
        }

        private void loadTargetValuesExcludingExisting() {
            ArrayList<String> arrayList;
            ClassificationTestSettingsType classificationTestSettingsType = TestLiftProfitDialogPanel.this.getTestSettingsType();
            ClassificationTestSettingsType.SpecificTargets specificTargets = classificationTestSettingsType.getSpecificTargets();
            HashMap<String, ClassificationTestSettingsType.SpecificTargets.TargetValue> hashMap = new HashMap<String, ClassificationTestSettingsType.SpecificTargets.TargetValue>();
            if (specificTargets != null) {
                arrayList = specificTargets.getTargetValue();
                for (ClassificationTestSettingsType.SpecificTargets.TargetValue object : arrayList) {
                    hashMap.put(object.getValue(), object);
                }
            }
            arrayList = new ArrayList<String>();
            if (hashMap.isEmpty()) {
                arrayList.addAll(TestLiftProfitDialogPanel.this.targetValues);
            } else {
                for (String string : TestLiftProfitDialogPanel.this.targetValues) {
                    if (null != hashMap.get(string)) continue;
                    arrayList.add(string);
                }
            }
            Collections.sort(arrayList);
            Object object = new TableAttributesModel(arrayList);
            TestLiftProfitDialogPanel.this.jAvailableAttrs.setModel((TableModel)object);
            TestLiftProfitDialogPanel.this.jAvailableAttrs.setSorted(true);
        }

        private String getStackedSQL() {
            StringBuilder stringBuilder = new StringBuilder("(");
            stringBuilder.append(TestLiftProfitDialogPanel.this.dataProvider.getInputSQL());
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<String> getDistinctTargetValues() {
            AttributeType attributeType;
            String string = this.getStackedSQL();
            AttributeType attributeType2 = attributeType = TestLiftProfitDialogPanel.this.nodeType instanceof SuperviseBuildNodeType ? ((SuperviseBuildNodeType)TestLiftProfitDialogPanel.this.nodeType).getTargetAttribute() : ((ExtensibleBuildNodeType)TestLiftProfitDialogPanel.this.nodeType).getTargetAttribute();
            if (attributeType == null) {
                return new LinkedList<String>();
            }
            String string2 = attributeType.getName();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select distinct \"");
            stringBuilder.append(string2);
            stringBuilder.append("\" from ");
            stringBuilder.append(string);
            stringBuilder.append(" where \"");
            stringBuilder.append(string2);
            stringBuilder.append("\" is not null");
            ArrayList<String> arrayList = new ArrayList<String>();
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append((CharSequence)stringBuilder);
            try (SQLHelper sQLHelper = new SQLHelper();){
                sQLHelper.conn = ConnectionFolder.getConnection(TestLiftProfitDialogPanel.this.getContext(TestLiftProfitDialogPanel.this.model), ConnectionProperties.ALTER_SESSION_FIXES);
                sQLHelper.stmt = sQLHelper.conn.createStatement();
                sQLHelper.rs = sQLHelper.stmt.executeQuery(stringBuilder2.toString());
                while (sQLHelper.rs.next()) {
                    String string3 = sQLHelper.rs.getString(1);
                    arrayList.add(string3);
                }
            }
            return arrayList;
        }

        @Override
        protected Void doInBackground() throws Exception {
            TestLiftProfitDialogPanel.this.targetValues = this.getDistinctTargetValues();
            if (TestLiftProfitDialogPanel.this.targetValues.isEmpty()) {
                throw new RuntimeException(PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_ERROR_TITLE_MESG"));
            }
            return null;
        }

        @Override
        protected void onSuccess(Void void_) {
            this.loadTargetValuesExcludingExisting();
        }

        @Override
        protected void onFinally() {
            TestLiftProfitDialogPanel.this.enableAuto(false);
        }
    }
}

