/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.exception.DataMinerException;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.inspect.CachePIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.applyText.WorkflowApplyTextNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.buildText.WorkflowBuildTextNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.graph.WorkflowGraphNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.profile.WorkflowDataProfileNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.transformations.WorkflowTransformNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ApplyTextNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNode;
import oracle.dmt.dataminer.workflow.model.DataProfileNode;
import oracle.dmt.dataminer.workflow.model.GraphNode;
import oracle.dmt.dataminer.workflow.model.SampleSettingsProperties;
import oracle.dmt.dataminer.workflow.model.TransformationNode;
import oracle.dmt.dataminer.workflow.preferences.CacheSettingsPanelSettings;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.GraphNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ResultType;
import oracle.dmt.dataminer.workflow.xmlschema.SampleSettings;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public class SamplePIComponentPanel
extends CachePIComponentPanel {
    private CacheSettingsPanelSettings _samplePreffrences = CacheSettingsPanelSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    private SampleSettings _sampleSettings;
    private static final Logger theLogger = Logger.getLogger(WorkflowNode.class.getName());

    private SampleSettings getSampleSettings(AbstractNode abstractNode) {
        SampleSettings sampleSettings = null;
        if (abstractNode instanceof DataProfileNode) {
            DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)abstractNode.getData();
            sampleSettings = dataProfileNodeType.getSampleSettings();
        } else if (abstractNode instanceof TransformationNode) {
            TransformationNodeType transformationNodeType = (TransformationNodeType)abstractNode.getData();
            sampleSettings = transformationNodeType.getSampleSettings();
        } else if (abstractNode instanceof BuildTextNode) {
            BuildTextNodeType buildTextNodeType = (BuildTextNodeType)abstractNode.getData();
            sampleSettings = buildTextNodeType.getSampleSettings();
        } else if (abstractNode instanceof ApplyTextNode) {
            ApplyTextNodeType applyTextNodeType = (ApplyTextNodeType)abstractNode.getData();
            sampleSettings = applyTextNodeType.getSampleSettings();
        } else if (abstractNode instanceof GraphNode) {
            GraphNodeType graphNodeType = (GraphNodeType)abstractNode.getData();
            sampleSettings = graphNodeType.getSampleSettings();
        }
        return sampleSettings;
    }

    @Override
    public void setSettings(AbstractNode abstractNode) {
        this._sampleSettings = this.getSampleSettings(abstractNode);
    }

    @Override
    public Object getRandom() {
        if (this._sampleSettings == null) {
            return null;
        }
        return this._sampleSettings.getMethod().getRandom();
    }

    @Override
    public Object getStratified() {
        if (this._sampleSettings == null) {
            return null;
        }
        return this._sampleSettings.getMethod().getStratified();
    }

    @Override
    public Long getNumberOfRows() {
        if (this._sampleSettings == null) {
            return null;
        }
        return this._sampleSettings.getNumberOfRows();
    }

    @Override
    public Double getPercentOfTotal() {
        if (this._sampleSettings == null) {
            return null;
        }
        return this._sampleSettings.getPercentOfTotal();
    }

    @Override
    public void setNumberRows(Integer n) {
        if (n == null) {
            return;
        }
        this.setNumberOfRows(n);
    }

    @Override
    public void setPercentOfTotal(Double d) {
        if (d == null) {
            return;
        }
        this.setPercent(d);
    }

    @Override
    public boolean isUseFullData() {
        if (this._sampleSettings == null) {
            return false;
        }
        return this._sampleSettings.isUseFullData();
    }

    public SamplePIComponentPanel(PropertyModel propertyModel) {
        super(propertyModel);
    }

    @Override
    protected void setCheckBoxText() {
        this.jCheckBoxAllData.setText(PropertyLrb.get("PI_ATTRIBUTES_SAMPLE_GROUP_USE_ALL_DATA"));
    }

    @Override
    protected Object copySettings() {
        Object object;
        BigInteger bigInteger;
        SampleSettings sampleSettings = new SampleSettings();
        Long l = this.getNumberOfRows();
        Double d = this.getPercentOfTotal();
        if (null == l && null == d) {
            l = 2000L;
        }
        sampleSettings.setNumberOfRows(l);
        sampleSettings.setPercentOfTotal(d);
        SampleSettings.Method method = this._sampleSettings != null ? this._sampleSettings.getMethod() : null;
        SampleSettings.Method method2 = new SampleSettings.Method();
        if (null == method || null != method.getRandom()) {
            bigInteger = null;
            bigInteger = method == null ? new BigInteger("1234") : method.getRandom().getSeed();
            object = new SampleSettings.Method.Random();
            object.setSeed(bigInteger);
            method2.setRandom((SampleSettings.Method.Random)object);
        } else if (null != method.getStratified()) {
            bigInteger = new SampleSettings.Method.Stratified();
            bigInteger.setTargetAttr(method.getStratified().getTargetAttr());
            method2.setStratified((SampleSettings.Method.Stratified)bigInteger);
        } else if (null != method.getTopN()) {
            bigInteger = new SampleSettings.Method.TopN();
            method2.setTopN((SampleSettings.Method.TopN)bigInteger);
        }
        sampleSettings.setMethod(method2);
        sampleSettings.setUseFullData(this.isUseFullData());
        sampleSettings.setGenerateCache(Boolean.valueOf(true));
        Object object2 = bigInteger = this._sampleSettings != null ? this._sampleSettings.getOutputTable() : null;
        if (bigInteger == null) {
            bigInteger = new ResultType();
            object = new GregorianCalendar();
            XMLGregorianCalendar xMLGregorianCalendar = null;
            ((Calendar)object).setTime(Calendar.getInstance().getTime());
            try {
                xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar((GregorianCalendar)object);
                bigInteger.setCreationDate(xMLGregorianCalendar);
                bigInteger.setName("");
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new DataMinerException("Failed to init XMLGregorianCalendar", datatypeConfigurationException);
            }
        }
        sampleSettings.setOutputTable((ResultType)bigInteger);
        return sampleSettings;
    }

    @Override
    protected void updateSettings(Object object, String string) {
        ComplexProperty complexProperty = new ComplexProperty(string, object);
        complexProperty.setOldData(this._sampleSettings);
        if (this._model instanceof WorkflowDataProfileNodePropertyProxyModel) {
            WorkflowDataProfileNodePropertyProxyModel workflowDataProfileNodePropertyProxyModel = (WorkflowDataProfileNodePropertyProxyModel)this._model;
            workflowDataProfileNodePropertyProxyModel.setValueAt(string, (AbstractDataNode)this.getTargetNode((PropertyModel)this._model), complexProperty, workflowDataProfileNodePropertyProxyModel.getRowMapping("SAMPLE_SETTINGS"));
        } else if (this._model instanceof WorkflowTransformNodePropertyProxyModel) {
            WorkflowTransformNodePropertyProxyModel workflowTransformNodePropertyProxyModel = (WorkflowTransformNodePropertyProxyModel)this._model;
            workflowTransformNodePropertyProxyModel.setValueAt(string, (AbstractDataNode)this.getTargetNode((PropertyModel)this._model), complexProperty, workflowTransformNodePropertyProxyModel.getRowMapping("SAMPLE_SETTINGS"));
        } else if (this._model instanceof WorkflowBuildTextNodePropertyProxyModel) {
            WorkflowBuildTextNodePropertyProxyModel workflowBuildTextNodePropertyProxyModel = (WorkflowBuildTextNodePropertyProxyModel)this._model;
            workflowBuildTextNodePropertyProxyModel.setValueAt(string, (AbstractDataNode)this.getTargetNode((PropertyModel)this._model), complexProperty, workflowBuildTextNodePropertyProxyModel.getRowMapping("SAMPLE_SETTINGS"));
        } else if (this._model instanceof WorkflowApplyTextNodePropertyProxyModel) {
            WorkflowApplyTextNodePropertyProxyModel workflowApplyTextNodePropertyProxyModel = (WorkflowApplyTextNodePropertyProxyModel)this._model;
            workflowApplyTextNodePropertyProxyModel.setValueAt(string, (AbstractDataNode)this.getTargetNode((PropertyModel)this._model), complexProperty, workflowApplyTextNodePropertyProxyModel.getRowMapping("SAMPLE_SETTINGS"));
        } else if (this._model instanceof WorkflowGraphNodePropertyProxyModel) {
            WorkflowGraphNodePropertyProxyModel workflowGraphNodePropertyProxyModel = (WorkflowGraphNodePropertyProxyModel)this._model;
            workflowGraphNodePropertyProxyModel.setValueAt(string, (AbstractNode)this.getTargetNode((PropertyModel)this._model), complexProperty, workflowGraphNodePropertyProxyModel.getRowMapping("SAMPLE_SETTINGS"));
        }
    }

    @Override
    protected void setStratifiedSettings(String string) {
        SampleSettings sampleSettings = (SampleSettings)this.copySettings();
        SampleSettings.Method.Stratified stratified = new SampleSettings.Method.Stratified();
        stratified.setTargetAttr(string);
        sampleSettings.getMethod().setRandom(null);
        sampleSettings.getMethod().setStratified(stratified);
        sampleSettings.getMethod().setTopN(null);
        this.updateSettings(sampleSettings, SampleSettingsProperties.SAMPLE_SETTINGS_STRATIFIED);
    }

    @Override
    protected void setRandomSettings() {
        SampleSettings sampleSettings = (SampleSettings)this.copySettings();
        SampleSettings.Method.Random random = new SampleSettings.Method.Random();
        random.setSeed(BigInteger.valueOf(this._samplePreffrences.getSeed()));
        sampleSettings.getMethod().setRandom(random);
        sampleSettings.getMethod().setStratified(null);
        sampleSettings.getMethod().setTopN(null);
        this.updateSettings(sampleSettings, SampleSettingsProperties.SAMPLE_SETTINGS_RANDOM);
    }

    @Override
    protected void setTopNSettings() {
        SampleSettings sampleSettings = (SampleSettings)this.copySettings();
        SampleSettings.Method.TopN topN = new SampleSettings.Method.TopN();
        sampleSettings.getMethod().setRandom(null);
        sampleSettings.getMethod().setStratified(null);
        sampleSettings.getMethod().setTopN(topN);
        this.updateSettings(sampleSettings, SampleSettingsProperties.SAMPLE_SETTINGS_TOPN);
    }

    @Override
    protected void setTargetAttribute(String string) {
        SampleSettings sampleSettings = (SampleSettings)this.copySettings();
        sampleSettings.getMethod().getStratified().setTargetAttr(string);
        this.updateSettings(sampleSettings, SampleSettingsProperties.SAMPLE_SETTINGS_TARGET);
    }

    @Override
    protected void setUseFullData(boolean bl) {
        SampleSettings sampleSettings = (SampleSettings)this.copySettings();
        sampleSettings.setUseFullData(bl);
        this.updateSettings(sampleSettings, SampleSettingsProperties.SAMPLE_SETTINGS_PERCENT);
    }

    @Override
    protected void setPercent(double d) {
        SampleSettings sampleSettings = (SampleSettings)this.copySettings();
        sampleSettings.setPercentOfTotal(Double.valueOf(d));
        sampleSettings.setNumberOfRows(null);
        this.updateSettings(sampleSettings, SampleSettingsProperties.SAMPLE_SETTINGS_PERCENT);
    }

    @Override
    public void initUI(PropertyModel propertyModel) {
        super.initUI(propertyModel);
        if (this._sampleSettings == null) {
            final SampleSettings sampleSettings = (SampleSettings)this.copySettings();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SamplePIComponentPanel.this.updateSettings(sampleSettings, SampleSettingsProperties.SAMPLE_SETTINGS_PERCENT);
                }
            });
        }
    }

    @Override
    protected void setNumberOfRows(Integer n) {
        SampleSettings sampleSettings = (SampleSettings)this.copySettings();
        sampleSettings.setNumberOfRows(Long.valueOf(n.longValue()));
        sampleSettings.setPercentOfTotal(null);
        this.updateSettings(sampleSettings, SampleSettingsProperties.SAMPLE_SETTINGS_NUMBER_OF_ROWS);
    }

    @Override
    protected void setSeed(Integer n) {
        SampleSettings sampleSettings = (SampleSettings)this.copySettings();
        sampleSettings.getMethod().getRandom().setSeed(BigInteger.valueOf(n.intValue()));
        this.updateSettings(sampleSettings, SampleSettingsProperties.SAMPLE_SETTINGS_SEED);
    }

    @Override
    protected void selectAllData(boolean bl) {
        this.jCmbSize.setEnabled(!bl);
        this.jLblSize.setEnabled(!bl);
        this.jPanelSamplingSizeRows.setEnabled(!bl);
        this.jPanelSamplingSizePercent.setEnabled(!bl);
    }

    @Override
    protected void updateUIElements(boolean bl) {
        boolean bl2 = this.isWritable();
        this.jCheckBoxAllData.setEnabled(bl2);
        this.jCmbSize.setEnabled(bl2 && !bl);
        this.jPanelSamplingSizeRows.setEnabled(bl2 && !bl);
        this.getSamplingSizePanel().setEnabled(bl2 && !bl);
        this.jPanelSamplingSizePercent.setEnabled(bl2 && !bl);
    }
}

