/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.inspect.AbstractNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.NodeProperty;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyGroupImpl;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationResultType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.dmt.dataminer.workflow.xmlschema.RSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseBuildNodeType;
import oracle.ide.Context;
import oracle.javatools.util.Pair;

public class ModelPartitionedBuildNodePropertyModel
extends AbstractNodePropertyModel {
    protected static List<NodeProperty> properties = new ArrayList<NodeProperty>();
    public static final NodeProperty TARGET;
    public static final NodeProperty MODEL_ADDED_REMOVED;
    public static final NodeProperty TUNING;
    public static final NodeProperty ALGORITHM_SETTINGS;
    public static final NodeProperty SPLIT_VALUE;
    public static final NodeProperty SPLIT_DATA_FORMAT;
    public static final NodeProperty GEN_ACCURACY_METRICS;
    public static final NodeProperty GEN_CONFUSION_MATRIX;
    public static final NodeProperty GEN_ROC_CURVE;
    public static final NodeProperty GEN_LIFT_AND_PROFIT;
    public static final NodeProperty GEN_FOR_TUNING;
    public static final NodeProperty CASE_IDS;
    public static final NodeProperty TEST_OPTIONS_CHANGED;
    public static final NodeProperty TEST_SETTINGS_CHANGED;
    public static final NodeProperty MODELS_RERUN;
    public static final NodeProperty TESTS_RERUN;
    public static final NodeProperty TESTS_ADDED_REMOVED;
    public static final NodeProperty TESTS_FOR_TUNING_ADDED_REMOVED;
    public static final NodeProperty COST_BENEFIT;
    public static final NodeProperty MODEL_ANNOTATION;
    public static final NodeProperty MODEL_NAME;
    public static final NodeProperty MODEL_USEFOROUTPUT;
    public static final NodeProperty MINING_ATTRIBUTE_SETTINGS;
    public static final NodeProperty PARTITIONS_MAX_NUM;
    public static final NodeProperty PARTITIONS_EXPRESSION_EDIT;
    public static final NodeProperty ODMS_PARTITION_BUILD_TYPE;

    public ModelPartitionedBuildNodePropertyModel(Context context) {
        super(context);
    }

    @Override
    public String getHelpTopic() {
        return "classification_build_node_pi";
    }

    @Override
    protected List<NodeProperty> getNodeProperties() {
        return properties;
    }

    public static void updateTargetModelAttributes(SuperviseBuildNodeType superviseBuildNodeType, List<Property> list, int n, AttributeType attributeType) {
        MiningAttributeType miningAttributeType;
        AttributeType attributeType2 = superviseBuildNodeType.getTargetAttribute();
        MiningAttributeType miningAttributeType2 = miningAttributeType = attributeType2 != null ? MetaDataHelper.createMiningAttributeFrom(attributeType2) : null;
        if (miningAttributeType != null) {
            miningAttributeType.setInput("Yes");
            miningAttributeType.setAutoPrep("Yes");
        }
        List<ModelType> list2 = MetaDataHelper.getModelsCollection((BuildNodeType)superviseBuildNodeType);
        HashMap<String, MiningAttributeType> hashMap = new HashMap<String, MiningAttributeType>();
        HashMap<String, ComplexProperty> hashMap2 = new HashMap<String, ComplexProperty>();
        for (ModelType modelType : list2) {
            Object object;
            ComplexProperty complexProperty;
            MiningAttributeType miningAttributeType3;
            if (miningAttributeType != null) {
                miningAttributeType3 = new Pair((Object)miningAttributeType.getName(), (Object)miningAttributeType);
                hashMap.put(modelType.getId(), miningAttributeType3);
                complexProperty = new ComplexProperty("miningAttributeSettings", hashMap);
                object = new Property(String.valueOf(n), null, complexProperty, null, null);
                list.add((Property)object);
            }
            miningAttributeType3 = MetaDataHelper.createMiningAttributeFrom(attributeType);
            if (superviseBuildNodeType instanceof RegressionBuildNodeType && modelType instanceof RSupportVectorMachineModelType || superviseBuildNodeType instanceof ClassificationBuildNodeType) {
                miningAttributeType3.setAutoPrep("Yes");
            } else {
                miningAttributeType3.setAutoPrep("No");
            }
            miningAttributeType3.setInput("Yes");
            complexProperty = new Pair((Object)miningAttributeType3.getName(), (Object)miningAttributeType3);
            hashMap2.put(modelType.getId(), complexProperty);
            object = new ComplexProperty("miningAttributeSettings", hashMap2);
            Property property = new Property(String.valueOf(n), null, object, null, null);
            list.add(property);
        }
    }

    public static void updateCaseIdModelAttributes(BuildNodeType buildNodeType, List<Property> list, int n, CaseAttributes caseAttributes) {
        MiningAttributeType miningAttributeType;
        AttributeType attributeType = MetaDataHelper.getCaseId(buildNodeType);
        MiningAttributeType miningAttributeType2 = miningAttributeType = attributeType != null ? MetaDataHelper.createMiningAttributeFrom(attributeType) : null;
        if (miningAttributeType != null) {
            miningAttributeType.setInput("Yes");
            miningAttributeType.setAutoPrep("Yes");
        }
        List<ModelType> list2 = MetaDataHelper.getModelsCollection(buildNodeType);
        HashMap<String, Pair> hashMap = new HashMap<String, Pair>();
        HashMap<String, Pair> hashMap2 = new HashMap<String, Pair>();
        for (ModelType modelType : list2) {
            Object object;
            Object object2;
            Pair pair;
            if (miningAttributeType != null) {
                pair = new Pair((Object)miningAttributeType.getName(), (Object)miningAttributeType);
                hashMap.put(modelType.getId(), pair);
                object2 = new ComplexProperty("miningAttributeSettings", hashMap);
                object = new Property(String.valueOf(n), null, object2, null, null);
                list.add((Property)object);
            }
            if (caseAttributes.getAttribute().size() <= 0) continue;
            pair = (AttributeType)caseAttributes.getAttribute().get(0);
            object2 = MetaDataHelper.createMiningAttributeFrom((AttributeType)pair);
            object2.setAutoPrep("No");
            object2.setInput("No");
            object = new Pair((Object)object2.getName(), object2);
            hashMap2.put(modelType.getId(), (Pair)object);
            ComplexProperty complexProperty = new ComplexProperty("miningAttributeSettings", hashMap2);
            Property property = new Property(String.valueOf(n), null, complexProperty, null, null);
            list.add(property);
        }
    }

    private static void prepareStatusReady(List<Property> list, AbstractBuildNode abstractBuildNode) {
        List<ModelType> list2 = MetaDataHelper.getModelsCollection((BuildNodeType)abstractBuildNode.getData());
        HashMap<String, ModelStatusType> hashMap = new HashMap<String, ModelStatusType>();
        for (ModelType object2 : list2) {
            hashMap.put(object2.getId(), ModelStatusType.READY);
        }
        if (!hashMap.isEmpty()) {
            list.add(new Property(String.valueOf(ModelPartitionedBuildNodePropertyModel.MODELS_RERUN.index), null, new ComplexProperty("modelsRerun", hashMap), null, null));
        }
        List<ClassificationResultType> list3 = MetaDataHelper.getClassificationResultsCollection(abstractBuildNode);
        HashMap<String, ModelStatusType> hashMap2 = new HashMap<String, ModelStatusType>();
        Iterator iterator = list3.iterator();
        while (iterator.hasNext()) {
            ClassificationResultType classificationResultType = (ClassificationResultType)iterator.next();
            if (null == hashMap.get(classificationResultType.getModelId())) continue;
            hashMap2.put(classificationResultType.getModelId(), ModelStatusType.READY);
        }
        if (!hashMap2.isEmpty()) {
            list.add(new Property(String.valueOf(ModelPartitionedBuildNodePropertyModel.TESTS_RERUN.index), null, new ComplexProperty("testsRerun", hashMap2), null, null));
        }
    }

    public static void updatePartitionBuildType(List<Property> list, AbstractBuildNode abstractBuildNode, String string, String string2) {
        ComplexProperty complexProperty = new ComplexProperty("ODMS_PARTITION_BUILD_TYPE", string);
        complexProperty.setOldData(string2);
        list.add(new Property(String.valueOf(ModelPartitionedBuildNodePropertyModel.ODMS_PARTITION_BUILD_TYPE.index), null, complexProperty, null, null));
        ModelPartitionedBuildNodePropertyModel.prepareStatusReady(list, abstractBuildNode);
    }

    public static void updateMaxNumPartitions(List<Property> list, AbstractBuildNode abstractBuildNode, BigInteger bigInteger, BigInteger bigInteger2) {
        ComplexProperty complexProperty = new ComplexProperty("PARTITIONS_MAX_NUM", bigInteger);
        complexProperty.setOldData(bigInteger2);
        list.add(new Property(String.valueOf(ModelPartitionedBuildNodePropertyModel.PARTITIONS_MAX_NUM.index), null, complexProperty, null, null));
        ModelPartitionedBuildNodePropertyModel.prepareStatusReady(list, abstractBuildNode);
    }

    public static void updatePartitionColumns(List<Property> list, AbstractBuildNode abstractBuildNode, PartitionExpressions partitionExpressions, PartitionExpressions partitionExpressions2) {
        ComplexProperty complexProperty = new ComplexProperty("PARTITIONS_EXPRESSION_EDIT", partitionExpressions);
        complexProperty.setOldData(partitionExpressions2);
        list.add(new Property(String.valueOf(ModelPartitionedBuildNodePropertyModel.PARTITIONS_EXPRESSION_EDIT.index), null, complexProperty, null, null));
        ModelPartitionedBuildNodePropertyModel.prepareStatusReady(list, abstractBuildNode);
    }

    static {
        properties.addAll(AbstractNodePropertyModel.properties);
        int n = properties.size();
        TARGET = new NodeProperty("targetAttribute", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_TARGET"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_TARGET_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(TARGET);
        MODEL_ADDED_REMOVED = new NodeProperty("modelAddedorRemoved", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_VIEW_PROPERTY_MODEL"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_VIEW_PROPERTY_MODEL_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(MODEL_ADDED_REMOVED);
        TUNING = new NodeProperty("tuningChanged", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(TUNING);
        ALGORITHM_SETTINGS = new NodeProperty("algTreeSettings", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_ALGORITHM"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_ALGORITHM_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(ALGORITHM_SETTINGS);
        SPLIT_VALUE = new NodeProperty("splitValueChanged", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TEST_SPLIT"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TEST_SPLIT_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(SPLIT_VALUE);
        SPLIT_DATA_FORMAT = new NodeProperty("splitDataFormat", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TEST_SPLIT_FORMAT"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TEST_SPLIT_FORMAT_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(SPLIT_DATA_FORMAT);
        GEN_ACCURACY_METRICS = new NodeProperty("genAccuracyMetrics", PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_ACCURACY_METRICS"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_ACCURACY_METRICS_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(GEN_ACCURACY_METRICS);
        GEN_CONFUSION_MATRIX = new NodeProperty("genConfusionMatrix", PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_CONFUSION_MATRIX"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_CONFUSION_MATRIX_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(GEN_CONFUSION_MATRIX);
        GEN_ROC_CURVE = new NodeProperty("genROC", PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_ROC_CURVE"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_ROC_CURVE_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(GEN_ROC_CURVE);
        GEN_LIFT_AND_PROFIT = new NodeProperty("genLiftProfit", PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_LIFT_AND_PROFIT"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_LIFT_AND_PROFIT_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(GEN_LIFT_AND_PROFIT);
        GEN_FOR_TUNING = new NodeProperty("genTuning", PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_TUNING"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_TUNING_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(GEN_FOR_TUNING);
        CASE_IDS = new NodeProperty("caseAttributes", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_CASE_ID"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_CASE_ID_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(CASE_IDS);
        TEST_OPTIONS_CHANGED = new NodeProperty("testOptionsChanged", PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_OPTIONS_CHANGED"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_OPTIONS_CHANGED_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(TEST_OPTIONS_CHANGED);
        TEST_SETTINGS_CHANGED = new NodeProperty("testSettingsChanged", PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_SETTINGS_CHANGED"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_SETTINGS_CHANGED_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(TEST_SETTINGS_CHANGED);
        MODELS_RERUN = new NodeProperty("modelsRerun", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_BUILD"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_BUILD"), Groups.CUSTOM_BUILD, n++);
        properties.add(MODELS_RERUN);
        TESTS_RERUN = new NodeProperty("testsRerun", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_TEST"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_TEST"), Groups.CUSTOM_BUILD, n++);
        properties.add(TESTS_RERUN);
        TESTS_ADDED_REMOVED = new NodeProperty("testsRemoved", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_TEST"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_TEST"), Groups.CUSTOM_BUILD, n++);
        properties.add(TESTS_ADDED_REMOVED);
        TESTS_FOR_TUNING_ADDED_REMOVED = new NodeProperty("testsForTuningRemoved", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_TEST"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_TEST"), Groups.CUSTOM_BUILD, n++);
        properties.add(TESTS_FOR_TUNING_ADDED_REMOVED);
        COST_BENEFIT = new NodeProperty("costBenefit", PropertyLrb.get("PI_CLASS_BUILD_GROUP_TUNE_OPTIONS_CHANGED"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_TUNE_OPTIONS_CHANGED_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(COST_BENEFIT);
        MODEL_ANNOTATION = new NodeProperty("modelAnnotation", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ANNOTATION"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ANNOTATION_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(MODEL_ANNOTATION);
        MODEL_NAME = new NodeProperty("modelName", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NAME"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NAME_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(MODEL_NAME);
        MODEL_USEFOROUTPUT = new NodeProperty("modelUseForOutput", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_USEFOR_OUTPUT"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_USEFOR_OUTPUT_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(MODEL_USEFOROUTPUT);
        MINING_ATTRIBUTE_SETTINGS = new NodeProperty("miningAttributeSettings", PropertyLrb.get("PI_BUILD_GROUP_BUILD_ATTRIBUTE_USAGE"), PropertyLrb.get("PI_BUILD_GROUP_BUILD_ATTRIBUTE_USAGE_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(MINING_ATTRIBUTE_SETTINGS);
        PARTITIONS_MAX_NUM = new NodeProperty("PARTITIONS_MAX_NUM", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NUM_PARTITIONS"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NUM_PARTITIONS_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PARTITIONS_MAX_NUM);
        PARTITIONS_EXPRESSION_EDIT = new NodeProperty("PARTITIONS_EXPRESSION_EDIT", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(PARTITIONS_EXPRESSION_EDIT);
        ODMS_PARTITION_BUILD_TYPE = new NodeProperty("ODMS_PARTITION_BUILD_TYPE", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION_BUILD_TYPE"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION_BUILD_TYPE_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(ODMS_PARTITION_BUILD_TYPE);
    }

    private static class Groups {
        private static final PropertyGroupImpl CUSTOM_BUILD = new PropertyGroupImpl(PreferencesLrb.get("PI_BUILD_NODE_GROUP_BUILD_TITLE"));

        private Groups() {
        }
    }
}

