/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.JSONQuery;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.DialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.JSONQuery.WorkflowJSONQueryNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.model.JSONQueryNode;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementsExType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeExType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.GroupingElementExType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONAttributesType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONQueryNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RelationalAttributesType;
import oracle.javatools.icons.OracleIcons;

public class JSONQueryOutputPanel
extends PIComponentPanel {
    private JSONQueryNode _targetNode;
    private OutputColumnsTableModel _tableModel;
    private JPanel jColumnPanel;
    private DataMinerTablePanel columnTablePanel;

    public JSONQueryOutputPanel(PropertyModel propertyModel) {
        super(propertyModel);
        this._targetNode = (JSONQueryNode)this.getTargetNode(propertyModel);
        this.setMinimumSize(new Dimension(200, 400));
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void initRes() {
    }

    public void initUI() {
        this.columnTablePanel = new DataMinerTablePanel();
        this.jColumnPanel.setLayout(new BorderLayout());
        this.jColumnPanel.add(this.columnTablePanel);
        JToggleButton jToggleButton = new JToggleButton(DialogsLrb.get("JSON_QUERY_PREVIEW_DATA_SHOW_PATH"), DataMinerIcons.get(Icons.SHOW_JSON_PATH));
        jToggleButton.setToolTipText(DialogsLrb.get("JSON_QUERY_PREVIEW_DATA_SHOW_PATH_TOOLTIP"));
        jToggleButton.setSelected(true);
        jToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
                JSONQueryOutputPanel.this.showJSONPaths(jToggleButton.isSelected());
            }
        });
        this.columnTablePanel.addControlBarComponents(jToggleButton);
        this.setupTable();
    }

    private void setupTable() {
        NodeType nodeType = this._targetNode.getData();
        JSONQueryNodeType jSONQueryNodeType = (JSONQueryNodeType)nodeType;
        this._tableModel = new OutputColumnsTableModel(jSONQueryNodeType);
        String string = DialogsLrb.get("JSON_QUERY_PREVIEW_DATA_NUM_COLS");
        String string2 = MessageFormat.format(string, this._tableModel.getRowCount());
        this.columnTablePanel.getTable().setFixedColumns(1, 250);
        this.columnTablePanel.setup((TableModel)((Object)this._tableModel), string2, this._tableModel.NAME_COLUMN, true);
        this.columnTablePanel.getTable().autoSizeColumnsToFit();
        TableColumn tableColumn = this.columnTablePanel.getTable().getFullColumnModel().getColumn(this._tableModel.NAME_COLUMN);
        tableColumn.setCellRenderer(new CustomCellRenderer(OracleIcons.getIcon((String)"attribute.png"), OracleIcons.getIcon((String)"warning.png")));
    }

    private void showJSONPaths(boolean bl) {
        this._tableModel.showFullPath(bl);
    }

    public void updatePI(PropertyModel propertyModel) {
        this._model = (WorkflowJSONQueryNodePropertyProxyModel)propertyModel;
        this.reload();
    }

    public void reload() {
        this._targetNode = (JSONQueryNode)this.getTargetNode((PropertyModel)this._model);
        NodeType nodeType = this._targetNode.getData();
        JSONQueryNodeType jSONQueryNodeType = (JSONQueryNodeType)nodeType;
        this._tableModel.refreshModel(jSONQueryNodeType);
        String string = DialogsLrb.get("JSON_QUERY_PREVIEW_DATA_NUM_COLS");
        String string2 = MessageFormat.format(string, this._tableModel.getRowCount());
        this.columnTablePanel.setTitle(string2);
        this.columnTablePanel.getTable().autoSizeColumnsToFit();
    }

    private void initComponents() {
        this.jColumnPanel = new JPanel();
        this.jColumnPanel.setName("jColumnPanel");
        this.jColumnPanel.setLayout(new BorderLayout());
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jColumnPanel, -1, 785, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jColumnPanel, -1, 499, Short.MAX_VALUE).addContainerGap()));
    }

    private static class CustomCellRenderer
    extends DefaultTableCellRenderer {
        private Icon validIcon;
        private Icon invalidIcon;

        public CustomCellRenderer(Icon icon, Icon icon2) {
            this.validIcon = icon;
            this.invalidIcon = icon2;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = jTable.convertRowIndexToModel(n);
            TableModel tableModel = jTable.getModel();
            AttributeStatus attributeStatus = AttributeStatus.VALID;
            if (tableModel instanceof OutputColumnsTableModel) {
                OutputColumnsTableModel outputColumnsTableModel = (OutputColumnsTableModel)((Object)tableModel);
                attributeStatus = (AttributeStatus)outputColumnsTableModel.getValueAt(n3, outputColumnsTableModel.ATTR_STATUS);
            }
            if (attributeStatus == AttributeStatus.VALID) {
                this.setIcon(this.validIcon);
            } else {
                this.setIcon(this.invalidIcon);
            }
            return component;
        }
    }

    private static class OutputColumnItem {
        private Object _sourceObject;
        private String _name;
        private String _orgDataType;
        private String _tgtDataType;
        private String _source;
        private String _fullPath;
        private String _shortPath;
        private String _aggregFunction;
        private String _groupByFull;
        private String _groupByShort;
        private String _subGroupByFull;
        private String _subGroupByShort;
        private AttributeStatus _status;

        public OutputColumnItem(Object object, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, AttributeStatus attributeStatus) {
            this._sourceObject = object;
            this._name = string;
            this._orgDataType = string2;
            this._tgtDataType = string3;
            this._source = string4;
            this._fullPath = string5;
            this._shortPath = string6;
            this._groupByFull = string8;
            this._groupByShort = string9;
            this._aggregFunction = string7;
            this._subGroupByFull = string10;
            this._subGroupByShort = string11;
            this._status = attributeStatus;
        }

        public String getName() {
            return this._name;
        }

        public String getOrgDataType() {
            return this._orgDataType;
        }

        public String getTgtDataType() {
            return this._tgtDataType;
        }

        public String getSource() {
            return this._source;
        }

        public String getFullPath() {
            return this._fullPath;
        }

        public String getShortPath() {
            return this._shortPath;
        }

        public String getAggregFunction() {
            return this._aggregFunction;
        }

        public String getGroupByFull() {
            return this._groupByFull;
        }

        public String getGroupByShort() {
            return this._groupByShort;
        }

        public String getSubGroupByFull() {
            return this._subGroupByFull;
        }

        public String getSubGroupByShort() {
            return this._subGroupByShort;
        }

        public AttributeStatus getStatus() {
            return this._status;
        }
    }

    private class OutputColumnsTableModel
    extends SimpleBaseTableModel {
        private String _JSONSourceColumn = null;
        private String _relationalDataSource = null;
        private JSONAttributesType _JSONAttributes = null;
        private RelationalAttributesType _relationalAttributes = null;
        private AggregationElementsExType _aggregationElements = null;
        private GroupingElementExType _groupingElements = null;
        private List<OutputColumnItem> _srcData = new ArrayList<OutputColumnItem>();
        private boolean _showFullPath = true;
        private String[] _columnNames = new String[]{DialogsLrb.get("JSON_QUERY_PREVIEW_DATA_COL_NAME"), DialogsLrb.get("JSON_QUERY_PREVIEW_DATA_COL_TYPE"), DialogsLrb.get("JSON_QUERY_PREVIEW_DATA_COL_SOURCE"), DialogsLrb.get("JSON_QUERY_PREVIEW_DATA_COL_JSON_PATH"), DialogsLrb.get("JSON_QUERY_PREVIEW_DATA_COL_AGGREG"), DialogsLrb.get("JSON_QUERY_PREVIEW_DATA_COL_GROUPBY"), DialogsLrb.get("JSON_QUERY_PREVIEW_DATA_COL_SUBGROUPBY")};
        private int _COL_INDEX = 0;
        public final int NAME_COLUMN = this._COL_INDEX++;
        public final int DATA_TYPE_COLUMN = this._COL_INDEX++;
        public final int SOURCE_COLUMN = this._COL_INDEX++;
        public final int JSON_PATH_COLUMN = this._COL_INDEX++;
        public final int AGGREG_COLUMN = this._COL_INDEX++;
        public final int GROUPBY_COLUMN = this._COL_INDEX++;
        public final int SUBGROUPBY_COLUMN = this._COL_INDEX++;
        public final int ORG_DATA_TYPE = this._COL_INDEX++;
        public final int ATTR_STATUS = this._COL_INDEX++;

        public OutputColumnsTableModel(JSONQueryNodeType jSONQueryNodeType) {
            String string = this._JSONSourceColumn = jSONQueryNodeType.getJSONAttributes() != null ? jSONQueryNodeType.getJSONAttributes().getSource() : null;
            if (JSONQueryOutputPanel.this._targetNode.findSourceNodes() != null && !JSONQueryOutputPanel.this._targetNode.findSourceNodes().isEmpty()) {
                this._relationalDataSource = JSONQueryOutputPanel.this._targetNode.findSourceNodes().get(0).getDefaultName();
            }
            this._JSONAttributes = jSONQueryNodeType.getJSONAttributes();
            this._relationalAttributes = jSONQueryNodeType.getRelationalAttributes();
            this._aggregationElements = jSONQueryNodeType.getAggregationElements();
            this._groupingElements = jSONQueryNodeType.getGroupingElement();
            this.init();
            this.setRowCount(this._srcData.size());
            this.setColumnIdentifiers(this.getColumnNames());
            this.setColumnCount(this.getColumnNames().length);
        }

        private String getShortPath(String string) {
            String string2 = string;
            int n = string.lastIndexOf(".");
            if (n >= 0) {
                string2 = string.substring(n + 1, string.length());
            }
            return string2;
        }

        /*
         * WARNING - void declaration
         */
        private void init() {
            String string;
            Object object;
            String string2;
            Object object2;
            Object object32;
            Object object42;
            List<Object> list;
            Object object522;
            GroupingElementExType.Attributes object6;
            this._srcData.clear();
            TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (this._JSONAttributes != null) {
                object6 = new ArrayList();
                for (Object object522 : this._JSONAttributes.getJSONAttribute()) {
                    if (object522.getDataType().compareToIgnoreCase("ARRAY") != 0 || !Boolean.FALSE.equals(object522.isUnnest())) continue;
                    object6.add(object522);
                }
                for (Object object522 : this._JSONAttributes.getJSONAttribute()) {
                    boolean bl = true;
                    for (JSONAttributeType jSONAttributeType : object6) {
                        if (object522.getPath().compareTo(jSONAttributeType.getPath()) == 0 || object522.getPath().indexOf(jSONAttributeType.getPath()) != 0) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    if (object522.getDataType().compareToIgnoreCase("ARRAY") == 0) {
                        void var8_27;
                        bl = false;
                        list = object522.getPath();
                        Object object5 = object522;
                        if (Boolean.FALSE.equals(object522.isUnnest())) {
                            bl = true;
                        } else {
                            bl = true;
                            list = list + "[*]";
                            for (Object object42 : this._JSONAttributes.getJSONAttribute()) {
                                if (object522.getPath().compareTo(object42.getPath()) == 0 || object42.getPath().indexOf(object522.getPath() + ".") != 0) continue;
                                bl = false;
                                break;
                            }
                            if (bl) {
                                JSONAttributeType jSONAttributeType = new JSONAttributeType();
                                jSONAttributeType.setDBDataType("VARCHAR2");
                                jSONAttributeType.setDBName(object522.getDBName());
                                jSONAttributeType.setDataType(object522.getDataType());
                                jSONAttributeType.setPath(list);
                                jSONAttributeType.setStatus(object522.getStatus());
                                jSONAttributeType.setUnnest(object522.isUnnest());
                            }
                        }
                        if (!bl) continue;
                        object32 = (List)treeMap.get(list);
                        if (object32 == null) {
                            object32 = new ArrayList();
                            treeMap.put(list, object32);
                        }
                        object32.add(var8_27);
                        continue;
                    }
                    if (object522.getDataType().compareToIgnoreCase("OBJECT") == 0) continue;
                    list = (List)treeMap.get(object522.getPath());
                    if (list == null) {
                        list = new ArrayList<Object>();
                        treeMap.put(object522.getPath(), list);
                    }
                    list.add(object522);
                }
            }
            if (this._relationalAttributes != null) {
                object6 = this._relationalAttributes.getAttribute().iterator();
                while (object6.hasNext()) {
                    void string5;
                    object2 = (AttributeExType)object6.next();
                    object522 = object2.getAlias() != null ? object2.getAlias() : object2.getName();
                    List arrayList2 = (List)treeMap.get(object522);
                    if (arrayList2 == null) {
                        ArrayList string3 = new ArrayList();
                        treeMap.put(object522, string3);
                    }
                    string5.add(object2);
                }
            }
            if (this._aggregationElements != null) {
                object6 = this._aggregationElements.getAggregationElement().iterator();
                while (object6.hasNext()) {
                    object2 = (AggregationElementsExType.AggregationElement)object6.next();
                    object522 = (List)treeMap.get(object2.getJSONAttribute().getPath());
                    if (object522 == null) {
                        object522 = new ArrayList();
                        treeMap.put(object2.getJSONAttribute().getPath(), object522);
                    }
                    object522.add(object2);
                }
            }
            if (this._groupingElements != null && (object6 = this._groupingElements.getAttributes()) != null) {
                block6: for (Object object522 : object6.getAttribute()) {
                    arrayList.add(object522);
                    String object8 = object522.getAlias() != null ? object522.getAlias() : object522.getName();
                    list = (List)treeMap.get(object8);
                    if (list == null) {
                        list = new ArrayList<Object>();
                        list.add(object522);
                        treeMap.put(object8, list);
                        continue;
                    }
                    boolean bl = false;
                    object32 = new ArrayList(list);
                    object42 = object32.iterator();
                    while (object42.hasNext()) {
                        string2 = (String)object42.next();
                        if (string2 instanceof AttributeExType) {
                            object = (AttributeExType)string2;
                            String string3 = string = object.getAlias() != null ? object.getAlias() : object.getName();
                            if (string.equals(object8)) {
                                bl = true;
                                continue block6;
                            }
                        }
                        if (bl) continue;
                        list.add(object522);
                    }
                }
                block8: for (Object object522 : object6.getJSONAttribute()) {
                    arrayList.add(object522);
                    String entry = object522.getPath();
                    list = (List)treeMap.get(entry);
                    if (list == null) {
                        list = new ArrayList();
                        list.add(object522);
                        treeMap.put(entry, list);
                        continue;
                    }
                    boolean bl = false;
                    object32 = new ArrayList(list);
                    object42 = object32.iterator();
                    while (object42.hasNext()) {
                        string2 = (String)object42.next();
                        if (string2 instanceof JSONAttributeType && (object = (JSONAttributeType)string2).getDBName().equals(object522.getDBName())) {
                            bl = true;
                            continue block8;
                        }
                        if (bl) continue;
                        list.add(object522);
                    }
                }
            }
            object6 = null;
            object2 = null;
            if (!arrayList.isEmpty()) {
                void var6_14;
                object522 = "";
                String string4 = "";
                for (Object e : arrayList) {
                    void var6_19;
                    if (e instanceof AttributeExType) {
                        object32 = (AttributeExType)e;
                        object42 = object32.getName();
                        if (((String)object522).length() > 0) {
                            object522 = (String)object522 + ", ";
                        }
                        object522 = (String)object522 + (String)object42;
                        if (var6_14.length() > 0) {
                            String string5 = (String)var6_14 + ", ";
                        }
                        String string6 = object42;
                        continue;
                    }
                    if (!(e instanceof JSONAttributeType)) continue;
                    object32 = (JSONAttributeType)e;
                    object42 = object32.getPath();
                    if (((String)object522).length() > 0) {
                        object522 = (String)object522 + ", ";
                    }
                    object522 = (String)object522 + (String)object42;
                    if (var6_14.length() > 0) {
                        String string7 = (String)var6_14 + ", ";
                    }
                    String string8 = (String)var6_19 + this.getShortPath((String)object42);
                }
                object2 = object522;
                object6 = var6_14;
            }
            for (Map.Entry entry : treeMap.entrySet()) {
                list = (List)entry.getValue();
                for (Object object32 : list) {
                    Object object7;
                    object42 = null;
                    string2 = null;
                    object = null;
                    string = null;
                    String string9 = null;
                    String string10 = null;
                    String string11 = null;
                    GroupingElementExType.Attributes attributes = null;
                    Object object8 = null;
                    String string12 = null;
                    String string13 = null;
                    AttributeStatus attributeStatus = null;
                    if (object32 instanceof AttributeExType) {
                        object7 = (AttributeExType)object32;
                        object42 = object7.getAlias() != null ? object7.getAlias() : object7.getName();
                    } else if (object32 instanceof JSONAttributeType) {
                        object7 = (JSONAttributeType)object32;
                        object42 = object7.getDBName();
                    } else if (object32 instanceof AggregationElementsExType.AggregationElement) {
                        object7 = (AggregationElementsExType.AggregationElement)object32;
                        object42 = object7.getOutput().getName();
                    }
                    if (object32 instanceof AttributeExType) {
                        object7 = (AttributeExType)object32;
                        string2 = object7.getDataType();
                        object = object7.getNewDataType();
                    } else if (object32 instanceof JSONAttributeType) {
                        object7 = (JSONAttributeType)object32;
                        string2 = DatabaseMetadataUtils.convertJSONAttrType(object7.getDataType());
                        object = object7.getDBDataType();
                        if ((object7.getDataType().compareToIgnoreCase("ARRAY") == 0 || object7.getDataType().compareToIgnoreCase("OBJECT") == 0) && Boolean.FALSE.equals(object7.isUnnest())) {
                            object = DatabaseMetadataUtils.getJSONDataType((String)object, "JSON");
                        }
                    } else if (object32 instanceof AggregationElementsExType.AggregationElement) {
                        object7 = (AggregationElementsExType.AggregationElement)object32;
                        string2 = DatabaseMetadataUtils.convertJSONAttrType(object7.getJSONAttribute().getDataType());
                        object = object7.getOutput().getDataType();
                    }
                    if (object32 instanceof AttributeExType) {
                        object7 = (AttributeExType)object32;
                        string = object7.getName();
                    } else if (object32 instanceof JSONAttributeType) {
                        string = this._JSONSourceColumn;
                    } else if (object32 instanceof AggregationElementsExType.AggregationElement) {
                        string = this._JSONSourceColumn;
                    }
                    if (object32 instanceof AttributeExType) {
                        string9 = null;
                        string10 = null;
                    } else if (object32 instanceof JSONAttributeType) {
                        object7 = (JSONAttributeType)object32;
                        string9 = object7.getPath();
                        string10 = this.getShortPath(string9);
                    } else if (object32 instanceof AggregationElementsExType.AggregationElement) {
                        object7 = (AggregationElementsExType.AggregationElement)object32;
                        string9 = object7.getJSONAttribute().getPath();
                        string10 = this.getShortPath(string9);
                    }
                    if (object32 instanceof AttributeExType) {
                        string11 = null;
                    } else if (object32 instanceof JSONAttributeType) {
                        string11 = null;
                    } else if (object32 instanceof AggregationElementsExType.AggregationElement) {
                        object7 = (AggregationElementsExType.AggregationElement)object32;
                        string11 = object7.getAggregationFunction();
                    }
                    if (object32 instanceof AttributeExType) {
                        string12 = null;
                        string13 = null;
                    } else if (object32 instanceof JSONAttributeType) {
                        string12 = null;
                        string13 = null;
                    } else if (object32 instanceof AggregationElementsExType.AggregationElement) {
                        object7 = new StringBuilder();
                        StringBuilder stringBuilder = new StringBuilder();
                        AggregationElementsExType.AggregationElement aggregationElement = (AggregationElementsExType.AggregationElement)object32;
                        if (aggregationElement.getSubGroupBy() != null && aggregationElement.getSubGroupBy().getAttributes() != null && !aggregationElement.getSubGroupBy().getAttributes().getJSONAttribute().isEmpty()) {
                            for (JSONAttributeType jSONAttributeType : aggregationElement.getSubGroupBy().getAttributes().getJSONAttribute()) {
                                String string14 = jSONAttributeType.getPath();
                                if (((StringBuilder)object7).length() > 0) {
                                    ((StringBuilder)object7).append(", ");
                                }
                                ((StringBuilder)object7).append(string14);
                                if (stringBuilder.length() > 0) {
                                    stringBuilder.append(", ");
                                }
                                stringBuilder.append(this.getShortPath(string14));
                            }
                        }
                        string12 = ((StringBuilder)object7).toString();
                        string13 = stringBuilder.toString();
                        if (object2 != null) {
                            object8 = object2;
                        }
                        if (object6 != null) {
                            attributes = object6;
                        }
                    }
                    if (object32 instanceof AttributeExType) {
                        object7 = (AttributeExType)object32;
                        attributeStatus = object7.getStatus();
                    } else if (object32 instanceof JSONAttributeType) {
                        object7 = (JSONAttributeType)object32;
                        attributeStatus = object7.getStatus();
                    } else if (object32 instanceof AggregationElementsExType.AggregationElement) {
                        object7 = (AggregationElementsExType.AggregationElement)object32;
                        attributeStatus = object7.getJSONAttribute().getStatus();
                    }
                    this._srcData.add(new OutputColumnItem(object32, (String)object42, string2, (String)object, string, string9, string10, string11, (String)object8, (String)attributes, string12, string13, attributeStatus));
                }
            }
        }

        protected String[] getColumnNames() {
            return this._columnNames;
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.size() : 0;
        }

        public Object getValueAt(int n, int n2) {
            if (this._srcData.isEmpty()) {
                return DialogsLrb.get("JSON_QUERY_LOADING");
            }
            if (n >= this._srcData.size()) {
                return "";
            }
            OutputColumnItem outputColumnItem = this._srcData.get(n);
            String string = null;
            if (n2 == this.NAME_COLUMN) {
                string = outputColumnItem.getName();
            } else if (n2 == this.DATA_TYPE_COLUMN) {
                string = outputColumnItem.getTgtDataType();
            } else if (n2 == this.SOURCE_COLUMN) {
                string = outputColumnItem.getSource();
            } else if (n2 == this.JSON_PATH_COLUMN) {
                string = this._showFullPath ? outputColumnItem.getFullPath() : outputColumnItem.getShortPath();
            } else if (n2 == this.AGGREG_COLUMN) {
                string = outputColumnItem.getAggregFunction();
            } else if (n2 == this.GROUPBY_COLUMN) {
                string = this._showFullPath ? outputColumnItem.getGroupByFull() : outputColumnItem.getGroupByShort();
            } else if (n2 == this.SUBGROUPBY_COLUMN) {
                string = this._showFullPath ? outputColumnItem.getSubGroupByFull() : outputColumnItem.getSubGroupByShort();
            } else if (n2 == this.ORG_DATA_TYPE) {
                string = outputColumnItem.getOrgDataType();
            } else if (n2 == this.ATTR_STATUS) {
                string = outputColumnItem.getStatus();
            } else assert (false) : "Out of bounds column when accessing items";
            return string != null ? string : "";
        }

        public void showFullPath(boolean bl) {
            this._showFullPath = bl;
            this.fireTableDataChanged();
        }

        public void refreshModel(JSONQueryNodeType jSONQueryNodeType) {
            String string = this._JSONSourceColumn = jSONQueryNodeType.getJSONAttributes() != null ? jSONQueryNodeType.getJSONAttributes().getSource() : null;
            if (JSONQueryOutputPanel.this._targetNode.findSourceNodes() != null && !JSONQueryOutputPanel.this._targetNode.findSourceNodes().isEmpty()) {
                this._relationalDataSource = JSONQueryOutputPanel.this._targetNode.findSourceNodes().get(0).getDefaultName();
            }
            this._JSONAttributes = jSONQueryNodeType.getJSONAttributes();
            this._relationalAttributes = jSONQueryNodeType.getRelationalAttributes();
            this._aggregationElements = jSONQueryNodeType.getAggregationElements();
            this._groupingElements = jSONQueryNodeType.getGroupingElement();
            this.init();
            this.fireTableDataChanged();
        }
    }
}

