/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditorSupport;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.controls.TableChooserModel;
import oracle.dmt.dataminer.controls.TableChooserPane;
import oracle.dmt.dataminer.core.model.ds.Table;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.wizard.group.GroupLrb;
import oracle.dmt.dataminer.workflow.inspect.AbstractNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.NodeProperty;
import oracle.dmt.dataminer.workflow.inspect.PropertyGroupImpl;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.javatools.dialogs.ExceptionDialog;

public class DataSourceNodePropertyModel
extends AbstractNodePropertyModel {
    protected static List<NodeProperty> properties = new ArrayList<NodeProperty>();
    public static final NodeProperty DATA_SOURCE_TABLE;
    public static final NodeProperty DATA_SOURCE_TABLE_CONTENTS;
    public static final NodeProperty DATA_SOURCE_TABLE_ALIAS_CHANGED;
    public static final NodeProperty CACHE_SETTINGS;
    public static final NodeProperty SQL_EXPRESSION;

    public DataSourceNodePropertyModel(Context context) {
        super(context);
    }

    @Override
    public String getHelpTopic() {
        return "datasource_node_pi";
    }

    @Override
    protected List<NodeProperty> getNodeProperties() {
        return properties;
    }

    static {
        properties.addAll(AbstractNodePropertyModel.properties);
        int n = properties.size();
        DATA_SOURCE_TABLE = new NodeProperty("dataSourceTable", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_DS"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_DS_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(DATA_SOURCE_TABLE);
        DATA_SOURCE_TABLE_CONTENTS = new NodeProperty("dataSourceTableContentChanged", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_DS_CONTENT"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_DS_CONTENT_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(DATA_SOURCE_TABLE_CONTENTS);
        DATA_SOURCE_TABLE_ALIAS_CHANGED = new NodeProperty("dataSourceTableAliasChange", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_DS_CONTENT_ALIAS"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_DS_CONTENT_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(DATA_SOURCE_TABLE_ALIAS_CHANGED);
        CACHE_SETTINGS = new NodeProperty("CACHE_SETTINGS", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_CACHE_SETTINGS"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_CACHE_SETTINGS_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(CACHE_SETTINGS);
        SQL_EXPRESSION = new NodeProperty("SQL_EXPRESSION", PropertyLrb.get("PI_SQL_EXPRESSION"), PropertyLrb.get("PI_SQL_EXPRESSION_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(SQL_EXPRESSION);
    }

    class CustomEditor
    extends JPanel
    implements VetoableChangeListener {
        private PropertyEditorFactory2 source;
        private TableChooserPane chooser;

        public CustomEditor(PropertyEditorFactory2 propertyEditorFactory2) {
            this.source = propertyEditorFactory2;
            this.chooser = new TableChooserPane(DataSourceNodePropertyModel.this.getContext());
            this.chooser.initUI();
            this.add(this.chooser);
        }

        @Override
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("closed")) {
                TableChooserModel tableChooserModel = this.chooser.getModel();
                int n = this.chooser.getSelectedRow();
                Table table = tableChooserModel.getRow(n);
                Map<String, AttributeType> map = this.getTableColumns(table);
                Table table2 = new Table(table.getSchema(), table.getName(), map);
                this.source.setValue((Object)table2);
            }
        }

        private Map<String, AttributeType> getTableColumns(final Table table) {
            final HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
            class Loader
            extends ProgressRunnable {
                Loader() {
                }

                protected Object doWork() throws Exception {
                    ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(DataSourceNodePropertyModel.this.getContext());
                    return DatabaseMetadataUtils.getColumnDetails(connectionFolder, table);
                }

                protected void finish(Object object) {
                    List list = (List)object;
                    for (List list2 : list) {
                        AttributeType attributeType = new AttributeType();
                        attributeType.setName((String)list2.get(0));
                        attributeType.setDataType((String)list2.get(1));
                        hashMap.put(attributeType.getName(), attributeType);
                    }
                }
            }
            Loader loader = new Loader();
            loader.setTitle(GroupLrb.get("RETRIEVING_AVAILABLE_TABLES"));
            loader.setMessage(GroupLrb.get("RETRIEVING_AVAILABLE_TABLES_DETAILS"));
            try {
                loader.start(true);
            }
            catch (ProgressException progressException) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)progressException, (String)"Application Error", (String)"Error getting table details", null);
            }
            return hashMap;
        }
    }

    class DataSourcePropertyEditor
    extends PropertyEditorSupport {
        public DataSourcePropertyEditor(Object object) {
            super(object);
        }

        @Override
        public Component getCustomEditor() {
            CustomEditor customEditor = new CustomEditor((PropertyEditorFactory2)this.getSource());
            return customEditor;
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }
    }

    private static class Groups {
        private static final PropertyGroupImpl CUSTOM_BUILD = new PropertyGroupImpl(PreferencesLrb.get("PI_ATTRUBUTES_GROUP_TITLE"));

        private Groups() {
        }
    }
}

