/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.dialog.transformations.MessagePanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformSettingsEditorDialog;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationNodeAttributesBasePanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationNodeAttributesGrid;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.ComponentWithTitlebar;

public class TransformationNodeAttributesPanelPreRun
extends TransformationNodeAttributesBasePanel {
    private ComponentWithTitlebar<JComponent> jAttributesComponent;
    private JPanel jBottomPanel;
    private JSplitPane jSplitPane1;
    private JPanel jTopPanel;
    private DataMinerTable _jAttributesTable = new DataMinerTable();

    public TransformationNodeAttributesPanelPreRun(TransformSettingsEditorDialog transformSettingsEditorDialog, Context context, AbstractNode abstractNode) {
        super(transformSettingsEditorDialog, context, abstractNode);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jTopPanel = new JPanel();
        this.jAttributesComponent = new ComponentWithTitlebar();
        this.jBottomPanel = new JPanel();
        this.jSplitPane1.setDividerLocation(150);
        this.jSplitPane1.setOrientation(0);
        GroupLayout groupLayout = new GroupLayout(this.jTopPanel);
        this.jTopPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 607, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jAttributesComponent, -1, 587, Short.MAX_VALUE).addContainerGap())));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 149, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.jAttributesComponent, -1, 127, Short.MAX_VALUE).addContainerGap())));
        this.jSplitPane1.setTopComponent(this.jTopPanel);
        GroupLayout groupLayout2 = new GroupLayout(this.jBottomPanel);
        this.jBottomPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 607, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 196, Short.MAX_VALUE));
        this.jSplitPane1.setRightComponent(this.jBottomPanel);
        GroupLayout groupLayout3 = new GroupLayout(this);
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, GroupLayout.Alignment.TRAILING, -1, 609, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addGap(29, 29, 29).addComponent(this.jSplitPane1, -1, 352, Short.MAX_VALUE)));
    }

    @Override
    public void initRes() {
        this.jSplitPane1.setDividerLocation(280);
        HelpUtils.setHelpID((JComponent)this, (String)"edit_transform_settings");
    }

    @Override
    public void initUI() {
        Object a = this.getData();
        NodeType nodeType = ((AbstractNode)a).getData();
        TransformationNodeType transformationNodeType = (TransformationNodeType)nodeType;
        this.grid = new TransformationNodeAttributesGrid((AbstractNode)a, this.parentDlg, transformationNodeType);
        this.grid.initUI(this.getContext(), this.jAttributesComponent, this._jAttributesTable);
        this.jBottomPanel.setLayout(new FlowLayout());
        this.createNoDataPanel(this.jBottomPanel);
    }

    private void createNoDataPanel(JPanel jPanel) {
        String string = XformDialogsLrb.get("ADD_TRANSFORMATION_PRE_RUN_1");
        String string2 = XformDialogsLrb.get("ADD_TRANSFORMATION_PRE_RUN_2");
        MessagePanel messagePanel = new MessagePanel(string, string2);
        jPanel.add(messagePanel);
    }

    @Override
    public boolean doWork() {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = this.isQuantileBinningValid(arrayList);
        if (!bl) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : arrayList) {
                if (!stringBuilder.toString().isEmpty()) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(string);
            }
            String string = StringUtils.getReplacedString(XformDialogsLrb.get("QUANTILE_BINNING_ERROR_NOT_ENOUGH_DITINCTS"), "<list of columns>", stringBuilder.toString());
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
        }
        return bl;
    }

    @Override
    public List<Property> getResults() {
        TransformationNodeType transformationNodeType = this.getCachedTransformationNodeType();
        ArrayList<Property> arrayList = new ArrayList<Property>();
        arrayList.add(new Property("allXfomNodeColumns", null, AttributeTypeHelper.getAllColumns(transformationNodeType), null, null));
        arrayList.add(new Property("SQL_EXPRESSION", null, "SQL_EXPRESSION_GENERATE", null, null));
        return arrayList;
    }

    @Override
    public void cleanUp() {
        this.grid.cleanUp();
    }
}

