/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JPanel;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.dialog.data.DataConsumerPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationTypes;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BinLabels;
import oracle.dmt.dataminer.workflow.xmlschema.MapTransformedSource;
import oracle.dmt.dataminer.workflow.xmlschema.StringCollection;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationOutputAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.ide.Context;

public abstract class AddEditTransformsPanelAbstract
extends JPanel
implements DataminerGUIPanel,
DataConsumerPanel {
    private static final Logger theLogger = Logger.getLogger(AddEditTransformsPanelAbstract.class.getName());
    protected Context _context;
    protected TransformationNodeType _nodeData;
    protected Map<String, TransformationSourceAttribute> _xformationSourceAttrMap;
    protected List<TransformationSourceAttribute> _xformationSourceAttrList;
    protected List<TransformationSourceAttribute> _selectedSourceColumns;
    protected TransformationStatisticsState _state;

    public abstract boolean isEditingMode();

    public AddEditTransformsPanelAbstract(Context context, TransformationStatisticsState transformationStatisticsState, TransformationNodeType transformationNodeType, Map<String, TransformationSourceAttribute> map, List<TransformationSourceAttribute> list, List<TransformationSourceAttribute> list2) {
        this._context = context;
        this._state = transformationStatisticsState;
        this._nodeData = transformationNodeType;
        this._xformationSourceAttrMap = map;
        this._xformationSourceAttrList = list;
        this._selectedSourceColumns = list2;
    }

    protected abstract String getCustomDataType();

    protected abstract TransformationType getResultTransformationType();

    protected abstract TransformationOutputAttribute getEditedColumn();

    public abstract String getNewColumnName();

    public MapTransformedSource getTransformedAttribute() {
        MapTransformedSource mapTransformedSource = null;
        TransformationSourceAttribute transformationSourceAttribute = this.getSelectedSourceColumn().getTransformationSourceAttribute();
        String string = transformationSourceAttribute.getDataType();
        if (this.isEditingMode()) {
            TransformationType transformationType;
            TransformationType transformationType2;
            String string2;
            mapTransformedSource = AttributeTypeHelper.findMapTransformedSource(this._nodeData.getTransformedAttributes(), (AttributeType)this.getEditedColumn());
            TransformationOutputAttribute transformationOutputAttribute = mapTransformedSource.getKey();
            boolean bl = false;
            String string3 = transformationOutputAttribute.getName();
            if (0 != string3.compareTo(string2 = this.getNewColumnName())) {
                transformationOutputAttribute.setName(string2);
                bl = true;
            }
            if (!TransformationTypes.areEqual(transformationType2 = this.getResultTransformationType(), transformationType = transformationOutputAttribute.getTransformationElementType())) {
                transformationOutputAttribute.setTransformationElementType(transformationType2);
                if (!bl) {
                    bl = true;
                }
            }
            if (!transformationOutputAttribute.isModified()) {
                transformationOutputAttribute.setModified(bl);
            }
            if (TransformationTypes.isCustomXform(transformationType2)) {
                string = this.getCustomDataType();
                transformationOutputAttribute.setDataType(string);
                transformationOutputAttribute.setModified(true);
            } else if (DatabaseMetadataUtils.isNumericTypeSupported(this._context, string)) {
                if (TransformationTypes.isBinning(transformationType2)) {
                    TransformationType.Binning binning = transformationType2.getBinning();
                    BinLabels binLabels = null;
                    if (null != binning.getEqualWidth()) {
                        binLabels = binning.getEqualWidth().getBinLabels();
                    } else if (null != binning.getQuantile()) {
                        binLabels = binning.getQuantile().getBinLabels();
                    } else if (null != binning.getCustomNumeric()) {
                        binLabels = binning.getCustomNumeric().getBinLabels();
                    }
                    if (binLabels != null) {
                        String string4;
                        if (null != binLabels.getRange()) {
                            String string5 = "VARCHAR2";
                            transformationOutputAttribute.setDataType(string5);
                            transformationOutputAttribute.setModified(true);
                        } else if (null != binLabels.getNumberSequence() && !(string4 = "NUMBER").equals(transformationOutputAttribute.getDataType())) {
                            transformationOutputAttribute.setDataType(string4);
                            transformationOutputAttribute.setModified(true);
                        }
                    }
                }
                string = DatabaseMetadataUtils.mapNumericSupportedType(this._context, string);
            } else if (string.equals("CHAR")) {
                string = "VARCHAR2";
                transformationOutputAttribute.setDataType(string);
                transformationOutputAttribute.setModified(true);
            } else if (string.equals("NCHAR")) {
                string = "NVARCHAR2";
                transformationOutputAttribute.setDataType(string);
                transformationOutputAttribute.setModified(true);
            } else if (string.equals("VARCHAR2")) {
                if (TransformationTypes.isBinning(transformationType2)) {
                    TransformationType.Binning binning = transformationType2.getBinning();
                    BinLabels binLabels = null;
                    if (null != binning.getEqualWidth()) {
                        binLabels = binning.getEqualWidth().getBinLabels();
                    } else if (null != binning.getQuantile()) {
                        binLabels = binning.getQuantile().getBinLabels();
                    } else if (null != binning.getCustomNumeric()) {
                        binLabels = binning.getCustomNumeric().getBinLabels();
                    }
                    if (binLabels != null) {
                        String string6;
                        if (null != binLabels.getNumberSequence()) {
                            string = "NUMBER";
                            transformationOutputAttribute.setDataType(string);
                            transformationOutputAttribute.setModified(true);
                        } else if (null != binLabels.getRange() && !(string6 = "VARCHAR2").equals(transformationOutputAttribute.getDataType())) {
                            transformationOutputAttribute.setDataType(string6);
                            transformationOutputAttribute.setModified(true);
                        }
                    }
                }
            } else if (string.equals("DATE") || DatabaseMetadataUtils.isTimestamp(string) || DatabaseMetadataUtils.isTimestampWithLocalTimeZone(string)) {
                if (TransformationTypes.isBinning(transformationType2)) {
                    TransformationType.Binning binning = transformationType2.getBinning();
                    BinLabels binLabels = null;
                    if (null != binning.getDateEqualWidth()) {
                        binLabels = binning.getDateEqualWidth().getBinLabels();
                    } else if (null != binning.getCustomDate()) {
                        binLabels = binning.getCustomDate().getBinLabels();
                    }
                    if (binLabels != null) {
                        String string7 = null;
                        if (null != binLabels.getNumberSequence()) {
                            string7 = "NUMBER";
                        } else if (null != binLabels.getRange()) {
                            string7 = "VARCHAR2";
                        }
                        if (string7 != null) {
                            transformationOutputAttribute.setDataType(string7);
                            transformationOutputAttribute.setModified(true);
                        }
                    }
                }
            } else if (DatabaseMetadataUtils.isTimestampWithTimeZone(string) && TransformationTypes.isBinning(transformationType2)) {
                TransformationType.Binning binning = transformationType2.getBinning();
                BinLabels binLabels = null;
                if (null != binning.getTimestampEqualWidth()) {
                    binLabels = binning.getTimestampEqualWidth().getBinLabels();
                } else if (null != binning.getCustomTimestamp()) {
                    binLabels = binning.getCustomTimestamp().getBinLabels();
                }
                if (binLabels != null) {
                    String string8 = null;
                    if (null != binLabels.getNumberSequence()) {
                        string8 = "NUMBER";
                    } else if (null != binLabels.getRange()) {
                        string8 = "VARCHAR2";
                    }
                    if (string8 != null) {
                        transformationOutputAttribute.setDataType(string8);
                        transformationOutputAttribute.setModified(true);
                    }
                }
            }
        } else {
            BinLabels binLabels;
            TransformationType.Binning binning;
            TransformationType transformationType = this.getResultTransformationType();
            if (TransformationTypes.isCustomXform(transformationType)) {
                string = this.getCustomDataType();
            } else if (DatabaseMetadataUtils.isNumericTypeSupported(this._context, string)) {
                if (TransformationTypes.isBinning(transformationType)) {
                    binning = transformationType.getBinning();
                    binLabels = null;
                    if (null != binning.getEqualWidth()) {
                        binLabels = binning.getEqualWidth().getBinLabels();
                    } else if (null != binning.getQuantile()) {
                        binLabels = binning.getQuantile().getBinLabels();
                    } else if (null != binning.getCustomNumeric()) {
                        binLabels = binning.getCustomNumeric().getBinLabels();
                    }
                    if (binLabels != null && null != binLabels.getRange()) {
                        string = "VARCHAR2";
                    }
                }
                if (DatabaseMetadataUtils.isNumericTypeSupported(this._context, string)) {
                    string = DatabaseMetadataUtils.mapNumericSupportedType(this._context, string);
                }
            } else if (string.equals("DATE") || DatabaseMetadataUtils.isTimestampWithLocalTimeZone(string) || DatabaseMetadataUtils.isTimestamp(string)) {
                if (TransformationTypes.isBinning(transformationType)) {
                    binning = transformationType.getBinning();
                    binLabels = null;
                    if (null != binning.getDateEqualWidth()) {
                        binLabels = binning.getDateEqualWidth().getBinLabels();
                    } else if (null != binning.getCustomDate()) {
                        binLabels = binning.getCustomDate().getBinLabels();
                    }
                    if (binLabels != null) {
                        if (null != binLabels.getRange()) {
                            string = "VARCHAR2";
                        } else if (null != binLabels.getNumberSequence()) {
                            string = "NUMBER";
                        }
                    }
                }
            } else if (DatabaseMetadataUtils.isTimestampWithTimeZone(string)) {
                if (TransformationTypes.isBinning(transformationType)) {
                    binning = transformationType.getBinning();
                    binLabels = null;
                    if (null != binning.getTimestampEqualWidth()) {
                        binLabels = binning.getTimestampEqualWidth().getBinLabels();
                    } else if (null != binning.getCustomTimestamp()) {
                        binLabels = binning.getCustomTimestamp().getBinLabels();
                    }
                    if (binLabels != null) {
                        if (null != binLabels.getRange()) {
                            string = "VARCHAR2";
                        } else if (null != binLabels.getNumberSequence()) {
                            string = "NUMBER";
                        }
                    }
                }
            } else if (string.equals("CHAR")) {
                string = "VARCHAR2";
            } else if (string.equals("NCHAR")) {
                string = "NVARCHAR2";
            }
            mapTransformedSource = new MapTransformedSource();
            binning = new TransformationOutputAttribute();
            binning.setModified(true);
            binning.setName(this.getNewColumnName());
            binning.setDataType(string);
            binning.setIsOutput(true);
            binning.setStatus(AttributeStatus.VALID);
            binning.setTransformationElementType(transformationType);
            mapTransformedSource.setKey((TransformationOutputAttribute)binning);
            binLabels = new StringCollection();
            binLabels.getValue().add(transformationSourceAttribute.getName());
            mapTransformedSource.setStringCollectionNames((StringCollection)binLabels);
        }
        return mapTransformedSource;
    }

    public abstract AttributeTypeHelper.ExTransformationSourceAttribute getSelectedSourceColumn();

    protected abstract void selectionChanged();

    protected void notifyPeer() {
        this.selectionChanged();
    }
}

