/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.transformations;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import oracle.dmt.dataminer.controls.TransformationPreferencesSettings;
import oracle.dmt.dataminer.expressionbuilder.AbstractExpressionBuilderContext;
import oracle.dmt.dataminer.expressionbuilder.ComputeFieldContext;
import oracle.dmt.dataminer.expressionbuilder.DialogsLrb;
import oracle.dmt.dataminer.expressionbuilder.ExpressionBuilderMainPanel;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.aggregate.AggregateEditExpressionPanel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DBHelper;
import oracle.dmt.dataminer.workflow.dialog.transformations.AddEditTransformsPanelAbstract;
import oracle.dmt.dataminer.workflow.dialog.transformations.CustomPanel;
import oracle.dmt.dataminer.workflow.dialog.transformations.EditTransformationsAbtractDialogEx;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationStatisticsState;
import oracle.dmt.dataminer.workflow.dialog.transformations.TransformationTypes;
import oracle.dmt.dataminer.workflow.dialog.transformations.XformDialogsLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.TransformationNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTransformedSource;
import oracle.dmt.dataminer.workflow.xmlschema.StringCollection;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationOutputAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributes;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;

public abstract class AddEditCustomTransformsDialogAbstractEx
extends EditTransformationsAbtractDialogEx {
    private static final Logger theLogger = Logger.getLogger(AddEditCustomTransformsDialogAbstractEx.class.getName());
    private TransformationPreferencesSettings transformSettings = TransformationPreferencesSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    protected ExpressionBuilderMainPanel dlg;
    protected AddEditTransformsPanelAbstract content;
    protected TransformationNodeType _cachedTransformationNodeType;
    protected TransformationStatisticsState state;
    protected boolean isPI = false;
    protected TransformationOutputAttribute _editedColumn;
    protected TransformationOutputAttribute _copyEditedColumn;
    protected boolean _bEditingMode = false;
    protected String _filter;
    protected String _outputColumnName;
    protected String _inputSQL;
    private static final String newAttributeQuery2 = "SELECT {0} AS \"{1}\" FROM ( {2} )";

    public AddEditCustomTransformsDialogAbstractEx(Context context, TransformationNode transformationNode, AbstractDataNode abstractDataNode, TransformationNodeType transformationNodeType, TransformationStatisticsState transformationStatisticsState, TransformationOutputAttribute transformationOutputAttribute, boolean bl) {
        super(context, transformationNode, abstractDataNode);
        this._cachedTransformationNodeType = transformationNodeType;
        this._editedColumn = transformationOutputAttribute;
        this.state = transformationStatisticsState;
        this.isPI = bl;
    }

    protected abstract List<AttributeType> getXformAttributes(AbstractDataNode var1);

    @Override
    protected void onDialogOK() {
        this._filter = this.dlg.getExpression();
        this._outputColumnName = this.dlg.getAttributeName();
        this._resultTransformationType = new TransformationType();
        this._resultTransformationType.setCustomTransformationEx(this._filter);
    }

    @Override
    protected JPanel getDialogContent() {
        Object object;
        AttributeType attributeType2;
        List<AttributeType> list = this.getXformAttributes(this.data);
        ArrayList<TransformationSourceAttribute> arrayList = new ArrayList<TransformationSourceAttribute>();
        if (null == list || list.isEmpty()) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_MSG"), (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_TITLE"), null);
            return null;
        }
        for (AttributeType attributeType2 : list) {
            TransformationSourceAttribute transformationSourceAttribute = null;
            if (attributeType2 instanceof TransformationSourceAttribute) {
                transformationSourceAttribute = AttributeTypeHelper.cloneTransformationAttribute(attributeType2);
            } else {
                transformationSourceAttribute = new TransformationSourceAttribute();
                AttributeTypeHelper.copyAttribute((AttributeType)transformationSourceAttribute, attributeType2);
                transformationSourceAttribute.setIsOutput(false);
            }
            arrayList.add(transformationSourceAttribute);
        }
        String[] stringArray = null;
        attributeType2 = this.state.getTransformedAttributes();
        if (attributeType2 != null && attributeType2.getMapTransformedSourceType() != null && !attributeType2.getMapTransformedSourceType().isEmpty()) {
            stringArray = new String[attributeType2.getMapTransformedSourceType().size()];
            int n = 0;
            for (Object object2 : attributeType2.getMapTransformedSourceType()) {
                stringArray[n++] = object2.getKey().getName();
            }
        }
        if (null != this._cachedTransformationNodeType && null != this._editedColumn) {
            this._copyEditedColumn = new TransformationOutputAttribute();
            AttributeTypeHelper.copyTransformationOutputAttribute(this._copyEditedColumn, this._editedColumn);
        }
        TransformedAttributes transformedAttributes = new TransformedAttributes();
        AttributeTypeHelper.copyTransformedAttributes(transformedAttributes, this._cachedTransformationNodeType.getTransformedAttributes());
        this._bEditingMode = this._copyEditedColumn != null;
        this._outputColumnName = !this._bEditingMode ? this.generateOutputName(transformedAttributes, arrayList) : this._editedColumn.getName();
        if (this._copyEditedColumn != null) {
            Object object2;
            object = this._copyEditedColumn.getTransformationElementType().getCustomTransformation();
            object2 = this._copyEditedColumn.getTransformationElementType().getCustomTransformationEx();
            if (object != null && object2 == null) {
                this._filter = object.getValue();
            } else if (object2 != null) {
                this._filter = object2;
            }
        }
        this._inputSQL = this.thisNode.getInputSQL(false);
        object = new ComputeFieldContext(this._inputSQL, this.state.getTransformationNode(), this._outputColumnName, this._filter, stringArray);
        this.dlg = new ExpressionBuilderMainPanel(this._context, (AbstractExpressionBuilderContext)object, true);
        return this.dlg;
    }

    private String generateOutputName(TransformedAttributes transformedAttributes, List<TransformationSourceAttribute> list) {
        String string = TransformationTypes.getXformAbbreviatedName(TransformationTypes.getTRANSFORMATION_TYPE_CUSTOM());
        String string2 = AttributeTypeHelper.createUniqueTransformationOutputName(this._context, null, string, list, transformedAttributes.getMapTransformedSourceType());
        return string2;
    }

    @Override
    public MapTransformedSource getTransformedAttribute() {
        MapTransformedSource mapTransformedSource = null;
        try {
            if (this._bEditingMode) {
                TransformationType transformationType;
                mapTransformedSource = AttributeTypeHelper.findMapTransformedSource(this._cachedTransformationNodeType.getTransformedAttributes(), (AttributeType)this._copyEditedColumn);
                TransformationOutputAttribute transformationOutputAttribute = mapTransformedSource.getKey();
                boolean bl = false;
                String string = transformationOutputAttribute.getName();
                if (0 != string.compareTo(this._outputColumnName)) {
                    transformationOutputAttribute.setName(this._outputColumnName);
                    bl = true;
                }
                if (!TransformationTypes.areEqual(this._resultTransformationType, transformationType = transformationOutputAttribute.getTransformationElementType())) {
                    transformationOutputAttribute.setTransformationElementType(this._resultTransformationType);
                    if (!bl) {
                        bl = true;
                    }
                }
                if (!transformationOutputAttribute.isModified()) {
                    transformationOutputAttribute.setModified(bl);
                }
                String string2 = this.validateExpression2();
                transformationOutputAttribute.setDataType(string2);
                transformationOutputAttribute.setModified(true);
            } else {
                mapTransformedSource = new MapTransformedSource();
                TransformationOutputAttribute transformationOutputAttribute = new TransformationOutputAttribute();
                transformationOutputAttribute.setModified(true);
                transformationOutputAttribute.setName(this._outputColumnName);
                String string = this.validateExpression2();
                transformationOutputAttribute.setDataType(string);
                transformationOutputAttribute.setIsOutput(true);
                transformationOutputAttribute.setStatus(AttributeStatus.VALID);
                transformationOutputAttribute.setTransformationElementType(this._resultTransformationType);
                mapTransformedSource.setKey(transformationOutputAttribute);
                StringCollection stringCollection = new StringCollection();
                mapTransformedSource.setStringCollectionNames(stringCollection);
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return mapTransformedSource;
    }

    private String validateExpression2() throws Exception {
        String string = this._filter;
        string = string.trim();
        String string2 = null;
        if (null == string || string.isEmpty()) {
            string2 = DialogsLrb.get("EXPBLDR_ERROR_EXPRESSION_EMPTY");
            throw new Exception(string2);
        }
        try {
            AggregateEditExpressionPanel.executeSQL(this._context, this._inputSQL);
        }
        catch (Exception exception) {
            TransformationNode transformationNode = this.state.getTransformationNode();
            AbstractNode abstractNode = transformationNode.findParentNode();
            boolean bl = abstractNode.validateCompleteChain(true);
            if (bl) {
                throw exception;
            }
            if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("EXPBLDR_PANEL_VALIDATE_RUN_PARENT_CONFIRM"), (String)XformDialogsLrb.get("ADD_TRANSFORMATION_DIALOG_ERROR_TITLE"), null)) {
                return "VARCHAR2";
            }
            throw new CustomPanel.ProceedWithoutValidationException();
        }
        StringBuilder stringBuilder = new StringBuilder(32000);
        stringBuilder.append(this.formNewAttributeQuery());
        String string3 = DBHelper.clientValidate(this._context, stringBuilder);
        return string3;
    }

    private String formNewAttributeQuery() {
        Object[] objectArray = new Object[]{this._filter, this._outputColumnName, this._inputSQL};
        return MessageFormat.format(newAttributeQuery2, objectArray);
    }

    @Override
    public boolean isUpdateWhenFinished() {
        boolean bl = this.transformSettings.isUpdateWhenFinished();
        if (bl) {
            bl = this.state.hasInputStatisticTable();
        }
        return bl;
    }

    protected List<AttributeType> getAvailableAttributes(final AbstractDataNode abstractDataNode) {
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        class GetAttrs
        extends ProgressRunnable {
            private List<AttributeType> cols;

            GetAttrs() {
            }

            public List<AttributeType> getColumns() {
                return this.cols;
            }

            protected Object doWork() throws Exception {
                if (abstractDataNode instanceof DataProvider) {
                    this.cols = AddEditCustomTransformsDialogAbstractEx.getColumnDetails(abstractDataNode.getAttributes().getAttribute());
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        }
        GetAttrs getAttrs = new GetAttrs();
        getAttrs.setTitle(WorkflowEditorLrb.get("LOAD_AVAIL_ATTRS"));
        getAttrs.setMessage(WorkflowEditorLrb.get("LOAD_AVAIL_ATTRS_DESCR"));
        getAttrs.setCancelable(false);
        try {
            getAttrs.start(true);
            if (null != getAttrs.getColumns()) {
                arrayList.addAll(getAttrs.getColumns());
            }
        }
        catch (ProgressException progressException) {
            theLogger.log(Level.SEVERE, progressException.getMessage(), progressException);
        }
        return arrayList;
    }

    public static List<AttributeType> getColumnDetails(List<AttributeType> list) {
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>(list.size());
        for (AttributeType attributeType : list) {
            AttributeType attributeType2 = new AttributeType();
            attributeType2.setName(attributeType.getName());
            attributeType2.setDataType(attributeType.getDataType());
            attributeType2.setDataTypeQualifier(attributeType.getDataTypeQualifier());
            attributeType2.setAlias(attributeType.getAlias());
            attributeType2.setAnnotation(attributeType.getAnnotation());
            attributeType2.setStatus(attributeType.getStatus());
            arrayList.add(attributeType2);
        }
        return arrayList;
    }
}

