/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.join;

import java.awt.Component;
import java.awt.Container;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import oracle.bali.share.nls.StringUtils;
import oracle.dmt.dataminer.DataMinerPreferenceSettings;
import oracle.dmt.dataminer.workflow.dialog.join.DialogsLrb;
import oracle.ide.config.Preferences;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;

public class JoinPreferencesPanel
extends DefaultTraversablePanel {
    private Boolean _automateSettingKey = true;
    private Boolean _automateSettingData = true;
    private JComboBox jAutoDataComboBox;
    private JLabel jAutoDataLabel;
    private JComboBox jAutoKeyComboBox;
    private JLabel jAutoKeyLabel;

    public JoinPreferencesPanel() {
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jAutoKeyLabel, (Component)this.jAutoKeyComboBox, (String)StringUtils.stripMnemonic((String)DialogsLrb.get("PREF_AUTOMATE_KEY_SETTING")));
        this.jAutoKeyLabel.getAccessibleContext().setAccessibleName("PREF_AUTOMATE_KEY_SETTING");
        this.jAutoKeyLabel.getAccessibleContext().setAccessibleDescription("PREF_AUTOMATE_KEY_SETTING_ADA");
        ResourceUtils.resLabel((JLabel)this.jAutoDataLabel, (Component)this.jAutoDataComboBox, (String)StringUtils.stripMnemonic((String)DialogsLrb.get("PREF_AUTOMATE_DATA_SETTING")));
        this.jAutoDataLabel.getAccessibleContext().setAccessibleName("PREF_AUTOMATE_DATA_SETTING");
        this.jAutoDataLabel.getAccessibleContext().setAccessibleDescription("PREF_AUTOMATE_DATA_SETTING_ADA");
        this.setHelpID("preferences_transforms_join");
    }

    public void initUI() {
        this.jAutoKeyComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{DialogsLrb.get("PREF_AUTOMATE_KEY_SETTING_ON"), DialogsLrb.get("PREF_AUTOMATE_KEY_SETTING_OFF")}));
        this.jAutoDataComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{DialogsLrb.get("PREF_AUTOMATE_DATA_SETTING_ON"), DialogsLrb.get("PREF_AUTOMATE_DATA_SETTING_OFF")}));
    }

    private void initComponents() {
        this.jAutoKeyLabel = new JLabel();
        this.jAutoKeyComboBox = new JComboBox();
        this.jAutoDataLabel = new JLabel();
        this.jAutoDataComboBox = new JComboBox();
        this.jAutoKeyLabel.setText("Automatic Key Column Deletion:");
        this.jAutoKeyLabel.setName("jAutoKeyLabel");
        this.jAutoKeyComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jAutoKeyComboBox.setName("jAutoKeyComboBox");
        this.jAutoDataLabel.setText("Automatic Data Column Option:");
        this.jAutoDataLabel.setName("jAutoDataLabel");
        this.jAutoDataComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jAutoDataComboBox.setName("jAutoDataComboBox");
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jAutoDataLabel, -1, -1, Short.MAX_VALUE).addComponent(this.jAutoKeyLabel, -1, -1, Short.MAX_VALUE)).addGap(5, 5, 5).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jAutoDataComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.jAutoKeyComboBox, 0, 132, Short.MAX_VALUE)).addContainerGap(100, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jAutoKeyLabel).addComponent(this.jAutoKeyComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jAutoDataComboBox, -2, -1, -2).addComponent(this.jAutoDataLabel)).addContainerGap(243, Short.MAX_VALUE)));
    }

    public void onEntry(TraversableContext traversableContext) {
        JoinPreferenceSettings joinPreferenceSettings = JoinPreferencesPanel.getCoolFeaturePrefs(traversableContext);
        this._automateSettingKey = joinPreferenceSettings.getAutomaticSettingKey();
        this.jAutoKeyComboBox.setSelectedItem(this._automateSettingKey != false ? DialogsLrb.get("PREF_AUTOMATE_KEY_SETTING_ON") : DialogsLrb.get("PREF_AUTOMATE_KEY_SETTING_OFF"));
        this._automateSettingData = joinPreferenceSettings.getAutomaticSettingData();
        this.jAutoDataComboBox.setSelectedItem(this._automateSettingData != false ? DialogsLrb.get("PREF_AUTOMATE_DATA_SETTING_ON") : DialogsLrb.get("PREF_AUTOMATE_DATA_SETTING_OFF"));
    }

    public void onExit(TraversableContext traversableContext) {
        JoinPreferenceSettings joinPreferenceSettings = JoinPreferencesPanel.getCoolFeaturePrefs(traversableContext);
        joinPreferenceSettings.setAutomaticSettingKey(this.jAutoKeyComboBox.getSelectedItem().equals(DialogsLrb.get("PREF_AUTOMATE_KEY_SETTING_ON")));
        joinPreferenceSettings.setAutomaticSettingData(this.jAutoDataComboBox.getSelectedItem().equals(DialogsLrb.get("PREF_AUTOMATE_DATA_SETTING_ON")));
    }

    private static JoinPreferenceSettings getCoolFeaturePrefs(TraversableContext traversableContext) {
        return JoinPreferenceSettings.getInstance(traversableContext.getPropertyStorage());
    }

    public static class JoinPreferenceSettings
    extends DataMinerPreferenceSettings {
        protected static final String DATA_KEY = "oracle.dmt.dataminer.workflow.JoinPreferenceSettings";

        public static JoinPreferenceSettings getInstance() {
            return JoinPreferenceSettings.getInstance((PropertyStorage)Preferences.getPreferences());
        }

        private JoinPreferenceSettings(HashStructure hashStructure) {
            super(hashStructure);
        }

        public static JoinPreferenceSettings getInstance(PropertyStorage propertyStorage) {
            return new JoinPreferenceSettings(JoinPreferenceSettings.findOrCreate((PropertyStorage)propertyStorage, (String)DATA_KEY));
        }

        public void setAutomaticSettingKey(boolean bl) {
            this._hash.putBoolean("automatic_setting_key", bl);
        }

        public boolean getAutomaticSettingKey() {
            return this._hash.getBoolean("automatic_setting_key", true);
        }

        public void setAutomaticSettingData(boolean bl) {
            this._hash.putBoolean("automatic_setting_data", bl);
        }

        public boolean getAutomaticSettingData() {
            return this._hash.getBoolean("automatic_setting_data", true);
        }
    }
}

