/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.featureCompare;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.workflow.dialog.featureCompare.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.featureCompare.FeatureCompareInputPanel;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.InputSourceType;
import oracle.javatools.ui.ghost.GhostPointingPalette;
import oracle.javatools.ui.ghost.UIConstants;

public class FeatureCompareEditValuePanel
extends JPanel
implements DataminerGUIPanel {
    private FeatureCompareInputPanel.AttributeTypeEditor editor;
    private GhostPointingPalette ownerDialog;
    private final String CUSTOM = "CUSTOM";
    private ButtonGroup buttonGroup;
    private JScrollPane inputValueScrollPane;
    private JTextPane inputValueTextPane;
    private JButton jCancelBtn;
    private JButton jOkBtn;

    public FeatureCompareEditValuePanel(FeatureCompareInputPanel.AttributeTypeEditor attributeTypeEditor) {
        this.editor = attributeTypeEditor;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        Object object = this.editor.getCellEditorValue();
        if (object instanceof AttributeType) {
            AttributeType attributeType = (AttributeType)object;
            if (DialogsLrb.get("EMPTY_COMBO").equals(attributeType.getName())) {
                this.inputValueTextPane.setText("");
            } else {
                this.inputValueTextPane.setText(attributeType.getName());
            }
        } else if (object instanceof InputSourceType.Custom.Attributes.Attribute) {
            InputSourceType.Custom.Attributes.Attribute attribute = (InputSourceType.Custom.Attributes.Attribute)object;
            if (DialogsLrb.get("EMPTY_COMBO").equals(attribute.getValue())) {
                this.inputValueTextPane.setText("");
            } else {
                this.inputValueTextPane.setText(attribute.getValue());
            }
        } else {
            this.inputValueTextPane.setText("");
        }
    }

    @Override
    public void initUI() {
        this.jOkBtn.addActionListener(new OkActionListener());
        this.jCancelBtn.addActionListener(new CancelActionListener());
    }

    public void showAsTooltipDialog(JComponent jComponent) {
        this.ownerDialog = new GhostPointingPalette();
        this.ownerDialog.setTitle(DialogsLrb.get("EDIT_CUSTOM_VALUE"));
        int n = jComponent.getSize().height - 2;
        this.ownerDialog.setPointing(jComponent, new Point(2, n));
        this.ownerDialog.setLook(UIConstants.Look.LIGHT);
        this.ownerDialog.setHideOnLoseFocus(true);
        this.ownerDialog.add((Component)this);
        this.ownerDialog.setCloseVisible(false);
        this.ownerDialog.setReceivesFocus(true);
        this.ownerDialog.pack();
        this.ownerDialog.show(true, true);
        Point point = jComponent.getLocation();
        Point point2 = this.ownerDialog.getLocation();
        int n2 = point.x - this.getWidth() - 5;
        this.ownerDialog.setLocation(n2, point2.y);
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.jOkBtn = new JButton();
        this.jCancelBtn = new JButton();
        this.inputValueScrollPane = new JScrollPane();
        this.inputValueTextPane = new JTextPane();
        this.jOkBtn.setText("OK");
        this.jOkBtn.setPreferredSize(new Dimension(65, 25));
        this.jCancelBtn.setText("Cancel");
        this.jCancelBtn.setPreferredSize(new Dimension(65, 25));
        this.inputValueScrollPane.setViewportView(this.inputValueTextPane);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(0, 114, Short.MAX_VALUE).addComponent(this.jCancelBtn, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jOkBtn, -2, 65, -2)).addComponent(this.inputValueScrollPane)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.inputValueScrollPane, -1, 227, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jOkBtn, -2, -1, -2).addComponent(this.jCancelBtn, -2, -1, -2)).addContainerGap()));
    }

    private class OkActionListener
    implements ActionListener {
        private OkActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InputSourceType.Custom.Attributes.Attribute attribute = new InputSourceType.Custom.Attributes.Attribute();
            attribute.setValue(FeatureCompareEditValuePanel.this.inputValueTextPane.getText());
            attribute.setValue(attribute.getValue().isEmpty() ? DialogsLrb.get("EMPTY_COMBO") : attribute.getValue());
            attribute.setSource("CUSTOM");
            FeatureCompareEditValuePanel.this.editor.commitChange(attribute);
            FeatureCompareEditValuePanel.this.ownerDialog.hidePanel();
        }
    }

    private class CancelActionListener
    implements ActionListener {
        private CancelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FeatureCompareEditValuePanel.this.editor.cancelCellEditing();
            FeatureCompareEditValuePanel.this.ownerDialog.hidePanel();
        }
    }
}

