/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.featureCompare;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.DBObjectNameEditor;
import oracle.dmt.dataminer.controls.DataMinerShuttlePanel;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.dialog.DialogOkExecutor;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.controls.renderers.AttributeNameCellRenderer;
import oracle.dmt.dataminer.core.utils.comparator.AttributeTypeComparator;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicNodesLrb;
import oracle.dmt.dataminer.workflow.dialog.featureCompare.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.featureCompare.FeatureCompareEditorState;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.FeatureCompareNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class FeatureCompareAddOutputPanel
extends JPanel {
    private static boolean dirty;
    private Context context;
    private JButton addItemBtn;
    private JButton autoItemBtn;
    private PropertyModel model;
    private JButton removeItemBtn;
    private FeatureCompareNode node;
    private DataMinerShuttlePanel shuttle;
    private FeatureCompareEditorState state;
    private FeatureCompareOutputTableModel tableModel;
    private AttributeNameCellRenderer modelCellRenderer;
    private DataMinerTablePanel outputTablePanel;

    public FeatureCompareAddOutputPanel(Context context, FeatureCompareNode featureCompareNode, FeatureCompareEditorState featureCompareEditorState, PropertyModel propertyModel) {
        this.node = featureCompareNode;
        this.context = context;
        this.model = propertyModel;
        this.state = featureCompareEditorState;
        dirty = false;
        this.modelCellRenderer = new AttributeNameCellRenderer(OracleIcons.getIcon((String)"attribute.png"), OracleIcons.getIcon((String)"warning.png"));
        this.initComponents();
        this.initRes();
        this.initShuttle();
        this.initTableBarComponents();
    }

    private boolean isInAdditionalOutput(AttributeType attributeType, AbstractDataNode abstractDataNode) {
        for (FeatureCompareOutputEntry featureCompareOutputEntry : this.tableModel.getSrcData()) {
            if (!featureCompareOutputEntry.getAttribute().getName().equals(attributeType.getName()) || !featureCompareOutputEntry.getSource().getData().getId().equals(abstractDataNode.getData().getId())) continue;
            return true;
        }
        return false;
    }

    private boolean isInDefaultOutput(AttributeType attributeType, FeatureCompareNode.DataInput dataInput) {
        switch (dataInput) {
            case INPUT_1: {
                return this.state.getCaseId1() != null && this.state.getCaseId1().getName().equals(attributeType.getName()) || this.state.getPartitionedAttrsInput1().containsKey(attributeType.getName());
            }
            case INPUT_2: {
                return this.state.getCaseId2() != null && this.state.getCaseId2().getName().equals(attributeType.getName()) || this.state.getPartitionedAttrsInput2().containsKey(attributeType.getName());
            }
        }
        return false;
    }

    private void initShuttle() {
        AttributeType attributeType;
        ArrayList<FeatureCompareOutputEntry> arrayList = new ArrayList<FeatureCompareOutputEntry>();
        ArrayList<FeatureCompareOutputEntry> arrayList2 = new ArrayList<FeatureCompareOutputEntry>();
        if (this.state.getSource1() != null && !this.state.getSource1().getData().getStatus().equals((Object)NodeStatusType.INVALID) && !this.state.getSource1().getData().getId().equals("-1") && this.state.getSource1().getAttributes() != null) {
            for (AttributeType attributeType2 : this.state.getSource1().getAttributes().getAttribute()) {
                if (this.isInDefaultOutput(attributeType2, FeatureCompareNode.DataInput.INPUT_1)) continue;
                attributeType = new AttributeType();
                attributeType.setName(attributeType2.getName());
                attributeType.setAlias(attributeType2.getAlias());
                attributeType.setDataType(attributeType2.getDataType());
                attributeType.setStatus(attributeType2.getStatus());
                attributeType.setDataTypeQualifier(attributeType2.getDataTypeQualifier());
                attributeType.setAnnotation(attributeType2.getAnnotation());
                if (this.isInAdditionalOutput(attributeType, this.state.getSource1())) {
                    arrayList2.add(new FeatureCompareOutputEntry(attributeType, this.state.getSource1()));
                    continue;
                }
                arrayList.add(new FeatureCompareOutputEntry(attributeType, this.state.getSource1()));
            }
        }
        if (this.state.getSource2() != null && !this.state.getSource2().getData().getStatus().equals((Object)NodeStatusType.INVALID) && !this.state.getSource2().getData().getId().equals("-1") && this.state.getSource2().getAttributes() != null) {
            for (AttributeType attributeType2 : this.state.getSource2().getAttributes().getAttribute()) {
                if (this.isInDefaultOutput(attributeType2, FeatureCompareNode.DataInput.INPUT_2)) continue;
                attributeType = new AttributeType();
                attributeType.setName(attributeType2.getName());
                attributeType.setAlias(attributeType2.getAlias());
                attributeType.setDataType(attributeType2.getDataType());
                attributeType.setStatus(attributeType2.getStatus());
                attributeType.setDataTypeQualifier(attributeType2.getDataTypeQualifier());
                attributeType.setAnnotation(attributeType2.getAnnotation());
                if (this.isInAdditionalOutput(attributeType, this.state.getSource2())) {
                    arrayList2.add(new FeatureCompareOutputEntry(attributeType, this.state.getSource2()));
                    continue;
                }
                arrayList.add(new FeatureCompareOutputEntry(attributeType, this.state.getSource2()));
            }
        }
        this.shuttle = new DataMinerShuttlePanel(DialogsLrb.get("EDIT_OUTPUT_DATA"), "help_topic", new DataMinerShuttlePanel.ShuttleData(DialogsLrb.get("AVAILABLE_ATTRIBUTES"), new FeatureCompareShuttleModel((List<FeatureCompareOutputEntry>)arrayList)), new DataMinerShuttlePanel.ShuttleData(DialogsLrb.get("SELECTED_ATTRIBUTES"), new FeatureCompareShuttleModel((List<FeatureCompareOutputEntry>)arrayList2)));
    }

    private void initRes() {
        this.state.addPropertyChangeListener(new StateChanged());
        this.tableModel = new FeatureCompareOutputTableModel((List<FeatureCompareOutputEntry>)new ArrayList<FeatureCompareOutputEntry>());
        this.setTable();
        this.outputTablePanel.setup((TableModel)((Object)this.tableModel), DialogsLrb.get("OUTPUT_TABLE_NAME"), 0, true);
        this.outputTablePanel.getTable().getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            int n = this.outputTablePanel.getTable().getSelectedRow();
            if (n != -1) {
                n = this.outputTablePanel.getTable().convertRowIndexToModel(n);
                String string = ((AttributeType)this.outputTablePanel.getTable().getModel().getValueAt(n, 0)).getName();
                if (this.state.getCaseId1() != null && this.state.getCaseId1().getName().equals(string) || this.state.getCaseId2() != null && this.state.getCaseId2().getName().equals(string) || this.state.getPartitionedAttrsInput1().containsKey(string) || this.state.getPartitionedAttrsInput2().containsKey(string)) {
                    this.removeItemBtn.setEnabled(false);
                } else {
                    this.removeItemBtn.setEnabled(true);
                }
            }
        });
        this.outputTablePanel.getTable().getFullColumnModel().getColumn(2).setCellEditor(new DBObjectNameEditor(this.context));
        this.outputTablePanel.getTable().getFullColumnModel().getColumn(0).setCellRenderer(this.modelCellRenderer);
    }

    private void setTable() {
        ArrayList<FeatureCompareOutputEntry> arrayList = new ArrayList<FeatureCompareOutputEntry>();
        if (this.state.getSource1() != null && this.state.getCaseId1() != null) {
            arrayList.add(new FeatureCompareOutputEntry(this.state.getCaseId1(), this.state.getSource1()));
        }
        if (this.state.getSource2() != null && this.state.getCaseId2() != null) {
            arrayList.add(new FeatureCompareOutputEntry(this.state.getCaseId2(), this.state.getSource2()));
        }
        for (String string : this.state.getPartitionedAttrsInput1().keySet()) {
            arrayList.add(new FeatureCompareOutputEntry(this.state.getPartitionedAttrsInput1().get(string), this.state.getSource1()));
        }
        for (String string : this.state.getPartitionedAttrsInput2().keySet()) {
            arrayList.add(new FeatureCompareOutputEntry(this.state.getPartitionedAttrsInput2().get(string), this.state.getSource2()));
        }
        for (String string : this.state.getAdditionalOutput1().keySet()) {
            arrayList.add(new FeatureCompareOutputEntry(this.state.getAdditionalOutput1().get(string), this.state.getSource1()));
        }
        for (String string : this.state.getAdditionalOutput2().keySet()) {
            arrayList.add(new FeatureCompareOutputEntry(this.state.getAdditionalOutput2().get(string), this.state.getSource2()));
        }
        this.tableModel.setSrcData(arrayList);
    }

    private void initTableBarComponents() {
        this.addItemBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.addItemBtn.setToolTipText(DialogsLrb.get("ADD_ITEM_ICON_ADA"));
        this.addItemBtn.getAccessibleContext().setAccessibleName(CommonLrb.get("COMMON_ADD"));
        this.addItemBtn.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("ADD_ITEM_ICON_ADA"));
        this.addItemBtn.addActionListener(actionEvent -> {
            DialogHelper dialogHelper = new DialogHelper(this.shuttle);
            dialogHelper.setDialogOkExecutor(new DialogOkExecutor(){

                @Override
                public void onOK() throws DialogExecutionException {
                    FeatureCompareAddOutputPanel.this.state.getAdditionalOutput1().clear();
                    FeatureCompareAddOutputPanel.this.state.getAdditionalOutput2().clear();
                    for (Object e : FeatureCompareAddOutputPanel.this.shuttle.getSelected()) {
                        FeatureCompareOutputEntry featureCompareOutputEntry = (FeatureCompareOutputEntry)e;
                        if (FeatureCompareAddOutputPanel.this.state.getSource1() != null && FeatureCompareAddOutputPanel.this.state.getSource1().getData().getId().equals(featureCompareOutputEntry.getSource().getData().getId())) {
                            if (FeatureCompareAddOutputPanel.this.state.getAdditionalOutput2().containsKey(featureCompareOutputEntry.getAttribute().getName())) {
                                FeatureCompareAddOutputPanel.this.state.getAdditionalOutput2().get(featureCompareOutputEntry.getAttribute().getName()).setAlias(featureCompareOutputEntry.getAttribute().getName() + "_2");
                            }
                            FeatureCompareAddOutputPanel.this.state.addAdditionalOutput1(featureCompareOutputEntry.getAttribute().getName(), featureCompareOutputEntry.getAttribute());
                            continue;
                        }
                        if (FeatureCompareAddOutputPanel.this.state.getSource2() == null || !FeatureCompareAddOutputPanel.this.state.getSource2().getData().getId().equals(featureCompareOutputEntry.getSource().getData().getId())) continue;
                        if (FeatureCompareAddOutputPanel.this.state.getAdditionalOutput1().containsKey(featureCompareOutputEntry.getAttribute().getName())) {
                            featureCompareOutputEntry.getAttribute().setAlias(featureCompareOutputEntry.getAttribute().getName() + "_2");
                        }
                        FeatureCompareAddOutputPanel.this.state.addAdditionalOutput2(featureCompareOutputEntry.getAttribute().getName(), featureCompareOutputEntry.getAttribute());
                    }
                    FeatureCompareAddOutputPanel.this.setTable();
                }
            });
            dialogHelper.showAsDialog();
            dirty = true;
        });
        this.removeItemBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this.removeItemBtn.setToolTipText(DialogsLrb.get("REMOVE_ITEM_ICON_ADA"));
        this.removeItemBtn.getAccessibleContext().setAccessibleName(CommonLrb.get("COMMON_REMOVE"));
        this.removeItemBtn.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("REMOVE_ITEM_ICON_ADA"));
        this.removeItemBtn.setEnabled(false);
        this.removeItemBtn.addActionListener(actionEvent -> {
            int n = this.outputTablePanel.getTable().getSelectedRow();
            if (n != -1) {
                n = this.outputTablePanel.getTable().convertRowIndexToModel(n);
                FeatureCompareOutputEntry featureCompareOutputEntry = (FeatureCompareOutputEntry)this.tableModel.getRow(n);
                if (featureCompareOutputEntry.getSource().getData().getId().equals(this.state.getSource1().getData().getId())) {
                    this.state.rmvAdditionalOutput1(featureCompareOutputEntry.getAttribute().getName());
                } else {
                    this.state.rmvAdditionalOutput2(featureCompareOutputEntry.getAttribute().getName());
                }
                this.initShuttle();
            }
            dirty = true;
        });
        this.autoItemBtn = new JButton(DataMinerIcons.get(Icons.AUTO_USAGE));
        this.autoItemBtn.setText(CommonLrb.get("COMMON_RESET"));
        this.autoItemBtn.setToolTipText(DialogsLrb.get("AUTO_ITEM_ICON_ADA"));
        this.autoItemBtn.getAccessibleContext().setAccessibleName(CommonLrb.get("COMMON_RESET"));
        this.autoItemBtn.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("AUTO_ITEM_ICON_ADA"));
        this.autoItemBtn.addActionListener(actionEvent -> {
            if (1 == MessageDialog.optionalConfirmOrCancel((String)"DATA_MINER_ADDITIONAL_OUTPUT_WARNING_ID", (Component)Ide.getMainWindow(), (Object)DynamicNodesLrb.get("SUPPLEMENTAL_SETTINGS_WARNING"), (String)DynamicNodesLrb.get("SUPPLEMENTAL_SETTINGS_WARNING_TITLE"), null)) {
                this.state.clearAdditionalOutput1();
                this.state.clearAdditionalOutput2();
                this.setTable();
                this.initShuttle();
                dirty = true;
            }
        });
        this.outputTablePanel.addControlBarComponents(this.addItemBtn, this.removeItemBtn, this.autoItemBtn);
    }

    public boolean isDirty() {
        return dirty;
    }

    private void initComponents() {
        this.outputTablePanel = new DataMinerTablePanel();
        this.setPreferredSize(new Dimension(800, 500));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.outputTablePanel, -1, 380, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.outputTablePanel, -1, 278, Short.MAX_VALUE).addContainerGap()));
    }

    public static class FeatureCompareOutputEntry {
        private AttributeType attribute;
        private AbstractDataNode source;

        public FeatureCompareOutputEntry(AttributeType attributeType, AbstractDataNode abstractDataNode) {
            this.attribute = attributeType;
            this.source = abstractDataNode;
        }

        public void setAttribute(AttributeType attributeType) {
            this.attribute = attributeType;
        }

        public AttributeType getAttribute() {
            return this.attribute;
        }

        public void setSource(AbstractDataNode abstractDataNode) {
            this.source = abstractDataNode;
        }

        public AbstractDataNode getSource() {
            return this.source;
        }
    }

    public static class FeatureCompareOutputTableModel
    extends ODMrTableModel<FeatureCompareOutputEntry> {
        private static final int ATTRIBUTE_NAME = 0;
        private static final int ATTRIBUTE_SOURCE = 1;
        private static final int ATTRIBUTE_ALIAS = 2;
        private static final int ATTRIBUTE_TYPE = 3;
        private static final String[] _columns = new String[]{CommonLrb.get("NAME"), CommonLrb.get("COMMON_SOURCE"), CommonLrb.get("COMMON_ALIAS"), CommonLrb.get("DATA_TYPE")};

        public FeatureCompareOutputTableModel(List<FeatureCompareOutputEntry> list) {
            super(_columns, list);
        }

        public Object getValueAt(int n, int n2) {
            Object object = null;
            FeatureCompareOutputEntry featureCompareOutputEntry = (FeatureCompareOutputEntry)this.srcData.get(n);
            switch (n2) {
                case 0: {
                    object = featureCompareOutputEntry.getAttribute();
                    break;
                }
                case 1: {
                    object = featureCompareOutputEntry.getSource().getData().getName();
                    break;
                }
                case 2: {
                    object = featureCompareOutputEntry.getAttribute().getAlias();
                    break;
                }
                case 3: {
                    object = featureCompareOutputEntry.getAttribute().getDataType();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        @Override
        public String getStringValueAt(int n, int n2) {
            String string = "";
            FeatureCompareOutputEntry featureCompareOutputEntry = (FeatureCompareOutputEntry)this.srcData.get(n);
            switch (n2) {
                case 0: {
                    string = featureCompareOutputEntry.getAttribute().getName();
                    break;
                }
                case 1: {
                    string = featureCompareOutputEntry.getSource().getData().getName();
                    break;
                }
                case 2: {
                    string = featureCompareOutputEntry.getAttribute().getAlias();
                    break;
                }
                case 3: {
                    string = featureCompareOutputEntry.getAttribute().getDataType();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 2) {
                FeatureCompareOutputEntry featureCompareOutputEntry = (FeatureCompareOutputEntry)this.srcData.get(n);
                featureCompareOutputEntry.getAttribute().setAlias(((String)object).toUpperCase());
                dirty = true;
            }
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 2;
        }

        public Comparator getColumnSortComparator(int n) {
            switch (n) {
                case 0: {
                    return AttributeTypeComparator.getComparator();
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return super.getColumnSortComparator(n);
        }
    }

    public class StateChanged
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("newCaseId1") && propertyChangeEvent.getNewValue() != null && FeatureCompareAddOutputPanel.this.isInAdditionalOutput((AttributeType)propertyChangeEvent.getNewValue(), FeatureCompareAddOutputPanel.this.state.getSource1())) {
                FeatureCompareAddOutputPanel.this.state.getAdditionalOutput1().remove(((AttributeType)propertyChangeEvent.getNewValue()).getName());
            } else if (propertyChangeEvent.getPropertyName().equals("newCaseId2") && propertyChangeEvent.getNewValue() != null && FeatureCompareAddOutputPanel.this.isInAdditionalOutput((AttributeType)propertyChangeEvent.getNewValue(), FeatureCompareAddOutputPanel.this.state.getSource2())) {
                FeatureCompareAddOutputPanel.this.state.getAdditionalOutput2().remove(((AttributeType)propertyChangeEvent.getNewValue()).getName());
            }
            FeatureCompareAddOutputPanel.this.setTable();
            FeatureCompareAddOutputPanel.this.initShuttle();
        }
    }

    public static class FeatureCompareShuttleModel
    extends ODMrTableModel<FeatureCompareOutputEntry> {
        private static final int ATTRIBUTE_NAME = 0;
        private static final int ATTRIBUTE_SOURCE = 1;
        private static final int ATTRIBUTE_TYPE = 2;
        private static final String[] _columns = new String[]{CommonLrb.get("NAME"), CommonLrb.get("COMMON_SOURCE"), CommonLrb.get("DATA_TYPE")};

        public FeatureCompareShuttleModel(List<FeatureCompareOutputEntry> list) {
            super(_columns, list);
        }

        public Object getValueAt(int n, int n2) {
            String string = null;
            FeatureCompareOutputEntry featureCompareOutputEntry = (FeatureCompareOutputEntry)this.srcData.get(n);
            switch (n2) {
                case 0: {
                    string = featureCompareOutputEntry.getAttribute().getName();
                    break;
                }
                case 1: {
                    string = featureCompareOutputEntry.getSource().getData().getName();
                    break;
                }
                case 2: {
                    string = featureCompareOutputEntry.getAttribute().getDataType();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return string;
        }
    }
}

