/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.dynamic.prediction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicNodeEditorState;
import oracle.dmt.dataminer.workflow.dialog.dynamic.prediction.ColumnGeneratorHelper;
import oracle.dmt.dataminer.workflow.dialog.dynamic.prediction.PredictionOutputsTableModel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.prediction.PredictionTargetsTableModel;
import oracle.dmt.dataminer.workflow.model.DynamicPredictionNode;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicApplyOutputColumnType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicApplyOutputColumns;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicPredictionNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.PredictionAttributesType;
import oracle.dmt.dataminer.workflow.xmlschema.TargetAttributes;
import oracle.ide.Context;

public class PredictionEditorState
extends DynamicNodeEditorState {
    private TargetAttributes _targetAttributes;
    private PredictionAttributesType _predictionAttributes;
    private Map<String, List<DynamicApplyOutputColumnType>> _mapTargetToDynamicApplyOutputColumns = new HashMap<String, List<DynamicApplyOutputColumnType>>();
    private PredictionTargetsTableModel _tableModelPredictionTargets;
    private PredictionOutputsTableModel _tableModelPredictionOutputs;

    public PredictionEditorState(Context context, DynamicPredictionNode dynamicPredictionNode, DynamicPredictionNodeType dynamicPredictionNodeType) {
        super(context, dynamicPredictionNode, dynamicPredictionNodeType.getDynamicNodeBaseSettings());
        this._predictionAttributes = dynamicPredictionNodeType.getPredictionAttributes();
        this._targetAttributes = this._predictionAttributes.getTargetAttributes();
        this._dynamicApplyOutputColumns = this.getBaseSettings().getDynamicApplyOutputColumns();
        this.constructDynamicApplyOutputColumnMaps();
        this._mapInputMiningAttributes = new HashMap();
        for (MiningAttributeType miningAttributeType : this.getMiningAttributes().getMiningAttribute()) {
            this._mapInputMiningAttributes.put(miningAttributeType.getName(), miningAttributeType);
        }
        this._tableModelPredictionTargets = new PredictionTargetsTableModel(this._targetAttributes);
        this._tableModelPredictionOutputs = new PredictionOutputsTableModel(this._dynamicApplyOutputColumns, this._mapInputMiningAttributes, null);
    }

    @Override
    protected void constructDynamicApplyOutputColumnMaps() {
        if (!this._mapTargetToDynamicApplyOutputColumns.isEmpty()) {
            this._mapTargetToDynamicApplyOutputColumns.clear();
        }
        for (DynamicApplyOutputColumnType dynamicApplyOutputColumnType : this._dynamicApplyOutputColumns.getDynamicApplyOutputColumn()) {
            String string = dynamicApplyOutputColumnType.getTargetAttributeName();
            List<DynamicApplyOutputColumnType> list = this._mapTargetToDynamicApplyOutputColumns.get(string);
            if (list == null) {
                list = new ArrayList<DynamicApplyOutputColumnType>();
                this._mapTargetToDynamicApplyOutputColumns.put(string, list);
            }
            list.add(dynamicApplyOutputColumnType);
        }
    }

    public void updatePredictionTargetsModel() {
        this._tableModelPredictionTargets = new PredictionTargetsTableModel(this._targetAttributes);
    }

    @Override
    public void updatePredictionOutputsModel() {
        this._tableModelPredictionOutputs = new PredictionOutputsTableModel(this._dynamicApplyOutputColumns, this._mapInputMiningAttributes, this.getAllTargetValues());
    }

    @Override
    public TargetAttributes getTargetAttributes() {
        return this._targetAttributes;
    }

    public MiningAttributeType findTargetAttribute(String string) {
        MiningAttributeType miningAttributeType = null;
        for (MiningAttributeType miningAttributeType2 : this._targetAttributes.getMiningAttribute()) {
            if (!miningAttributeType2.getName().equals(string)) continue;
            miningAttributeType = miningAttributeType2;
            break;
        }
        return miningAttributeType;
    }

    @Override
    public List<MiningAttributeType> getTargetAttributeList() {
        return this._targetAttributes.getMiningAttribute();
    }

    public void removeTargetsFromList(List<MiningAttributeType> list) {
        List list2 = this._targetAttributes.getMiningAttribute();
        list2.removeAll(list);
        this.updatePredictionTargetsModel();
    }

    @Override
    public boolean isTargetAttribute(MiningAttributeType miningAttributeType) {
        boolean bl = false;
        List list = this._targetAttributes.getMiningAttribute();
        for (MiningAttributeType miningAttributeType2 : list) {
            if (!miningAttributeType2.getName().equals(miningAttributeType.getName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public List<MiningAttributeType> getListOfTargetsToRemove(List<MiningAttributeType> list) {
        ArrayList<MiningAttributeType> arrayList = new ArrayList<MiningAttributeType>();
        List list2 = this._targetAttributes.getMiningAttribute();
        if (list == null || list.isEmpty()) {
            return list2;
        }
        HashMap<String, MiningAttributeType> hashMap = new HashMap<String, MiningAttributeType>();
        for (MiningAttributeType miningAttributeType : list) {
            hashMap.put(miningAttributeType.getName(), miningAttributeType);
        }
        for (MiningAttributeType miningAttributeType : list2) {
            if (null != hashMap.get(miningAttributeType.getName())) continue;
            arrayList.add(miningAttributeType);
        }
        return arrayList;
    }

    public void removeUnusedPredictionTargets(List<MiningAttributeType> list) {
        ArrayList<DynamicApplyOutputColumnType> arrayList = new ArrayList<DynamicApplyOutputColumnType>();
        for (MiningAttributeType miningAttributeType : list) {
            List<DynamicApplyOutputColumnType> list2 = this._mapTargetToDynamicApplyOutputColumns.get(miningAttributeType.getName());
            if (null == list2 || list2.isEmpty()) continue;
            arrayList.addAll(list2);
        }
        if (!arrayList.isEmpty()) {
            Iterator iterator = this._dynamicApplyOutputColumns.getDynamicApplyOutputColumn();
            iterator.removeAll(arrayList);
            this.constructDynamicApplyOutputColumnMaps();
        }
        this.updatePredictionOutputsModel();
        for (DynamicApplyOutputColumnType dynamicApplyOutputColumnType : arrayList) {
            this.removeUniqueName(dynamicApplyOutputColumnType);
        }
    }

    public List<DynamicApplyOutputColumnType> getResetList(List<MiningAttributeType> list) {
        ArrayList<DynamicApplyOutputColumnType> arrayList = new ArrayList<DynamicApplyOutputColumnType>();
        for (MiningAttributeType miningAttributeType : list) {
            List<DynamicApplyOutputColumnType> list2 = this._mapTargetToDynamicApplyOutputColumns.get(miningAttributeType.getName());
            if (null == list2 || list2.isEmpty()) continue;
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    public void resetPredictionTargets(List<MiningAttributeType> list, List<DynamicApplyOutputColumnType> list2) {
        Object object2;
        for (Object object2 : list) {
            MiningAttributeType miningAttributeType = this.findTargetAttribute(object2.getName());
            if (miningAttributeType == null) continue;
            miningAttributeType.setMiningType(object2.getMiningType());
        }
        List list3 = this._dynamicApplyOutputColumns.getDynamicApplyOutputColumn();
        list3.removeAll(list2);
        object2 = this.generateDefaultPredictionOutputs(list);
        this.addPredictionTargets((List<DynamicApplyOutputColumnType>)object2);
        this.updatePredictionOutputsModel();
        this.constructDynamicApplyOutputColumnMaps();
    }

    public void addPredictionTargets(List<DynamicApplyOutputColumnType> list) {
        List list2 = this._dynamicApplyOutputColumns.getDynamicApplyOutputColumn();
        list2.addAll(list);
        this.constructDynamicApplyOutputColumnMaps();
        this.updatePredictionOutputsModel();
    }

    public void addPredictionTarget(DynamicApplyOutputColumnType dynamicApplyOutputColumnType) {
        List list = this._dynamicApplyOutputColumns.getDynamicApplyOutputColumn();
        list.add(dynamicApplyOutputColumnType);
        this.updatePredictionOutputsModel();
        this.constructDynamicApplyOutputColumnMaps();
    }

    public List<MiningAttributeType> getListOfTargetsToAdd(List<MiningAttributeType> list) {
        ArrayList<MiningAttributeType> arrayList = new ArrayList<MiningAttributeType>();
        if (list == null || list.isEmpty()) {
            return arrayList;
        }
        HashMap<String, MiningAttributeType> hashMap = new HashMap<String, MiningAttributeType>();
        List list2 = this._targetAttributes.getMiningAttribute();
        for (MiningAttributeType miningAttributeType : list2) {
            hashMap.put(miningAttributeType.getName(), miningAttributeType);
        }
        for (MiningAttributeType miningAttributeType : list) {
            if (null != hashMap.get(miningAttributeType.getName())) continue;
            arrayList.add(miningAttributeType);
        }
        return arrayList;
    }

    public String getAttributeMiningType(String string) {
        return ((MiningAttributeType)this._mapInputMiningAttributes.get(string)).getMiningType();
    }

    public DynamicApplyOutputColumns getDynamicApplyOutputColumns() {
        return this._dynamicApplyOutputColumns;
    }

    public Map<String, MiningAttributeType> getMapInputMiningAttributes() {
        return this._mapInputMiningAttributes;
    }

    public PredictionTargetsTableModel getTableModelPredictionTargets() {
        return this._tableModelPredictionTargets;
    }

    public List<DynamicApplyOutputColumnType> generateDefaultPredictionOutputs(List<MiningAttributeType> list) {
        ArrayList<DynamicApplyOutputColumnType> arrayList = new ArrayList<DynamicApplyOutputColumnType>();
        for (MiningAttributeType miningAttributeType : list) {
            arrayList.add(ColumnGeneratorHelper.generateDefaultPredictionOutput(miningAttributeType.getName(), this._outputColumnNameGenerator, true));
            arrayList.add(ColumnGeneratorHelper.generateDefaultPredictionDetailsOutput(miningAttributeType.getName(), this._outputColumnNameGenerator, true));
            if (!DatabaseMetadataUtils.isACharacterOracleDataType(miningAttributeType.getDataType()) && !miningAttributeType.getMiningType().equals("Categorical")) continue;
            arrayList.add(ColumnGeneratorHelper.generateDefaultPredictionProbabilityOutput(miningAttributeType.getName(), this._outputColumnNameGenerator, true));
        }
        return arrayList;
    }

    @Override
    public DynamicApplyOutputColumnType generateDynamicApplyOutputColumn(String string, String string2) {
        return ColumnGeneratorHelper.generateDynamicApplyOutputColumn(string, this._outputColumnNameGenerator, string2);
    }

    public PredictionOutputsTableModel getTableModelPredictionOutputs() {
        return this._tableModelPredictionOutputs;
    }

    @Override
    public Map<String, Vector<Object>> getAllTargetValues() {
        DynamicPredictionNode dynamicPredictionNode = (DynamicPredictionNode)this.getNode();
        return dynamicPredictionNode.getAllTargetValues();
    }

    @Override
    public Vector<Object> getNodeSpecificTargetValues(String string) {
        Map<String, Vector<Object>> map = this.getAllTargetValues();
        Vector<Object> vector = DynamicPredictionNode.getTargetValues(map, string);
        return vector;
    }
}

