/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.dynamic;

import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.core.utils.comparator.AttributeTypeComparator;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicNodesLrb;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.SupplementalAttributesType;

public class OutputDataTableModel
extends SimpleBaseTableModel {
    static final int USAGE_ATTRIBUTE_NAME = 0;
    static final int USAGE_DATA_TYPE = 1;
    Vector<AttributeType> _data = new Vector();
    SupplementalAttributesType _supAttributes;

    public OutputDataTableModel(SupplementalAttributesType supplementalAttributesType) {
        this._supAttributes = supplementalAttributesType;
        Vector<String> vector = new Vector<String>();
        vector.add(DynamicNodesLrb.get("BUILD_DATA_USAGE_ATTRS"));
        vector.add(DynamicNodesLrb.get("BUILD_DATA_USAGE_DATA_TYPE"));
        this.setColumnIdentifiers(vector);
        this.fillData();
        if (this._data.isEmpty()) {
            this.setRowCount(0);
            return;
        }
        this.setRowCount(this._data.size());
        this.setColumnCount(vector.size());
    }

    public void removeAttributes(Vector<AttributeType> vector) {
        this.setRowCount(0);
        for (AttributeType attributeType : vector) {
            this._data.remove(attributeType);
        }
        this.setRowCount(this._data.size());
    }

    private void fillData() {
        for (AttributeType attributeType : this._supAttributes.getAttribute()) {
            this._data.add(attributeType);
        }
    }

    public Vector getDataVector() {
        return this._data;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public Object getValueAt(int n, int n2) {
        if (n >= this._data.size()) {
            return new AttributeType();
        }
        AttributeType attributeType = this._data.get(n);
        Object object = null;
        if (0 == n2) {
            object = attributeType;
        } else if (1 == n2) {
            String string = attributeType.getDataType();
            String string2 = attributeType.getDataTypeQualifier();
            object = DatabaseMetadataUtils.isACharacterOracleDataType(string) ? DatabaseMetadataUtils.getJSONDataType(string, string2) : string;
        }
        return object != null ? object : "";
    }

    public AttributeType getRowData(int n) {
        List list = this._supAttributes.getAttribute();
        AttributeType attributeType = (AttributeType)list.get(n);
        return attributeType;
    }

    public void refresh() {
        this.setRowCount(0);
        this._data.clear();
        this.fillData();
        this.setRowCount(this._data.size());
    }

    public Comparator getColumnSortComparator(int n) {
        if (n == 0) {
            return AttributeTypeComparator.getComparator();
        }
        return super.getColumnSortComparator(n);
    }
}

