/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.dynamic;

import java.awt.BorderLayout;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import oracle.dmt.dataminer.controls.models.ModelHeuristicRules;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.dialog.AbstractPanel;
import oracle.dmt.dataminer.workflow.dialog.build.DataUsagePanel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicNodeEditorState;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicNodesLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.OuputColumnsPanel;
import oracle.dmt.dataminer.workflow.dialog.dynamic.partition.PartitionLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.partition.PartitionPanel;
import oracle.dmt.dataminer.workflow.model.DynamicNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicNodeBaseSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.TransformsNodeType;
import oracle.ide.Context;

public abstract class DynamicEditorPanel<T extends DynamicNode>
extends AbstractPanel<T> {
    private JPanel jInputTab;
    private DataUsagePanel jInputHostPanel;
    private JPanel jOutputTab;
    protected OuputColumnsPanel jOutputHostPanel;
    private PartitionPanel jPartitionHostPanel;
    private JPanel jPartitionTab;

    public void createTabs(DynamicNodeEditorState dynamicNodeEditorState, JTabbedPane jTabbedPane, Map<String, ModelHeuristicRules> map) {
        MiningAttributeType miningAttributeType2;
        MiningAttributes miningAttributes = dynamicNodeEditorState.getMiningAttributes();
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        HashMap<String, AttributeType> hashMap2 = new HashMap<String, AttributeType>();
        HashMap<String, AttributeType> hashMap3 = new HashMap<String, AttributeType>();
        for (MiningAttributeType miningAttributeType2 : dynamicNodeEditorState.getTargetAttributeList()) {
            hashMap.put(miningAttributeType2.getName(), (AttributeType)miningAttributeType2);
        }
        for (MiningAttributeType miningAttributeType2 : dynamicNodeEditorState.getCaseAttributes().getAttribute()) {
            hashMap2.put(miningAttributeType2.getName(), (AttributeType)miningAttributeType2);
        }
        for (MiningAttributeType miningAttributeType2 : dynamicNodeEditorState.getPartitionExpressions().getPartitionExpression()) {
            if (miningAttributeType2.getSQLExpression() != null) continue;
            AttributeType attributeType = miningAttributeType2.getPartitionAttribute();
            hashMap3.put(attributeType.getName(), attributeType);
        }
        this.jInputTab = new JPanel();
        this.jInputTab.setLayout(new BorderLayout());
        Object object = null;
        miningAttributeType2 = null;
        if (dynamicNodeEditorState.getNode().getData() instanceof TransformsNodeType) {
            miningAttributeType2 = (TransformsNodeType)dynamicNodeEditorState.getNode().getData();
        }
        if (dynamicNodeEditorState.getNode() instanceof DynamicNode) {
            object = (DynamicNode)dynamicNodeEditorState.getNode();
        }
        this.jInputHostPanel = new DataUsagePanel(dynamicNodeEditorState.getContext(), (DynamicNode)object, (TransformsNodeType)miningAttributeType2, miningAttributes, hashMap, hashMap2, hashMap3, 0, map);
        this.jInputTab.add("Center", this.jInputHostPanel);
        jTabbedPane.addTab(DynamicNodesLrb.get("INPUT_EDITOR_TAB"), this.jInputTab);
        this.jOutputTab = new JPanel();
        this.jOutputTab.setLayout(new BorderLayout());
        this.jOutputHostPanel = new OuputColumnsPanel(dynamicNodeEditorState.getContext(), dynamicNodeEditorState);
        this.jOutputTab.add("Center", this.jOutputHostPanel);
        this.jPartitionHostPanel.setOutputColumnsPanel(this.jOutputHostPanel);
        jTabbedPane.addTab(DynamicNodesLrb.get("OUTPUT_EDITOR_TAB"), this.jOutputTab);
    }

    public DynamicEditorPanel(Context context, T t) {
        super(context, t);
    }

    protected void createPartitionTab(JTabbedPane jTabbedPane, DynamicNodeEditorState dynamicNodeEditorState) {
        this.jPartitionTab = new JPanel();
        this.jPartitionTab.setLayout(new BorderLayout());
        this.jPartitionHostPanel = new PartitionPanel();
        this.jPartitionHostPanel.setState(dynamicNodeEditorState);
        this.jPartitionTab.add("Center", this.jPartitionHostPanel);
        jTabbedPane.setTitleAt(0, this.getFirstTabTitle());
        jTabbedPane.addTab(PartitionLrb.get("PARTITION_EDITOR_TAB_TITLE"), this.jPartitionTab);
    }

    protected abstract String getFirstTabTitle();

    protected abstract JComboBox getCaseIDCombo();

    public abstract DynamicNodeEditorState getState();

    protected abstract DynamicNodeBaseSettingsType getOriginalDynamicNodeBaseSettings();

    protected abstract JLabel getCaseIDLabel();

    @Override
    public void initRes() {
        this.jPartitionHostPanel.initRes();
        this.getCaseIDLabel().setVisible(false);
    }

    @Override
    public void initUI() {
        this.jPartitionHostPanel.initUI(this);
    }

    public void updateCaseIDs() {
        String string = this.getState().getSelectedCaseAttribute();
        Map<String, AttributeType> map = this.buildMapOfRestrictedColumns();
        Vector<String> vector = new Vector<String>();
        if (!this.getOriginalDynamicNodeBaseSettings().getMiningAttributes().getMiningAttribute().isEmpty()) {
            for (MiningAttributeType miningAttributeType : this.getOriginalDynamicNodeBaseSettings().getMiningAttributes().getMiningAttribute()) {
                String string2;
                if (!DatabaseMetadataUtils.isDynamicCaseIdDataTypeSupported(miningAttributeType.getDataType()) || null != map.get(string2 = miningAttributeType.getAlias() != null ? miningAttributeType.getAlias() : miningAttributeType.getName())) continue;
                vector.add(string2);
            }
            Collections.sort(vector);
        }
        vector.insertElementAt(DynamicNodeEditorState._none, 0);
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(vector);
        defaultComboBoxModel.setSelectedItem(string != null ? string : DynamicNodeEditorState._none);
        this.getCaseIDCombo().setModel(defaultComboBoxModel);
    }

    protected void setSelectedCaseAttribute(String string) {
        this.getState().setSelectedCaseAttribute(string != null ? string : DynamicNodeEditorState._none);
        this.jOutputHostPanel.updateAutoSupplementalList();
    }

    protected Map<String, AttributeType> buildMapOfRestrictedColumns() {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (MiningAttributeType miningAttributeType : this.getState().getTargetAttributes().getMiningAttribute()) {
            hashMap.put(miningAttributeType.getName(), (AttributeType)miningAttributeType);
        }
        for (MiningAttributeType miningAttributeType : this.getState().getPartitionExpressions().getPartitionExpression()) {
            if (null != miningAttributeType.getSQLExpression()) continue;
            AttributeType attributeType = miningAttributeType.getPartitionAttribute();
            hashMap.put(attributeType.getName(), attributeType);
        }
        return hashMap;
    }

    protected boolean isInputAttributesListEmpty() {
        boolean bl = true;
        DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getOriginalDynamicNodeBaseSettings();
        List list = dynamicNodeBaseSettingsType.getMiningAttributes().getMiningAttribute();
        for (MiningAttributeType miningAttributeType : list) {
            if (!"Yes".equals(miningAttributeType.getInput())) continue;
            bl = false;
            break;
        }
        return bl;
    }
}

