/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.buildText;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.DataMinerCombBox;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.OutputCellEditor;
import oracle.dmt.dataminer.controls.ToolTipComboBoxRenderer;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableExecutableAdapter;
import oracle.dmt.dataminer.controls.models.AttributeItem;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.controls.renderers.OutputCellRenderer;
import oracle.dmt.dataminer.core.utils.ObjectUtils;
import oracle.dmt.dataminer.core.utils.comparator.AttributeTypeComparator;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.PIAncestorListener;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.AbstractPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.BuildTextOutputPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.BuildTextTokenPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.buildText.StoplistPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.TextTransColumnSettingPanel;
import oracle.dmt.dataminer.workflow.dialog.buildText.TransformWizard;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.buildText.BuildTextNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.buildText.BuildTextPIPropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.buildText.WorkflowBuildTextNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTextNode;
import oracle.dmt.dataminer.workflow.model.BuildTextNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildTextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.MapTextTransformedSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationOutputAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationSourceAttribute;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Element;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;

public class BuildTextPanel
extends AbstractPanel<BuildTextNode>
implements SearchListener,
DialogDisplayable {
    private WorkflowBuildTextNodePropertyProxyModel _propertyModel;
    private TextNodeType _textNodeType;
    private AttributeType _caseAttribute;
    private TextTransformationOutputAttributeType _selectedTextTransformationOutputAttribute = null;
    private List<TransformationSourceAttribute> _combinedAttrList = new ArrayList<TransformationSourceAttribute>();
    private AttrsTableModel _models;
    private GenericTable _attributeTable = new DataMinerTable();
    private SearchField _searchField;
    private String _searchText;
    private transient SearchCategory _searchCategory;
    private transient RowFilter<AttrsTableModel, Integer> _nodeFilter;
    private boolean _bShowAllRows;
    private boolean _isAdjusting;
    private boolean _dirty;
    private JButton _removeBtn;
    private JButton _editBtn;
    private JButton _addBtn;
    private JButton _outputTrueBtn;
    private JButton _outputFalseBtn;
    private AttributeItem SELECT_CASEID_NONE;
    private BuildTextTokenPanel _tokensPanel;
    private BuildTextOutputPanel _outputPanel;
    private BlockingComponent _overLayPanel = null;
    private static String TOKENS_TAB = DialogsLrb.get("BUILDTEXT_TOKENS_TAB");
    private static String THEMES_TAB = DialogsLrb.get("BUILDTEXT_THEMES_TAB");
    private static String OUTPUT_TAB = DialogsLrb.get("BUILDTEXT_OUTPUT_TAB");
    private static final String[] COLUMN_NAMES = new String[]{DialogsLrb.get("BUILDTEXT_COLUMN_ATTRIBUTE"), DialogsLrb.get("BUILDTEXT_COLUMN_DATA_TYPE"), DialogsLrb.get("BUILDTEXT_COLUMN_SOURCE"), DialogsLrb.get("BUILDTEXT_COLUMN_TRANSFORM"), DialogsLrb.get("BUILDTEXT_COLUMN_OUTPUT")};
    private int[] _columnWidths = new int[]{220, 140, 220, 83, 60};
    private int[] _columnWidthsForPI = new int[]{170, 140, 160, 65, 50};
    private static final int ATTRIBUTE = 0;
    private static final int DATA_TYPE = 1;
    private static final int SOURCE = 2;
    private static final int TRANSFORM = 3;
    private static final int OUTPUT = 4;
    private static final int ATTR_STATUS = 99;
    private ComponentWithTitlebar<JScrollPane> columnComponentWithTitlebar;
    private JPanel jBottomPanel;
    private DataMinerCombBox<AttributeItem> jCaseIdComboBox;
    private JLabel jCaseIdLabel;
    private JButton jEditStoplistsButton;
    private JSplitPane jSplitPane;
    private JTabbedPane jTabbedPane;
    private JPanel jTopPanel;
    private JComboBox<String> jColumnTypeComboBox;

    public BuildTextPanel(Context context, BuildTextNode buildTextNode) {
        super(context, buildTextNode);
        this.init((BuildTextNode)this._data, null);
    }

    public BuildTextPanel(PropertyModel propertyModel) {
        super(null, null);
        assert (propertyModel != null) : "PropertyModel for BuildText node is null.";
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this.addAncestorListener(new PIAncestorListener(this));
        this.init((BuildTextNode)this._data, propertyModel);
    }

    private void init(BuildTextNode buildTextNode, PropertyModel propertyModel) {
        this._propertyModel = (WorkflowBuildTextNodePropertyProxyModel)propertyModel;
        this._dirty = false;
        this.initSettings(buildTextNode);
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jCaseIdLabel, this.jCaseIdComboBox, (String)DialogsLrb.get("BUILDTEXT_CASEID"));
        ResourceUtils.resButton((AbstractButton)this.jEditStoplistsButton, (String)DialogsLrb.get("BUILDTEXT_EDIT_STOPLIST"));
    }

    @Override
    public void initUI() {
        this._isAdjusting = true;
        this.initCaseAttribute();
        this.buildAttrList();
        Collections.sort(this._combinedAttrList, AttributeTypeComparator.getComparator());
        this._models = new AttrsTableModel();
        JScrollPane jScrollPane = new JScrollPane((Component)this._attributeTable);
        this.columnComponentWithTitlebar.setComponent((JComponent)jScrollPane);
        ControlBar controlBar = new ControlBar();
        this.columnComponentWithTitlebar.setControlBar(controlBar);
        this.installItemFilterActions(controlBar);
        this._attributeTable.setModel((TableModel)((Object)this._models));
        this._attributeTable.setResizeColumnOnDoubleClick(true);
        this._attributeTable.getSelectionModel().setSelectionMode(2);
        this._attributeTable.setAutoResizeMode(0);
        this._attributeTable.setSelectionMode(2);
        this._attributeTable.setColumnSelectorAvailable(true);
        this._attributeTable.setShowToolTips(true);
        this._attributeTable.setUpdateSelectionOnSort(true);
        this._attributeTable.setRowSelectionAllowed(true);
        IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Object object2;
                int n3 = BuildTextPanel.this._attributeTable.convertRowIndexToModel(n);
                GenericBaseTableModel genericBaseTableModel = (GenericBaseTableModel)BuildTextPanel.this._attributeTable.getModel();
                AttributeStatus attributeStatus = AttributeStatus.VALID;
                if (genericBaseTableModel instanceof AttrsTableModel && (object2 = genericBaseTableModel.getValueAt(n3, 99)) instanceof AttributeStatus) {
                    attributeStatus = (AttributeStatus)object2;
                }
                if (attributeStatus.equals((Object)AttributeStatus.VALID)) {
                    return OracleIcons.getIcon((String)"attribute.png");
                }
                return OracleIcons.getIcon((String)"warning.png");
            }
        });
        TableColumn tableColumn = this._attributeTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(iconCellRenderer);
        tableColumn = this._attributeTable.getColumnModel().getColumn(4);
        tableColumn.setCellEditor(new OutputCellEditor());
        tableColumn.setCellRenderer(new OutputCellRenderer());
        this._nodeFilter = new RowFilter<AttrsTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends AttrsTableModel, ? extends Integer> entry) {
                String string;
                String string2;
                boolean bl = false;
                boolean bl2 = true;
                boolean bl3 = BuildTextPanel.this._searchText != null && BuildTextPanel.this._searchCategory != null;
                Integer n = entry.getIdentifier();
                AttrsTableModel attrsTableModel = entry.getModel();
                if (!BuildTextPanel.this._bShowAllRows) {
                    bl2 = false;
                    string2 = (String)attrsTableModel.getValueAt(n, 1);
                    if (DatabaseMetadataUtils.isTypeSupportedAsText(string2)) {
                        bl2 = true;
                    }
                    if (!bl2 && (string = (String)attrsTableModel.getValueAt(n, 2)) != null) {
                        bl2 = true;
                    }
                }
                String string3 = string2 = BuildTextPanel.this._searchText != null ? BuildTextPanel.this._searchText.toLowerCase() : null;
                if (bl2 && bl3 && BuildTextPanel.this._searchCategory.getLabel().equals(DialogsLrb.get("BUILDTEXT_COLUMN_ATTRIBUTE"))) {
                    string = (String)attrsTableModel.getValueAt(n, 0);
                    if (string.toLowerCase().startsWith(string2)) {
                        bl = true;
                    }
                } else if (bl2 && bl3 && BuildTextPanel.this._searchCategory.getLabel().equals(DialogsLrb.get("BUILDTEXT_COLUMN_DATA_TYPE"))) {
                    string = (String)attrsTableModel.getValueAt(n, 1);
                    if (string.toLowerCase().startsWith(string2)) {
                        bl = true;
                    }
                } else if (bl2 && bl3 && BuildTextPanel.this._searchCategory.getLabel().equals(DialogsLrb.get("BUILDTEXT_COLUMN_SOURCE"))) {
                    String string4 = string = (String)attrsTableModel.getValueAt(n, 2) != null ? ((String)attrsTableModel.getValueAt(n, 2)).toLowerCase() : "";
                    if (string.startsWith(string2)) {
                        bl = true;
                    }
                } else if (bl2 && bl3 && BuildTextPanel.this._searchCategory.getLabel().equals(DialogsLrb.get("BUILDTEXT_COLUMN_TRANSFORM"))) {
                    string = (String)attrsTableModel.getValueAt(n, 3);
                    if (string.toLowerCase().startsWith(string2)) {
                        bl = true;
                    }
                } else if (bl2) {
                    bl = true;
                }
                return bl;
            }
        };
        this.configureSorting();
        int n = 0;
        int[] nArray = this.isPIMode() ? this._columnWidthsForPI : this._columnWidths;
        for (int n2 : nArray) {
            this._attributeTable.getColumnModel().getColumn(n++).setPreferredWidth(n2);
        }
        this._attributeTable.getSelectionModel().addListSelectionListener(new SelectedItemSelectionHandler(this));
        if (this.isPIMode()) {
            this.jSplitPane.setRightComponent(null);
            this.jSplitPane.setDividerSize(0);
        } else {
            BuildTextNodeType buildTextNodeType = (BuildTextNodeType)((BuildTextNode)this.getData()).getData();
            this._overLayPanel = new BlockingComponent((JComponent)this);
            this._outputPanel = new BuildTextOutputPanel(this._context, (AbstractTextNode)this._data, this._textNodeType);
            this._outputPanel.setOverLayPanel(this._overLayPanel);
            int n3 = 0;
            if (!buildTextNodeType.getTransformedAttributes().getMapTextTransformedSource().isEmpty()) {
                n3 = ((MapTextTransformedSourceType)buildTextNodeType.getTransformedAttributes().getMapTextTransformedSource().get(0)).getKey().getTransformationElement().getTheme() != null ? 1 : 0;
            }
            this.jTabbedPane.add(n3 != 0 ? THEMES_TAB : TOKENS_TAB, this._outputPanel);
            this._tokensPanel = new BuildTextTokenPanel(this._context, (AbstractTextNode)this._data);
            this.jTabbedPane.add(OUTPUT_TAB, this._tokensPanel);
        }
        this._isAdjusting = false;
        this._attributeTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && BuildTextPanel.this._editBtn.isEnabled()) {
                    BuildTextPanel.this.processAddOrEdit();
                }
            }
        });
        this.enableControls();
    }

    private void installItemFilterActions(ControlBar controlBar) {
        SearchCategory[] searchCategoryArray;
        this.jColumnTypeComboBox = new JComboBox();
        this.jColumnTypeComboBox.removeAllItems();
        this.jColumnTypeComboBox.addItem(DialogsLrb.get("BUILDTEXT_TABLE_ALL"));
        this.jColumnTypeComboBox.addItem(DialogsLrb.get("BUILDTEXT_TABLE_TEXT_AND_TRANSFORMED"));
        this.jColumnTypeComboBox.setSelectedItem(DialogsLrb.get("BUILDTEXT_TABLE_ALL"));
        this._bShowAllRows = true;
        this.jColumnTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)BuildTextPanel.this.jColumnTypeComboBox.getSelectedItem();
                BuildTextPanel.this._bShowAllRows = string.equals(DialogsLrb.get("BUILDTEXT_TABLE_ALL"));
                BuildTextPanel.this.configureSorting();
            }
        });
        controlBar.add(this.jColumnTypeComboBox);
        this._editBtn = new JButton(InspectorArb.getIcon((int)24));
        this._editBtn.setToolTipText(DialogsLrb.get("BUILDTEXT_EDIT_TEXT_XFORM_TOOLTIP"));
        this._editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BuildTextPanel.this.processAddOrEdit();
            }
        });
        controlBar.add((Component)this._editBtn);
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.setToolTipText(DialogsLrb.get("BUILDTEXT_DELETE_TEXT_XFORM_TOOLTIP"));
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = BuildTextPanel.this._attributeTable.getSelectedRowsInModel();
                BuildTextPanel.this._models.removeSelectedRows(nArray);
                BuildTextPanel.this.resetNiceTableModel(BuildTextPanel.this._models);
                if (BuildTextPanel.this.isPIMode()) {
                    ArrayList<Property> arrayList = new ArrayList<Property>(1);
                    ComplexProperty complexProperty = new ComplexProperty("allXfomNodeColumns", AttributeTypeHelper.getAllColumns(BuildTextPanel.this._textNodeType.getTransformedAttributes(), BuildTextPanel.this._textNodeType.getTransformationSourceAttributes()));
                    BuildTextNodeType buildTextNodeType = (BuildTextNodeType)((BuildTextNode)BuildTextPanel.this.getData()).getData();
                    complexProperty.setOldData(AttributeTypeHelper.getAllColumns(buildTextNodeType.getTransformedAttributes(), buildTextNodeType.getTransformationSourceAttributes()));
                    arrayList.add(new Property(String.valueOf(BuildTextNodePropertyModel.ALL_TRANSFORMATION_NODE_COLUMNS.index), null, complexProperty, null, null));
                    BuildTextPanel.this._propertyModel.setValueAt(BuildTextPIPropertyLrb.get("PI_BUILDTEXT_NODE_REMOVE_COLUMNS"), (AbstractNode)BuildTextPanel.this.getData(), (List<Property>)arrayList);
                }
            }
        });
        controlBar.add((Component)this._removeBtn);
        this._addBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this._addBtn.setToolTipText(DialogsLrb.get("BUILDTEXT_ADD_TEXT_XFORM_TOOLTIP"));
        this._addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BuildTextPanel.this.processAddOrEdit();
            }
        });
        controlBar.add((Component)this._addBtn);
        this._outputTrueBtn = new JButton(OracleIcons.getIcon((String)"messageAsync.png"));
        this._outputTrueBtn.setToolTipText(DialogsLrb.get("BUILDTEXT_INCLUDE_COLUMN_TOOLTIP"));
        this._outputTrueBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BuildTextPanel.this.setOutputState(true);
            }
        });
        controlBar.add((Component)this._outputTrueBtn);
        this._outputFalseBtn = new JButton(DataMinerIcons.get(Icons.ATTR_IGNORE));
        this._outputFalseBtn.setToolTipText(DialogsLrb.get("BUILDTEXT_EXCLUDE_COLUMN_TOOLTIP"));
        this._outputFalseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BuildTextPanel.this.setOutputState(false);
            }
        });
        controlBar.add((Component)this._outputFalseBtn);
        this._searchField = new SearchField(SearchField.Style.FILTER);
        this._searchField.setPreferredSize(new Dimension(200, 10));
        for (SearchCategory searchCategory : searchCategoryArray = new SearchCategory[]{new SearchCategory(DialogsLrb.get("BUILDTEXT_COLUMN_ATTRIBUTE")), new SearchCategory(DialogsLrb.get("BUILDTEXT_COLUMN_DATA_TYPE")), new SearchCategory(DialogsLrb.get("BUILDTEXT_COLUMN_SOURCE")), new SearchCategory(DialogsLrb.get("BUILDTEXT_COLUMN_TRANSFORM"))}) {
            this._searchField.addCategory(searchCategory);
        }
        controlBar.add((Component)this._searchField);
        this._searchField.addSearchListener((SearchListener)this);
    }

    private void resetNiceTableModel(AttrsTableModel attrsTableModel) {
        attrsTableModel.fireTableDataChanged();
        this._attributeTable.clearSelection();
        this._attributeTable.updateUI();
        this.configureSorting();
    }

    public void configureSorting() {
        TableRowSorter<AttrsTableModel> tableRowSorter = (TableRowSorter<AttrsTableModel>)this._attributeTable.getRowSorter();
        if (tableRowSorter == null) {
            tableRowSorter = new TableRowSorter<AttrsTableModel>(this._models);
            ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>(1);
            arrayList.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
            tableRowSorter.setSortKeys(arrayList);
            tableRowSorter.setSortsOnUpdates(true);
        }
        tableRowSorter.setRowFilter(this._nodeFilter);
        this._attributeTable.setRowSorter(tableRowSorter);
    }

    public void searchPerformed(SearchEvent searchEvent) {
        this._searchCategory = searchEvent.getSearchCategory();
        this._searchText = searchEvent.getSearchText();
        this.configureSorting();
        this._attributeTable.scrollToSelection();
    }

    public void searchCategoryChanged(SearchEvent searchEvent) {
        this._searchCategory = searchEvent.getSearchCategory();
        this._searchText = searchEvent.getSearchText();
        this.configureSorting();
        this._attributeTable.scrollToSelection();
    }

    private boolean isPIMode() {
        return this._propertyModel != null;
    }

    private void initSettings(BuildTextNode buildTextNode) {
        BuildTextNodeType buildTextNodeType = (BuildTextNodeType)buildTextNode.getData();
        this._textNodeType = (TextNodeType)MetaDataHelper.copyMetadataObject(buildTextNodeType);
        this._caseAttribute = !this._textNodeType.getCaseAttributes().getAttribute().isEmpty() ? (AttributeType)this._textNodeType.getCaseAttributes().getAttribute().get(0) : null;
    }

    private void buildAttrList() {
        List list;
        this._combinedAttrList.clear();
        List list2 = this._textNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType();
        if (list2 != null && !list2.isEmpty()) {
            this._combinedAttrList.addAll(list2);
        }
        if (this._textNodeType.getTransformedAttributes() != null && (list = this._textNodeType.getTransformedAttributes().getMapTextTransformedSource()) != null && !list.isEmpty()) {
            for (MapTextTransformedSourceType mapTextTransformedSourceType : list) {
                this._combinedAttrList.add((TransformationSourceAttribute)mapTextTransformedSourceType.getKey());
            }
        }
    }

    private void processAddOrEdit() {
        int[] nArray = this._attributeTable.getSelectedRowsInModel();
        if (nArray.length == 1) {
            BuildTextNode buildTextNode = (BuildTextNode)this.getData();
            TextTransColumnSettingPanel textTransColumnSettingPanel = null;
            if (this.isPIMode()) {
                textTransColumnSettingPanel = new TextTransColumnSettingPanel((PropertyModel)this._propertyModel, this._textNodeType.getTransformationSourceAttributes(), this._textNodeType.getTransformedAttributes(), this.getSelectedAttributes());
                textTransColumnSettingPanel.showAsDialog(this);
            } else {
                textTransColumnSettingPanel = new TextTransColumnSettingPanel(this.getContext(), buildTextNode, this._textNodeType, this._textNodeType.getTransformationSourceAttributes(), this._textNodeType.getTransformedAttributes(), this.getSelectedAttributes());
                if (textTransColumnSettingPanel.showAsDialog(this) && textTransColumnSettingPanel.isDirty()) {
                    this.refreshUI();
                    this._dirty = true;
                }
            }
        } else {
            TransformWizard transformWizard = new TransformWizard();
            BuildTextNode buildTextNode = (BuildTextNode)this._data;
            if (transformWizard.runWizard(this, (PropertyModel)this._propertyModel, this._context, buildTextNode, this._textNodeType, this.getSelectedAttributes())) {
                this.refreshUI();
                this._dirty = true;
            }
        }
    }

    private void enableControls() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = this._attributeTable.getSelectedRowCount();
        AttributeItem attributeItem = (AttributeItem)this.jCaseIdComboBox.getSelectedItem();
        this.jCaseIdComboBox.setEnabled(this.isWritable());
        if (!attributeItem.equals(this.SELECT_CASEID_NONE) && !attributeItem.getAttribute().getStatus().equals((Object)AttributeStatus.VALID)) {
            this.jCaseIdLabel.setIcon(OracleIcons.getIcon((String)"warning.png"));
        } else {
            this.jCaseIdLabel.setIcon(null);
        }
        bl2 = false;
        bl3 = false;
        bl = false;
        if (n > 0) {
            int[] nArray;
            bl2 = true;
            bl3 = true;
            bl = true;
            for (int n2 : nArray = this._attributeTable.getSelectedRowsInModel()) {
                TransformationSourceAttribute transformationSourceAttribute = this._models.getAttribute(n2);
                String string = DatabaseMetadataUtils.getJSONDataType(transformationSourceAttribute.getDataType(), transformationSourceAttribute.getDataTypeQualifier());
                if (transformationSourceAttribute.getStatus() != AttributeStatus.VALID || !(transformationSourceAttribute instanceof TextTransformationOutputAttributeType)) {
                    bl2 = false;
                }
                if (transformationSourceAttribute.getStatus() != AttributeStatus.VALID || !DatabaseMetadataUtils.isTypeSupportedAsText(string)) {
                    bl3 = false;
                }
                if (transformationSourceAttribute.getStatus() == AttributeStatus.INVALID || transformationSourceAttribute instanceof TextTransformationOutputAttributeType) continue;
                bl = false;
            }
        }
        this._outputTrueBtn.setEnabled(this.isWritable());
        this._outputFalseBtn.setEnabled(this.isWritable());
        this.jEditStoplistsButton.setEnabled(this.isWritable());
        this.jCaseIdComboBox.setEnabled(this.isWritable());
        this.jColumnTypeComboBox.setEnabled(this.isWritable());
        this._removeBtn.setEnabled(this.isWritable() && bl);
        this._editBtn.setEnabled(this.isWritable() && bl2);
        this._addBtn.setEnabled(this.isWritable() && bl3);
    }

    public void updatePI(PropertyModel propertyModel) {
        WorkflowBuildTextNodePropertyProxyModel workflowBuildTextNodePropertyProxyModel = (WorkflowBuildTextNodePropertyProxyModel)propertyModel;
        Context context = workflowBuildTextNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        BuildTextNode buildTextNode = (BuildTextNode)workflowNodeInspectorElement.getNode();
        if (buildTextNode == null) {
            return;
        }
        this._propertyModel = (WorkflowBuildTextNodePropertyProxyModel)propertyModel;
        this._context = context;
        this._data = buildTextNode;
        this._dirty = false;
        this.initSettings(buildTextNode);
        this.refreshUI();
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowBuildTextNodePropertyProxyModel)) {
            return null;
        }
        WorkflowBuildTextNodePropertyProxyModel workflowBuildTextNodePropertyProxyModel = (WorkflowBuildTextNodePropertyProxyModel)propertyModel;
        Context context = workflowBuildTextNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    private BuildTextNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowBuildTextNodePropertyProxyModel)) {
            return null;
        }
        WorkflowBuildTextNodePropertyProxyModel workflowBuildTextNodePropertyProxyModel = (WorkflowBuildTextNodePropertyProxyModel)propertyModel;
        Context context = workflowBuildTextNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof BuildTextNodeType) {
            return (BuildTextNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    private void initCaseAttribute() {
        Object object;
        if (this.SELECT_CASEID_NONE == null) {
            object = new AttributeType();
            object.setName(DialogsLrb.get("BUILDTEXT_SELECT_CASEID_NONE"));
            object.setDataType("String");
            this.SELECT_CASEID_NONE = new AttributeItem((AttributeType)object);
        }
        object = (BuildTextNode)this.getData();
        List<AttributeType> list = ((BuildTextNode)object).getCaseAttributes();
        Collections.sort(list, AttributeTypeComparator.getComparator());
        this.jCaseIdComboBox.removeAllItems();
        this.jCaseIdComboBox.addItem(this.SELECT_CASEID_NONE);
        for (AttributeType attributeType : list) {
            this.jCaseIdComboBox.addItem(new AttributeItem(attributeType));
        }
        this.jCaseIdComboBox.setSelectedItem(this.SELECT_CASEID_NONE);
        if (this._caseAttribute != null) {
            boolean bl = false;
            for (int i = 0; i < this.jCaseIdComboBox.getItemCount(); ++i) {
                AttributeItem attributeItem = (AttributeItem)this.jCaseIdComboBox.getItemAt(i);
                if (!this._caseAttribute.getName().equals(attributeItem.getAttribute().getName())) continue;
                this.jCaseIdComboBox.setSelectedItem(attributeItem);
                bl = true;
                break;
            }
            if (!bl) {
                AttributeItem attributeItem = new AttributeItem(this._caseAttribute);
                this.jCaseIdComboBox.addItem(attributeItem);
                this.jCaseIdComboBox.setSelectedItem(attributeItem);
            }
        }
        this.jCaseIdComboBox.setRenderer(new ToolTipComboBoxRenderer());
    }

    public void refreshUI() {
        this._isAdjusting = true;
        this.initCaseAttribute();
        this.buildAttrList();
        Collections.sort(this._combinedAttrList, AttributeTypeComparator.getComparator());
        this._models = new AttrsTableModel();
        this._attributeTable.clearSelection();
        this.configureSorting();
        this._isAdjusting = false;
        this.enableControls();
    }

    private void setOutputState(boolean bl) {
        int[] nArray = this._attributeTable.getSelectedRowsInModel();
        if (nArray != null && nArray.length > 0) {
            Object object;
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
            boolean bl2 = true;
            for (int i = 0; i < nArray.length; ++i) {
                object = this._models.getAttribute(nArray[i]);
                if (bl2 && object.isIsOutput() != bl) {
                    bl2 = false;
                }
                if (bl2) continue;
                if (this.isPIMode()) {
                    hashMap.put(object.getName(), object.isIsOutput());
                    hashMap2.put(object.getName(), bl);
                    continue;
                }
                object.setIsOutput(bl);
                this._dirty = true;
            }
            if (bl2) {
                return;
            }
            if (this.isPIMode()) {
                ComplexProperty complexProperty = new ComplexProperty("outputState", hashMap2);
                complexProperty.setOldData(hashMap);
                object = new ArrayList();
                object.add(new Property(String.valueOf(BuildTextNodePropertyModel.OUTPUT_STATE.index), null, complexProperty, null, null));
                this._propertyModel.setValueAt(BuildTextPIPropertyLrb.get("PI_BUILDTEXT_NODE_OUTPUT_TRANSFORMATION_ELEMENT"), (AbstractNode)this.getData(), (List<Property>)object);
            } else {
                this._models.fireTableDataChanged();
            }
            this._attributeTable.setSelectedRowsInModel(nArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNode() {
        BuildTextNode buildTextNode = (BuildTextNode)this.getData();
        CommandProcessor.getInstance().beginTrans(DialogsLrb.get("BUILDTEXT_NODE_EDIT_TRANSACTION_NAME"));
        try {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            CaseAttributes caseAttributes = new CaseAttributes();
            if (this._caseAttribute != null) {
                caseAttributes.getAttribute().add(this._caseAttribute);
            }
            arrayList.add(new Property("caseAttribute", null, caseAttributes, null, null));
            arrayList.add(new Property("editStoplists", null, this._textNodeType.getStoplists(), null, null));
            arrayList.add(new Property("allXfomNodeColumns", null, AttributeTypeHelper.getAllColumns(this._textNodeType.getTransformedAttributes(), this._textNodeType.getTransformationSourceAttributes()), null, null));
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)buildTextNode.getUndoFilter();
            odmrSDMUndoFilter.prepareUndoPropertyList(buildTextNode, this._context, arrayList);
            buildTextNode.validate(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)DialogsLrb.get("BUILDTEXT_NODE_EDIT_ERROR_MESG"), null);
            CommandProcessor.getInstance().abortTrans();
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
    }

    private void initComponents() {
        this.jSplitPane = new JSplitPane();
        this.jTopPanel = new JPanel();
        this.jCaseIdLabel = new JLabel();
        this.jCaseIdComboBox = new DataMinerCombBox();
        this.jEditStoplistsButton = new JButton();
        this.columnComponentWithTitlebar = new ComponentWithTitlebar();
        this.jBottomPanel = new JPanel();
        this.jTabbedPane = new JTabbedPane();
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(642, 550));
        this.jSplitPane.setBorder(null);
        this.jSplitPane.setDividerLocation(240);
        this.jSplitPane.setOrientation(0);
        this.jSplitPane.setResizeWeight(0.5);
        this.jSplitPane.setOneTouchExpandable(true);
        this.jSplitPane.setOpaque(false);
        this.jTopPanel.setOpaque(false);
        this.jCaseIdLabel.setText("CaseId:");
        this.jCaseIdComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BuildTextPanel.this.jCaseIdComboBoxActionPerformed(actionEvent);
            }
        });
        this.jEditStoplistsButton.setText("Edit Stoplist...");
        this.jEditStoplistsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BuildTextPanel.this.jEditStoplistsButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jTopPanel);
        this.jTopPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.columnComponentWithTitlebar, GroupLayout.Alignment.LEADING, -1, 622, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jCaseIdLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCaseIdComboBox, -2, 222, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 257, Short.MAX_VALUE).addComponent(this.jEditStoplistsButton))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCaseIdLabel).addComponent(this.jCaseIdComboBox, -2, -1, -2).addComponent(this.jEditStoplistsButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.columnComponentWithTitlebar, -1, 189, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane.setTopComponent(this.jTopPanel);
        this.jBottomPanel.setOpaque(false);
        GroupLayout groupLayout2 = new GroupLayout(this.jBottomPanel);
        this.jBottomPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane, -1, 622, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane, -1, 283, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane.setRightComponent(this.jBottomPanel);
        GroupLayout groupLayout3 = new GroupLayout(this);
        this.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane));
    }

    private void jCaseIdComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this._isAdjusting) {
            return;
        }
        AttributeType attributeType = this._caseAttribute;
        AttributeItem attributeItem = (AttributeItem)this.jCaseIdComboBox.getSelectedItem();
        this._caseAttribute = attributeItem.equals(this.SELECT_CASEID_NONE) ? null : attributeItem.getAttribute();
        if (!ObjectUtils.areBothNull((Object)attributeType, (Object)this._caseAttribute)) {
            if (ObjectUtils.isAnyNull((Object)attributeType, (Object)this._caseAttribute)) {
                this._dirty = true;
            } else if (!attributeType.getName().equals(this._caseAttribute.getName())) {
                this._dirty = true;
            }
        }
        if (this.isPIMode() && this._dirty) {
            CaseAttributes caseAttributes = new CaseAttributes();
            if (this._caseAttribute != null) {
                caseAttributes.getAttribute().add(this._caseAttribute);
            }
            CaseAttributes caseAttributes2 = new CaseAttributes();
            if (attributeType != null) {
                caseAttributes2.getAttribute().add(attributeType);
            }
            ComplexProperty complexProperty = new ComplexProperty("caseAttribute", caseAttributes);
            complexProperty.setOldData(caseAttributes2);
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(BuildTextNodePropertyModel.CASE_ATTRIBUTES.index), null, complexProperty, null, null));
            this._propertyModel.setValueAt(BuildTextPIPropertyLrb.get("PI_BUILDTEXT_NODE_EDIT_CASEID"), (AbstractNode)this.getData(), (List<Property>)arrayList);
        }
    }

    private void jEditStoplistsButtonActionPerformed(ActionEvent actionEvent) {
        AbstractTextNode abstractTextNode = (AbstractTextNode)this.getData();
        StoplistPanel stoplistPanel = null;
        if (this.isPIMode()) {
            stoplistPanel = new StoplistPanel((PropertyModel)this._propertyModel, this);
            stoplistPanel.showAsDialog(this);
        } else {
            stoplistPanel = new StoplistPanel(this.getContext(), abstractTextNode, this._textNodeType, this);
            if (stoplistPanel.showAsDialog(this) && stoplistPanel.isDirty()) {
                this.refreshUI();
                this._dirty = true;
            }
        }
    }

    private List<TransformationSourceAttribute> getSelectedAttributes() {
        int[] nArray = this._attributeTable.getSelectedRowsInModel();
        ArrayList<TransformationSourceAttribute> arrayList = new ArrayList<TransformationSourceAttribute>();
        for (int i = 0; i < nArray.length; ++i) {
            TransformationSourceAttribute transformationSourceAttribute = this._models.getAttribute(nArray[i]);
            arrayList.add(transformationSourceAttribute);
        }
        return arrayList;
    }

    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    public TextTransformationOutputAttributeType getSelectedTextTransformationOutputAttribute() {
        return this._selectedTextTransformationOutputAttribute;
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableExecutableAdapter(){

            @Override
            public void customizeDialogProperties(JEWTDialog jEWTDialog) {
                super.customizeDialogProperties(jEWTDialog);
                jEWTDialog.setMaximumInitialSize(new Dimension(800, 700));
                jEWTDialog.setMinimumSize(new Dimension(800, 700));
            }

            @Override
            public void onOK() throws DialogExecutionException {
                if (!BuildTextPanel.this.isPIMode()) {
                    if (BuildTextPanel.this._dirty) {
                        BuildTextPanel.this.updateNode();
                    } else if (BuildTextPanel.this._outputPanel != null && BuildTextPanel.this._outputPanel.isDirty()) {
                        BuildTextPanel.this.updateNode();
                    }
                }
            }

            @Override
            public String getTitle() {
                return DialogsLrb.get("BUILD_TEXT_DIALOG_TITLE");
            }

            @Override
            public String getHelpTopic() {
                return "buildtext";
            }

            @Override
            public JComponent getContent() {
                return BuildTextPanel.this._overLayPanel.getBlockingComponent();
            }
        };
    }

    private class AttrsTableModel
    extends SimpleBaseTableModel {
        AttrsTableModel() {
            this.setColumnIdentifiers(COLUMN_NAMES);
            this.setRowCount(this.getRowCount());
        }

        public int getRowCount() {
            return BuildTextPanel.this._combinedAttrList.size();
        }

        @Override
        public Class<?> getColumnClass(int n) {
            Object object = this.getValueAt(0, n);
            if (object != null) {
                if (n == 4) {
                    return ImageIcon.class;
                }
                return object.getClass();
            }
            return String.class;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 4) {
                return BuildTextPanel.this.isWritable();
            }
            return false;
        }

        public Object getValueAt(int n, int n2) {
            if (BuildTextPanel.this._combinedAttrList.size() == 0) {
                return "Loading...";
            }
            TransformationSourceAttribute transformationSourceAttribute = BuildTextPanel.this._combinedAttrList.get(n);
            Object object = null;
            switch (n2) {
                case 0: {
                    object = transformationSourceAttribute.getName();
                    break;
                }
                case 1: {
                    object = DatabaseMetadataUtils.getJSONDataType(transformationSourceAttribute.getDataType(), transformationSourceAttribute.getDataTypeQualifier());
                    break;
                }
                case 2: {
                    String string = null;
                    if (transformationSourceAttribute instanceof TextTransformationOutputAttributeType) {
                        TextTransformationOutputAttributeType textTransformationOutputAttributeType = (TextTransformationOutputAttributeType)transformationSourceAttribute;
                        string = textTransformationOutputAttributeType.getSource();
                    }
                    object = string;
                    break;
                }
                case 3: {
                    String string = null;
                    if (transformationSourceAttribute instanceof TextTransformationOutputAttributeType) {
                        TextTransformationOutputAttributeType textTransformationOutputAttributeType = (TextTransformationOutputAttributeType)transformationSourceAttribute;
                        string = textTransformationOutputAttributeType.getTransformationElement().getToken() != null ? DialogsLrb.get("BUILDTEXT_TRANSFORM_TYPE_TOKEN") : DialogsLrb.get("BUILDTEXT_TRANSFORM_TYPE_THEME");
                    }
                    object = string;
                    break;
                }
                case 4: {
                    object = transformationSourceAttribute.isIsOutput();
                    break;
                }
                case 99: {
                    object = transformationSourceAttribute.getStatus();
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }

        public void setValueAt(Object object, int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            TransformationSourceAttribute transformationSourceAttribute = BuildTextPanel.this._combinedAttrList.get(n);
            switch (n2) {
                case 4: {
                    BuildTextPanel.this._dirty = true;
                    if (BuildTextPanel.this.isPIMode()) {
                        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                        hashMap.put(transformationSourceAttribute.getName(), transformationSourceAttribute.isIsOutput());
                        ArrayList<Property> arrayList = new ArrayList<Property>();
                        HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
                        hashMap2.put(transformationSourceAttribute.getName(), (Boolean)object);
                        ComplexProperty complexProperty = new ComplexProperty("outputState", hashMap2);
                        complexProperty.setOldData(hashMap);
                        arrayList.add(new Property(String.valueOf(BuildTextNodePropertyModel.OUTPUT_STATE.index), null, complexProperty, null, null));
                        BuildTextPanel.this._propertyModel.setValueAt(BuildTextPIPropertyLrb.get("PI_BUILDTEXT_NODE_OUTPUT_TRANSFORMATION_ELEMENT"), (AbstractNode)BuildTextPanel.this.getData(), (List<Property>)arrayList);
                        break;
                    }
                    transformationSourceAttribute.setIsOutput(((Boolean)object).booleanValue());
                    break;
                }
                default: {
                    assert (false) : "Invalid option";
                    break;
                }
            }
        }

        public void removeSelectedRows(int[] nArray) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<MapTextTransformedSourceType> arrayList2 = new ArrayList<MapTextTransformedSourceType>();
            ArrayList<TransformationSourceAttribute> arrayList3 = new ArrayList<TransformationSourceAttribute>();
            for (int i = 0; i < nArray.length; ++i) {
                TransformationSourceAttribute transformationSourceAttribute = this.getAttribute(nArray[i]);
                arrayList.add(transformationSourceAttribute);
                if (transformationSourceAttribute instanceof TextTransformationOutputAttributeType) {
                    for (MapTextTransformedSourceType mapTextTransformedSourceType : BuildTextPanel.this._textNodeType.getTransformedAttributes().getMapTextTransformedSource()) {
                        if (!mapTextTransformedSourceType.getKey().getName().equals(transformationSourceAttribute.getName())) continue;
                        arrayList2.add(mapTextTransformedSourceType);
                    }
                    continue;
                }
                arrayList3.add(transformationSourceAttribute);
                for (MapTextTransformedSourceType mapTextTransformedSourceType : BuildTextPanel.this._textNodeType.getTransformedAttributes().getMapTextTransformedSource()) {
                    if (!mapTextTransformedSourceType.getKey().getSource().equals(transformationSourceAttribute.getName())) continue;
                    arrayList2.add(mapTextTransformedSourceType);
                    arrayList.add(mapTextTransformedSourceType.getKey());
                }
            }
            BuildTextPanel.this._combinedAttrList.removeAll(arrayList);
            BuildTextPanel.this._textNodeType.getTransformationSourceAttributes().getTransformationSourceAttributeType().removeAll(arrayList3);
            BuildTextPanel.this._textNodeType.getTransformedAttributes().getMapTextTransformedSource().removeAll(arrayList2);
            this.setRowCount(BuildTextPanel.this._combinedAttrList.size());
            BuildTextPanel.this._dirty = true;
        }

        public TransformationSourceAttribute getAttribute(int n) {
            return BuildTextPanel.this._combinedAttrList.get(n);
        }
    }

    private class SelectedItemSelectionHandler
    implements ListSelectionListener {
        BuildTextPanel _parent;

        public SelectedItemSelectionHandler(BuildTextPanel buildTextPanel2) {
            this._parent = buildTextPanel2;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            TransformationSourceAttribute transformationSourceAttribute;
            DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
            if (defaultListSelectionModel != null && defaultListSelectionModel.getValueIsAdjusting()) {
                return;
            }
            BuildTextPanel.this.enableControls();
            int[] nArray = BuildTextPanel.this._attributeTable.getSelectedRowsInModel();
            TextTransformationOutputAttributeType textTransformationOutputAttributeType = null;
            if (nArray.length == 1 && (transformationSourceAttribute = BuildTextPanel.this._models.getAttribute(nArray[0])) instanceof TextTransformationOutputAttributeType) {
                textTransformationOutputAttributeType = (TextTransformationOutputAttributeType)transformationSourceAttribute;
            }
            if (BuildTextPanel.this._selectedTextTransformationOutputAttribute != null && textTransformationOutputAttributeType != null && textTransformationOutputAttributeType.getName().compareTo(BuildTextPanel.this._selectedTextTransformationOutputAttribute.getName()) == 0) {
                return;
            }
            BuildTextPanel.this._selectedTextTransformationOutputAttribute = textTransformationOutputAttributeType;
            if (BuildTextPanel.this._outputPanel != null) {
                boolean bl = false;
                if (textTransformationOutputAttributeType != null) {
                    bl = textTransformationOutputAttributeType.getTransformationElement().getTheme() != null;
                }
                BuildTextPanel.this.jTabbedPane.setTitleAt(0, bl ? THEMES_TAB : TOKENS_TAB);
                BuildTextPanel.this._outputPanel.refreshUI(this._parent, textTransformationOutputAttributeType);
            }
            if (BuildTextPanel.this._tokensPanel != null) {
                BuildTextPanel.this._tokensPanel.refreshUI(this._parent, textTransformationOutputAttributeType);
            }
        }
    }
}

