/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.utils.PIAncestorListener;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.ModelARAggregatePanel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Element;

public class SamplingSettingsPanel
extends JPanel {
    private static final Logger theLogger = Logger.getLogger(ModelARAggregatePanel.class.getName());
    private AbstractBuildNode node;
    private Context _context;
    private BuildNodeType nodeDataCopy;
    private boolean dirty = false;
    private boolean bPIMode = false;
    private boolean initializing = true;
    private ButtonGroup btnGroupOn;
    private ButtonGroup btnGroupTop;
    private JLabel jLblNumberOfRows;
    private JRadioButton jRadioButtonOff;
    private JRadioButton jRadioButtonOn;
    private JRadioButton jRadioButtonSystemDetermined;
    private JRadioButton jRadioButtonUserSpecified;
    private JSpinner jSpinnerSize;

    public SamplingSettingsPanel(PropertyModel propertyModel) {
        this.bPIMode = true;
        this._context = this.getContext(propertyModel);
        this.node = this.getTargetNode(propertyModel);
        this.nodeDataCopy = (BuildNodeType)this.node.getData();
        this.addAncestorListener(new PIAncestorListener(this));
        this.initComponents();
        this.loadData(false);
        this.initializing = false;
    }

    public SamplingSettingsPanel(AbstractBuildNode abstractBuildNode, BuildNodeType buildNodeType, Context context) {
        this.bPIMode = false;
        this.node = abstractBuildNode;
        this._context = context;
        this.nodeDataCopy = buildNodeType;
        this.initComponents();
        this.loadData(false);
        this.initializing = false;
    }

    public void reload(PropertyModel propertyModel) {
        this.initializing = true;
        this.bPIMode = true;
        this._context = this.getContext(propertyModel);
        this.node = this.getTargetNode(propertyModel);
        this.nodeDataCopy = (BuildNodeType)this.node.getData();
        this.loadData(true);
        this.initializing = false;
    }

    private void loadData(boolean bl) {
        this.btnGroupTop.add(this.jRadioButtonOff);
        this.btnGroupTop.add(this.jRadioButtonOn);
        this.btnGroupOn.add(this.jRadioButtonSystemDetermined);
        this.btnGroupOn.add(this.jRadioButtonUserSpecified);
        this.jRadioButtonOff.setSelected(true);
        this.jSpinnerSize.setEnabled(false);
        boolean bl2 = this.nodeDataCopy.isODMSSAMPLING();
        if (bl2) {
            this.jRadioButtonOn.setSelected(true);
            this.jRadioButtonSystemDetermined.setEnabled(true);
            if (this.nodeDataCopy.getODMSSAMPLESIZE() == null) {
                this.jRadioButtonSystemDetermined.setSelected(true);
                this.jSpinnerSize.setEnabled(false);
            } else {
                String string = this.nodeDataCopy.getODMSSAMPLESIZE().toString();
                this.jRadioButtonUserSpecified.setSelected(true);
                this.jSpinnerSize.setEnabled(true);
                this.jSpinnerSize.setValue(Integer.parseInt(string));
            }
        } else {
            this.jRadioButtonUserSpecified.setEnabled(false);
            this.jRadioButtonSystemDetermined.setEnabled(false);
        }
    }

    private void initComponents() {
        this.btnGroupTop = new ButtonGroup();
        this.btnGroupOn = new ButtonGroup();
        this.jRadioButtonOff = new JRadioButton();
        this.jRadioButtonOn = new JRadioButton();
        this.jLblNumberOfRows = new JLabel();
        this.jRadioButtonSystemDetermined = new JRadioButton();
        this.jRadioButtonUserSpecified = new JRadioButton();
        this.jSpinnerSize = new JSpinner();
        this.jRadioButtonOff.setText("Off");
        this.jRadioButtonOff.setName("jRadioButtonOff");
        this.jRadioButtonOff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SamplingSettingsPanel.this.jRadioButtonOffActionPerformed(actionEvent);
            }
        });
        this.jRadioButtonOn.setText("On");
        this.jRadioButtonOn.setName("jRadioButtonOn");
        this.jRadioButtonOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SamplingSettingsPanel.this.jRadioButtonOnActionPerformed(actionEvent);
            }
        });
        this.jLblNumberOfRows.setText("Number of Rows:");
        this.jRadioButtonSystemDetermined.setText("System Determined");
        this.jRadioButtonSystemDetermined.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SamplingSettingsPanel.this.jRadioButtonSystemDeterminedActionPerformed(actionEvent);
            }
        });
        this.jRadioButtonUserSpecified.setText("User Specified:");
        this.jRadioButtonUserSpecified.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SamplingSettingsPanel.this.jRadioButtonUserSpecifiedActionPerformed(actionEvent);
            }
        });
        this.jSpinnerSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SamplingSettingsPanel.this.jSpinnerSizeStateChanged(changeEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(24, 24, 24).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonOn).addComponent(this.jRadioButtonOff))).addGroup(groupLayout.createSequentialGroup().addGap(61, 61, 61).addComponent(this.jLblNumberOfRows)).addGroup(groupLayout.createSequentialGroup().addGap(81, 81, 81).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jRadioButtonUserSpecified).addGap(18, 18, 18).addComponent(this.jSpinnerSize, -2, 97, -2)).addComponent(this.jRadioButtonSystemDetermined)))).addContainerGap(312, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jRadioButtonOff).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonOn).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLblNumberOfRows).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonSystemDetermined).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonUserSpecified).addComponent(this.jSpinnerSize, -2, -1, -2)).addContainerGap(250, Short.MAX_VALUE)));
    }

    private void jRadioButtonOffActionPerformed(ActionEvent actionEvent) {
        this.dirty = true;
        this.jRadioButtonOn.setSelected(false);
        this.jSpinnerSize.setEnabled(false);
        this.jRadioButtonSystemDetermined.setEnabled(false);
        this.jRadioButtonUserSpecified.setEnabled(false);
        this.jSpinnerSize.setEnabled(false);
        if (this.bPIMode) {
            this.processItemChanged();
        }
    }

    private void jRadioButtonOnActionPerformed(ActionEvent actionEvent) {
        this.dirty = true;
        this.jRadioButtonOff.setSelected(false);
        this.jSpinnerSize.setEnabled(false);
        this.jRadioButtonSystemDetermined.setEnabled(true);
        this.jRadioButtonSystemDetermined.setSelected(true);
        this.jRadioButtonUserSpecified.setEnabled(true);
        if (this.bPIMode) {
            this.processItemChanged();
        }
    }

    private void jRadioButtonUserSpecifiedActionPerformed(ActionEvent actionEvent) {
        this.dirty = true;
        this.jRadioButtonSystemDetermined.setSelected(false);
        this.jSpinnerSize.setEnabled(true);
        if (this.bPIMode) {
            this.processItemChanged();
        }
    }

    private void jRadioButtonSystemDeterminedActionPerformed(ActionEvent actionEvent) {
        this.dirty = true;
        this.jRadioButtonUserSpecified.setSelected(false);
        this.jSpinnerSize.setEnabled(false);
        if (this.bPIMode) {
            this.processItemChanged();
        }
    }

    private void jSpinnerSizeStateChanged(ChangeEvent changeEvent) {
        this.dirty = true;
        if (this.bPIMode) {
            this.processItemChanged();
        }
    }

    private AbstractBuildNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowNodePropertyProxyModel)) {
            return null;
        }
        WorkflowNodePropertyProxyModel workflowNodePropertyProxyModel = (WorkflowNodePropertyProxyModel)propertyModel;
        Context context = workflowNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof BuildNodeType) {
            return (AbstractBuildNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowNodePropertyProxyModel)) {
            return null;
        }
        WorkflowNodePropertyProxyModel workflowNodePropertyProxyModel = (WorkflowNodePropertyProxyModel)propertyModel;
        Context context = workflowNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void processItemChanged() {
        Object object;
        this.nodeDataCopy.setODMSSAMPLING(Boolean.valueOf(this.jRadioButtonOn.isSelected()));
        if (this.jRadioButtonOn.isSelected() && this.jRadioButtonUserSpecified.isSelected()) {
            object = BigInteger.valueOf(((Integer)this.jSpinnerSize.getValue()).intValue());
            this.nodeDataCopy.setODMSSAMPLESIZE((BigInteger)object);
        }
        if (this.bPIMode && !this.initializing) {
            MetaDataHelper.setModelsStatus(this.nodeDataCopy, ModelStatusType.READY);
            try {
                CommandProcessor.getInstance().beginTrans(BuildEditorLrb.get("EDIT_NODE"));
                object = (OdmrSDMUndoFilter)this.node.getUndoFilter();
                ((OdmrSDMUndoFilter)((Object)object)).prepareUndo(this.node, this._context, "nodetype", this.nodeDataCopy);
                this.node.validateAfterEdit();
                CommandProcessor.getInstance().endTrans();
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                CommandProcessor.getInstance().abortTrans();
            }
        }
    }
}

