/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build.algorithm;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableExecutableAdapter;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.AlgSettingsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.ModelGLMBuildSettingsPanel;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RGeneralizedLinearModelType;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class ModelGLMBuildRideRegressPanel
extends JPanel
implements DataminerGUIPanel,
DialogDisplayable {
    private Map<String, Object> _cacheSettings;
    private ModelType _modelType;
    private ButtonGroup buttonGroup1;
    private JCheckBox jChkProduceVIF;
    private JRadioButton jRadioButtonSystem;
    private JRadioButton jRadioButtonUser;
    private JLabel jRidgeValueLabel;
    private JTextField jTxtRidgeValue;

    public ModelGLMBuildRideRegressPanel(ModelGLMBuildSettingsPanel modelGLMBuildSettingsPanel) {
        this._modelType = modelGLMBuildSettingsPanel.getModelType();
        this._cacheSettings = modelGLMBuildSettingsPanel.getCacheSettings();
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jRidgeValueLabel, null, (String)AlgSettingsLrb.get("GLM_RIDGE_VALUE"));
        ResourceUtils.resButton((AbstractButton)this.jRadioButtonSystem, (String)AlgSettingsLrb.get("GLM_RIDGE_VALUE_SYSTEM"));
        ResourceUtils.resButton((AbstractButton)this.jRadioButtonUser, (String)AlgSettingsLrb.get("GLM_RIDGE_VALUE_USER"));
        ResourceUtils.resButton((AbstractButton)this.jChkProduceVIF, (String)AlgSettingsLrb.get("GLM_PRODUCE_VIF"));
    }

    @Override
    public void initUI() {
        if (this._modelType instanceof RGeneralizedLinearModelType) {
            HelpUtils.setHelpID((JComponent)this, (String)"ridge_glmr");
        } else {
            HelpUtils.setHelpID((JComponent)this, (String)"ridge_glmc");
        }
        this.jTxtRidgeValue.setToolTipText(AlgSettingsLrb.get("GLM_RIDGE_VALUE_TOOLTIP"));
        ((NumberTextField)this.jTxtRidgeValue).setDataType(Double.class);
        ((NumberTextField)this.jTxtRidgeValue).setDecimal(true, 4);
        ((NumberTextField)this.jTxtRidgeValue).setSigned(true);
        this.jTxtRidgeValue.setLocale(Locale.getDefault());
        this.jRadioButtonSystem.setEnabled(true);
        this.jRadioButtonUser.setEnabled(true);
        Number number = null;
        number = (Number)this._cacheSettings.get("GLMS_RIDGE_VALUE");
        if (number != null) {
            ((NumberTextField)this.jTxtRidgeValue).setNumber(number);
            this.jRadioButtonUser.setSelected(true);
        } else {
            this.jRadioButtonSystem.setSelected(true);
        }
        if (this._modelType instanceof RGeneralizedLinearModelType) {
            this.jChkProduceVIF.setVisible(true);
            this.jChkProduceVIF.setEnabled(true);
            String string = (String)this._cacheSettings.get("GLMS_VIF_FOR_RIDGE");
            boolean bl = string != null && string.equals("GLMS_VIF_RIDGE_ENABLE");
            this.jChkProduceVIF.setSelected(bl);
        } else {
            this.jChkProduceVIF.setVisible(false);
            this.jChkProduceVIF.setEnabled(false);
        }
        this.enableControls();
    }

    private void enableControls() {
        this.jTxtRidgeValue.setEnabled(this.jRadioButtonUser.isSelected());
    }

    public boolean doWork() {
        Object object;
        if (this.jRadioButtonUser.isSelected()) {
            object = ((NumberTextField)this.jTxtRidgeValue).getNumber();
            if (object == null || ((Number)object).doubleValue() < 0.0) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)AlgSettingsLrb.get("GLM_RIDGE_VALUE_INVALID"), (String)AlgSettingsLrb.get("GLM_RIDGE_REGRESSION_OPTION_DIALOG_TITLE"), null);
                return false;
            }
            this._cacheSettings.put("GLMS_RIDGE_VALUE", object);
        } else {
            this._cacheSettings.put("GLMS_RIDGE_VALUE", null);
        }
        if (this._modelType instanceof RGeneralizedLinearModelType) {
            object = this.jChkProduceVIF.isSelected() ? "GLMS_VIF_RIDGE_ENABLE" : "GLMS_VIF_RIDGE_DISABLE";
            this._cacheSettings.put("GLMS_VIF_FOR_RIDGE", object);
        }
        return true;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jRidgeValueLabel = new JLabel();
        this.jRadioButtonSystem = new JRadioButton();
        this.jRadioButtonUser = new JRadioButton();
        this.jTxtRidgeValue = new NumberTextField();
        this.jChkProduceVIF = new JCheckBox();
        this.jRidgeValueLabel.setText("Ridge Value");
        this.buttonGroup1.add(this.jRadioButtonSystem);
        this.jRadioButtonSystem.setText("System Determined");
        this.jRadioButtonSystem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelGLMBuildRideRegressPanel.this.jRadioButtonSystemActionPerformed(actionEvent);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonUser);
        this.jRadioButtonUser.setText("User Specified:");
        this.jRadioButtonUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelGLMBuildRideRegressPanel.this.jRadioButtonUserActionPerformed(actionEvent);
            }
        });
        this.jChkProduceVIF.setText("Produce Variance Inflation Factor");
        this.jChkProduceVIF.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jChkProduceVIF.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jRadioButtonUser).addGap(37, 37, 37).addComponent(this.jTxtRidgeValue, -2, 149, -2)).addComponent(this.jRadioButtonSystem))).addComponent(this.jRidgeValueLabel).addComponent(this.jChkProduceVIF, -2, 273, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jRidgeValueLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonSystem).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonUser).addComponent(this.jTxtRidgeValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jChkProduceVIF).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jRadioButtonSystemActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    private void jRadioButtonUserActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableExecutableAdapter(){

            @Override
            public void onOK() throws DialogExecutionException {
                ModelGLMBuildRideRegressPanel.this.doWork();
            }

            @Override
            public String getTitle() {
                return AlgSettingsLrb.get("GLM_RIDGE_REGRESSION_OPTION_DIALOG_TITLE");
            }

            @Override
            public String getHelpTopic() {
                if (ModelGLMBuildRideRegressPanel.this._modelType instanceof RGeneralizedLinearModelType) {
                    return "ridge_glmr";
                }
                return "ridge_glmc";
            }

            @Override
            public JComponent getContent() {
                return ModelGLMBuildRideRegressPanel.this;
            }
        };
    }
}

