/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.workflow.dialog.build.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.StoplistDetailsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.StoplistWizard;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.LexerType;
import oracle.dmt.dataminer.workflow.xmlschema.StoplistType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationTokenType;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.icons.OracleIcons;

public class TextTransColumnSettingThemePanel
extends JPanel {
    private BuildNodeType _buildNodeType = null;
    private String _sourceAttributeName = null;
    private BuildNodeType.Stoplists _stoplists = null;
    private AbstractBuildNode _node;
    private Context _context;
    private TransformationTokenType _textTransformation;
    private boolean _isAdjusting;
    private static Icon _editIcon;
    private boolean _dirty;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private ButtonGroup buttonGroup4;
    private JButton jEditStoplistButton;
    private JLabel jLanguageLabel;
    private JLabel jMaxNumAllDocsLabel;
    private JSpinner jMaxNumAllDocsSpinner;
    private JButton jNewStoplistButton;
    private JComboBox jSelectedStoplistComboBox;
    private JComboBox jSingleLanguageComboBox;
    private JLabel jStoplistLabel;
    private JLabel jTokensLabel;

    public TextTransColumnSettingThemePanel(Context context, AbstractBuildNode abstractBuildNode, BuildNodeType buildNodeType, String string, TransformationTokenType transformationTokenType, BuildNodeType.Stoplists stoplists) {
        this._context = context;
        this._node = abstractBuildNode;
        this._buildNodeType = buildNodeType;
        this._stoplists = stoplists;
        this._sourceAttributeName = string;
        this._textTransformation = transformationTokenType;
        this._dirty = false;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    public void initUI() {
        this._isAdjusting = true;
        this.jEditStoplistButton.setText(null);
        this.jEditStoplistButton.setIcon(_editIcon);
        this.jEditStoplistButton.setToolTipText(DialogsLrb.get("BUILD_TEXT_EDIT_STOPLIST_TOOLTIP"));
        this.jNewStoplistButton.setText(null);
        this.jNewStoplistButton.setIcon(OracleIcons.getIcon((String)"add.png"));
        this.jNewStoplistButton.setToolTipText(DialogsLrb.get("BUILD_TEXT_ADD_STOPLIST_TOOLTIP"));
        Vector<String> vector = new Vector<String>();
        for (ServerConstants.StoplistLanguage.BASIC_LEXER_LANG_SINGLE_BYTE bASIC_LEXER_LANG_SINGLE_BYTE : ServerConstants.StoplistLanguage.BASIC_LEXER_LANG_SINGLE_BYTE.values()) {
            vector.add(bASIC_LEXER_LANG_SINGLE_BYTE.value());
        }
        this.jSingleLanguageComboBox.setModel(new DefaultComboBoxModel(vector));
        LexerType lexerType = this._textTransformation.getToken().getLexer();
        List list = lexerType.getSettings().getAttribute();
        if (list != null && list.size() > 0) {
            this.jSingleLanguageComboBox.setSelectedItem(((LexerType.Settings.Attribute)list.get(0)).getValueString());
        } else {
            this.jSingleLanguageComboBox.setSelectedItem(ServerConstants.StoplistLanguage.toHuman((String)"ENGLISH"));
        }
        this.initStoplists(this._textTransformation.getToken().getStoplistId());
        this.jMaxNumAllDocsSpinner.setModel(new SpinnerNumberModel(300, 1, 100000, 1000));
        this.refreshUI(this._textTransformation);
        this._isAdjusting = false;
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLanguageLabel, (Component)this.jSingleLanguageComboBox, (String)DialogsLrb.get("ADD_STOPWORD_LANGUAGE"));
        ResourceUtils.resLabel((JLabel)this.jStoplistLabel, (Component)this.jSelectedStoplistComboBox, (String)DialogsLrb.get("BUILD_TEXT_STOPLIST"));
        ResourceUtils.resLabel((JLabel)this.jTokensLabel, null, (String)DialogsLrb.get("BUILD_TEXT_THEMES"));
        ResourceUtils.resSpinner((JLabel)this.jMaxNumAllDocsLabel, (JSpinner)this.jMaxNumAllDocsSpinner, (String)DialogsLrb.get("BUILD_TEXT_MAX_NUM_ALL_DOCS"));
        _editIcon = InspectorArb.getIcon((int)24);
    }

    private void initStoplists(String string) {
        List list = null;
        list = this._stoplists.getStoplist();
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (StoplistType stoplistType : list) {
            arrayList.add(stoplistType.getName());
            if (string == null || !stoplistType.getId().equals(string)) continue;
            string2 = stoplistType.getName();
        }
        Collections.sort(arrayList);
        arrayList.add(0, ServerConstants.StoplistLanguage.toHuman((String)"None"));
        this.jSelectedStoplistComboBox.removeAllItems();
        this.jSelectedStoplistComboBox.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        if (string2 != null) {
            this.jSelectedStoplistComboBox.setSelectedItem(string2);
        }
    }

    public void refreshUI(TransformationTokenType transformationTokenType) {
        this._textTransformation = transformationTokenType;
        List list = null;
        list = this._textTransformation.getToken().getLanguages().getLanguage();
        this.jSingleLanguageComboBox.setSelectedItem(ServerConstants.StoplistLanguage.toHuman((String)((TransformationTokenType.Token.Languages.Language)list.get(0)).getName()));
        StoplistType stoplistType = null;
        String string = transformationTokenType.getToken().getStoplistId();
        if (string != null) {
            for (StoplistType stoplistType2 : this._stoplists.getStoplist()) {
                if (!stoplistType2.getId().equals(string)) continue;
                stoplistType = stoplistType2;
                break;
            }
        }
        if (stoplistType != null) {
            this.jSelectedStoplistComboBox.setSelectedItem(stoplistType.getName());
        } else {
            this.jSelectedStoplistComboBox.setSelectedItem(ServerConstants.StoplistLanguage.toHuman((String)"None"));
        }
        int n = transformationTokenType.getToken().getMaxNumberAllDocs().intValue();
        this.jMaxNumAllDocsSpinner.setValue(n);
        this.enableControls();
    }

    public boolean copySettings(BuildNodeType buildNodeType, TransformationTokenType transformationTokenType, BuildNodeType.Stoplists stoplists) throws ValidationException {
        Integer n;
        TransformationTokenType.Token.Languages languages = new TransformationTokenType.Token.Languages();
        TransformationTokenType.Token.Languages.Language language = null;
        String string = (String)this.jSingleLanguageComboBox.getSelectedItem();
        language = new TransformationTokenType.Token.Languages.Language();
        language.setName(ServerConstants.StoplistLanguage.toSchema((String)string));
        language.setType("SingleByte");
        languages.getLanguage().add(language);
        transformationTokenType.getToken().setLanguages(languages);
        transformationTokenType.getToken().setStoplistId(null);
        String string2 = (String)this.jSelectedStoplistComboBox.getSelectedItem();
        if (string2 != null) {
            if (ServerConstants.StoplistLanguage.isDefault((String)ServerConstants.StoplistLanguage.toSchema((String)string2))) {
                string = (String)this.jSingleLanguageComboBox.getSelectedItem();
                string = ServerConstants.StoplistLanguage.toSchema((String)string);
                n = AbstractBuildNode.findDefaultStoplist(stoplists, string);
                String string3 = n.getId();
                transformationTokenType.getToken().setStoplistId(string3);
            } else {
                transformationTokenType.getToken().setStoplistId(AbstractBuildNode.findStoplistId(stoplists, string2));
            }
        }
        n = (Integer)this.jMaxNumAllDocsSpinner.getValue();
        transformationTokenType.getToken().setMaxNumberAllDocs(BigInteger.valueOf(n.intValue()));
        return true;
    }

    private void enableControls() {
        if (this.jSelectedStoplistComboBox.getItemCount() > 0) {
            String string = (String)this.jSelectedStoplistComboBox.getSelectedItem();
            this.jEditStoplistButton.setEnabled(!ServerConstants.StoplistLanguage.isNone((String)ServerConstants.StoplistLanguage.toSchema((String)string)));
        } else {
            this.jEditStoplistButton.setEnabled(false);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.buttonGroup4 = new ButtonGroup();
        this.jLanguageLabel = new JLabel();
        this.jSingleLanguageComboBox = new JComboBox();
        this.jStoplistLabel = new JLabel();
        this.jSelectedStoplistComboBox = new JComboBox();
        this.jEditStoplistButton = new JButton();
        this.jNewStoplistButton = new JButton();
        this.jTokensLabel = new JLabel();
        this.jMaxNumAllDocsLabel = new JLabel();
        this.jMaxNumAllDocsSpinner = new JSpinner();
        this.jLanguageLabel.setText("Language:");
        this.jSingleLanguageComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jStoplistLabel.setText("Stoplist:");
        this.jSelectedStoplistComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jSelectedStoplistComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingThemePanel.this.jSelectedStoplistComboBoxActionPerformed(actionEvent);
            }
        });
        this.jEditStoplistButton.setText("---");
        this.jEditStoplistButton.setMargin(new Insets(2, 2, 2, 2));
        this.jEditStoplistButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingThemePanel.this.jEditStoplistButtonActionPerformed(actionEvent);
            }
        });
        this.jNewStoplistButton.setText("+");
        this.jNewStoplistButton.setMargin(new Insets(2, 2, 2, 2));
        this.jNewStoplistButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingThemePanel.this.jNewStoplistButtonActionPerformed(actionEvent);
            }
        });
        this.jTokensLabel.setText("Themes:");
        this.jMaxNumAllDocsLabel.setLabelFor(this.jMaxNumAllDocsSpinner);
        this.jMaxNumAllDocsLabel.setText("Max number across all documents");
        this.jMaxNumAllDocsSpinner.setModel(new SpinnerNumberModel(3000, 1, 100000, 100));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jMaxNumAllDocsLabel, -1, 205, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jMaxNumAllDocsSpinner)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTokensLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jStoplistLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLanguageLabel, GroupLayout.Alignment.LEADING, -1, 80, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSingleLanguageComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.jSelectedStoplistComboBox, 0, -1, Short.MAX_VALUE)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jEditStoplistButton, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jNewStoplistButton, -2, 26, -2).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLanguageLabel).addComponent(this.jSingleLanguageComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jStoplistLabel).addComponent(this.jEditStoplistButton).addComponent(this.jNewStoplistButton).addComponent(this.jSelectedStoplistComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTokensLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMaxNumAllDocsLabel).addComponent(this.jMaxNumAllDocsSpinner, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jSelectedStoplistComboBoxActionPerformed(ActionEvent actionEvent) {
        this.enableControls();
    }

    private void jEditStoplistButtonActionPerformed(ActionEvent actionEvent) {
        StoplistType stoplistType;
        String string = (String)this.jSelectedStoplistComboBox.getSelectedItem();
        StoplistType stoplistType2 = null;
        Object object = this._stoplists.getStoplist().iterator();
        while (object.hasNext()) {
            stoplistType = (StoplistType)object.next();
            if (!stoplistType.getName().equals(string)) continue;
            stoplistType2 = stoplistType;
            break;
        }
        if (((DialogDisplayer)(object = new StoplistDetailsPanel(this._context, this._node, this._buildNodeType, this, stoplistType2))).showAsDialog(this) && ((StoplistDetailsPanel)object).isDirty()) {
            stoplistType = ((StoplistDetailsPanel)object).getStoplist();
            for (int i = 0; i < this._stoplists.getStoplist().size(); ++i) {
                if (!((StoplistType)this._stoplists.getStoplist().get(i)).getId().equals(stoplistType.getId())) continue;
                this._stoplists.getStoplist().set(i, stoplistType);
                break;
            }
            this._dirty = true;
            this.initStoplists(stoplistType.getId());
        }
    }

    private void jNewStoplistButtonActionPerformed(ActionEvent actionEvent) {
        StoplistWizard stoplistWizard = new StoplistWizard();
        if (stoplistWizard.runWizard(this, null, this._context, this._node, this._sourceAttributeName)) {
            StoplistType stoplistType = stoplistWizard.getModel().getStoplist();
            String string = "" + AbstractBuildNode.getStoplistNextId(this._stoplists);
            stoplistType.setId(string);
            this._stoplists.getStoplist().add(stoplistType);
            this._dirty = true;
            this.initStoplists(string);
        }
    }

    public BuildNodeType.Stoplists getStoplists() {
        return this._stoplists;
    }
}

