/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.utils.UITools;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.build.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.TextTransColumnSettingSynonymPanel;
import oracle.dmt.dataminer.workflow.dialog.build.TextTransColumnSettingThemePanel;
import oracle.dmt.dataminer.workflow.dialog.build.TextTransColumnSettingTokenPanel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.LexerType;
import oracle.dmt.dataminer.workflow.xmlschema.MapTextTransformedSourceType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationOutputAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.TextTransformationType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformationTokenType;
import oracle.dmt.dataminer.workflow.xmlschema.TransformedAttributesType;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Version;

public class TextTransColumnSettingPanel
extends DialogDisplayer<AbstractBuildNode> {
    private static final String TRANSFORM_TOKEN = DialogsLrb.get("BUILD_TEXT_TRANSFORM_TYPE_TOKEN");
    private static final String TRANSFORM_THEME = DialogsLrb.get("BUILD_TEXT_TRANSFORM_TYPE_THEME");
    private static final String TRANSFORM_SYNONYM = DialogsLrb.get("BUILD_TEXT_TRANSFORM_TYPE_SYNONYM");
    private BuildNodeType _buildNodeType;
    private BuildNodeType.Stoplists _existStoplists;
    private TransformedAttributesType _textAttributes;
    private TransformationTokenType _token;
    private TransformationTokenType _theme;
    private TextTransformationType.Synonym _synonym;
    private boolean _bShowTokenSettings;
    private boolean _bShowThemeSettings;
    private boolean _bShowSynonymSettings;
    private String _sourceAttributeName = null;
    private TextTransColumnSettingTokenPanel _tokenPanel;
    private TextTransColumnSettingThemePanel _themePanel;
    private TextTransColumnSettingSynonymPanel _synonymPanel;
    private boolean _dirty;
    private boolean _isAdjusting;
    private boolean is122andUp;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private ButtonGroup buttonGroup4;
    private JPanel jSettingPanel;
    private JComboBox<String> jTransformTypeComboBox;
    private JLabel jTransformTypeLabel;

    public TextTransColumnSettingPanel(Context context, AbstractBuildNode abstractBuildNode, BuildNodeType buildNodeType, String string) {
        super(context, abstractBuildNode);
        assert (context != null) : "Context must not be null.";
        assert (abstractBuildNode != null) : "node node must not be null.";
        Version version = ConnectionFolder.getConnectionFolder(this._context).getDbVersion();
        this.is122andUp = DbVersionHelper.isDB122Up((Version)version);
        BuildNodeType buildNodeType2 = (BuildNodeType)MetaDataHelper.copyMetadataObject(buildNodeType);
        this.init(buildNodeType2, string);
    }

    private void init(BuildNodeType buildNodeType, String string) {
        TransformationTokenType.Token.Languages.Language language;
        TextTransformationOutputAttributeType textTransformationOutputAttributeType;
        Object object;
        MapTextTransformedSourceType mapTextTransformedSourceType2;
        this._buildNodeType = buildNodeType;
        this._sourceAttributeName = string;
        this._textAttributes = this._buildNodeType.getTextAttributes();
        boolean bl = false;
        for (MapTextTransformedSourceType mapTextTransformedSourceType2 : this._textAttributes.getMapTextTransformedSource()) {
            if (!mapTextTransformedSourceType2.getKey().getName().equals(string)) continue;
            object = mapTextTransformedSourceType2.getKey();
            bl = true;
            this._theme = object.getTransformationElement().getTheme();
            this._token = object.getTransformationElement().getToken();
            this._synonym = object.getTransformationElement().getSynonym();
            if (this._token != null) {
                this._bShowTokenSettings = true;
                break;
            }
            if (this._theme != null) {
                this._bShowThemeSettings = true;
                break;
            }
            if (!this.is122andUp || this._synonym == null) break;
            this._bShowSynonymSettings = true;
            break;
        }
        if (!bl) {
            textTransformationOutputAttributeType = new TextTransformationOutputAttributeType();
            mapTextTransformedSourceType2 = new MapTextTransformedSourceType();
            object = new TextTransformationType();
            textTransformationOutputAttributeType.setName(string);
            textTransformationOutputAttributeType.setSource(string);
            textTransformationOutputAttributeType.setDataType("DM_NESTED_NUMERICALS");
            textTransformationOutputAttributeType.setIsOutput(true);
            textTransformationOutputAttributeType.setModified(true);
            textTransformationOutputAttributeType.setStatus(AttributeStatus.VALID);
            textTransformationOutputAttributeType.setTransformationElement((TextTransformationType)object);
            mapTextTransformedSourceType2.setKey(textTransformationOutputAttributeType);
            this._textAttributes.getMapTextTransformedSource().add(mapTextTransformedSourceType2);
            if (this._buildNodeType.getTextSettings().getTransformType().equals("Token")) {
                this._bShowTokenSettings = true;
            } else if (this._buildNodeType.getTextSettings().getTransformType().equals("Theme")) {
                this._bShowThemeSettings = true;
            } else if (this.is122andUp && this._buildNodeType.getTextSettings().getTransformType().equals("Synonym")) {
                this._bShowSynonymSettings = true;
            }
        }
        if (this._token == null) {
            this._token = (TransformationTokenType)MetaDataHelper.copyMetadataObject(this._buildNodeType.getTextSettings().getToken());
        }
        if (this._theme == null) {
            textTransformationOutputAttributeType = new TransformationTokenType.Token();
            textTransformationOutputAttributeType.setPolicy("");
            mapTextTransformedSourceType2 = new TransformationTokenType.Token.Languages();
            for (TransformationTokenType.Token.Languages.Language language2 : this._buildNodeType.getTextSettings().getTheme().getToken().getLanguages().getLanguage()) {
                language = new TransformationTokenType.Token.Languages.Language();
                language.setName(language2.getName());
                language.setType(language2.getType());
                mapTextTransformedSourceType2.getLanguage().add(language);
            }
            textTransformationOutputAttributeType.setLanguages((TransformationTokenType.Token.Languages)mapTextTransformedSourceType2);
            textTransformationOutputAttributeType.setLexer((LexerType)MetaDataHelper.copyMetadataObject(this._buildNodeType.getTextSettings().getTheme().getToken().getLexer()));
            textTransformationOutputAttributeType.setFrequency(this._buildNodeType.getTextSettings().getTheme().getToken().getFrequency());
            textTransformationOutputAttributeType.setMaxNumberAllDocs(this._buildNodeType.getTextSettings().getTheme().getToken().getMaxNumberAllDocs());
            textTransformationOutputAttributeType.setMaxNumberPerDoc(this._buildNodeType.getTextSettings().getTheme().getToken().getMaxNumberPerDoc());
            textTransformationOutputAttributeType.setStoplistId(this._buildNodeType.getTextSettings().getTheme().getToken().getStoplistId());
            this._theme = new TextTransformationType.Theme();
            ((TextTransformationType.Theme)this._theme).setType("Single");
            this._theme.setToken((TransformationTokenType.Token)textTransformationOutputAttributeType);
        }
        if (this.is122andUp && this._synonym == null) {
            this._synonym = (TextTransformationType.Synonym)MetaDataHelper.copyMetadataObject(this._buildNodeType.getTextSettings().getSynonym());
            if (this._synonym == null) {
                this._synonym = new TextTransformationType.Synonym();
                textTransformationOutputAttributeType = new TransformationTokenType.Token();
                textTransformationOutputAttributeType.setPolicy("");
                mapTextTransformedSourceType2 = new TransformationTokenType.Token.Languages();
                for (TransformationTokenType.Token.Languages.Language language2 : this._buildNodeType.getTextSettings().getTheme().getToken().getLanguages().getLanguage()) {
                    language = new TransformationTokenType.Token.Languages.Language();
                    language.setName(language2.getName());
                    language.setType(language2.getType());
                    mapTextTransformedSourceType2.getLanguage().add(language);
                }
                textTransformationOutputAttributeType.setLanguages((TransformationTokenType.Token.Languages)mapTextTransformedSourceType2);
                textTransformationOutputAttributeType.setLexer((LexerType)MetaDataHelper.copyMetadataObject(this._buildNodeType.getTextSettings().getTheme().getToken().getLexer()));
                textTransformationOutputAttributeType.setFrequency("IDF");
                textTransformationOutputAttributeType.setMaxNumberAllDocs(BigInteger.valueOf(3000L));
                textTransformationOutputAttributeType.setMaxNumberPerDoc(BigInteger.valueOf(1L));
                textTransformationOutputAttributeType.setStoplistId(null);
                this._synonym.setToken((TransformationTokenType.Token)textTransformationOutputAttributeType);
            }
        }
        this._existStoplists = this._buildNodeType.getStoplists();
        this._dirty = false;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    @Override
    public void initRes() {
        this.jSettingPanel.setBorder(BorderFactory.createTitledBorder(DialogsLrb.get("TEXT_SETTINGS_BORDER_TITLE")));
        ResourceUtils.resLabel((JLabel)this.jTransformTypeLabel, this.jTransformTypeComboBox, (String)DialogsLrb.get("TEXT_SETTINGS_COLUMN_TRANSFORM_TYPE"));
    }

    @Override
    public void initUI() {
        this._isAdjusting = true;
        this.jTransformTypeComboBox.removeAllItems();
        this.jTransformTypeComboBox.addItem(TRANSFORM_TOKEN);
        this.jTransformTypeComboBox.addItem(TRANSFORM_THEME);
        if (this.is122andUp) {
            this.jTransformTypeComboBox.addItem(TRANSFORM_SYNONYM);
        }
        if (this._bShowTokenSettings) {
            this.jTransformTypeComboBox.setSelectedItem(TRANSFORM_TOKEN);
        } else if (this._bShowThemeSettings) {
            this.jTransformTypeComboBox.setSelectedItem(TRANSFORM_THEME);
        } else if (this.is122andUp) {
            this.jTransformTypeComboBox.setSelectedItem(TRANSFORM_SYNONYM);
        }
        this._tokenPanel = new TextTransColumnSettingTokenPanel(this._context, (AbstractBuildNode)this._data, this._buildNodeType, this._sourceAttributeName, this._token, this._existStoplists);
        this._themePanel = new TextTransColumnSettingThemePanel(this._context, (AbstractBuildNode)this._data, this._buildNodeType, this._sourceAttributeName, this._theme, this._existStoplists);
        if (this.is122andUp) {
            this._synonymPanel = new TextTransColumnSettingSynonymPanel(this._context, (AbstractBuildNode)this._data, this._buildNodeType, this._sourceAttributeName, this._synonym, this._existStoplists);
            this._bShowSynonymSettings = this._synonymPanel.isThesaurusLoaded();
        }
        this.jSettingPanel.removeAll();
        if (this._bShowTokenSettings) {
            this.jSettingPanel.add(this._tokenPanel);
        } else if (this._bShowThemeSettings) {
            this.jSettingPanel.add(this._themePanel);
        } else if (this.is122andUp && this._bShowSynonymSettings) {
            this.jSettingPanel.add(this._synonymPanel);
        }
        this._isAdjusting = false;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    @Override
    public boolean doWork() {
        boolean bl = true;
        try {
            TextTransformationType textTransformationType = null;
            for (MapTextTransformedSourceType mapTextTransformedSourceType : this._textAttributes.getMapTextTransformedSource()) {
                if (!mapTextTransformedSourceType.getKey().getName().equals(this._sourceAttributeName)) continue;
                TextTransformationOutputAttributeType textTransformationOutputAttributeType = mapTextTransformedSourceType.getKey();
                textTransformationType = textTransformationOutputAttributeType.getTransformationElement();
                break;
            }
            if (this._bShowTokenSettings) {
                this._dirty = this._tokenPanel.copySettings(this._buildNodeType, this._token, this._existStoplists);
                textTransformationType.setToken(this._token);
                textTransformationType.setTheme(null);
                textTransformationType.setSynonym(null);
            } else if (this._bShowThemeSettings) {
                this._dirty = this._themePanel.copySettings(this._buildNodeType, this._theme, this._existStoplists);
                textTransformationType.setToken(null);
                textTransformationType.setTheme((TextTransformationType.Theme)this._theme);
                textTransformationType.setSynonym(null);
            } else if (this.is122andUp && this._bShowSynonymSettings) {
                this._dirty = this._synonymPanel.copySettings(this._buildNodeType, (TransformationTokenType)this._synonym, this._existStoplists);
                textTransformationType.setToken(null);
                textTransformationType.setTheme(null);
                textTransformationType.setSynonym(this._synonym);
            }
        }
        catch (ValidationException validationException) {
            MessageDialog.error((Component)UITools.getParentWindow(this), (Object)validationException.getLocalizedMessage(), (String)DialogsLrb.get("ERROR_TITLE"), null);
            bl = false;
        }
        return bl;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.buttonGroup4 = new ButtonGroup();
        this.jTransformTypeLabel = new JLabel();
        this.jTransformTypeComboBox = new JComboBox();
        this.jSettingPanel = new JPanel();
        this.jTransformTypeLabel.setLabelFor(this.jTransformTypeComboBox);
        this.jTransformTypeLabel.setText("Transform Type:");
        this.jTransformTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextTransColumnSettingPanel.this.jTransformTypeComboBoxActionPerformed(actionEvent);
            }
        });
        this.jSettingPanel.setBorder(BorderFactory.createTitledBorder("Settings"));
        this.jSettingPanel.setLayout(new BorderLayout());
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jTransformTypeLabel, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTransformTypeComboBox, -2, 112, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jSettingPanel, GroupLayout.Alignment.TRAILING, -1, 374, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTransformTypeLabel).addComponent(this.jTransformTypeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSettingPanel, -1, 305, Short.MAX_VALUE).addContainerGap()));
    }

    private void jTransformTypeComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this._isAdjusting) {
            return;
        }
        this._isAdjusting = true;
        String string = (String)this.jTransformTypeComboBox.getSelectedItem();
        this.jSettingPanel.removeAll();
        if (string.equals(TRANSFORM_TOKEN)) {
            this._bShowTokenSettings = true;
            this._bShowThemeSettings = false;
            this._bShowSynonymSettings = false;
            this._tokenPanel.refreshUI(this._token);
            this.jSettingPanel.add(this._tokenPanel);
        } else if (string.equals(TRANSFORM_THEME)) {
            this._bShowTokenSettings = false;
            this._bShowThemeSettings = true;
            this._bShowSynonymSettings = false;
            this._themePanel.refreshUI(this._theme);
            this.jSettingPanel.add(this._themePanel);
        } else if (this.is122andUp && string.equals(TRANSFORM_SYNONYM)) {
            this._bShowTokenSettings = false;
            this._bShowThemeSettings = false;
            this._bShowSynonymSettings = this._synonymPanel.isThesaurusLoaded();
            if (this._bShowSynonymSettings) {
                this._synonymPanel.refreshUI(this._synonym);
                this.jSettingPanel.add(this._synonymPanel);
            }
        }
        this.jSettingPanel.updateUI();
        this._isAdjusting = false;
    }

    public BuildNodeType.Stoplists getStoplists() {
        return this._existStoplists;
    }

    public TransformedAttributesType getTextAttributes() {
        return this._textAttributes;
    }

    @Override
    protected String getDialogTitle() {
        return DialogsLrb.get("ADD_BUILD_TEXT_TRANSFORM_DIALOG");
    }

    @Override
    protected String getHelpTopic() {
        return "text_custom_settings";
    }
}

