/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableExecutableAdapter;
import oracle.dmt.dataminer.core.model.CoreServerConstantsLrb;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.ModelPartitionedBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowModelPartitionedBuildNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.anomaly.AnomalyPartitionedBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.anomaly.WorkflowAnomalyPartitionedBuildNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.association.AssociationPartitionedBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.association.WorkflowAssociationPartitionedBuildNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.clustering.ClusteringPartitionedBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.clustering.WorkflowClusteringPartitionedBuildNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.efe.ExplicitFeatureExtractionPartitionedBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.efe.WorkflowExplicitFeatureExtractionPartitionedBuildNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.feature.FeatureExtractionPartitionedBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.feature.WorkflowFeatureExtractionPartitionedBuildNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.regression.RegressionPartitionedBuildNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.regression.WorkflowRegressionPartitionedBuildNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.ide.util.ResourceUtils;

public class PartitionAdvanceSettingPanel
extends JPanel
implements DialogDisplayable {
    private String oldPartitionBuildType;
    private PropertyModel propertyModel;
    private AbstractBuildNode buildNode;
    private BuildNodeType nodeDataCopy;
    private String partitionBuildType;
    private JComboBox cboPartitionBuildType;
    private JComboBox jComboBox1;
    private JLabel lblPartitionBuildType;

    public PartitionAdvanceSettingPanel(PropertyModel propertyModel, AbstractBuildNode abstractBuildNode, BuildNodeType buildNodeType) {
        this.oldPartitionBuildType = buildNodeType.getODMSPARTITIONBUILDTYPE();
        this.propertyModel = propertyModel;
        this.buildNode = abstractBuildNode;
        this.nodeDataCopy = buildNodeType;
        this.initComponents();
        this.initUI();
    }

    public void initUI() {
        ResourceUtils.resLabel((JLabel)this.lblPartitionBuildType, (Component)this.cboPartitionBuildType, (String)CoreServerConstantsLrb.get((String)"ODMS_PARTITION_BUILD_TYPE"));
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(new String[]{ServerConstants.GlobalSettings.toHuman((String)"ODMS_PARTITION_BUILD_HYBRID"), ServerConstants.GlobalSettings.toHuman((String)"ODMS_PARTITION_BUILD_INTER"), ServerConstants.GlobalSettings.toHuman((String)"ODMS_PARTITION_BUILD_INTRA")});
        this.cboPartitionBuildType.setModel(defaultComboBoxModel);
        String string = this.nodeDataCopy.getODMSPARTITIONBUILDTYPE();
        if (string == null || string.isEmpty()) {
            this.cboPartitionBuildType.setSelectedIndex(0);
        } else {
            this.cboPartitionBuildType.setSelectedItem(ServerConstants.GlobalSettings.toHuman((String)string));
        }
    }

    public String getPartitionBuildType() {
        return this.partitionBuildType;
    }

    private void updatePartitionType() {
        String string = this.cboPartitionBuildType.getSelectedItem().toString();
        this.partitionBuildType = ServerConstants.GlobalSettings.toAlgorithm((String)string);
        if (this.propertyModel != null) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            this.nodeDataCopy.setODMSPARTITIONBUILDTYPE(this.partitionBuildType);
            if (this.propertyModel instanceof WorkflowModelPartitionedBuildNodePropertyProxyModel) {
                ModelPartitionedBuildNodePropertyModel.updatePartitionBuildType(arrayList, this.buildNode, this.partitionBuildType, this.oldPartitionBuildType);
                ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION_BUILD_TYPE"), this.buildNode, arrayList);
            } else if (this.propertyModel instanceof WorkflowAnomalyPartitionedBuildNodePropertyProxyModel) {
                AnomalyPartitionedBuildNodePropertyModel.updatePartitionBuildType(arrayList, this.buildNode, this.partitionBuildType, this.oldPartitionBuildType);
                ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION_BUILD_TYPE"), this.buildNode, arrayList);
            } else if (this.propertyModel instanceof WorkflowAssociationPartitionedBuildNodePropertyProxyModel) {
                AssociationPartitionedBuildNodePropertyModel.updatePartitionBuildType(arrayList, this.buildNode, this.partitionBuildType, this.oldPartitionBuildType);
                ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION_BUILD_TYPE"), this.buildNode, arrayList);
            } else if (this.propertyModel instanceof WorkflowClusteringPartitionedBuildNodePropertyProxyModel) {
                ClusteringPartitionedBuildNodePropertyModel.updatePartitionBuildType(arrayList, this.buildNode, this.partitionBuildType, this.oldPartitionBuildType);
                ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION_BUILD_TYPE"), this.buildNode, arrayList);
            } else if (this.propertyModel instanceof WorkflowFeatureExtractionPartitionedBuildNodePropertyProxyModel) {
                FeatureExtractionPartitionedBuildNodePropertyModel.updatePartitionBuildType(arrayList, this.buildNode, this.partitionBuildType, this.oldPartitionBuildType);
                ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION_BUILD_TYPE"), this.buildNode, arrayList);
            } else if (this.propertyModel instanceof WorkflowRegressionPartitionedBuildNodePropertyProxyModel) {
                RegressionPartitionedBuildNodePropertyModel.updatePartitionBuildType(arrayList, this.buildNode, this.partitionBuildType, this.oldPartitionBuildType);
                ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION_BUILD_TYPE"), this.buildNode, arrayList);
            } else if (this.propertyModel instanceof WorkflowExplicitFeatureExtractionPartitionedBuildNodePropertyProxyModel) {
                ExplicitFeatureExtractionPartitionedBuildNodePropertyModel.updatePartitionBuildType(arrayList, this.buildNode, this.partitionBuildType, this.oldPartitionBuildType);
                ((WorkflowNodePropertyProxyModel)this.propertyModel).setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_PARTITION_BUILD_TYPE"), this.buildNode, arrayList);
            }
        }
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableExecutableAdapter(){

            @Override
            public void onOK() throws DialogExecutionException {
                PartitionAdvanceSettingPanel.this.updatePartitionType();
            }

            @Override
            public String getTitle() {
                return DataDialogsLrb.get("PARTITION_ADVANCED_SETTINGS");
            }

            @Override
            public String getHelpTopic() {
                return "partition_advanced_settings";
            }

            @Override
            public JPanel getContent() {
                return PartitionAdvanceSettingPanel.this;
            }
        };
    }

    private void initComponents() {
        this.jComboBox1 = new JComboBox();
        this.lblPartitionBuildType = new JLabel();
        this.cboPartitionBuildType = new JComboBox();
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.lblPartitionBuildType.setText("Partition Build Type:");
        this.cboPartitionBuildType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cboPartitionBuildType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PartitionAdvanceSettingPanel.this.cboPartitionBuildTypeActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.lblPartitionBuildType).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cboPartitionBuildType, -2, 202, -2).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPartitionBuildType).addComponent(this.cboPartitionBuildType, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void cboPartitionBuildTypeActionPerformed(ActionEvent actionEvent) {
    }
}

