/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.DialogExecutionException;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableExecutableAdapter;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.dal.sql.queries.extensible.r.GetRConfigurationQuery;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.ModelNameValidationDocument;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.build.extensible.r.BuildFunctionSelectionPanel;
import oracle.dmt.dataminer.workflow.dialog.build.extensible.r.DetailsFunctionSelectionPanel;
import oracle.dmt.dataminer.workflow.dialog.build.extensible.r.ScoreFunctionSelectionPanel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.ExtensibleBuildNode;
import oracle.dmt.dataminer.workflow.model.RBuildNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ExtensibleBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.RModelType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.BlockingComponent;
import oracle.javatools.util.Version;

public class NewRModelPanel
extends JPanel
implements DialogDisplayable {
    private static final Logger theLogger = Logger.getLogger(NewRModelPanel.class.getName());
    private static final int MAX_COMMENT_LENGTH = 10000;
    private static final int NAME_MAX_LEN_EX = 123;
    private static final int NAME_MAX_LEN = 25;
    private RModelType.BuildFunctions modelBuildFunctions;
    private RModelType.ScoreFunctions modelScoreFunctions;
    private RModelType.DetailFunction modelDetailFunction;
    private RModelType newModel;
    private ConnectionManager connectionManager;
    private SqlDataAccessObject dao;
    private Version dbVersion;
    private Collection<String> wfInMemoryModelNames;
    private BlockingComponent overlayPanel;
    private RBuildNode rBuildNode;
    private String miningFunction;
    private Boolean nameTouched;
    private String modelName;
    private Context context;
    private String comment;
    private JLabel buildWarning;
    private JLabel detailsWarning;
    private JButton jBuildButton;
    private JTextField jBuildFunction;
    private JLabel jBuildLabel;
    private JLabel jCommentLabel;
    private JTextArea jCommentText;
    private JButton jDetailsButton;
    private JTextField jDetailsFunction;
    private JLabel jDetailsLabel;
    private JTextField jModelName;
    private JLabel jModelNameLabel;
    private JButton jScoreButton;
    private JTextField jScoreFunction;
    private JLabel jScoreLabel;
    private JLabel scoreWarning;
    private JScrollPane textScrolPane;

    public NewRModelPanel(Context context, RBuildNode rBuildNode, MiningFunctionType miningFunctionType, Collection<String> collection) {
        this.context = context;
        this.rBuildNode = rBuildNode;
        this.connectionManager = ConnectionFolder.getConnectionFolder(context);
        this.dbVersion = this.connectionManager.getDbVersion();
        this.dao = new SqlDataAccessObject(this.connectionManager);
        this.wfInMemoryModelNames = collection;
        switch (miningFunctionType) {
            case CLASSIFICATION: {
                this.miningFunction = "CLASSIFICATION";
                break;
            }
            case REGRESSION: {
                this.miningFunction = "REGRESSION";
                break;
            }
            case CLUSTERING: {
                this.miningFunction = "CLUSTERING";
                break;
            }
            case FEATURE_EXTRACTION: {
                this.miningFunction = "FEATURE_EXTRACTION";
                break;
            }
            default: {
                assert (false) : "Invalid Option";
                break;
            }
        }
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.jModelNameLabel = new JLabel();
        this.jModelName = new JTextField();
        this.jBuildLabel = new JLabel();
        this.jBuildFunction = new JTextField();
        this.jScoreFunction = new JTextField();
        this.jScoreLabel = new JLabel();
        this.jDetailsFunction = new JTextField();
        this.jDetailsLabel = new JLabel();
        this.jBuildButton = new JButton();
        this.jScoreButton = new JButton();
        this.jDetailsButton = new JButton();
        this.textScrolPane = new JScrollPane();
        this.jCommentText = new JTextArea();
        this.jCommentLabel = new JLabel();
        this.buildWarning = new JLabel();
        this.scoreWarning = new JLabel();
        this.detailsWarning = new JLabel();
        this.jModelNameLabel.setText("Name:");
        this.jBuildLabel.setText("Build Function:");
        this.jScoreLabel.setText("Score Function:");
        this.jDetailsLabel.setText("Model Details Function:");
        this.jBuildButton.setText("Edit...");
        this.jScoreButton.setText("Edit...");
        this.jDetailsButton.setText("Edit...");
        this.jCommentText.setColumns(20);
        this.jCommentText.setRows(5);
        this.textScrolPane.setViewportView(this.jCommentText);
        this.jCommentLabel.setText("Comment:");
        this.buildWarning.setText("warning");
        this.scoreWarning.setText("warning");
        this.detailsWarning.setText("warning");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jDetailsLabel).addComponent(this.jModelNameLabel, GroupLayout.Alignment.LEADING).addComponent(this.jBuildLabel, GroupLayout.Alignment.LEADING).addComponent(this.jScoreLabel, GroupLayout.Alignment.LEADING)).addComponent(this.jCommentLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jScoreFunction, -1, 215, Short.MAX_VALUE).addComponent(this.jBuildFunction, GroupLayout.Alignment.LEADING).addComponent(this.jModelName, GroupLayout.Alignment.LEADING).addComponent(this.jDetailsFunction)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.jScoreButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scoreWarning)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jDetailsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.detailsWarning)).addGroup(groupLayout.createSequentialGroup().addComponent(this.jBuildButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buildWarning)))).addComponent(this.textScrolPane)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jModelNameLabel).addComponent(this.jModelName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jBuildLabel).addComponent(this.jBuildFunction, -2, -1, -2).addComponent(this.jBuildButton).addComponent(this.buildWarning)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jScoreFunction, -2, -1, -2).addComponent(this.jScoreLabel).addComponent(this.jScoreButton).addComponent(this.scoreWarning)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jDetailsFunction, -2, -1, -2).addComponent(this.jDetailsLabel).addComponent(this.jDetailsButton).addComponent(this.detailsWarning)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.textScrolPane, -1, 84, Short.MAX_VALUE).addContainerGap()).addGroup(groupLayout.createSequentialGroup().addComponent(this.jCommentLabel).addContainerGap()))));
    }

    private void initRes() {
        ResourceUtils.resLabel((JLabel)this.jModelNameLabel, (Component)this.jModelName, (String)BuildEditorLrb.get("MODEL_NAME"));
        ResourceUtils.resLabel((JLabel)this.jBuildLabel, (Component)this.jBuildLabel, (String)BuildEditorLrb.get("R_BUILD_FUNCTION"));
        ResourceUtils.resLabel((JLabel)this.jScoreLabel, (Component)this.jScoreLabel, (String)BuildEditorLrb.get("R_SCORE_FUNCTION"));
        ResourceUtils.resLabel((JLabel)this.jDetailsLabel, (Component)this.jDetailsLabel, (String)BuildEditorLrb.get("R_DETAILS_FUNCTION"));
        ResourceUtils.resButton((AbstractButton)this.jBuildButton, (String)WorkflowEditorLrb.get("EDIT_NODE"));
        ResourceUtils.resButton((AbstractButton)this.jScoreButton, (String)WorkflowEditorLrb.get("EDIT_NODE"));
        ResourceUtils.resButton((AbstractButton)this.jDetailsButton, (String)WorkflowEditorLrb.get("EDIT_NODE"));
        this.buildWarning.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.buildWarning.setText("");
        this.buildWarning.setToolTipText(BuildEditorLrb.get("R_BUILD_FUNCTIONS_MISSING"));
        this.scoreWarning.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.scoreWarning.setText("");
        this.scoreWarning.setToolTipText(BuildEditorLrb.get("R_SCORE_FUNCTIONS_MISSING"));
        this.detailsWarning.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this.detailsWarning.setText("");
        this.detailsWarning.setToolTipText(BuildEditorLrb.get("R_DETAILS_FUNCTION_MISSING"));
    }

    private void initUI() {
        this.overlayPanel = new BlockingComponent((JComponent)this);
        this.jModelName.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                NewRModelPanel.this.nameTouched = true;
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        try {
            this.modelName = WorkflowUtils.getNewModelNameWfid(this.context, this.wfInMemoryModelNames, this.miningFunction, "ALGO_R_USER_DEFINED");
        }
        catch (Exception exception) {
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
            this.modelName = "";
        }
        boolean bl = SQLHelper.isExpandedObjNameEnabled(this.context);
        this.jModelName.setDocument(new ModelNameValidationDocument(bl ? 123 : 25, true));
        this.jModelName.setText(this.modelName);
        this.jBuildFunction.setEditable(false);
        this.jScoreFunction.setEditable(false);
        this.jDetailsFunction.setEditable(false);
        this.jBuildButton.addActionListener(actionEvent -> {
            Optional<RModelType.BuildFunctions> optional = BuildFunctionSelectionPanel.addBuildFunctions(this.context, this.rBuildNode, this.modelBuildFunctions);
            if (optional.isPresent()) {
                if (this.modelBuildFunctions != null) {
                    this.modelBuildFunctions.setSettings(null);
                }
                this.modelBuildFunctions = optional.get();
                this.jBuildFunction.setText(this.modelBuildFunctions.getPrimaryFunction());
                this.jBuildFunction.setCaretPosition(0);
            }
            this.buildWarning.setVisible(this.modelBuildFunctions == null || StringUtils.isEmpty(this.modelBuildFunctions.getPrimaryFunction()));
        });
        this.jScoreButton.addActionListener(actionEvent -> {
            Optional<RModelType.ScoreFunctions> optional = ScoreFunctionSelectionPanel.addScoreFunctions(this.context, this.modelScoreFunctions);
            if (optional.isPresent()) {
                this.modelScoreFunctions = optional.get();
                this.jScoreFunction.setText(this.modelScoreFunctions.getPrimaryFunction());
                this.jScoreFunction.setCaretPosition(0);
            }
            this.scoreWarning.setVisible(this.modelScoreFunctions == null || StringUtils.isEmpty(this.modelScoreFunctions.getPrimaryFunction()));
        });
        this.jDetailsButton.addActionListener(actionEvent -> {
            Optional<RModelType.DetailFunction> optional = DetailsFunctionSelectionPanel.addDetailFunction(this.context, this.modelDetailFunction);
            if (optional.isPresent()) {
                if (this.modelDetailFunction != null) {
                    this.modelDetailFunction.setOutput(null);
                }
                this.modelDetailFunction = optional.get();
                this.jDetailsFunction.setText(this.modelDetailFunction.getPrimaryFunction());
                this.jDetailsFunction.setCaretPosition(0);
            }
            this.detailsWarning.setVisible(this.modelDetailFunction == null || StringUtils.isEmpty(this.modelDetailFunction.getPrimaryFunction()));
        });
    }

    public boolean validateForm() {
        boolean bl = true;
        this.modelName = this.jModelName.getText();
        this.comment = this.jCommentText.getText();
        if (!NewRModelPanel.validateName(this.modelName, this.context, this, this.wfInMemoryModelNames, null) || !this.validateComment(this.comment)) {
            bl = false;
        }
        if (StringUtils.checkDataLossWithMsg(this.context, this.modelName, BuildEditorLrb.get("MODEL_NAME_INVALID_TITLE"))) {
            bl = false;
        }
        boolean bl2 = bl = this.modelBuildFunctions != null && StringUtils.isNotEmpty(this.modelBuildFunctions.getPrimaryFunction());
        if (bl) {
            this.newModel = (RModelType)this.rBuildNode.createNewModel(this.modelName, this.comment, this.miningFunction, "ALGO_R_USER_DEFINED");
        }
        if (this.newModel != null) {
            this.newModel.setUseForOutput(true);
            this.newModel.setBuildFunctions(this.modelBuildFunctions);
            if (this.modelScoreFunctions != null) {
                this.newModel.setScoreFunctions(this.modelScoreFunctions);
            }
            if (this.modelDetailFunction != null) {
                this.newModel.setDetailFunction(this.modelDetailFunction);
            }
        }
        return bl;
    }

    public static boolean validateName(String string, Context context, Component component, Collection<String> collection, String string2) {
        boolean bl = true;
        boolean bl2 = SQLHelper.isExpandedObjNameEnabled(context);
        if (string.length() == 0) {
            Object[] objectArray = new Object[]{bl2 ? 123 : 25};
            String string3 = MessageFormat.format(BuildEditorLrb.get("ADD_NAME_ERROR"), objectArray);
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string3, (String)BuildEditorLrb.get("ADD_NAME_ERROR_TITLE"), null);
            return false;
        }
        if (bl2) {
            if (string.length() > 123) {
                Object[] objectArray = new Object[]{123};
                String string4 = MessageFormat.format(BuildEditorLrb.get("ADD_NAME_ERROR"), objectArray);
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string4, (String)BuildEditorLrb.get("ADD_NAME_ERROR_TITLE"), null);
                return false;
            }
        } else if (string.length() > 25) {
            Object[] objectArray = new Object[]{25};
            String string5 = MessageFormat.format(BuildEditorLrb.get("ADD_NAME_ERROR"), objectArray);
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string5, (String)BuildEditorLrb.get("ADD_NAME_ERROR_TITLE"), null);
            return false;
        }
        if (!StringUtils.containsOnlyValidDBNameCharacters(string)) {
            Object[] objectArray = new Object[]{bl2 ? 123 : 25};
            String string6 = MessageFormat.format(BuildEditorLrb.get("MODEL_NAME_INVALID"), objectArray);
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string6, (String)BuildEditorLrb.get("MODEL_NAME_INVALID_TITLE"), null);
            return false;
        }
        if (string2 == null || !string2.equals(string)) {
            bl = WorkflowUtils.validateUserModelName(context, string, component, collection, WorkflowUtils.getAllInMemoryModelNames(context));
        }
        return bl;
    }

    private boolean validateComment(String string) {
        boolean bl = true;
        if (string.length() > 10000) {
            bl = false;
        }
        return bl;
    }

    private void blockFunctionSelectionButtons() {
        this.jBuildButton.setEnabled(false);
        this.jScoreButton.setEnabled(false);
        this.jDetailsButton.setEnabled(false);
        this.buildWarning.setVisible(true);
        this.scoreWarning.setVisible(true);
        this.detailsWarning.setVisible(true);
        this.buildWarning.setIcon(OracleIcons.getIcon((String)"error.png"));
        this.scoreWarning.setIcon(OracleIcons.getIcon((String)"error.png"));
        this.detailsWarning.setIcon(OracleIcons.getIcon((String)"error.png"));
        this.buildWarning.setToolTipText(BuildEditorLrb.get("R_NOT_AVAILABLE"));
        this.scoreWarning.setToolTipText(BuildEditorLrb.get("R_NOT_AVAILABLE"));
        this.detailsWarning.setToolTipText(BuildEditorLrb.get("R_NOT_AVAILABLE"));
    }

    public void load() {
        LoadRConfig loadRConfig = new LoadRConfig();
        loadRConfig.execute();
    }

    public ModelType getNewModel() {
        return this.newModel;
    }

    public static ModelType addNewModel(Component component, BuildNodeType buildNodeType, Context context, AbstractBuildNode abstractBuildNode, Collection<String> collection) {
        WorkflowModel workflowModel = WorkflowUtils.getWorkflowModel((WorkflowNode)context.getNode());
        Collection<String> collection2 = WorkflowUtils.getInMemoryModelNames(workflowModel, buildNodeType);
        collection2.addAll(collection);
        ModelType modelType = null;
        NewRModelPanel newRModelPanel = new NewRModelPanel(context, (RBuildNode)abstractBuildNode, ((RBuildNodeType)buildNodeType).getMiningFunction(), collection2);
        newRModelPanel.load();
        DialogHelper dialogHelper = new DialogHelper(newRModelPanel);
        if (dialogHelper.showAsDialog(component)) {
            Object object;
            modelType = newRModelPanel.getNewModel();
            MetaDataHelper.setModelTargetPropertiesWithDefaultsFromModel(buildNodeType, modelType);
            MetaDataHelper.disableInvalidInputsInModel(modelType);
            if (abstractBuildNode instanceof ExtensibleBuildNode && ((AbstractBuildNode)(object = (ExtensibleBuildNode)abstractBuildNode)).isSupervisedBuildNode()) {
                ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)buildNodeType;
                AttributeType attributeType = extensibleBuildNodeType.getTargetAttribute();
                MetaDataHelper.setModelTargetPropertiesWithDefaults(buildNodeType, modelType, attributeType);
            }
            object = buildNodeType.getCaseAttributes().getAttribute();
            MetaDataHelper.setModelCaseIDsPropertiesWithDefaults(buildNodeType, modelType, (List<AttributeType>)object);
        }
        return modelType;
    }

    public static ModelType addNewModel(Component component, BuildNodeType buildNodeType, Context context, AbstractBuildNode abstractBuildNode) {
        return NewRModelPanel.addNewModel(component, buildNodeType, context, abstractBuildNode, new ArrayList<String>());
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableExecutableAdapter(){

            @Override
            public String getTitle() {
                return BuildEditorLrb.get("NEW_MODEL_DIALOG_TITLE");
            }

            @Override
            public String getHelpTopic() {
                return "r_pi_models_build";
            }

            @Override
            public JComponent getContent() {
                return NewRModelPanel.this.overlayPanel.getBlockingComponent();
            }

            @Override
            public void onOK() throws DialogExecutionException {
                if (!NewRModelPanel.this.validateForm()) {
                    throw new DialogExecutionException(CommonLrb.get("ERROR"), BuildEditorLrb.get("R_MODEL_INCOMPLETE"), null);
                }
            }
        };
    }

    protected class LoadRConfig
    extends ODMrSwingWorker<Map<String, Object>, Void> {
        private GetRConfigurationQuery query;

        protected LoadRConfig() {
            super(NewRModelPanel.this, NewRModelPanel.this.overlayPanel);
            this.query = new GetRConfigurationQuery(NewRModelPanel.this.dbVersion);
        }

        @Override
        protected void onSuccess(Map<String, Object> map) throws Exception {
            if (map.isEmpty()) {
                NewRModelPanel.this.blockFunctionSelectionButtons();
            }
        }

        @Override
        protected Map<String, Object> doInBackground() throws Exception {
            return NewRModelPanel.this.dao.readItem((Query)this.query).orElse(Collections.emptyMap());
        }

        @Override
        protected void onFailure(Throwable throwable) {
            NewRModelPanel.this.blockFunctionSelectionButtons();
        }
    }
}

