/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.build;

import java.awt.BorderLayout;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ListSelectionModel;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.workflow.WorkflowUtils;
import oracle.dmt.dataminer.workflow.dialog.build.AbstractModelSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.AbstractSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.AdvancedSettingsPanel;
import oracle.dmt.dataminer.workflow.dialog.build.ModelEditRecord;
import oracle.dmt.dataminer.workflow.dialog.build.algorithm.MainAlgorithmSettingsPanel;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AnomalyDetectionBuildNode;
import oracle.dmt.dataminer.workflow.model.AssociationBuildNode;
import oracle.dmt.dataminer.workflow.model.ClassificationBuildNode;
import oracle.dmt.dataminer.workflow.model.ClusteringBuildNode;
import oracle.dmt.dataminer.workflow.model.ExplicitFeatureExtractionBuildNode;
import oracle.dmt.dataminer.workflow.model.FeatureExtractionBuildNode;
import oracle.dmt.dataminer.workflow.model.RegressionBuildNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;

public class AlgorithmSettingsPanel
extends AbstractSettingsPanel {
    private static final Logger theLogger = Logger.getLogger(AlgorithmSettingsPanel.class.getName());
    protected AbstractModelSettingsPanel host;

    public AlgorithmSettingsPanel(AdvancedSettingsPanel advancedSettingsPanel, Context context, AbstractBuildNode abstractBuildNode, BuildNodeType buildNodeType) {
        super(advancedSettingsPanel, context, abstractBuildNode, (NodeType)buildNodeType);
        this.initUI();
    }

    public MainAlgorithmSettingsPanel getHost() {
        return (MainAlgorithmSettingsPanel)this.host;
    }

    protected void initIconResources() {
    }

    public void initUI() {
        this.host = new MainAlgorithmSettingsPanel(this.getEnclosingPanel());
        this.setLayout(new BorderLayout());
        this.add(this.host);
    }

    public boolean doWork() {
        return false;
    }

    @Override
    public boolean canProceed(ListSelectionModel listSelectionModel) {
        this.host.processInput();
        boolean bl = this.host.isValidState();
        if (bl && this.host.apply()) {
            ModelType modelType = this.host.getParentPanel().findEditedModel(this.host.getModelType());
            if (modelType == null) {
                modelType = this.host.getModelType();
                this.addEditedModelRecord(modelType, 1);
            } else {
                ModelType modelType2 = this.host.getModelType();
                if (modelType2 != null) {
                    ModelEditRecord modelEditRecord = this.host.getParentPanel().findEditedModelRecord(modelType);
                    if (modelEditRecord != null) {
                        this.replaceEditedModel(modelType);
                    } else {
                        this.addEditedModelRecord(modelType, 1);
                    }
                }
            }
        }
        return bl;
    }

    @Override
    protected boolean canHandleModelSelectionChange(ListSelectionModel listSelectionModel) {
        boolean bl = false;
        if (!listSelectionModel.isSelectionEmpty()) {
            this.host.processInput();
            bl = this.host.isValidState();
        }
        return bl;
    }

    @Override
    protected boolean handleModelSelectionChanged(ListSelectionModel listSelectionModel) {
        boolean bl;
        block13: {
            bl = false;
            if (!super.handleModelSelectionChanged(listSelectionModel)) {
                return bl;
            }
            if (!listSelectionModel.isSelectionEmpty() && listSelectionModel.getMinSelectionIndex() == listSelectionModel.getMaxSelectionIndex()) {
                int[] nArray = this.getSelectedModelRowsInModel();
                Object object = this.getModelsDataList().get(nArray[0]);
                AbstractBuildNode abstractBuildNode = this.getWorkflowNode();
                try {
                    if (!(abstractBuildNode instanceof ClassificationBuildNode) && !(abstractBuildNode instanceof RegressionBuildNode) && !(abstractBuildNode instanceof ClusteringBuildNode) && !(abstractBuildNode instanceof AnomalyDetectionBuildNode) && !(abstractBuildNode instanceof AssociationBuildNode) && !(abstractBuildNode instanceof FeatureExtractionBuildNode) && !(abstractBuildNode instanceof ExplicitFeatureExtractionBuildNode)) break block13;
                    WorkflowModel workflowModel = WorkflowUtils.getWorkflowModel((WorkflowNode)this.getContext().getNode());
                    AbstractDataNode abstractDataNode = abstractBuildNode.findBuildDataNode(workflowModel);
                    this.host.processInput();
                    if (this.host.isValidState()) {
                        if (this.host.apply()) {
                            ModelEditRecord modelEditRecord;
                            ModelType modelType = this.host.getModelType();
                            if (modelType != null) {
                                modelEditRecord = this.host.getParentPanel().findEditedModelRecord(modelType);
                                if (modelEditRecord != null) {
                                    this.replaceEditedModel(modelType);
                                } else {
                                    this.addEditedModelRecord(modelType, 1);
                                }
                            }
                            if ((modelEditRecord = this.host.getParentPanel().findEditedModel((ModelType)object)) == null) {
                                this.addEditedModelRecord((ModelType)object, 1);
                            } else {
                                object = modelEditRecord;
                            }
                        }
                        this.host.loadModel(this.getContext(), (ModelType)object, this.getMetadataCopy(), abstractDataNode);
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    this.host.loadUnderConstruction();
                    theLogger.log(Level.SEVERE, exception.getMessage(), exception);
                }
            } else if (!listSelectionModel.isSelectionEmpty() && listSelectionModel.getMinSelectionIndex() != listSelectionModel.getMaxSelectionIndex()) {
                this.host.loadMultipleSelection();
            }
        }
        return bl;
    }

    protected void handleModelMetadataChanged() {
    }

    @Override
    protected void loadEmptySelectionUI() {
        this.host.loadEmptySelection();
    }
}

