/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.apply;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.PropertyModelUpdateEvent;
import oracle.bali.inspector.UpdateType;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.ToolTipComboBoxRenderer;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.BaseTreeNode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.utils.PIAncestorListener;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.AbstractPanel;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyEditorPanel;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyOutputPanel;
import oracle.dmt.dataminer.workflow.dialog.apply.ApplyWizard;
import oracle.dmt.dataminer.workflow.dialog.apply.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicNodeEditorState;
import oracle.dmt.dataminer.workflow.dialog.model.EditModelNodePartitionDefPanel;
import oracle.dmt.dataminer.workflow.inspect.ApplyNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowApplyNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ApplyNode;
import oracle.dmt.dataminer.workflow.model.CreateTableNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.xmlschema.AnomalyDetectionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ApplyOutputColumnsType;
import oracle.dmt.dataminer.workflow.xmlschema.AssociationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.BuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClusteringBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.CreateTableNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DBAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.ExpectationMaximizationModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ExplicitFeatureExtractionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureExtractionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NonNegativeMatrixFactorModelType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressionType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.dmt.dataminer.workflow.xmlschema.RegressionBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.SupplementalAttributesType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.docking.DockableView;
import oracle.ide.inspector.InspectorManager;
import oracle.ide.model.Element;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorWindowImpl;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.util.Version;

public class ApplyModelsPanel
extends AbstractPanel<ApplyNode> {
    private static final Logger LOGGER = Logger.getLogger(ApplyModelsPanel.class.getName());
    private static DefaultComboBoxModel<String> EMPTY_MODEL = new DefaultComboBoxModel<String>(new String[]{DynamicNodeEditorState._none});
    private ApplyNode.ApplyOutputColumnNameGenerator _outputColumnNameGenerator;
    private WorkflowApplyNodePropertyProxyModel _propertyModel;
    private ApplyOutputColumnsType _applyOutputColumns;
    private Map<String, String> _modelNodesLookupMap;
    private Map<String, Boolean> _modelPartitioned;
    private boolean _isDatabaseVersion12_2andUp;
    private ApplyEditorPanel _parentEditor;
    private boolean bInitializingPanel;
    private ModelsTableModel _models;
    private String _ownerName;
    private boolean _dirty;
    private String oldCaseID;
    private JLabel JLblCaseID;
    private JButton addBtn;
    private JButton editBtn;
    private JCheckBox jAutoSettingsCheckBox;
    private JComboBox jComboCaseID;
    private JButton partitionBtn;
    private JButton removeBtn;
    private DataMinerTablePanel tablePanel;
    private JButton wizBtn;

    public ApplyModelsPanel(PropertyModel propertyModel) {
        super(null, null);
        assert (propertyModel != null) : "PropertyModel for apply node is null.";
        this._modelNodesLookupMap = new HashMap<String, String>();
        this._modelPartitioned = new HashMap<String, Boolean>();
        this._context = this.getContext(propertyModel);
        this._data = this.getTargetNode(propertyModel);
        this.addAncestorListener(new PIAncestorListener(this));
        this.init((ApplyNode)this._data, propertyModel);
    }

    public ApplyModelsPanel(Context context, ApplyNode applyNode, PropertyModel propertyModel, ApplyEditorPanel applyEditorPanel) {
        super(context, applyNode);
        assert (context != null) : "Context must not be null.";
        assert (applyNode != null) : "Apply node must not be null.";
        this._modelNodesLookupMap = new HashMap<String, String>();
        this._modelPartitioned = new HashMap<String, Boolean>();
        this._parentEditor = applyEditorPanel;
        this.init(applyNode, propertyModel);
    }

    private void init(ApplyNode applyNode, PropertyModel propertyModel) {
        this._propertyModel = (WorkflowApplyNodePropertyProxyModel)propertyModel;
        this.bInitializingPanel = true;
        this._dirty = false;
        ApplyNodeType applyNodeType = (ApplyNodeType)applyNode.getData();
        this._applyOutputColumns = (ApplyOutputColumnsType)MetaDataHelper.copyMetadataObject(applyNodeType.getOutputColumns());
        this._outputColumnNameGenerator = new ApplyNode.ApplyOutputColumnNameGenerator(applyNode.getContext(), this._applyOutputColumns);
        List<AbstractNode> list = applyNode.findApplyModelNodes();
        this._modelNodesLookupMap.clear();
        this._ownerName = ConnectionFolder.getUserAccountName(this._context);
        this._ownerName = StringUtils.isDoubleQuotedString(this._ownerName) ? StringUtils.trimDoubleQuotes(this._ownerName) : this._ownerName.toUpperCase();
        Version version = ConnectionFolder.getConnectionFolder(this.getContext()).getDbVersion();
        this._isDatabaseVersion12_2andUp = DbVersionHelper.isDB122Up((Version)version);
        for (AbstractNode abstractNode : list) {
            this._modelNodesLookupMap.put(abstractNode.getData().getId(), abstractNode.getData().getName());
            if (abstractNode.getData() instanceof ModelNodeType) {
                ModelNodeType modelNodeType = (ModelNodeType)abstractNode.getData();
                for (ModelNodeType.Models.Model model : modelNodeType.getModels().getModel()) {
                    if (model.getPartitionExpressions() != null && model.getPartitionExpressions().getPartitionExpression() != null && model.getPartitionExpressions().getPartitionExpression().size() > 0 && ((PartitionExpressionType)model.getPartitionExpressions().getPartitionExpression().get(0)).getPartitionAttribute() != null && ((PartitionExpressionType)model.getPartitionExpressions().getPartitionExpression().get(0)).getPartitionAttribute().getName() != null && !"".equals(((PartitionExpressionType)model.getPartitionExpressions().getPartitionExpression().get(0)).getPartitionAttribute().getName().trim())) {
                        this._modelPartitioned.put(model.getName(), true);
                        continue;
                    }
                    this._modelPartitioned.put(model.getName(), false);
                }
                continue;
            }
            this.findPartitionedModels((BuildNodeType)abstractNode.getData());
        }
        this.initComponents();
        this.initRes();
        this.initUI();
        this.loadCaseIds(applyNode);
        this.jComboCaseID.addActionListener(actionEvent -> {
            String string = (String)this.jComboCaseID.getSelectedItem();
            if (!this.bInitializingPanel) {
                this.updateSupplementalOutputs(string);
                this.oldCaseID = string;
            }
        });
        this.jComboCaseID.setRenderer(new ToolTipComboBoxRenderer());
        this.bInitializingPanel = false;
    }

    private void loadCaseIds(ApplyNode applyNode) {
        DataProvider dataProvider;
        List<String> list = new ArrayList<String>();
        Collection collection = null;
        AbstractNode abstractNode = applyNode.findApplyDataNode(applyNode.getModel());
        if (abstractNode == null) {
            this.jComboCaseID.setModel(EMPTY_MODEL);
            return;
        }
        if (abstractNode instanceof CreateTableNode) {
            dataProvider = (CreateTableNode)abstractNode;
            CreateTableNodeType createTableNodeType = (CreateTableNodeType)((AbstractNode)((Object)dataProvider)).getData();
            if (createTableNodeType != null) {
                DBAttributes dBAttributes = createTableNodeType.getDBAttributes();
                collection = dBAttributes.getDBAttribute();
            }
        } else if (abstractNode instanceof DataProvider) {
            dataProvider = (DataProvider)((Object)abstractNode);
            Attributes attributes = dataProvider.getAttributes();
            collection = attributes.getAttribute();
        }
        if (collection != null) {
            list = collection.stream().map(attributeType -> attributeType.getAlias() != null ? attributeType.getAlias() : attributeType.getName()).sorted().collect(Collectors.toList());
        }
        list.add(0, DynamicNodeEditorState._none);
        dataProvider = list.toArray(new String[list.size()]);
        this.jComboCaseID.setModel(new DefaultComboBoxModel((E[])dataProvider));
        this.loadSupplementalOutputs();
        if (this.jComboCaseID.getSelectedIndex() > -1) {
            this.oldCaseID = this.jComboCaseID.getSelectedItem().toString();
        }
    }

    private void loadSupplementalOutputs() {
        ApplyNode applyNode = (ApplyNode)this.getData();
        ApplyNodeType applyNodeType = (ApplyNodeType)applyNode.getData();
        CaseAttributes caseAttributes = applyNodeType.getCaseAttributes();
        if (caseAttributes != null) {
            block0: for (AttributeType attributeType : caseAttributes.getAttribute()) {
                for (int i = 0; i < this.jComboCaseID.getModel().getSize(); ++i) {
                    if (!this.jComboCaseID.getModel().getElementAt(i).toString().equals(attributeType.getName())) continue;
                    this.jComboCaseID.setSelectedIndex(i);
                    continue block0;
                }
            }
        }
    }

    private void updateSupplementalOutputs(String string) {
        Object object7;
        Object object22;
        Object object3;
        Object object4;
        Object object5;
        ApplyNode applyNode = (ApplyNode)this.getData();
        ApplyNodeType applyNodeType = (ApplyNodeType)applyNode.getData();
        SupplementalAttributesType supplementalAttributesType = applyNodeType.getSupplementalAttributes();
        CaseAttributes caseAttributes = applyNodeType.getCaseAttributes();
        List list = supplementalAttributesType.getAttribute();
        Object object6 = null;
        AbstractNode abstractNode = applyNode.findApplyDataNode(applyNode.getModel());
        if (abstractNode == null) {
            return;
        }
        if (abstractNode instanceof CreateTableNode) {
            object5 = (CreateTableNode)abstractNode;
            object4 = (CreateTableNodeType)((AbstractNode)object5).getData();
            if (object4 != null) {
                object3 = object4.getDBAttributes();
                for (Object object22 : object3.getDBAttribute()) {
                    if (object22.getAlias() != null) {
                        if (!object22.getAlias().equals(string)) continue;
                        object6 = object22;
                    } else {
                        if (!object22.getName().equals(string)) continue;
                        object6 = object22;
                    }
                    break;
                }
            }
        } else if (abstractNode instanceof DataProvider) {
            object5 = (DataProvider)((Object)abstractNode);
            object4 = object5.getAttributes();
            for (Object object7 : object4.getAttribute()) {
                if (object7.getAlias() != null) {
                    if (!object7.getAlias().equals(string)) continue;
                    object6 = object7;
                } else {
                    if (!object7.getName().equals(string)) continue;
                    object6 = object7;
                }
                break;
            }
        }
        if (DynamicNodeEditorState._none.equals(string)) {
            object5 = this._parentEditor != null && this._parentEditor.getDataPanel() != null ? this._parentEditor.getDataPanel().getSupplementalAttributes() : applyNodeType.getSupplementalAttributes();
            object4 = object5.getAttribute();
            if (AutoSpecType.YES.equals((Object)object5.getAutoSpec())) {
                object3 = null;
                object7 = object4.iterator();
                while (object7.hasNext()) {
                    object22 = (AttributeType)object7.next();
                    if (!object22.getName().equals(this.oldCaseID)) continue;
                    object3 = object22;
                    break;
                }
                if (object3 != null) {
                    if (this._parentEditor != null && this._parentEditor.getDataPanel() != null) {
                        this._parentEditor.getDataPanel().removeCaseId((AttributeType)object3);
                    } else {
                        object4.remove(object3);
                    }
                }
            }
            applyNodeType.setCaseAttributes(new CaseAttributes());
            this.updatePI();
        } else if (object6 != null) {
            object5 = "";
            object5 = object6.getName();
            if (object6.getAlias() != null) {
                object5 = object6.getAlias();
            }
            if (caseAttributes == null) {
                applyNodeType.setCaseAttributes(new CaseAttributes());
                caseAttributes = applyNodeType.getCaseAttributes();
            }
            object4 = caseAttributes.getAttribute();
            object4.clear();
            object4.add(object6);
            boolean bl = false;
            object7 = this._parentEditor != null && this._parentEditor.getDataPanel() != null ? this._parentEditor.getDataPanel().getSupplementalAttributes() : applyNodeType.getSupplementalAttributes();
            object22 = object7.getAttribute();
            if (object22 != null) {
                Iterator iterator = object22.iterator();
                while (iterator.hasNext()) {
                    AttributeType attributeType = (AttributeType)iterator.next();
                    String string2 = attributeType.getName();
                    if (attributeType.getAlias() != null) {
                        string2 = attributeType.getAlias();
                    }
                    if (!string2.equals(object5)) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                if (object7.getAutoSpec() == AutoSpecType.YES) {
                    object22.clear();
                    object22.add(object6);
                }
                this.updatePI();
            }
        }
        this._dirty = true;
        if (this._parentEditor != null && this._parentEditor.getDataPanel() != null) {
            this._parentEditor.getDataPanel().setDirty(true);
        }
        if (this._propertyModel != null && (object5 = (BaseTreeNode)this._context.getNode()) instanceof WorkflowNode) {
            object5.markDirty(true);
        }
    }

    private void updatePI() {
        if (this._propertyModel != null) {
            for (Object e : InspectorManager.getInspectorManager().getViews()) {
                DockableView dockableView;
                if (!(e instanceof DockableView) || !(dockableView = (DockableView)e).isVisible() || !(dockableView instanceof InspectorWindowImpl) || dockableView.getGUI() == null) continue;
                PropertyModelUpdateEvent propertyModelUpdateEvent = new PropertyModelUpdateEvent();
                propertyModelUpdateEvent.updateType(UpdateType.UPDATE_VALUES_ONLY);
                InspectorWindowImpl inspectorWindowImpl = (InspectorWindowImpl)dockableView;
                inspectorWindowImpl.updatePropertyInspector(propertyModelUpdateEvent);
            }
        }
    }

    public void findPartitionedModels(BuildNodeType buildNodeType) {
        block23: {
            boolean bl;
            block28: {
                block27: {
                    block26: {
                        block25: {
                            block24: {
                                Object object5;
                                block22: {
                                    Object object2;
                                    Object object3;
                                    Object object42;
                                    bl = false;
                                    if (!(buildNodeType instanceof ClassificationBuildNodeType)) break block22;
                                    ClassificationBuildNodeType classificationBuildNodeType = (ClassificationBuildNodeType)buildNodeType;
                                    if (classificationBuildNodeType.getPartitionExpressions() != null && classificationBuildNodeType.getPartitionExpressions().getPartitionExpression() != null && classificationBuildNodeType.getPartitionExpressions().getPartitionExpression().size() > 0) {
                                        bl = true;
                                    }
                                    List list = classificationBuildNodeType.getModels().getCGeneralizedLinearModel();
                                    for (Object object42 : list) {
                                        this._modelPartitioned.put(object42.getName(), bl);
                                    }
                                    List list2 = classificationBuildNodeType.getModels().getCSupportVectorMachineModel();
                                    object42 = list2.iterator();
                                    while (object42.hasNext()) {
                                        object3 = (ModelType)object42.next();
                                        this._modelPartitioned.put(object3.getName(), bl);
                                    }
                                    object42 = classificationBuildNodeType.getModels().getDecisionTreeModel();
                                    object3 = object42.iterator();
                                    while (object3.hasNext()) {
                                        object2 = (ModelType)object3.next();
                                        this._modelPartitioned.put(object2.getName(), bl);
                                    }
                                    object3 = classificationBuildNodeType.getModels().getNaiveBayesModel();
                                    object2 = object3.iterator();
                                    while (object2.hasNext()) {
                                        ModelType modelType = (ModelType)object2.next();
                                        this._modelPartitioned.put(modelType.getName(), bl);
                                    }
                                    break block23;
                                }
                                if (!(buildNodeType instanceof RegressionBuildNodeType)) break block24;
                                RegressionBuildNodeType regressionBuildNodeType = (RegressionBuildNodeType)buildNodeType;
                                if (regressionBuildNodeType.getPartitionExpressions() != null && regressionBuildNodeType.getPartitionExpressions().getPartitionExpression() != null && regressionBuildNodeType.getPartitionExpressions().getPartitionExpression().size() > 0) {
                                    bl = true;
                                }
                                List list = regressionBuildNodeType.getModels().getRGeneralizedLinearModel();
                                for (Object object5 : list) {
                                    this._modelPartitioned.put(object5.getName(), bl);
                                }
                                List list3 = regressionBuildNodeType.getModels().getRSupportVectorMachineModel();
                                object5 = list3.iterator();
                                while (object5.hasNext()) {
                                    ModelType modelType = (ModelType)object5.next();
                                    this._modelPartitioned.put(modelType.getName(), bl);
                                }
                                break block23;
                            }
                            if (!(buildNodeType instanceof ClusteringBuildNodeType)) break block25;
                            ClusteringBuildNodeType clusteringBuildNodeType = (ClusteringBuildNodeType)buildNodeType;
                            if (clusteringBuildNodeType.getPartitionExpressions() != null && clusteringBuildNodeType.getPartitionExpressions().getPartitionExpression() != null && clusteringBuildNodeType.getPartitionExpressions().getPartitionExpression().size() > 0) {
                                bl = true;
                            }
                            ClusteringBuildNodeType.Models models = clusteringBuildNodeType.getModels();
                            for (ExpectationMaximizationModelType expectationMaximizationModelType : models.getExpectationMaximizationModel()) {
                                this._modelPartitioned.put(expectationMaximizationModelType.getName(), bl);
                            }
                            for (ExpectationMaximizationModelType expectationMaximizationModelType : models.getKMeansModel()) {
                                this._modelPartitioned.put(expectationMaximizationModelType.getName(), bl);
                            }
                            for (ExpectationMaximizationModelType expectationMaximizationModelType : models.getOClusterModel()) {
                                this._modelPartitioned.put(expectationMaximizationModelType.getName(), bl);
                            }
                            break block23;
                        }
                        if (!(buildNodeType instanceof AssociationBuildNodeType)) break block26;
                        AssociationBuildNodeType associationBuildNodeType = (AssociationBuildNodeType)buildNodeType;
                        if (associationBuildNodeType.getPartitionExpressions() != null && associationBuildNodeType.getPartitionExpressions().getPartitionExpression() != null && associationBuildNodeType.getPartitionExpressions().getPartitionExpression().size() > 0) {
                            bl = true;
                        }
                        List list = associationBuildNodeType.getModels().getAprioriModel();
                        for (ModelType modelType : list) {
                            this._modelPartitioned.put(modelType.getName(), bl);
                        }
                        break block23;
                    }
                    if (!(buildNodeType instanceof FeatureExtractionBuildNodeType)) break block27;
                    FeatureExtractionBuildNodeType featureExtractionBuildNodeType = (FeatureExtractionBuildNodeType)buildNodeType;
                    if (featureExtractionBuildNodeType.getPartitionExpressions() != null && featureExtractionBuildNodeType.getPartitionExpressions().getPartitionExpression() != null && featureExtractionBuildNodeType.getPartitionExpressions().getPartitionExpression().size() > 0) {
                        bl = true;
                    }
                    FeatureExtractionBuildNodeType.Models models = featureExtractionBuildNodeType.getModels();
                    for (NonNegativeMatrixFactorModelType nonNegativeMatrixFactorModelType : models.getNonNegativeMatrixFactorModel()) {
                        this._modelPartitioned.put(nonNegativeMatrixFactorModelType.getName(), bl);
                    }
                    for (NonNegativeMatrixFactorModelType nonNegativeMatrixFactorModelType : models.getPCAModel()) {
                        this._modelPartitioned.put(nonNegativeMatrixFactorModelType.getName(), bl);
                    }
                    for (NonNegativeMatrixFactorModelType nonNegativeMatrixFactorModelType : models.getSVDModel()) {
                        this._modelPartitioned.put(nonNegativeMatrixFactorModelType.getName(), bl);
                    }
                    break block23;
                }
                if (!(buildNodeType instanceof AnomalyDetectionBuildNodeType)) break block28;
                AnomalyDetectionBuildNodeType anomalyDetectionBuildNodeType = (AnomalyDetectionBuildNodeType)buildNodeType;
                if (anomalyDetectionBuildNodeType.getPartitionExpressions() != null && anomalyDetectionBuildNodeType.getPartitionExpressions().getPartitionExpression() != null && anomalyDetectionBuildNodeType.getPartitionExpressions().getPartitionExpression().size() > 0) {
                    bl = true;
                }
                List list = anomalyDetectionBuildNodeType.getModels().getAnomalyDetectionModel();
                for (ModelType modelType : list) {
                    this._modelPartitioned.put(modelType.getName(), bl);
                }
                break block23;
            }
            if (!(buildNodeType instanceof ExplicitFeatureExtractionBuildNodeType)) break block23;
            ExplicitFeatureExtractionBuildNodeType explicitFeatureExtractionBuildNodeType = (ExplicitFeatureExtractionBuildNodeType)buildNodeType;
            if (explicitFeatureExtractionBuildNodeType.getPartitionExpressions() != null && explicitFeatureExtractionBuildNodeType.getPartitionExpressions().getPartitionExpression() != null && explicitFeatureExtractionBuildNodeType.getPartitionExpressions().getPartitionExpression().size() > 0) {
                bl = true;
            }
            List list = explicitFeatureExtractionBuildNodeType.getModels().getExplicitSemanticAnalysisModel();
            for (ModelType modelType : list) {
                this._modelPartitioned.put(modelType.getName(), bl);
            }
        }
    }

    public boolean isShowSchema() {
        boolean bl = false;
        if (this._applyOutputColumns.getOutputColumn() != null) {
            for (ApplyOutputColumnsType.OutputColumn outputColumn : this._applyOutputColumns.getOutputColumn()) {
                String string = outputColumn.getModel().getSchema();
                if (string == null || string.compareTo(this._ownerName) == 0) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void updatePI(PropertyModel propertyModel) {
        WorkflowApplyNodePropertyProxyModel workflowApplyNodePropertyProxyModel = (WorkflowApplyNodePropertyProxyModel)propertyModel;
        Context context = workflowApplyNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        ApplyNode applyNode = (ApplyNode)workflowNodeInspectorElement.getNode();
        if (applyNode == null) {
            return;
        }
        this._propertyModel = (WorkflowApplyNodePropertyProxyModel)propertyModel;
        this._context = context;
        this._data = applyNode;
        this._dirty = false;
        ApplyNodeType applyNodeType = (ApplyNodeType)applyNode.getData();
        this._applyOutputColumns = (ApplyOutputColumnsType)MetaDataHelper.copyMetadataObject(applyNodeType.getOutputColumns());
        this._outputColumnNameGenerator = new ApplyNode.ApplyOutputColumnNameGenerator(applyNode.getContext(), this._applyOutputColumns);
        List<AbstractNode> list = applyNode.findApplyModelNodes();
        this._modelNodesLookupMap.clear();
        for (AbstractNode abstractNode : list) {
            this._modelNodesLookupMap.put(abstractNode.getData().getId(), abstractNode.getData().getName());
        }
        this.loadCaseIds(applyNode);
        this.refreshUI();
    }

    private Context getContext(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowApplyNodePropertyProxyModel)) {
            return null;
        }
        WorkflowApplyNodePropertyProxyModel workflowApplyNodePropertyProxyModel = (WorkflowApplyNodePropertyProxyModel)propertyModel;
        Context context = workflowApplyNodePropertyProxyModel.getSelectionContext();
        return context;
    }

    private ApplyNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowApplyNodePropertyProxyModel)) {
            return null;
        }
        WorkflowApplyNodePropertyProxyModel workflowApplyNodePropertyProxyModel = (WorkflowApplyNodePropertyProxyModel)propertyModel;
        Context context = workflowApplyNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof ApplyNodeType) {
            return (ApplyNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }

    private void updateNode() {
        if (this._dirty && this._propertyModel != null) {
            ApplyNode applyNode = (ApplyNode)this.getData();
            ApplyNodeType applyNodeType = (ApplyNodeType)applyNode.getData();
            ComplexProperty complexProperty = new ComplexProperty("applyScoreOutputColumns", this._applyOutputColumns);
            ApplyOutputColumnsType applyOutputColumnsType = (ApplyOutputColumnsType)MetaDataHelper.copyMetadataObject(applyNodeType.getOutputColumns());
            complexProperty.setOldData(applyOutputColumnsType);
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(new Property(String.valueOf(ApplyNodePropertyModel.APPLY_SCORE_OUTPUT_COLUMNS.index), null, complexProperty, null, null));
            this._propertyModel.setValueAt(PropertyLrb.get("PI_APPLY_GROUP_APPLY_SCORE_OUTPUT_COLUMNS"), applyNode, arrayList);
        }
    }

    @Override
    public void initRes() {
        HashMap<String, JComponent> hashMap = new HashMap<String, JComponent>();
        hashMap.put(DialogsLrb.get("APPLY_AUTO_SETTING"), this.jAutoSettingsCheckBox);
        ResourceUtils.resLabel((JLabel)this.JLblCaseID, (Component)this.jComboCaseID, (String)BuildEditorLrb.get("BUILD_NODE_CASEID"));
        UIResourceHelper.setComponentText(hashMap);
    }

    @Override
    public void initUI() {
        this._models = new ModelsTableModel(this, this._applyOutputColumns.getOutputColumn(), this._modelNodesLookupMap);
        this.editBtn.setEnabled(false);
        this.removeBtn.setEnabled(false);
        this.tablePanel.addControlBarComponents(this.partitionBtn, this.wizBtn, this.addBtn, this.editBtn, this.removeBtn);
        this.tablePanel.setup((TableModel)((Object)this._models), DialogsLrb.get("APPLY_MODEL_TABLE_TITLE"), 0, true);
        this.partitionBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = ApplyModelsPanel.this.tablePanel.getTable().getSelectedRowsInModel();
                if (nArray.length != 1) {
                    return;
                }
                String string = ApplyModelsPanel.this.tablePanel.getTable().getModel().getValueAt(nArray[0], 3).toString();
                EditModelNodePartitionDefPanel editModelNodePartitionDefPanel = new EditModelNodePartitionDefPanel(ApplyModelsPanel.this._context, ApplyModelsPanel.this._ownerName, string);
                DialogHelper dialogHelper = new DialogHelper(editModelNodePartitionDefPanel);
                dialogHelper.showAsDialog();
            }
        });
        this.wizBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyModelsPanel.this.jWizardButtonActionPerformed(actionEvent);
            }
        });
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyModelsPanel.this.processAdd();
            }
        });
        this.editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyModelsPanel.this.processEdit();
            }
        });
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("APPLY_OUTPUT_REMOVE_OUTPUT"), (String)DialogsLrb.get("WARNING_TITLE"), null, (boolean)true)) {
                    return;
                }
                ApplyModelsPanel.this.processRemove();
            }
        });
        this.tablePanel.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ApplyModelsPanel.this.handleModelSelectionChanged();
            }
        });
        this.tablePanel.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ApplyModelsPanel.this.processEdit();
                }
            }
        });
        IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                RefModelType refModelType = ((ApplyOutputColumnsType.OutputColumn)ApplyModelsPanel.this._applyOutputColumns.getOutputColumn().get(n)).getModel();
                RefModelStatusType refModelStatusType = refModelType.getStatus();
                return refModelStatusType == RefModelStatusType.VALID ? DataMinerIcons.getNullIcon() : OracleIcons.getIcon((String)"warning.png");
            }
        });
        TableColumn tableColumn = this.tablePanel.getTable().getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(iconCellRenderer);
        TableColumn tableColumn2 = this.tablePanel.getTable().getColumnModel().getColumn(3);
        CustomCellRenderer customCellRenderer = new CustomCellRenderer();
        tableColumn2.setCellRenderer(customCellRenderer);
        this.tablePanel.getTable().setSelectionMode(2);
        this.tablePanel.getTable().setColumnSelectorAvailable(true);
        this.tablePanel.getTable().setShowToolTips(true);
        this.tablePanel.getTable().setUpdateSelectionOnSort(true);
        this.tablePanel.getTable().setRowSelectionAllowed(true);
        int n = 0;
        for (int n2 : ModelsTableModel._columnWidths) {
            this.tablePanel.getTable().getColumnModel().getColumn(n++).setPreferredWidth(n2);
        }
        this.enableControls();
    }

    public void refreshUI() {
        this._models.refreshModel(this._applyOutputColumns.getOutputColumn(), this._modelNodesLookupMap);
        this.loadSupplementalOutputs();
        this.enableControls();
    }

    private void enableControls() {
        Object object;
        boolean bl = this._applyOutputColumns.getAutoSpec().equals((Object)AutoSpecType.YES);
        this.jAutoSettingsCheckBox.setSelected(bl);
        this.jAutoSettingsCheckBox.setEnabled(this.isWritable());
        int n = this.tablePanel.getTable().getSelectedRowCount();
        if (this._isDatabaseVersion12_2andUp) {
            this.partitionBtn.setVisible(true);
            if (n != 1) {
                this.partitionBtn.setEnabled(false);
            } else {
                object = this.tablePanel.getTable().getModel().getValueAt(this.tablePanel.getTable().getSelectedRow(), 3).toString();
                if (this._modelPartitioned.containsKey(object) && this._modelPartitioned.get(object).booleanValue()) {
                    this.partitionBtn.setEnabled(true);
                } else {
                    this.partitionBtn.setEnabled(false);
                }
            }
        } else {
            this.partitionBtn.setVisible(false);
            this.partitionBtn.setEnabled(false);
        }
        object = ((ApplyNode)this._data).findApplyModelNodes();
        this.addBtn.setEnabled(this.isWritable() && !bl && object.size() > 0);
        this.editBtn.setEnabled(this.isWritable() && !bl && n == 1);
        this.removeBtn.setEnabled(this.isWritable() && !bl && n > 0);
        this.wizBtn.setEnabled(this.isWritable() && !bl && object.size() > 0);
    }

    private void processAdd() {
        ApplyOutputPanel applyOutputPanel = new ApplyOutputPanel(this.getContext(), this, this._applyOutputColumns, false);
        if (applyOutputPanel.showAsDialog(this) && applyOutputPanel.isDirty()) {
            ApplyOutputColumnsType.OutputColumn outputColumn = applyOutputPanel.getOutput();
            this._applyOutputColumns.getOutputColumn().add(outputColumn);
            this._models.refreshModel(this._applyOutputColumns.getOutputColumn(), this._modelNodesLookupMap);
            this._dirty = true;
            if (this._propertyModel != null) {
                this.updateNode();
            }
        }
    }

    private void processEdit() {
        int[] nArray = this.tablePanel.getTable().getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        ApplyOutputPanel applyOutputPanel = new ApplyOutputPanel(this.getContext(), this, this._applyOutputColumns, true);
        if (applyOutputPanel.showAsDialog(this) && applyOutputPanel.isDirty()) {
            ApplyOutputColumnsType.OutputColumn outputColumn = applyOutputPanel.getOutput();
            this._applyOutputColumns.getOutputColumn().set(nArray[0], outputColumn);
            this._models.refreshModel(this._applyOutputColumns.getOutputColumn(), this._modelNodesLookupMap);
            this._dirty = true;
            if (this._propertyModel != null) {
                this.updateNode();
            }
        }
    }

    private void processRemove() {
        int[] nArray = this.tablePanel.getTable().getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        ArrayList<ApplyOutputColumnsType.OutputColumn> arrayList = new ArrayList<ApplyOutputColumnsType.OutputColumn>();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            ApplyOutputColumnsType.OutputColumn outputColumn = (ApplyOutputColumnsType.OutputColumn)this._applyOutputColumns.getOutputColumn().get(n);
            arrayList.add(outputColumn);
        }
        for (ApplyOutputColumnsType.OutputColumn outputColumn : arrayList) {
            this._applyOutputColumns.getOutputColumn().remove(outputColumn);
            this._outputColumnNameGenerator.removeUniqueName(outputColumn);
        }
        this._models.refreshModel(this._applyOutputColumns.getOutputColumn(), this._modelNodesLookupMap);
        this._dirty = true;
        if (this._propertyModel != null) {
            this.updateNode();
        }
    }

    private void processRemoveAll() {
        this._applyOutputColumns.getOutputColumn().clear();
        this._outputColumnNameGenerator.removeAllUniqueNames();
        this._models.refreshModel(this._applyOutputColumns.getOutputColumn(), this._modelNodesLookupMap);
        this._dirty = true;
        if (this._propertyModel != null) {
            this.updateNode();
        }
    }

    private void handleModelSelectionChanged() {
        this.enableControls();
    }

    private void initComponents() {
        this.removeBtn = new JButton();
        this.addBtn = new JButton();
        this.editBtn = new JButton();
        this.wizBtn = new JButton();
        this.partitionBtn = new JButton();
        this.jAutoSettingsCheckBox = new JCheckBox();
        this.tablePanel = new DataMinerTablePanel();
        this.JLblCaseID = new JLabel();
        this.jComboCaseID = new JComboBox();
        this.removeBtn.setIcon(OracleIcons.getIcon((String)"delete.png"));
        this.removeBtn.setToolTipText(DialogsLrb.get("APPLY_MODEL_DELETE_APPLY_COLUMN_TOOLTIP"));
        this.removeBtn.setName("removeBtn");
        this.addBtn.setIcon(OracleIcons.getIcon((String)"add.png"));
        this.addBtn.setToolTipText(DialogsLrb.get("APPLY_MODEL_ADD_APPLY_COLUMN_TOOLTIP"));
        this.addBtn.setName("addBtn");
        this.editBtn.setIcon(OracleIcons.getIcon((String)"edit.png"));
        this.editBtn.setToolTipText(DialogsLrb.get("APPLY_MODEL_EDIT_APPLY_COLUMN_TOOLTIP"));
        this.editBtn.setName("editBtn");
        this.wizBtn.setIcon(DataMinerIcons.get(Icons.TUNE));
        this.wizBtn.setToolTipText(DialogsLrb.get("APPLY_MODEL_DEFINE_APPLY_COLUMNS_TOOLTIP"));
        this.wizBtn.setName("wizBtn");
        this.partitionBtn.setIcon(DataMinerIcons.get(Icons.PARTITION_KEY_ICON));
        this.partitionBtn.setToolTipText(DialogsLrb.get("APPLY_MODEL_PARTITION_APPLY_COLUMN_TOOLTIP"));
        this.partitionBtn.setName("partitionBtn");
        this.setPreferredSize(new Dimension(950, 400));
        this.jAutoSettingsCheckBox.setText("Automatic Settings");
        this.jAutoSettingsCheckBox.setName("jAutoSettingsCheckBox");
        this.jAutoSettingsCheckBox.setOpaque(false);
        this.jAutoSettingsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ApplyModelsPanel.this.jAutoSettingsCheckBoxActionPerformed(actionEvent);
            }
        });
        this.tablePanel.setName("tablePanel");
        this.JLblCaseID.setText("Case ID:");
        this.JLblCaseID.setName("JLblCaseID");
        this.jComboCaseID.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboCaseID.setName("jComboCaseID");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tablePanel, -1, 930, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jAutoSettingsCheckBox).addGap(18, 18, 18).addComponent(this.JLblCaseID).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboCaseID, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jAutoSettingsCheckBox).addComponent(this.JLblCaseID).addComponent(this.jComboCaseID, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tablePanel, -1, 352, Short.MAX_VALUE).addContainerGap()));
    }

    private void jAutoSettingsCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.jAutoSettingsCheckBox.isSelected();
        if (bl) {
            if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)DialogsLrb.get("APPLY_OUTPUT_AUTO_SETTING_ON"), (String)DialogsLrb.get("WARNING_TITLE"), null, (boolean)true)) {
                this.jAutoSettingsCheckBox.setSelected(false);
                return;
            }
            if (this._propertyModel != null) {
                this._applyOutputColumns.setAutoSpec(AutoSpecType.YES);
                this._applyOutputColumns.getOutputColumn().clear();
                this._outputColumnNameGenerator.removeAllUniqueNames();
                this._models.refreshModel(this._applyOutputColumns.getOutputColumn(), this._modelNodesLookupMap);
                this._dirty = true;
                ApplyNode.addModels(this.getTargetNode((PropertyModel)this._propertyModel), this._applyOutputColumns, this._outputColumnNameGenerator);
                this.updateNode();
            } else {
                this.processRemoveAll();
                this._applyOutputColumns.setAutoSpec(AutoSpecType.YES);
                ApplyNode.addModels((ApplyNode)this.getData(), this._applyOutputColumns, this._outputColumnNameGenerator);
                this._models.refreshModel(this._applyOutputColumns.getOutputColumn(), this._modelNodesLookupMap);
            }
        } else {
            this._applyOutputColumns.setAutoSpec(AutoSpecType.NO);
            this._dirty = true;
            if (this._propertyModel != null) {
                this.updateNode();
            }
        }
        this.enableControls();
    }

    private void jWizardButtonActionPerformed(ActionEvent actionEvent) {
        ApplyWizard applyWizard = new ApplyWizard();
        if (applyWizard.runWizard(this, this.getContext(), this._applyOutputColumns)) {
            this._models.refreshModel(this._applyOutputColumns.getOutputColumn(), this._modelNodesLookupMap);
            this._dirty = true;
            if (this._propertyModel != null) {
                this.updateNode();
            }
        }
    }

    public ApplyOutputColumnsType getApplyOutputColumns() {
        return this._applyOutputColumns;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    public ApplyNode.ApplyOutputColumnNameGenerator getOutputColumnNameGenerator() {
        return this._outputColumnNameGenerator;
    }

    public GenericTable getTable() {
        return this.tablePanel.getTable();
    }

    static class ModelsTableModel
    extends SimpleBaseTableModel {
        static String[] _columnNames = new String[]{DialogsLrb.get("APPLY_MODEL_COLUMN"), DialogsLrb.get("APPLY_MODEL_FUNCTION"), DialogsLrb.get("APPLY_MODEL_PARAMETER"), DialogsLrb.get("APPLY_MODEL_MODEL"), DialogsLrb.get("APPLY_MODEL_NODE")};
        static int[] _columnWidths = new int[]{150, 140, 240, 180, 90};
        private static final int MODEL_COLUMN = 0;
        private static final int MODEL_FUNCTION = 1;
        private static final int MODEL_PARAMETER = 2;
        private static final int MODEL_MODEL = 3;
        private static final int MODEL_NODE = 4;
        private static final int COLUMN_COUNT = 5;
        private ApplyModelsPanel _parent;
        private List<ApplyOutputColumnsType.OutputColumn> _srcData;
        private Map<String, String> _modelNodesLookupMap;

        public ModelsTableModel(ApplyModelsPanel applyModelsPanel, List<ApplyOutputColumnsType.OutputColumn> list, Map<String, String> map) {
            this._parent = applyModelsPanel;
            this._srcData = list;
            this._modelNodesLookupMap = map;
            this.setColumnIdentifiers(_columnNames);
            this.setRowCount(this.getRowCount());
            this.setColumnCount(5);
        }

        public void refreshModel(List<ApplyOutputColumnsType.OutputColumn> list, Map<String, String> map) {
            this._srcData = list;
            this._modelNodesLookupMap = map;
            this.fireTableDataChanged();
        }

        public int getRowCount() {
            return this._srcData != null ? this._srcData.size() : 0;
        }

        public Object getValueAt(int n, int n2) {
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds";
            if (this._srcData == null) {
                return "Loading...";
            }
            ApplyOutputColumnsType.OutputColumn outputColumn = this._srcData.get(n);
            Object object = null;
            switch (n2) {
                case 0: {
                    object = ApplyNode.getPredictionFunctionOutput(outputColumn);
                    break;
                }
                case 1: {
                    object = ServerConstants.ApplyPredictionFunctions.getUIFunctionName((String)ApplyNode.getPredictionFunction(outputColumn));
                    break;
                }
                case 2: {
                    object = ApplyNode.getPredictionFunctionParameters(outputColumn).toString();
                    break;
                }
                case 3: {
                    if (this._parent.isShowSchema()) {
                        object = outputColumn.getModel().getSchema() + "." + outputColumn.getModel().getName();
                        break;
                    }
                    object = outputColumn.getModel().getName();
                    break;
                }
                case 4: {
                    object = this._modelNodesLookupMap.get(outputColumn.getModel().getNodeId());
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column";
                    break;
                }
            }
            return object;
        }
    }

    private class CustomCellRenderer
    extends PartitionCustomCellRenderer {
        private CustomCellRenderer() {
        }

        @Override
        public Icon getValidIcon() {
            return DataMinerIcons.get(Icons.PARTITION_KEY_ICON);
        }

        @Override
        public Icon getInvalidIcon() {
            return OracleIcons.getIcon((String)"Empty.gif");
        }
    }

    public abstract class PartitionCustomCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            boolean bl3 = false;
            if (ApplyModelsPanel.this._isDatabaseVersion12_2andUp && ApplyModelsPanel.this._modelPartitioned.containsKey(object.toString()) && ApplyModelsPanel.this._modelPartitioned.get(object.toString()).booleanValue()) {
                bl3 = true;
            }
            this.setIcon(bl3 ? this.getValidIcon() : this.getInvalidIcon());
            return component;
        }

        public abstract Icon getValidIcon();

        public abstract Icon getInvalidIcon();
    }
}

