/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.Window;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.ide.Ide;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.util.SwingUtils;

public class UITools {
    public static Window getParentWindow(JComponent jComponent) {
        Dialog dialog = SwingUtils.getAncestorDialog((Component)jComponent);
        if (dialog == null) {
            dialog = Ide.getMainWindow();
        }
        return dialog;
    }

    public static JEWTDialog getParentDialog(JPanel jPanel) {
        return (JEWTDialog)SwingUtils.getAncestorDialog((Component)jPanel);
    }

    public static Point getPositionInMainWindow(Component component) {
        int n = 0;
        int n2 = 0;
        while (component != null && component != Ide.getMainWindow()) {
            n += component.getLocation().x;
            n2 += component.getLocation().y;
            component = component.getParent();
        }
        return new Point(n, n2);
    }

    public static <T> void setTableModelData(GenericTable genericTable, List<T> list) {
        genericTable.setRowSorter(null);
        ODMrTableModel oDMrTableModel = (ODMrTableModel)((Object)genericTable.getModel());
        oDMrTableModel.setSrcData(list);
        genericTable.setSorted(true);
    }

    public static <T> void setModelPresevingSort(DataMinerTablePanel dataMinerTablePanel, ODMrTableModel<T> oDMrTableModel) {
        DataMinerTable dataMinerTable = dataMinerTablePanel.getTable();
        TableModel tableModel = dataMinerTable.getModel();
        if (UITools.existsAndIsODMrModel(tableModel)) {
            UITools.setTableModelData(dataMinerTable, oDMrTableModel.getSrcData());
        } else {
            dataMinerTablePanel.setup((TableModel)((Object)oDMrTableModel), null, 0, true);
        }
    }

    private static boolean existsAndIsODMrModel(TableModel tableModel) {
        return tableModel != null && tableModel instanceof ODMrTableModel;
    }
}

