/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.utils;

import java.util.Map;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import oracle.dmt.dataminer.utils.SingleColumnRowSorter;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.table.GenericTable;

public class SimpleSearchListener
implements SearchListener {
    private int filteringColumn;
    private int sortColumn;
    private GenericTable table;
    private Map<String, Integer> columnCategoryMap;
    private RowFilter customFilter;

    public SimpleSearchListener(GenericTable genericTable, int n) {
        this(genericTable, n, n);
    }

    public SimpleSearchListener(GenericTable genericTable, int n, int n2) {
        this.table = genericTable;
        this.filteringColumn = n;
        this.sortColumn = n2;
    }

    public SimpleSearchListener(GenericTable genericTable, Map<String, Integer> map) {
        this(genericTable, map, -1);
    }

    public SimpleSearchListener(GenericTable genericTable, Map<String, Integer> map, int n) {
        this.table = genericTable;
        this.columnCategoryMap = map;
        this.sortColumn = n;
    }

    public SimpleSearchListener(GenericTable genericTable, RowFilter rowFilter) {
        this(genericTable, rowFilter, -1);
    }

    public SimpleSearchListener(GenericTable genericTable, RowFilter rowFilter, int n) {
        this.table = genericTable;
        this.customFilter = rowFilter;
        this.sortColumn = n;
    }

    public void searchPerformed(SearchEvent searchEvent) {
        this.performSearch(searchEvent);
    }

    public void searchCategoryChanged(SearchEvent searchEvent) {
        this.performSearch(searchEvent);
    }

    private void performSearch(SearchEvent searchEvent) {
        SingleColumnRowSorter singleColumnRowSorter;
        String string = searchEvent.getSearchText();
        if (searchEvent.isFromClear()) {
            return;
        }
        if ("".equals(string)) {
            this.table.setRowSorter(null);
            if (this.sortColumn == -1) {
                this.sortColumn = this.filteringColumn;
            }
            this.table.setSortColumn(this.sortColumn, true);
            this.table.setSorted(true);
            return;
        }
        if (this.customFilter != null) {
            singleColumnRowSorter = new SingleColumnRowSorter(this.table.getModel(), this.customFilter, this.sortColumn);
        } else {
            if (this.columnCategoryMap != null) {
                SearchCategory searchCategory = searchEvent.getSearchCategory();
                this.filteringColumn = this.columnCategoryMap.get(searchCategory.getLabel());
            }
            singleColumnRowSorter = new SingleColumnRowSorter(this.table.getModel(), string, this.filteringColumn, this.sortColumn);
        }
        this.table.setRowSorter((RowSorter)singleColumnRowSorter);
        this.table.setSorted(true);
    }
}

