/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.performance;

import java.math.BigDecimal;
import java.util.List;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.utils.res.NumberUtils;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.performance.PerformanceMetric;

class PerformanceTableModel
extends ODMrTableModel<PerformanceMetric> {
    private String[] columnNames;

    public PerformanceTableModel(String[] stringArray) {
        super(stringArray);
    }

    public PerformanceTableModel(String[] stringArray, List<PerformanceMetric> list) {
        super(stringArray, list);
        this.columnNames = stringArray;
    }

    public Object getValueAt(int n, int n2) {
        PerformanceMetric performanceMetric = (PerformanceMetric)this.srcData.get(n);
        if (this.columnNames[n2].equals(CommonLrb.get("NAME"))) {
            return performanceMetric.getTestResult().toString();
        }
        if (this.columnNames[n2].equals(TestViewerLrb.get("ALGORITHM"))) {
            return performanceMetric.getAlgorithm();
        }
        if (this.columnNames[n2].equals(TestViewerLrb.get("CREATION_DATE"))) {
            return performanceMetric.getCreationDate();
        }
        if (this.columnNames[n2].equals(TestViewerLrb.get("PREDICTIVE_CONFIDENCE_COL"))) {
            return NumberUtils.toDouble((BigDecimal)performanceMetric.getPredConfidence());
        }
        if (this.columnNames[n2].equals(TestViewerLrb.get("OVERALL_ACCURACY_COL"))) {
            return NumberUtils.toDouble((BigDecimal)performanceMetric.getOverallAccuracyOrMeanAbsErr());
        }
        if (this.columnNames[n2].equals(TestViewerLrb.get("AVG_ACCURACY_COL"))) {
            return NumberUtils.toDouble((BigDecimal)performanceMetric.getAvgAccuracyOrRoorMeanSqrtErr());
        }
        if (this.columnNames[n2].equals(TestViewerLrb.get("COST"))) {
            return NumberUtils.toDouble((BigDecimal)performanceMetric.getCostOrMeanPredictValue());
        }
        if (this.columnNames[n2].equals(TestViewerLrb.get("MEAN_PREDICTED_VALUE"))) {
            return NumberUtils.toDouble((BigDecimal)performanceMetric.getCostOrMeanPredictValue());
        }
        if (this.columnNames[n2].equals(TestViewerLrb.get("MEAN_ACTUAL_VALUE"))) {
            return NumberUtils.toDouble((BigDecimal)performanceMetric.getMeanActualValue());
        }
        if (this.columnNames[n2].equals(TestViewerLrb.get("MEAN_ABSOLUTE_ERROR"))) {
            return NumberUtils.toDouble((BigDecimal)performanceMetric.getOverallAccuracyOrMeanAbsErr());
        }
        if (this.columnNames[n2].equals(TestViewerLrb.get("ROOT_MEAN_SQRT_ERROR"))) {
            return NumberUtils.toDouble((BigDecimal)performanceMetric.getAvgAccuracyOrRoorMeanSqrtErr());
        }
        if (this.columnNames[n2].equals(TestViewerLrb.get("BUILD_ROWS"))) {
            return NumberUtils.toInteger((BigDecimal)performanceMetric.getBuildRows());
        }
        if (this.columnNames[n2].equals(TestViewerLrb.get("TEST_ROWS"))) {
            return NumberUtils.toInteger((BigDecimal)performanceMetric.getTestRows());
        }
        return "Undefined";
    }
}

