/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.partitions;

import java.util.Comparator;
import java.util.List;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionColumn;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionTestResult;
import oracle.dmt.dataminer.core.utils.comparator.StringEndingWithNumberComparator;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;

class ModelPartitionsTableModel
extends ODMrTableModel<PartitionTestResult> {
    static final int COMMON_MODEL_NAME = 0;
    static final int COMMON_PARTITION_ID = 1;
    static final int COMMON_PARTITION_NAME = 2;
    static final int COMMON_PREDICTIVE_CONFIDENCE = 3;
    static final int CLASS_OVERALL_ACCURACY = 4;
    static final int CLASS_AVERAGE_ACCURACY = 5;
    static final int CLASS_BUILD_ROWS = 6;
    static final int CLASS_TEST_ROWS = 7;
    static final int CLASS_COST = 8;
    static final int CLASS_ALGORITHM_TYPE = 9;
    static final int CLASS_CREATION_DATE = 10;
    static final int CLASS_BUILD_ROWS_PERCENT = 11;
    static final int CLASS_TEST_ROWS_PERCENT = 12;
    static final int CLASS_LAST_VISIBLE_COL = 11;
    static final int CLASS_LAST_COL_INDEX = 13;
    static final int REG_MEAN_ABSOLUTE_ERROR = 4;
    static final int REG_ROOT_MEAN_SQRT_ERROR = 5;
    static final int REG_MEAN_PREDICTED_VALUE = 6;
    static final int REG_MEAN_ACTUAL_VALUE = 7;
    static final int REG_BUILD_ROWS = 8;
    static final int REG_TEST_ROWS = 9;
    static final int REG_ALGORITHM_TYPE = 10;
    static final int REG_CREATION_DATE = 11;
    static final int REG_BUILD_ROWS_PERCENT = 12;
    static final int REG_TEST_ROWS_PERCENT = 13;
    static final int REG_LAST_VISIBLE_COL = 12;
    static final int REG_LAST_COL_INDEX = 14;
    static final String[] BASE_COLUMNS_CLASSIFICATION = new String[]{CommonLrb.get("MODEL"), TestViewerLrb.get("PARTITION_TEST_RESULT_PARTITION_ID"), TestViewerLrb.get("PARTITION_TEST_RESULT_PARTITION_NAME"), TestViewerLrb.get("PREDICTIVE_CONFIDENCE"), TestViewerLrb.get("OVERALL_ACCURACY_COL"), TestViewerLrb.get("AVG_ACCURACY_COL"), TestViewerLrb.get("BUILD_ROWS"), TestViewerLrb.get("TEST_ROWS"), TestViewerLrb.get("COST"), TestViewerLrb.get("ALGORITHM"), TestViewerLrb.get("CREATION_DATE"), TestViewerLrb.get("PARTITION_TEST_RESULT_BUILD_ROWS_PERCENT"), TestViewerLrb.get("PARTITION_TEST_RESULT_TEST_ROWS_PERCENT")};
    static final String[] BASE_COLUMNS_REGRESSION = new String[]{CommonLrb.get("MODEL"), TestViewerLrb.get("PARTITION_TEST_RESULT_PARTITION_ID"), TestViewerLrb.get("PARTITION_TEST_RESULT_PARTITION_NAME"), TestViewerLrb.get("PREDICTIVE_CONFIDENCE"), TestViewerLrb.get("MEAN_ABSOLUTE_ERROR"), TestViewerLrb.get("ROOT_MEAN_SQRT_ERROR"), TestViewerLrb.get("MEAN_PREDICTED_VALUE"), TestViewerLrb.get("MEAN_ACTUAL_VALUE"), TestViewerLrb.get("BUILD_ROWS"), TestViewerLrb.get("TEST_ROWS"), TestViewerLrb.get("ALGORITHM"), TestViewerLrb.get("CREATION_DATE"), TestViewerLrb.get("PARTITION_TEST_RESULT_BUILD_ROWS_PERCENT"), TestViewerLrb.get("PARTITION_TEST_RESULT_TEST_ROWS_PERCENT")};
    static final String[] SEARCH_COLUMNS = new String[]{CommonLrb.get("MODEL"), TestViewerLrb.get("PARTITION_TEST_RESULT_PARTITION_ID"), TestViewerLrb.get("PARTITION_TEST_RESULT_PARTITION_NAME"), TestViewerLrb.get("ALGORITHM")};
    private boolean isClassification;

    public ModelPartitionsTableModel(String[] stringArray, List<PartitionTestResult> list, boolean bl) {
        super(stringArray, list);
        this.isClassification = bl;
    }

    public Object getValueAt(int n, int n2) {
        return this.isClassification ? this.getValueForClassification(n, n2) : this.getValueForRegression(n, n2);
    }

    private Object getValueForClassification(int n, int n2) {
        PartitionTestResult partitionTestResult = (PartitionTestResult)this.srcData.get(n);
        switch (n2) {
            case 0: {
                return partitionTestResult.getModelName();
            }
            case 1: {
                return partitionTestResult.getPartitionInfo().getPartitionID();
            }
            case 2: {
                return partitionTestResult.getPartitionInfo().getPartitionName();
            }
            case 3: {
                return partitionTestResult.getPredictiveConfidence();
            }
            case 4: {
                return partitionTestResult.getClassOverallAccuracy();
            }
            case 5: {
                return partitionTestResult.getClassAverageAccuracy();
            }
            case 6: {
                return partitionTestResult.getBuildRows();
            }
            case 7: {
                return partitionTestResult.getTestRows();
            }
            case 8: {
                return partitionTestResult.getClassCost();
            }
            case 9: {
                return partitionTestResult.getAlgorithmType();
            }
            case 10: {
                return partitionTestResult.getCreationDate();
            }
            case 11: {
                return partitionTestResult.getBuildRowsPercent();
            }
            case 12: {
                return partitionTestResult.getTestRowsPercent();
            }
        }
        return ((PartitionColumn)partitionTestResult.getPartitionInfo().getColumns().get(n2 - 13)).getValue();
    }

    public Comparator getColumnSortComparator(int n) {
        switch (n) {
            case 1: 
            case 2: {
                return StringEndingWithNumberComparator.getComparator();
            }
        }
        return super.getColumnSortComparator(n);
    }

    private Object getValueForRegression(int n, int n2) {
        PartitionTestResult partitionTestResult = (PartitionTestResult)this.srcData.get(n);
        switch (n2) {
            case 0: {
                return partitionTestResult.getModelName();
            }
            case 1: {
                return partitionTestResult.getPartitionInfo().getPartitionID();
            }
            case 2: {
                return partitionTestResult.getPartitionInfo().getPartitionName();
            }
            case 3: {
                return partitionTestResult.getPredictiveConfidence();
            }
            case 4: {
                return partitionTestResult.getRegMeanAbsoluteError();
            }
            case 5: {
                return partitionTestResult.getRegRootMeanSquareError();
            }
            case 6: {
                return partitionTestResult.getRegMeanPredictedValue();
            }
            case 7: {
                return partitionTestResult.getRegMeanActualValue();
            }
            case 8: {
                return partitionTestResult.getBuildRows();
            }
            case 9: {
                return partitionTestResult.getTestRows();
            }
            case 10: {
                return partitionTestResult.getAlgorithmType();
            }
            case 11: {
                return partitionTestResult.getCreationDate();
            }
            case 12: {
                return partitionTestResult.getBuildRowsPercent();
            }
            case 13: {
                return partitionTestResult.getTestRowsPercent();
            }
        }
        return ((PartitionColumn)partitionTestResult.getPartitionInfo().getColumns().get(n2 - 14)).getValue();
    }
}

