/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.matrix;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.dal.sql.queries.clas.common.GetCostMatrixCountQuery;
import oracle.dmt.dataminer.core.model.common.build.ModelDescriptor;
import oracle.dmt.dataminer.core.model.common.build.partition.CompareMode;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.matrix.PMatrixCompareTableModel;
import oracle.dmt.dataminer.tviewer.matrix.PMatrixDataProvider;
import oracle.dmt.dataminer.tviewer.matrix.PMatrixSummaryTableModel;
import oracle.dmt.dataminer.tviewer.matrix.PMatrixTableModel;
import oracle.dmt.dataminer.tviewer.matrix.PMatrixTargetCompareTableModel;
import oracle.dmt.dataminer.tviewer.matrix.TargetPair;
import oracle.dmt.dataminer.tviewer.performance.CPerformanceTabState;
import oracle.dmt.dataminer.tviewer.performance.PerformanceMetric;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.javatools.ui.table.GenericBaseTableModel;

public class PMatrixTabState {
    private static final Logger theLogger = Logger.getLogger(PMatrixTabState.class.getName());
    public static final int IX_TARGET_VALUES = 0;
    public static final int IX_TOTAL_ACTUALS = 1;
    public static final int IX_TOTAL_PREDICTED = 2;
    public static final int IX_ACTUAL_COST = 3;
    public static final int IX_PREDICTED_COST = 4;
    public static final int IX_CORRECT_PERC_ACTUAL = 5;
    public static final int IX_CORRECT_PERC_PREDICTED = 6;
    public static final int IX_ACTUAL_PERC_COST = 7;
    public static final int IX_CORRECT_PREDICTED = 8;
    private boolean currentPivotMode;
    private SharedTestEditorState parentTestViewerState;
    private Map<BigDecimal, PMatrixTableModel> matricesMap;
    private Map<BigDecimal, PMatrixSummaryTableModel> matrixSummaryMap;
    private Map<String, PMatrixSummaryTableModel> matrixSummaryMapByName;
    private Map<BigDecimal, PerformanceMetric> metricsMap;
    private PMatrixCompareTableModel compareSummaryModel;
    private List<String> testResultNames;
    private List<BigDecimal> testResultIds;
    private List<String> currentSelectedTestResults;
    private ConnectionManager connManager;
    private SqlDataAccessObject dao;
    private static final String PMATRIX_SUMMARY_STAT_WITHOUT_COST = new StringBuffer("WITH total_actuals AS ").append("  (SELECT actual_target_value, ").append("     SUM(VALUE) total_actuals ").append("   FROM {0} ").append("   GROUP BY actual_target_value), ").append("  total_predicted AS ").append("  (SELECT predicted_target_value, ").append("     SUM(VALUE) total_predicted ").append("   FROM {0} ").append("   GROUP BY predicted_target_value), ").append("  right_predictions AS ").append("  (SELECT actual_target_value, ").append("     VALUE AS correct ").append("   FROM {0} ").append("   WHERE actual_target_value = predicted_target_value) ").append("SELECT a.actual_target_value target_value, ").append("  total_actuals, ").append("  nvl(total_predicted, 0) total_predicted, ").append("  null as actuals_cost, ").append("  null as predicted_cost, ").append("  nvl((correct / total_actuals) * 100, 0) correct_perc_actual, ").append("  nvl((correct / total_predicted) * 100, 0) correct_perc_predicted, ").append("  null as actuals_perc_cost , ").append("  nvl(correct, 0) correct_predicted ").append("FROM total_actuals a, total_predicted p, right_predictions c  ").append("WHERE a.actual_target_value = p.predicted_target_value(+) AND a.actual_target_value = c.actual_target_value(+) ").append("ORDER BY a.actual_target_value asc").toString();
    private static final String PMATRIX_SUMMARY_STAT_WITH_COST = new StringBuffer(" WITH tr_cost AS ").append("  (    select ACTUAL actual_target_value, PREDICTED predicted_target_value, COST ").append("  from TABLE(DBMS_DATA_MINING.GET_MODEL_COST_MATRIX(?)) ").append("  ), ").append("  total_actuals AS ").append("  (SELECT nvl(a.actual_target_value,    b.actual_target_value) actual_target_value, ").append("     SUM(a.VALUE * b.cost) actuals_cost, ").append("     SUM(a.VALUE) total_actuals ").append("   FROM {0} a, ").append("     tr_cost b ").append("   WHERE a.actual_target_value(+) = b.actual_target_value ").append("   AND a.predicted_target_value(+) = b.predicted_target_value ").append("   GROUP BY nvl(a.actual_target_value,    b.actual_target_value)), ").append("  total_predicted AS ").append("  (SELECT nvl(a.predicted_target_value,    b.predicted_target_value) predicted_target_value, ").append("     SUM(a.VALUE * b.cost) predicted_cost, ").append("     SUM(a.VALUE) total_predicted ").append("   FROM {0} a, ").append("     tr_cost b ").append("   WHERE a.actual_target_value(+) = b.actual_target_value ").append("   AND a.predicted_target_value(+) = b.predicted_target_value ").append("   GROUP BY nvl(a.predicted_target_value,    b.predicted_target_value)), ").append("  right_predictions AS ").append("  (SELECT actual_target_value, ").append("     VALUE AS correct ").append("   FROM {0} ").append("   WHERE actual_target_value = predicted_target_value), ").append("  actuals_total_cost as ").append("  (SELECT SUM(a.VALUE * b.cost) actuals_total_cost ").append("   FROM {0} a, ").append("     tr_cost b ").append("   WHERE a.actual_target_value = b.actual_target_value ").append("   AND a.predicted_target_value = b.predicted_target_value) ").append("SELECT a.actual_target_value target_value, ").append("  nvl(total_actuals, 0) total_actuals, ").append("  nvl(total_predicted, 0) total_predicted, ").append("  nvl(actuals_cost, 0) actuals_cost, ").append("  nvl(predicted_cost, 0) predicted_cost, ").append("  nvl((correct / total_actuals) * 100, 0) correct_perc_actual, ").append("  nvl((correct / total_predicted) * 100, 0) correct_perc_predicted, ").append("  nvl((actuals_cost / GREATEST(0.0001, tc.actuals_total_cost)) * 100, 0) actuals_perc_cost, ").append("  nvl(correct, 0) correct_predicted ").append("FROM total_actuals a, ").append("  total_predicted p, ").append("  right_predictions c, ").append("  actuals_total_cost tc ").append("WHERE a.actual_target_value = p.predicted_target_value(+) AND a.actual_target_value = c.actual_target_value(+) ").append("ORDER BY a.actual_target_value ASC").toString();
    private static final String perfomance_matrix_table = "<perfomance_matrix_table>";
    private static final String model = "<MODEL>";
    private static final String PMATRIX_SUMMARY_STAT_WITH_COST_PARTITIONED_ACTUAL = "with costMatrix as (   select PARTITION_NAME, ACTUAL_TARGET_VALUE, COST   from DM$VC<MODEL>  where ACTUAL_TARGET_VALUE != PREDICTED_TARGET_VALUE ), actuals_cost as (   SELECT c.ACTUAL_TARGET_VALUE TARGET_VALUE,   SUM(w.cost*c.value) actuals_cost   from costMatrix w, <perfomance_matrix_table> c   WHERE w.ACTUAL_TARGET_VALUE=c.ACTUAL_TARGET_VALUE   AND w.PARTITION_NAME       = c.PARTITION_NAME   AND c.ACTUAL_TARGET_VALUE != c.PREDICTED_TARGET_VALUE   GROUP BY c.ACTUAL_TARGET_VALUE   ORDER BY c.ACTUAL_TARGET_VALUE ASC ), actuals_total_cost as (   SELECT SUM(a.actuals_cost) actuals_total_cost   from actuals_cost a ) select a.target_value,   NVL(a.actuals_cost, 0) actuals_cost,   NVL((a.actuals_cost / GREATEST(0.0001, tc.actuals_total_cost)) * 100, 0) actuals_perc_cost from actuals_cost a, actuals_total_cost tc";
    private static final String PMATRIX_SUMMARY_STAT_WITH_COST_PARTITIONED_PREDICTED = "with costMatrix as (   select PARTITION_NAME, PREDICTED_TARGET_VALUE, COST   from DM$VC<MODEL>  where ACTUAL_TARGET_VALUE != PREDICTED_TARGET_VALUE ) select c.PREDICTED_TARGET_VALUE TARGET_VALUE, sum(w.cost*c.value) predicted_cost from costMatrix w, <perfomance_matrix_table> c where w.PREDICTED_TARGET_VALUE=c.PREDICTED_TARGET_VALUE and w.PARTITION_NAME = c.PARTITION_NAME and c.ACTUAL_TARGET_VALUE != c.PREDICTED_TARGET_VALUE group by c.PREDICTED_TARGET_VALUE ORDER BY c.PREDICTED_TARGET_VALUE asc";
    private static final String PMATRIX_SUMMARY_STAT_WITH_COST_PARTITIONED = "WITH   partition_data AS ( SELECT * FROM <perfomance_matrix_table> WHERE <partition_clause> ),\n  tr_cost AS (\n     SELECT ACTUAL actual_target_value, PREDICTED predicted_target_value, COST \n     FROM TABLE(DBMS_DATA_MINING.GET_MODEL_COST_MATRIX(model_name => ?, partition_name => ?)) ),\n  total_actuals AS (\n     SELECT nvl(a.actual_target_value, b.actual_target_value) actual_target_value, \n     SUM(a.VALUE * b.cost) actuals_cost, SUM(a.VALUE) total_actuals  \n     FROM partition_data a, tr_cost b \n     WHERE a.actual_target_value(+) = b.actual_target_value \n     AND a.predicted_target_value(+) = b.predicted_target_value \n     GROUP BY nvl(a.actual_target_value, b.actual_target_value)),\n  total_predicted AS (\n     SELECT nvl(a.predicted_target_value, b.predicted_target_value) predicted_target_value, \n     SUM(a.VALUE * b.cost) predicted_cost, \n     SUM(a.VALUE) total_predicted \n     FROM <perfomance_matrix_table> a, tr_cost b \n     WHERE a.actual_target_value(+) = b.actual_target_value \n     AND a.predicted_target_value(+) = b.predicted_target_value \n     GROUP BY nvl(a.predicted_target_value, b.predicted_target_value)), \n  right_predictions AS (\n     SELECT actual_target_value, VALUE AS correct FROM partition_data \n     WHERE actual_target_value = predicted_target_value), \n  actuals_total_cost as( \n     SELECT SUM(a.VALUE * b.cost) actuals_total_cost \n     FROM partition_data a, tr_cost b \n     WHERE a.actual_target_value = b.actual_target_value \n     AND a.predicted_target_value = b.predicted_target_value) \nSELECT a.actual_target_value target_value, \n  nvl(total_actuals, 0) total_actuals, \n  nvl(total_predicted, 0) total_predicted, \n  nvl(actuals_cost, 0) actuals_cost, \n  nvl(predicted_cost, 0) predicted_cost, \n  nvl((correct / total_actuals) * 100, 0) correct_perc_actual, \n  nvl((correct / total_predicted) * 100, 0) correct_perc_predicted, \n  nvl((actuals_cost / GREATEST(0.0001, tc.actuals_total_cost)) * 100, 0) actuals_perc_cost, \n  nvl(correct, 0) correct_predicted \nFROM total_actuals a, \n  total_predicted p, \n  right_predictions c, \n  actuals_total_cost tc \nWHERE a.actual_target_value = p.predicted_target_value(+) AND \n      a.actual_target_value = c.actual_target_value(+) ORDER BY a.actual_target_value ASC";
    private static final String PMATRIX_SUMMARY_STAT_WITHOUT_COST_PARTITIONED = "WITH \n  partition_data AS ( SELECT * FROM <perfomance_matrix_table> WHERE <partition_clause> ),\n  total_actuals AS (    SELECT actual_target_value,  SUM(VALUE) total_actuals \n    FROM partition_data \n    GROUP BY actual_target_value), \n  total_predicted AS( \n    SELECT predicted_target_value, SUM(VALUE) total_predicted  \n    FROM partition_data \n    GROUP BY predicted_target_value), \n  right_predictions AS (  \n    SELECT actual_target_value, VALUE AS correct \n    FROM partition_data \n    WHERE actual_target_value = predicted_target_value) \nSELECT a.actual_target_value target_value, \n  total_actuals, \n  nvl(total_predicted, 0) total_predicted, \n  null as actuals_cost, \n  null as predicted_cost, \n  nvl((correct / total_actuals) * 100, 0) correct_perc_actual, \n  nvl((correct / total_predicted) * 100, 0) correct_perc_predicted, \n  null as actuals_perc_cost , \n  nvl(correct, 0) correct_predicted \nFROM total_actuals a, total_predicted p, right_predictions c  \nWHERE a.actual_target_value = p.predicted_target_value(+) AND a.actual_target_value = c.actual_target_value(+) \nORDER BY a.actual_target_value asc";
    private static final String CONFUSION_MATRIX_PARTITIONED = "SELECT ACTUAL_TARGET_VALUE, PREDICTED_TARGET_VALUE, VALUE from <perfomance_matrix_table>\nWHERE <partition_clause>\nORDER BY ACTUAL_TARGET_VALUE ASC, PREDICTED_TARGET_VALUE ASC";

    public PMatrixTabState(SharedTestEditorState sharedTestEditorState) {
        this.parentTestViewerState = sharedTestEditorState;
        this.testResultNames = new ArrayList<String>();
        this.testResultIds = new ArrayList<BigDecimal>();
        this.currentSelectedTestResults = new ArrayList<String>();
        this.connManager = ConnectionFolder.getConnectionFolder(this.getParentTestViewerState().getContext());
        this.dao = new SqlDataAccessObject(this.connManager);
    }

    public void setCurrentSelectedTestResults(List<String> list) {
        this.currentSelectedTestResults = list;
    }

    public List<String> getCurrentSelectedTestResults() {
        return this.currentSelectedTestResults;
    }

    public PerformanceMetric getPerformanceMetric(BigDecimal bigDecimal) {
        return this.metricsMap.get(bigDecimal);
    }

    public PMatrixTableModel getPerformanceMatrixModel(BigDecimal bigDecimal) {
        return this.matricesMap.get(bigDecimal);
    }

    public PMatrixSummaryTableModel getPerformanceMatrixSummaryModel(BigDecimal bigDecimal) {
        return this.matrixSummaryMap.get(bigDecimal);
    }

    public void switchCurrentPivotMode() {
        this.currentPivotMode = !this.currentPivotMode;
    }

    public SharedTestEditorState getParentTestViewerState() {
        return this.parentTestViewerState;
    }

    public List<String> getTestResultNames() {
        return this.testResultNames;
    }

    public List<BigDecimal> getTestResultIds() {
        return this.testResultIds;
    }

    public synchronized void load(CompareMode compareMode) throws SQLException, ODMrDAOException {
        boolean bl = false;
        this.matricesMap = new HashMap<BigDecimal, PMatrixTableModel>();
        this.matrixSummaryMap = new HashMap<BigDecimal, PMatrixSummaryTableModel>();
        this.matrixSummaryMapByName = new HashMap<String, PMatrixSummaryTableModel>();
        this.metricsMap = new HashMap<BigDecimal, PerformanceMetric>();
        List<PerformanceMetric> list = this.parentTestViewerState.getPerformanceMetrics();
        if (list == null) {
            CPerformanceTabState cPerformanceTabState = new CPerformanceTabState(this.parentTestViewerState);
            cPerformanceTabState.load(new String[0], compareMode);
            list = this.parentTestViewerState.getPerformanceMetrics();
        }
        try {
            int n = 0;
            for (TestResult testResult : this.parentTestViewerState.getTestResults()) {
                int n2 = 0;
                BigDecimal bigDecimal = testResult.getId();
                PerformanceMetric performanceMetric = list.get(n++);
                String string = ((ClassTestResult)testResult).getConfusionMatrixTable();
                this.metricsMap.put(bigDecimal, performanceMetric);
                List[] listArray = new List[9];
                GetCostMatrixCountQuery getCostMatrixCountQuery = new GetCostMatrixCountQuery(this.connManager.getDbVersion(), new ModelDescriptor(null, testResult.toString()));
                int n3 = this.dao.readItem((Query)getCostMatrixCountQuery).orElse(0);
                bl = n3 > 0;
                SQLHelper sQLHelper = new SQLHelper();
                Object object = bl ? PMATRIX_SUMMARY_STAT_WITH_COST : PMATRIX_SUMMARY_STAT_WITHOUT_COST;
                Object[] objectArray = new Object[]{string};
                object = MessageFormat.format((String)object, objectArray);
                Double d = 0.0;
                Double d2 = 0.0;
                Double d3 = 0.0;
                try {
                    sQLHelper.conn = this.connManager.getConnection();
                    sQLHelper.pstmt = sQLHelper.conn.prepareStatement((String)object);
                    if (bl) {
                        sQLHelper.pstmt.setString(1, testResult.toString());
                    }
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    boolean bl2 = true;
                    while (sQLHelper.rs.next()) {
                        if (bl2) {
                            listArray[0] = new ArrayList();
                            listArray[1] = new ArrayList();
                            listArray[2] = new ArrayList();
                            listArray[3] = new ArrayList();
                            listArray[4] = new ArrayList();
                            listArray[5] = new ArrayList();
                            listArray[6] = new ArrayList();
                            listArray[7] = new ArrayList();
                            listArray[8] = new ArrayList();
                            bl2 = false;
                        }
                        listArray[0].add(sQLHelper.rs.getObject("target_value"));
                        d = d + sQLHelper.rs.getDouble("total_actuals");
                        d2 = d2 + sQLHelper.rs.getDouble("correct_predicted");
                        d3 = d3 + sQLHelper.rs.getDouble("predicted_cost");
                        listArray[1].add(sQLHelper.rs.getObject("total_actuals"));
                        listArray[2].add(sQLHelper.rs.getObject("total_predicted"));
                        listArray[3].add(sQLHelper.rs.getObject("actuals_cost"));
                        listArray[4].add(sQLHelper.rs.getObject("predicted_cost"));
                        listArray[5].add(sQLHelper.rs.getObject("correct_perc_actual"));
                        listArray[6].add(sQLHelper.rs.getObject("correct_perc_predicted"));
                        listArray[7].add(sQLHelper.rs.getObject("actuals_perc_cost"));
                        listArray[8].add(sQLHelper.rs.getObject("correct_predicted"));
                    }
                }
                catch (SQLException sQLException) {
                    theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
                    throw sQLException;
                }
                finally {
                    sQLHelper.close();
                }
                PMatrixSummaryTableModel pMatrixSummaryTableModel = new PMatrixSummaryTableModel(testResult.toString(), listArray, d, d2, d3);
                this.matrixSummaryMap.put(testResult.getId(), pMatrixSummaryTableModel);
                this.matrixSummaryMapByName.put(testResult.toString(), pMatrixSummaryTableModel);
                object = "Select ACTUAL_TARGET_VALUE, PREDICTED_TARGET_VALUE, VALUE from " + string + " order by ACTUAL_TARGET_VALUE ASC, PREDICTED_TARGET_VALUE ASC";
                HashMap<TargetPair, BigDecimal> hashMap = new HashMap<TargetPair, BigDecimal>();
                try {
                    Object object2;
                    Object object3;
                    sQLHelper.conn = this.connManager.getConnection();
                    sQLHelper.pstmt = sQLHelper.conn.prepareStatement((String)object);
                    sQLHelper.rs = sQLHelper.pstmt.executeQuery();
                    while (sQLHelper.rs.next()) {
                        object3 = sQLHelper.rs.getObject("ACTUAL_TARGET_VALUE");
                        object2 = sQLHelper.rs.getObject("PREDICTED_TARGET_VALUE");
                        BigDecimal bigDecimal2 = sQLHelper.rs.getBigDecimal("VALUE");
                        n2 += bigDecimal2.intValue();
                        hashMap.put(new TargetPair(object3, object2), bigDecimal2);
                    }
                    object3 = new PMatrixDataProvider(hashMap, listArray, n2);
                    object2 = new PMatrixTableModel((PMatrixDataProvider)object3);
                    this.matricesMap.put(testResult.getId(), (PMatrixTableModel)((Object)object2));
                    this.testResultNames.add(testResult.getName());
                    this.testResultIds.add(testResult.getId());
                }
                catch (SQLException sQLException) {
                    theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
                    throw sQLException;
                }
                finally {
                    sQLHelper.close();
                }
            }
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            throw sQLException;
        }
        this.compareSummaryModel = new PMatrixCompareTableModel(this.matrixSummaryMap);
    }

    public synchronized void loadPartitioned(CompareMode compareMode) throws ODMrDAOException {
        Object object;
        boolean bl = false;
        this.matricesMap = new HashMap<BigDecimal, PMatrixTableModel>();
        this.matrixSummaryMap = new HashMap<BigDecimal, PMatrixSummaryTableModel>();
        this.matrixSummaryMapByName = new HashMap<String, PMatrixSummaryTableModel>();
        this.metricsMap = new HashMap<BigDecimal, PerformanceMetric>();
        List<PerformanceMetric> list = this.parentTestViewerState.getPerformanceMetrics();
        if (list == null) {
            object = new CPerformanceTabState(this.parentTestViewerState);
            ((CPerformanceTabState)object).load(new String[0], compareMode);
            list = this.parentTestViewerState.getPerformanceMetrics();
        }
        object = new SQLHelper();
        try {
            int n = 0;
            String string = this.parentTestViewerState.getSelectedPartition();
            for (TestResult testResult : this.parentTestViewerState.getTestResults()) {
                int n2 = 0;
                String string2 = ((ClassTestResult)testResult).getConfusionMatrixTable();
                this.metricsMap.put(testResult.getId(), list.get(n++));
                List[] listArray = new List[9];
                GetCostMatrixCountQuery getCostMatrixCountQuery = new GetCostMatrixCountQuery(this.connManager.getDbVersion(), new ModelDescriptor(null, testResult.toString().toUpperCase(), string));
                int n3 = this.dao.readItem((Query)getCostMatrixCountQuery).orElse(0);
                bl = n3 > 0;
                String string3 = null;
                string3 = string != null ? (bl ? PMATRIX_SUMMARY_STAT_WITH_COST_PARTITIONED : PMATRIX_SUMMARY_STAT_WITHOUT_COST_PARTITIONED) : PMATRIX_SUMMARY_STAT_WITHOUT_COST_PARTITIONED;
                string3 = SharedTestEditorState.setPartitionClause(string3, string);
                string3 = StringUtils.getReplacedString(string3, perfomance_matrix_table, string2);
                Double d = 0.0;
                Double d2 = 0.0;
                Double d3 = 0.0;
                int n4 = 1;
                try {
                    ((SQLHelper)object).conn = this.connManager.getConnection();
                    ((SQLHelper)object).pstmt = ((SQLHelper)object).conn.prepareStatement(string3);
                    if (string != null && bl) {
                        ((SQLHelper)object).pstmt.setString(n4++, testResult.toString());
                        ((SQLHelper)object).pstmt.setString(n4, "\"" + string + "\"");
                    }
                    ((SQLHelper)object).rs = ((SQLHelper)object).pstmt.executeQuery();
                    boolean bl2 = true;
                    while (((SQLHelper)object).rs.next()) {
                        if (bl2) {
                            listArray[0] = new ArrayList();
                            listArray[1] = new ArrayList();
                            listArray[2] = new ArrayList();
                            listArray[3] = new ArrayList();
                            listArray[4] = new ArrayList();
                            listArray[5] = new ArrayList();
                            listArray[6] = new ArrayList();
                            listArray[7] = new ArrayList();
                            listArray[8] = new ArrayList();
                            bl2 = false;
                        }
                        listArray[0].add(((SQLHelper)object).rs.getObject("target_value"));
                        d = d + ((SQLHelper)object).rs.getDouble("total_actuals");
                        d2 = d2 + ((SQLHelper)object).rs.getDouble("correct_predicted");
                        listArray[1].add(((SQLHelper)object).rs.getObject("total_actuals"));
                        listArray[2].add(((SQLHelper)object).rs.getObject("total_predicted"));
                        if (string != null || !bl) {
                            listArray[3].add(((SQLHelper)object).rs.getObject("actuals_cost"));
                            listArray[4].add(((SQLHelper)object).rs.getObject("predicted_cost"));
                            listArray[7].add(((SQLHelper)object).rs.getObject("actuals_perc_cost"));
                            d3 = d3 + ((SQLHelper)object).rs.getDouble("predicted_cost");
                        }
                        listArray[5].add(((SQLHelper)object).rs.getObject("correct_perc_actual"));
                        listArray[6].add(((SQLHelper)object).rs.getObject("correct_perc_predicted"));
                        listArray[8].add(((SQLHelper)object).rs.getObject("correct_predicted"));
                    }
                }
                catch (SQLException sQLException) {
                    theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
                    throw new ODMrDAOException((Throwable)sQLException);
                }
                finally {
                    ((SQLHelper)object).close();
                }
                if (string == null && bl) {
                    try {
                        string3 = PMATRIX_SUMMARY_STAT_WITH_COST_PARTITIONED_ACTUAL;
                        string3 = StringUtils.getReplacedString(string3, model, testResult.toString().toUpperCase());
                        string3 = StringUtils.getReplacedString(string3, perfomance_matrix_table, string2);
                        ((SQLHelper)object).conn = this.connManager.getConnection();
                        ((SQLHelper)object).pstmt = ((SQLHelper)object).conn.prepareStatement(string3);
                        ((SQLHelper)object).rs = ((SQLHelper)object).pstmt.executeQuery();
                        while (((SQLHelper)object).rs.next()) {
                            listArray[3].add(((SQLHelper)object).rs.getObject("actuals_cost"));
                            listArray[7].add(((SQLHelper)object).rs.getObject("actuals_perc_cost"));
                        }
                        string3 = PMATRIX_SUMMARY_STAT_WITH_COST_PARTITIONED_PREDICTED;
                        string3 = StringUtils.getReplacedString(string3, model, testResult.toString().toUpperCase());
                        string3 = StringUtils.getReplacedString(string3, perfomance_matrix_table, string2);
                        ((SQLHelper)object).pstmt = ((SQLHelper)object).conn.prepareStatement(string3);
                        ((SQLHelper)object).rs = ((SQLHelper)object).pstmt.executeQuery();
                        while (((SQLHelper)object).rs.next()) {
                            listArray[4].add(((SQLHelper)object).rs.getObject("predicted_cost"));
                            d3 = d3 + ((SQLHelper)object).rs.getDouble("predicted_cost");
                        }
                    }
                    catch (SQLException sQLException) {
                        theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
                        throw new ODMrDAOException((Throwable)sQLException);
                    }
                    finally {
                        ((SQLHelper)object).close();
                    }
                }
                PMatrixSummaryTableModel pMatrixSummaryTableModel = new PMatrixSummaryTableModel(testResult.toString(), listArray, d, d2, d3);
                this.matrixSummaryMap.put(testResult.getId(), pMatrixSummaryTableModel);
                this.matrixSummaryMapByName.put(testResult.toString(), pMatrixSummaryTableModel);
                string3 = SharedTestEditorState.setPartitionClause(CONFUSION_MATRIX_PARTITIONED, string);
                string3 = StringUtils.getReplacedString(string3, perfomance_matrix_table, string2);
                HashMap<TargetPair, BigDecimal> hashMap = new HashMap<TargetPair, BigDecimal>();
                try {
                    Object object2;
                    Object object3;
                    ((SQLHelper)object).conn = this.connManager.getConnection();
                    ((SQLHelper)object).pstmt = ((SQLHelper)object).conn.prepareStatement(string3);
                    ((SQLHelper)object).rs = ((SQLHelper)object).pstmt.executeQuery();
                    while (((SQLHelper)object).rs.next()) {
                        object3 = ((SQLHelper)object).rs.getObject("ACTUAL_TARGET_VALUE");
                        object2 = ((SQLHelper)object).rs.getObject("PREDICTED_TARGET_VALUE");
                        BigDecimal bigDecimal = ((SQLHelper)object).rs.getBigDecimal("VALUE");
                        n2 += bigDecimal.intValue();
                        hashMap.put(new TargetPair(object3, object2), bigDecimal);
                    }
                    object3 = new PMatrixDataProvider(hashMap, listArray, n2);
                    object2 = new PMatrixTableModel((PMatrixDataProvider)object3);
                    this.matricesMap.put(testResult.getId(), (PMatrixTableModel)((Object)object2));
                    this.testResultNames.add(testResult.getName());
                    this.testResultIds.add(testResult.getId());
                }
                catch (SQLException sQLException) {
                    theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
                    throw new ODMrDAOException((Throwable)sQLException);
                }
                finally {
                    ((SQLHelper)object).close();
                }
            }
        }
        catch (ODMrDAOException oDMrDAOException) {
            theLogger.log(Level.SEVERE, oDMrDAOException.getMessage(), oDMrDAOException);
            throw oDMrDAOException;
        }
        this.compareSummaryModel = new PMatrixCompareTableModel(this.matrixSummaryMap);
    }

    public GenericBaseTableModel getCompareSummaryModel() {
        return this.compareSummaryModel;
    }

    public PMatrixTargetCompareTableModel createPMatrixTargetCompareModel(int n) {
        return new PMatrixTargetCompareTableModel(this.getCurrentSelectedTestResults(), n, this.matrixSummaryMapByName);
    }
}

