/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.tviewer.lift;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Icon;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.SqlMapper;
import oracle.dmt.dataminer.core.dal.sql.mapping.clas.common.GetLiftResultsMapper;
import oracle.dmt.dataminer.core.dal.sql.queries.clas.common.GetConfusionMatrixResultsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.clas.common.GetLiftResultsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.clas.common.GetSchemaFromPMatrixTableQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.clas.common.GetTargetDataTypeQuery;
import oracle.dmt.dataminer.core.model.clas.common.LiftInfo;
import oracle.dmt.dataminer.core.model.common.build.partition.CompareMode;
import oracle.dmt.dataminer.repository.ClassTestResult;
import oracle.dmt.dataminer.repository.TestResult;
import oracle.dmt.dataminer.tviewer.BaseTestViewerState;
import oracle.dmt.dataminer.tviewer.SharedTestEditorState;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.workflow.dialog.test.TuneState;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;

public class LiftTabState
extends BaseTestViewerState {
    public static final String DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES = "DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES";
    public static final String DISPLAY_OPTION_CUMULATIVE_LIFT = "DISPLAY_OPTION_CUMULATIVE_LIFT";
    private Map<String, Map<String, List<LiftInfo>>> _liftdata = new HashMap<String, Map<String, List<LiftInfo>>>();
    private String _selectedDisplayOption = "DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES";
    private int _selectedQuantileValue = 20;
    private double _customThresholdValue;
    private LiftTableModel _liftTableModel;
    private DefaultGraphDataModel _liftGraphModel = new DefaultGraphDataModel(null, 61, null, null, null);
    private int _thresholdSeries;
    private double _maxCumLift;
    private int _maxQuantileCnt;
    private int _numPosTargets;
    private int _totNumRows;

    public LiftTabState(SharedTestEditorState sharedTestEditorState) {
        super(sharedTestEditorState);
    }

    public int getRESULT_NAME() {
        return this._liftTableModel.getRESULT_NAME();
    }

    public int getTUNE() {
        return ((LiftTuneTableModel)this._liftTableModel).getTUNE();
    }

    public int getLIFT_CUMULATIVE() {
        return this._liftTableModel.getLIFT_CUMULATIVE();
    }

    public int getGAIN_CUMULATIVE() {
        return this._liftTableModel.getGAIN_CUMULATIVE();
    }

    public int getPERCENTAGE_RECORDS_CUMULATIVE() {
        return this._liftTableModel.getPERCENTAGE_RECORDS_CUMULATIVE();
    }

    public int getTARGET_DENSITY_CUMULATIVE() {
        return this._liftTableModel.getTARGET_DENSITY_CUMULATIVE();
    }

    public int getALGORITHM() {
        return this._liftTableModel.getALGORITHM();
    }

    public int getBUILD_ROWS() {
        return this._liftTableModel.getBUILD_ROWS();
    }

    public int getTEST_ROWS() {
        return this._liftTableModel.getTEST_ROWS();
    }

    public int getCREATION_DATE() {
        return this._liftTableModel.getCREATION_DATE();
    }

    public void load(CompareMode compareMode) throws ODMrDAOException {
        boolean bl = CompareMode.isPartitioned((CompareMode)compareMode);
        this.targetValues.clear();
        this.testResults = this.parentState.getTestResults();
        this.setSelectedDisplayOption(DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES);
        for (TestResult testResult : this.testResults) {
            List<String> list = ((ClassTestResult)testResult).getTargetValues(bl);
            for (String string : list) {
                if (this.targetValues.contains(string)) continue;
                this.targetValues.add(string);
            }
        }
        Object object = null;
        object = bl ? ((ClassTestResult)this.testResults.get(0)).getLeastTargetValue(true, this.parentState.getSelectedPartition()) : ((ClassTestResult)this.testResults.get(0)).getLeastTargetValue(false, null);
        if (object == null || !this.targetValues.contains(object)) {
            object = (String)this.targetValues.get(0);
        }
        this.setSelectedTargetValue((String)object);
        this.loadLiftData(compareMode);
        this.loadLiftGraph();
    }

    public void refreshLiftData(CompareMode compareMode) throws ODMrDAOException {
        this.loadLiftData(compareMode);
        this.loadLiftGraph();
    }

    private void loadLiftData(CompareMode compareMode) throws ODMrDAOException {
        boolean bl = CompareMode.isPartitioned((CompareMode)compareMode);
        if (bl) {
            this.loadLiftDataPartitioned(compareMode);
        } else {
            this.loadLiftDataNonPartitioned(compareMode);
        }
    }

    private void loadLiftDataNonPartitioned(CompareMode compareMode) throws ODMrDAOException {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        TreeMap<String, List<LiftInfo>> treeMap = new TreeMap<String, List<LiftInfo>>();
        String string = ((TestResult)this.testResults.get(0)).getPerformanceMatrixTable();
        String string2 = ((ClassTestResult)this.testResults.get(0)).getConfusionMatrixTable();
        String string3 = this.dao.readItem((Query)new GetSchemaFromPMatrixTableQuery(string)).orElse("");
        String string4 = this.dao.readItem((Query)new GetTargetDataTypeQuery(string3, string)).orElse("VARCHAR2");
        Integer[] integerArray = this.dao.readItem((Query)new GetConfusionMatrixResultsQuery(this.connManager.getDbVersion(), compareMode, string2, string4, this.getSelectedTargetValue())).orElse(new Integer[]{0, 0});
        this._numPosTargets = integerArray[0];
        this._totNumRows = integerArray[1];
        for (TestResult testResult : this.testResults) {
            GetLiftResultsMapper getLiftResultsMapper;
            List list;
            String string5;
            ClassTestResult classTestResult = testResult instanceof ClassTestResult ? (ClassTestResult)testResult : null;
            if (classTestResult == null || (string5 = classTestResult.geLiftResultTable(this.getSelectedTargetValue(), false)) == null) continue;
            String string6 = testResult.toString();
            Map<String, List<LiftInfo>> map = this._liftdata.get(this.getSelectedTargetValue());
            if (map == null) {
                map = new HashMap<String, List<LiftInfo>>();
                this._liftdata.put(this.getSelectedTargetValue(), map);
            }
            if ((list = map.get(string6)) == null) {
                LiftInfo liftInfo;
                getLiftResultsMapper = new GetLiftResultsMapper(testResult.getMiningAlgorithm(), testResult.getCreationTime(), classTestResult.getTestRows(false, null));
                list = this.dao.readItems((Query)new GetLiftResultsQuery(this.connManager.getDbVersion(), (SqlMapper)getLiftResultsMapper, compareMode, string5));
                Iterator iterator = list.iterator();
                int n4 = 0;
                LiftInfo liftInfo2 = null;
                while (iterator.hasNext()) {
                    liftInfo = (LiftInfo)iterator.next();
                    n4 = liftInfo.getQuantile();
                    d3 += liftInfo.getQuantileTargetCnt().doubleValue();
                    if (n3 == 0) {
                        if (d3 > (double)this._numPosTargets && n4 > 0) {
                            n3 = n4 - 1;
                        } else if (d3 == (double)this._numPosTargets) {
                            n3 = n4;
                        }
                    }
                    liftInfo2 = new LiftInfo(liftInfo);
                    liftInfo2.setQuantile(Integer.valueOf(n4));
                    if (d < liftInfo.getGainCum()) {
                        d = liftInfo.getGainCum();
                        n = n4;
                    }
                    if (!(d2 < liftInfo.getLiftCum())) continue;
                    d2 = liftInfo.getLiftCum();
                    n2 = n4;
                }
                while (n4 < 100) {
                    liftInfo = new LiftInfo(liftInfo2);
                    liftInfo.setQuantile(Integer.valueOf(++n4));
                    list.add(liftInfo);
                }
                liftInfo = new LiftInfo(Integer.valueOf(n4), Double.valueOf(0.0), Double.valueOf(0.0), Integer.valueOf(n), Double.valueOf(n2), Double.valueOf(0.0), ((LiftInfo)list.get(1)).getLiftCum(), Double.valueOf(d), Double.valueOf(d2), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), null, null, null);
                liftInfo.setIdealQuantile(Integer.valueOf(Math.max(1, n3)));
                list.add(0, liftInfo);
                map.put(string6, list);
            }
            getLiftResultsMapper = map.get(string6);
            treeMap.put(string6, (List<LiftInfo>)getLiftResultsMapper);
        }
        TuneState tuneState = (TuneState)this.context.getProperty("TUNE_STATE");
        this._liftTableModel = tuneState == null ? new LiftTableModel(treeMap, false) : new LiftTuneTableModel(tuneState, treeMap, false);
    }

    private void loadLiftDataPartitioned(CompareMode compareMode) throws ODMrDAOException {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        TreeMap<String, List<LiftInfo>> treeMap = new TreeMap<String, List<LiftInfo>>();
        String string = ((TestResult)this.testResults.get(0)).getPerformanceMatrixTable();
        String string2 = ((ClassTestResult)this.testResults.get(0)).getConfusionMatrixTable();
        String string3 = this.parentState.getSelectedPartition();
        String string4 = this.dao.readItem((Query)new GetSchemaFromPMatrixTableQuery(string)).orElse("");
        String string5 = this.dao.readItem((Query)new GetTargetDataTypeQuery(string4, string)).orElse("VARCHAR2");
        GetConfusionMatrixResultsQuery getConfusionMatrixResultsQuery = new GetConfusionMatrixResultsQuery(this.connManager.getDbVersion(), compareMode, string2, string5, this.getSelectedTargetValue());
        getConfusionMatrixResultsQuery.setPartitionId(string3);
        Integer[] integerArray = this.dao.readItem((Query)getConfusionMatrixResultsQuery).orElse(new Integer[]{0, 0});
        this._numPosTargets = integerArray[0];
        this._totNumRows = integerArray[1];
        Map<String, Integer> map = this.parentState.getBuildRowsCount(string3, CompareMode.isPartitioned((CompareMode)compareMode));
        for (TestResult testResult : this.testResults) {
            GetLiftResultsMapper getLiftResultsMapper;
            List list;
            ClassTestResult classTestResult;
            ClassTestResult classTestResult2 = classTestResult = testResult instanceof ClassTestResult ? (ClassTestResult)testResult : null;
            if (classTestResult == null) continue;
            Integer n4 = classTestResult.getTestRows(true, string3);
            String string6 = classTestResult.geLiftResultTable(this.getSelectedTargetValue(), true);
            if (string6 == null) continue;
            String string7 = testResult.toString();
            Map<String, List<LiftInfo>> map2 = this._liftdata.get(this.getSelectedTargetValue());
            if (map2 == null) {
                map2 = new HashMap<String, List<LiftInfo>>();
                this._liftdata.put(this.getSelectedTargetValue(), map2);
            }
            if ((list = map2.get(string7)) == null) {
                LiftInfo liftInfo;
                getLiftResultsMapper = new GetLiftResultsMapper(testResult.getMiningAlgorithm(), testResult.getCreationTime(), n4);
                GetLiftResultsQuery getLiftResultsQuery = new GetLiftResultsQuery(this.connManager.getDbVersion(), (SqlMapper)getLiftResultsMapper, compareMode, string6);
                getLiftResultsQuery.setPartitionId(string3);
                list = this.dao.readItems((Query)getLiftResultsQuery);
                Iterator iterator = list.iterator();
                int n5 = 0;
                LiftInfo liftInfo2 = null;
                while (iterator.hasNext()) {
                    liftInfo = (LiftInfo)iterator.next();
                    n5 = liftInfo.getQuantile();
                    d3 += liftInfo.getQuantileTargetCnt().doubleValue();
                    if (n3 == 0) {
                        if (d3 > (double)this._numPosTargets && n5 > 0) {
                            n3 = n5 - 1;
                        } else if (d3 == (double)this._numPosTargets) {
                            n3 = n5;
                        }
                    }
                    liftInfo2 = liftInfo;
                    liftInfo2.setQuantile(Integer.valueOf(n5));
                    Integer n6 = map.get(testResult.getName());
                    liftInfo2.setBuildRows(Integer.valueOf(n6 != null ? n6 : 0));
                    if (d < liftInfo.getGainCum()) {
                        d = liftInfo.getGainCum();
                        n = n5;
                    }
                    if (!(d2 < liftInfo.getLiftCum())) continue;
                    d2 = liftInfo.getLiftCum();
                    n2 = n5;
                }
                while (n5 < 100) {
                    liftInfo = liftInfo2 != null ? new LiftInfo(liftInfo2) : new LiftInfo(Integer.valueOf(++n5));
                    liftInfo.setQuantile(Integer.valueOf(n5));
                    list.add(liftInfo);
                }
                liftInfo = new LiftInfo(Integer.valueOf(n5), Double.valueOf(0.0), Double.valueOf(0.0), Integer.valueOf(n), Double.valueOf(n2), Double.valueOf(0.0), ((LiftInfo)list.get(1)).getLiftCum(), Double.valueOf(d), Double.valueOf(d2), Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0), null, null, null);
                liftInfo.setIdealQuantile(Integer.valueOf(Math.max(1, n3)));
                list.add(0, liftInfo);
                map2.put(string7, list);
            }
            getLiftResultsMapper = map2.get(string7);
            treeMap.put(string7, (List<LiftInfo>)getLiftResultsMapper);
        }
        TuneState tuneState = (TuneState)this.context.getProperty("TUNE_STATE");
        this._liftTableModel = tuneState == null ? new LiftTableModel(treeMap, true) : new LiftTuneTableModel(tuneState, treeMap, true);
    }

    private void loadLiftGraph() {
        TestResult testResult;
        List<LiftInfo> list;
        double d;
        double d2;
        Map<String, List<LiftInfo>> map = this._liftdata.get(this.getSelectedTargetValue());
        this._liftGraphModel.clear();
        this._maxCumLift = 0.0;
        this._maxQuantileCnt = 0;
        ArrayList<Color> arrayList = new ArrayList<Color>();
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        for (TestResult testResult2 : this.testResults) {
            String string = testResult2.toString();
            Object object = map.get(string);
            if (object == null) continue;
            int n3 = object.size();
            if (this._maxQuantileCnt < n3) {
                this._maxQuantileCnt = n3;
            }
            int n4 = object.get(0).getIdealQuantile();
            n2 = Math.min(n2, n4);
            ++n;
        }
        Object[][] objectArray = new Object[this._maxQuantileCnt * 2][n + 3];
        Object[] objectArray2 = new Object[n + 3];
        Object[] objectArray3 = new Object[n + 3];
        int n5 = 0;
        int n6 = 0;
        for (Object object : this.testResults) {
            String string = ((TestResult)object).toString();
            List<LiftInfo> list2 = map.get(string);
            if (list2 == null) continue;
            n6 = 0;
            for (int i = 0; i < list2.size(); ++i) {
                objectArray[n6++][n5] = (double)i;
                if (this._selectedDisplayOption.equals(DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES)) {
                    objectArray[n6++][n5] = list2.get(i).getGainCum();
                    continue;
                }
                objectArray[n6++][n5] = list2.get(i).getLiftCum();
                this._maxCumLift = (double)this._totNumRows / (double)this._numPosTargets;
            }
            if (list2.get(0).getTargetCum() > this._maxCumLift) {
                this._maxCumLift = list2.get(0).getTargetCum();
            }
            objectArray2[n5] = "Lift: " + string;
            objectArray3[n5] = 0;
            ++n5;
            Color color = this.parentState.getTestResultGraphColor(string);
            arrayList.add(color);
        }
        n6 = 0;
        double d3 = this._selectedQuantileValue;
        double d4 = this._selectedQuantileValue;
        if (this._selectedDisplayOption.equals(DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES)) {
            d2 = 0.0;
            d = 1.0;
        } else {
            d2 = 0.0;
            d = this._maxCumLift;
        }
        objectArray[n6++][n5] = d3;
        objectArray[n6++][n5] = d2;
        objectArray[n6++][n5] = d4;
        objectArray[n6++][n5] = d;
        objectArray2[n5] = TestViewerLrb.get("LIFT_GRAPH_DATA_THRESHOLD");
        objectArray3[n5] = 0;
        this._thresholdSeries = n5++;
        n6 = 0;
        d3 = 0.0;
        d4 = this._maxQuantileCnt - 1;
        if (this._selectedDisplayOption.equals(DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES)) {
            d2 = 0.0;
            d = 1.0;
        } else {
            d2 = 1.0;
            d = 1.0;
        }
        objectArray[n6++][n5] = d3;
        objectArray[n6++][n5] = d2;
        objectArray[n6++][n5] = d4;
        objectArray[n6++][n5] = d;
        objectArray2[n5] = TestViewerLrb.get("LIFT_GRAPH_DATA_RANDOM");
        objectArray3[n5] = 0;
        ++n5;
        n6 = 0;
        String string = null;
        Iterator iterator = this.testResults.iterator();
        while (iterator.hasNext() && (list = map.get(string = (testResult = (TestResult)iterator.next()).toString())) == null) {
        }
        if (this._selectedDisplayOption.equals(DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES)) {
            objectArray[n6++][n5] = 0.0;
            objectArray[n6++][n5] = 0.0;
            objectArray[n6++][n5] = (double)n2;
            objectArray[n6++][n5] = 1.0;
            objectArray[n6++][n5] = (double)(this._maxQuantileCnt - 1);
            objectArray[n6++][n5] = 1.0;
        } else {
            objectArray[n6++][n5] = 0.0;
            objectArray[n6++][n5] = (double)this._totNumRows / (double)this._numPosTargets;
            objectArray[n6++][n5] = (double)n2;
            objectArray[n6++][n5] = (double)this._totNumRows / (double)this._numPosTargets;
            objectArray[n6++][n5] = (double)n2;
            objectArray[n6++][n5] = 1.0;
            objectArray[n6++][n5] = (double)(this._maxQuantileCnt - 1);
            objectArray[n6++][n5] = 1.0;
        }
        objectArray2[n5] = TestViewerLrb.get("LIFT_GRAPH_DATA_IDEAL");
        objectArray3[n5] = 0;
        this._liftGraphModel.addRowLabels(objectArray2);
        this._liftGraphModel.addRowMarkerShapes(objectArray3);
        this._liftGraphModel.addGraphData(objectArray);
        this._liftGraphModel.setLegendVisible(true);
        this._liftGraphModel.setLegendSeriesStart(n);
        this._liftGraphModel.setLegendSeriesCount(3);
        Object[] objectArray4 = new Object[this._maxQuantileCnt * 2];
        for (int i = 0; i < objectArray4.length; ++i) {
            objectArray4[i] = "";
        }
        this._liftGraphModel.addColumnLabels(objectArray4);
        arrayList.add(SharedTestEditorState.LIFT_QUANTILE_LINE);
        arrayList.add(SharedTestEditorState.LIFT_RANDOM_LINE);
        arrayList.add(SharedTestEditorState.LIFT_IDEAL_LINE);
        this._liftGraphModel.addRowColors(arrayList.toArray(new Color[arrayList.size()]));
        this._liftGraphModel.setX1(TestViewerLrb.get("QUANTILE"), this._maxQuantileCnt - 1);
        if (this._selectedDisplayOption.equals(DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES)) {
            this._liftGraphModel.setY1(TestViewerLrb.get("CUMULATIVE_POSITIVE_CASES"), 0.0, 1.0);
        } else {
            this._liftGraphModel.setY1(TestViewerLrb.get("CUMULATIVE_LIFT"), 0.0, this._maxCumLift);
        }
    }

    public void refreshCustomThresholdData() {
        double d;
        double d2;
        Object[][] objectArray = this._liftGraphModel.getGraphData();
        this._liftGraphModel.clearGraphData();
        double d3 = this.getSelectedQuantileValue();
        double d4 = this.getSelectedQuantileValue();
        if (DISPLAY_OPTION_CUMULATIVE_POSITIVE_CASES.equals(this._selectedDisplayOption)) {
            d2 = 0.0;
            d = 1.0;
        } else {
            d2 = 0.0;
            d = this._maxCumLift;
        }
        objectArray[0][this._thresholdSeries] = d3;
        objectArray[1][this._thresholdSeries] = d2;
        objectArray[2][this._thresholdSeries] = d4;
        objectArray[3][this._thresholdSeries] = d;
        this._liftGraphModel.addGraphData(objectArray);
    }

    public Map<String, List<LiftInfo>> getLiftData() {
        return this._liftdata.get(this.getSelectedTargetValue());
    }

    public LiftTableModel getLoadingLiftTableModel() {
        return new LiftTableModel();
    }

    public LiftTableModel getLiftTableModel() {
        return this._liftTableModel;
    }

    public DefaultGraphDataModel getLiftGraphModel() {
        return this._liftGraphModel;
    }

    public TestResult getSelectedTestResultObj() {
        for (TestResult testResult : this.testResults) {
            if (!testResult.toString().equals(this.getSelectedTestResult())) continue;
            return testResult;
        }
        return null;
    }

    public void setSelectedDisplayOption(String string) {
        this._selectedDisplayOption = string;
    }

    public String getSelectedDisplayOption() {
        return this._selectedDisplayOption;
    }

    public void setSelectedQuantileValue(int n) {
        this._selectedQuantileValue = n;
    }

    public int getSelectedQuantileValue() {
        return this._selectedQuantileValue;
    }

    public void setCustomThresholdValue(double d) {
        this._customThresholdValue = d;
    }

    public double getCustomThresholdValue() {
        return this._customThresholdValue;
    }

    public double getMaxCumLift() {
        return this._maxCumLift;
    }

    public int getMaxQuantileCnt() {
        return this._maxQuantileCnt;
    }

    public class LiftTuneTableModel
    extends LiftTableModel {
        private int _start;
        private int RESULT_NAME;
        private int TUNE;
        private int LIFT_CUMULATIVE;
        private int GAIN_CUMULATIVE;
        private int PERCENTAGE_RECORDS_CUMULATIVE;
        private int TARGET_DENSITY_CUMULATIVE;
        private int ALGORITHM;
        private int BUILD_ROWS;
        private int TEST_ROWS;
        private int CREATION_DATE;
        private TuneState _tuneState;
        private String TUNE_NONE;
        private String TUNE_BENEFIT;
        private String TUNE_COST;
        private String TUNE_ROC;
        private String TUNE_LIFT;
        private String TUNE_PROFIT;

        public int getRESULT_NAME() {
            return this.RESULT_NAME;
        }

        public int getTUNE() {
            return this.TUNE;
        }

        public int getLIFT_CUMULATIVE() {
            return this.LIFT_CUMULATIVE;
        }

        public int getGAIN_CUMULATIVE() {
            return this.GAIN_CUMULATIVE;
        }

        public int getPERCENTAGE_RECORDS_CUMULATIVE() {
            return this.PERCENTAGE_RECORDS_CUMULATIVE;
        }

        public int getTARGET_DENSITY_CUMULATIVE() {
            return this.TARGET_DENSITY_CUMULATIVE;
        }

        public int getALGORITHM() {
            return this.ALGORITHM;
        }

        public int getBUILD_ROWS() {
            return this.BUILD_ROWS;
        }

        public int getTEST_ROWS() {
            return this.TEST_ROWS;
        }

        public int getCREATION_DATE() {
            return this.CREATION_DATE;
        }

        protected void createColumns(boolean bl) {
            if (bl) {
                this._colNames = new Vector();
                this._colNames.add(TestViewerLrb.get("RESULT_NAME"));
                this._colNames.add(PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE"));
                this._colNames.add(TestViewerLrb.get("LIFT_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("GAIN_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("PERCENTAGE_RECORDS_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("TARGET_DENSITY_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("ALGORITHM"));
                this._colNames.add(TestViewerLrb.get("BUILD_ROWS"));
                this._colNames.add(TestViewerLrb.get("TEST_ROWS"));
                this._colNames.add(TestViewerLrb.get("CREATION_DATE"));
                this.BUILD_ROWS = this._start++;
                this.TEST_ROWS = this._start++;
            } else {
                this._colNames = new Vector();
                this._colNames.add(TestViewerLrb.get("RESULT_NAME"));
                this._colNames.add(PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE"));
                this._colNames.add(TestViewerLrb.get("LIFT_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("GAIN_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("PERCENTAGE_RECORDS_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("TARGET_DENSITY_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("ALGORITHM"));
                this._colNames.add(TestViewerLrb.get("CREATION_DATE"));
            }
            this.CREATION_DATE = this._start;
        }

        public LiftTuneTableModel(TuneState tuneState, Map<String, List<LiftInfo>> map, boolean bl) {
            super(map, bl);
            this._start = 0;
            this.RESULT_NAME = this._start++;
            this.TUNE = this._start++;
            this.LIFT_CUMULATIVE = this._start++;
            this.GAIN_CUMULATIVE = this._start++;
            this.PERCENTAGE_RECORDS_CUMULATIVE = this._start++;
            this.TARGET_DENSITY_CUMULATIVE = this._start++;
            this.ALGORITHM = this._start++;
            this.TUNE_NONE = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_NONE");
            this.TUNE_BENEFIT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_BENEFIT");
            this.TUNE_COST = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_COST");
            this.TUNE_ROC = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_ROC");
            this.TUNE_LIFT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_LIFT");
            this.TUNE_PROFIT = PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TUNE_VALUES_PROFIT");
            this._tuneState = tuneState;
        }

        @Override
        public String getColumnName(int n) {
            return (String)this._colNames.get(n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == this.RESULT_NAME) {
                return super.getValueAt(n, this.RESULT_NAME);
            }
            if (n2 == this.GAIN_CUMULATIVE) {
                return super.getValueAt(n, this.GAIN_CUMULATIVE);
            }
            if (n2 == this.PERCENTAGE_RECORDS_CUMULATIVE) {
                return super.getValueAt(n, this.PERCENTAGE_RECORDS_CUMULATIVE);
            }
            if (n2 == this.LIFT_CUMULATIVE) {
                return super.getValueAt(n, this.LIFT_CUMULATIVE);
            }
            if (n2 == this.TARGET_DENSITY_CUMULATIVE) {
                return super.getValueAt(n, this.TARGET_DENSITY_CUMULATIVE);
            }
            if (n2 == this.ALGORITHM) {
                return super.getValueAt(n, this.ALGORITHM);
            }
            if (n2 == this.CREATION_DATE) {
                return super.getValueAt(n, this.CREATION_DATE);
            }
            if (n2 == this.TUNE) {
                if (this._liftData != null) {
                    Object[] objectArray = this._liftData.keySet().toArray();
                    String string = (String)objectArray[n];
                    if (this._tuneState.isTuningNone(string)) {
                        return this.TUNE_NONE;
                    }
                    if (this._tuneState.isTuningBenefit(string)) {
                        return this.TUNE_BENEFIT;
                    }
                    if (this._tuneState.isTuningCost(string)) {
                        return this.TUNE_COST;
                    }
                    if (this._tuneState.isTuningCustomROC(string)) {
                        return this.TUNE_ROC;
                    }
                    if (this._tuneState.isTuningCustomLift(string)) {
                        return this.TUNE_LIFT;
                    }
                    if (this._tuneState.isTuningCustomProfit(string)) {
                        return this.TUNE_PROFIT;
                    }
                }
            } else {
                if (n2 == this.BUILD_ROWS) {
                    return "";
                }
                if (n2 == this.TEST_ROWS) {
                    return "";
                }
            }
            return null;
        }
    }

    public class LiftTableModel
    extends SimpleBaseTableModel {
        private int _start = 0;
        private int RESULT_NAME = this._start++;
        private int LIFT_CUMULATIVE = this._start++;
        private int GAIN_CUMULATIVE = this._start++;
        private int PERCENTAGE_RECORDS_CUMULATIVE = this._start++;
        private int TARGET_DENSITY_CUMULATIVE = this._start++;
        private int ALGORITHM = this._start++;
        private int BUILD_ROWS;
        private int TEST_ROWS;
        private int CREATION_DATE;
        protected Vector<String> _colNames;
        protected Map<String, List<LiftInfo>> _liftData;
        private final String LOADING = TestViewerLrb.get("LOADING");

        private int getRESULT_NAME() {
            return this.RESULT_NAME;
        }

        private int getLIFT_CUMULATIVE() {
            return this.LIFT_CUMULATIVE;
        }

        private int getGAIN_CUMULATIVE() {
            return this.GAIN_CUMULATIVE;
        }

        private int getPERCENTAGE_RECORDS_CUMULATIVE() {
            return this.PERCENTAGE_RECORDS_CUMULATIVE;
        }

        private int getTARGET_DENSITY_CUMULATIVE() {
            return this.TARGET_DENSITY_CUMULATIVE;
        }

        private int getALGORITHM() {
            return this.ALGORITHM;
        }

        private int getBUILD_ROWS() {
            return this.BUILD_ROWS;
        }

        private int getTEST_ROWS() {
            return this.TEST_ROWS;
        }

        private int getCREATION_DATE() {
            return this.CREATION_DATE;
        }

        public LiftTableModel() {
            this(null, false);
        }

        private void createColumns(boolean bl) {
            if (bl) {
                this._colNames = new Vector();
                this._colNames.add(TestViewerLrb.get("RESULT_NAME"));
                this._colNames.add(TestViewerLrb.get("LIFT_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("GAIN_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("PERCENTAGE_RECORDS_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("TARGET_DENSITY_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("ALGORITHM"));
                this._colNames.add(TestViewerLrb.get("BUILD_ROWS"));
                this._colNames.add(TestViewerLrb.get("TEST_ROWS"));
                this._colNames.add(TestViewerLrb.get("CREATION_DATE"));
                this.BUILD_ROWS = this._start++;
                this.TEST_ROWS = this._start++;
            } else {
                this._colNames = new Vector();
                this._colNames.add(TestViewerLrb.get("RESULT_NAME"));
                this._colNames.add(TestViewerLrb.get("LIFT_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("GAIN_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("PERCENTAGE_RECORDS_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("TARGET_DENSITY_CUMULATIVE"));
                this._colNames.add(TestViewerLrb.get("ALGORITHM"));
                this._colNames.add(TestViewerLrb.get("CREATION_DATE"));
            }
            this.CREATION_DATE = this._start;
        }

        public LiftTableModel(Map<String, List<LiftInfo>> map, boolean bl) {
            this._liftData = map;
            this.createColumns(bl);
            this.setColumnIdentifiers(this._colNames);
            this.setRowCount(this._liftData == null ? 1 : map.size());
            this.setColumnCount(this._colNames.size());
        }

        public String getColumnName(int n) {
            return this._colNames.get(n);
        }

        public Object getValueAt(int n, int n2) {
            if (this._liftData == null) {
                if (n2 == 0) {
                    return this.LOADING;
                }
                return null;
            }
            Object[] objectArray = this._liftData.keySet().toArray();
            List<LiftInfo> list = this._liftData.get(objectArray[n]);
            int n3 = LiftTabState.this._selectedQuantileValue;
            if (n2 == this.RESULT_NAME) {
                return objectArray[n];
            }
            if (n2 == this.GAIN_CUMULATIVE) {
                return list.get(n3).getGainCum() != null ? list.get(n3).getGainCum() * 100.0 : 0.0;
            }
            if (n2 == this.PERCENTAGE_RECORDS_CUMULATIVE) {
                return list.get(n3).getPercentRecordsCum();
            }
            if (n2 == this.LIFT_CUMULATIVE) {
                return list.get(n3).getLiftCum();
            }
            if (n2 == this.TARGET_DENSITY_CUMULATIVE) {
                return list.get(n3).getTargetDensityCum();
            }
            if (n2 == this.ALGORITHM) {
                return list.get(n3).getAlgorithm();
            }
            if (n2 == this.CREATION_DATE) {
                return list.get(n3).getCreation_date();
            }
            if (n2 == this.BUILD_ROWS) {
                return list.get(n3).getBuildRows();
            }
            if (n2 == this.TEST_ROWS) {
                return list.get(n3).getTestRows();
            }
            return "Undefined";
        }
    }

    public static class LiftData
    extends LiftInfo
    implements Element {
        private String _label;

        public LiftData(LiftInfo liftInfo) {
            super(liftInfo);
        }

        public LiftData(Integer n) {
            super(n);
        }

        public LiftData(Integer n, Double d, Double d2, Integer n2, Double d3, Double d4, Double d5, Double d6, Double d7, Double d8, Double d9, Double d10, String string, Date date, Integer n3) {
            super(n, d, d2, n2, d3, d4, d5, d6, d7, d8, d9, d10, string, date, n3);
        }

        public void setLabel(String string) {
            this._label = string;
        }

        public boolean mayHaveChildren() {
            return false;
        }

        public Iterator<Element> getChildren() {
            return Collections.emptyIterator();
        }

        public Attributes getAttributes() {
            return null;
        }

        public Object getData() {
            return null;
        }

        public String getShortLabel() {
            return this._label;
        }

        public String getLongLabel() {
            return "";
        }

        public Icon getIcon() {
            return null;
        }

        public String getToolTipText() {
            return "";
        }

        public String toString() {
            return "";
        }
    }
}

